/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public final class CameraLogger {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_ERROR = 3;
    static String lastMessage;
    static String lastTag;
    private static int sLevel;
    private static List<Logger> sLoggers;
    @NonNull
    private String mTag;

    static CameraLogger create(@NonNull String tag) {
        return new CameraLogger(tag);
    }

    public static void setLogLevel(int logLevel) {
        sLevel = logLevel;
    }

    public static void registerLogger(@NonNull Logger logger) {
        sLoggers.add(logger);
    }

    public static void unregisterLogger(@NonNull Logger logger) {
        sLoggers.remove(logger);
    }

    private CameraLogger(@NonNull String tag) {
        this.mTag = tag;
    }

    private boolean should(int messageLevel) {
        return sLevel <= messageLevel && sLoggers.size() > 0;
    }

    void v(Object ... data) {
        this.log(0, data);
    }

    void i(Object ... data) {
        this.log(1, data);
    }

    void w(Object ... data) {
        this.log(2, data);
    }

    void e(Object ... data) {
        this.log(3, data);
    }

    private void log(int level, Object ... data) {
        if (!this.should(level)) {
            return;
        }
        StringBuilder message = new StringBuilder();
        Throwable throwable = null;
        for (Object object : data) {
            if (object instanceof Throwable) {
                throwable = (Throwable)object;
            }
            message.append(String.valueOf(object));
            message.append(" ");
        }
        String string = message.toString().trim();
        for (Logger logger : sLoggers) {
            logger.log(level, this.mTag, string, throwable);
        }
        lastMessage = string;
        lastTag = this.mTag;
    }

    static {
        CameraLogger.setLogLevel(3);
        sLoggers = new ArrayList<Logger>();
        sLoggers.add(new Logger(){

            @Override
            public void log(int level, @NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
                switch (level) {
                    case 0: {
                        Log.v((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 1: {
                        Log.i((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 2: {
                        Log.w((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 3: {
                        Log.e((String)tag, (String)message, (Throwable)throwable);
                    }
                }
            }
        });
    }

    public static interface Logger {
        public void log(int var1, @NonNull String var2, @NonNull String var3, @Nullable Throwable var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

