/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.location.Location;
import android.os.Build;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.CameraController;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraView;
import com.otaliastudios.cameraview.CropHelper;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Frame;
import com.otaliastudios.cameraview.FullPictureRecorder;
import com.otaliastudios.cameraview.FullVideoRecorder;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GlCameraPreview;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mapper1;
import com.otaliastudios.cameraview.Mode;
import com.otaliastudios.cameraview.PictureRecorder;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.SnapshotPictureRecorder;
import com.otaliastudios.cameraview.SnapshotVideoRecorder;
import com.otaliastudios.cameraview.Task;
import com.otaliastudios.cameraview.VideoRecorder;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.WhiteBalance;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class Camera1
extends CameraController
implements Camera.PreviewCallback,
Camera.ErrorCallback,
VideoRecorder.VideoResultListener,
PictureRecorder.PictureResultListener {
    private static final String TAG = Camera1.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Camera mCamera;
    private boolean mIsBound = false;
    private final int mPostFocusResetDelay = 3000;
    private Runnable mPostFocusResetRunnable = new Runnable(){

        @Override
        public void run() {
            if (!Camera1.this.isCameraAvailable()) {
                return;
            }
            Camera1.this.mCamera.cancelAutoFocus();
            Camera.Parameters params = Camera1.this.mCamera.getParameters();
            int maxAF = params.getMaxNumFocusAreas();
            int maxAE = params.getMaxNumMeteringAreas();
            if (maxAF > 0) {
                params.setFocusAreas(null);
            }
            if (maxAE > 0) {
                params.setMeteringAreas(null);
            }
            Camera1.this.applyDefaultFocus(params);
            Camera1.this.mCamera.setParameters(params);
        }
    };

    Camera1(@NonNull CameraView.CameraCallbacks callback) {
        super(callback);
        this.mMapper = new Mapper1();
    }

    private void schedule(final @Nullable Task<Void> task, final boolean ensureAvailable, final Runnable action) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ensureAvailable && !Camera1.this.isCameraAvailable()) {
                    if (task != null) {
                        task.end(null);
                    }
                } else {
                    action.run();
                    if (task != null) {
                        task.end(null);
                    }
                }
            }
        });
    }

    @Override
    public void onSurfaceAvailable() {
        LOG.i("onSurfaceAvailable:", "Size is", this.mPreview.getOutputSurfaceSize());
        this.schedule(null, false, new Runnable(){

            @Override
            public void run() {
                LOG.i("onSurfaceAvailable:", "Inside handler. About to bind.");
                if (Camera1.this.shouldBindToSurface()) {
                    Camera1.this.bindToSurface();
                }
                if (Camera1.this.shouldStartPreview()) {
                    Camera1.this.startPreview("onSurfaceAvailable");
                }
            }
        });
    }

    @Override
    public void onSurfaceChanged() {
        LOG.i("onSurfaceChanged, size is", this.mPreview.getOutputSurfaceSize());
        this.schedule(null, true, new Runnable(){

            @Override
            public void run() {
                if (!Camera1.this.mIsBound) {
                    return;
                }
                Size newSize = Camera1.this.computePreviewSize(Camera1.this.sizesFromList(Camera1.this.mCamera.getParameters().getSupportedPreviewSizes()));
                if (newSize.equals(Camera1.this.mPreviewSize)) {
                    return;
                }
                LOG.i("onSurfaceChanged:", "Computed a new preview size. Going on.");
                Camera1.this.mPreviewSize = newSize;
                Camera1.this.stopPreview();
                Camera1.this.startPreview("onSurfaceChanged:");
            }
        });
    }

    @Override
    public void onSurfaceDestroyed() {
        LOG.i("onSurfaceDestroyed");
        this.schedule(null, true, new Runnable(){

            @Override
            public void run() {
                Camera1.this.stopPreview();
                if (Camera1.this.mIsBound) {
                    Camera1.this.unbindFromSurface();
                }
            }
        });
    }

    private boolean shouldBindToSurface() {
        return this.isCameraAvailable() && this.mPreview != null && this.mPreview.hasSurface() && !this.mIsBound;
    }

    @WorkerThread
    private void bindToSurface() {
        LOG.i("bindToSurface:", "Started");
        Object output = this.mPreview.getOutput();
        try {
            if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                this.mCamera.setPreviewDisplay((SurfaceHolder)output);
            } else {
                this.mCamera.setPreviewTexture((SurfaceTexture)output);
            }
        }
        catch (IOException e) {
            LOG.e("bindToSurface:", "Failed to bind.", e);
            throw new CameraException(e, 2);
        }
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewSize = this.computePreviewSize(this.sizesFromList(this.mCamera.getParameters().getSupportedPreviewSizes()));
        this.mIsBound = true;
    }

    @WorkerThread
    private void unbindFromSurface() {
        this.mIsBound = false;
        this.mPreviewSize = null;
        this.mCaptureSize = null;
        try {
            if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                this.mCamera.setPreviewDisplay(null);
            } else {
                this.mCamera.setPreviewTexture(null);
            }
        }
        catch (IOException e) {
            LOG.e("unbindFromSurface", "Could not release surface", e);
        }
    }

    private boolean shouldStartPreview() {
        return this.isCameraAvailable() && this.mIsBound;
    }

    private void startPreview(String log) {
        LOG.i(log, "Dispatching onCameraPreviewSizeChanged.");
        this.mCameraCallbacks.onCameraPreviewSizeChanged();
        Size previewSize = this.getPreviewSize(1);
        boolean wasFlipped = this.flip(0, 1);
        this.mPreview.setInputStreamSize(previewSize.getWidth(), previewSize.getHeight(), wasFlipped);
        Camera.Parameters params = this.mCamera.getParameters();
        this.mPreviewFormat = params.getPreviewFormat();
        params.setPreviewSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
        if (this.mMode == Mode.PICTURE) {
            params.setPictureSize(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        } else {
            Size pictureSize = this.computeCaptureSize(Mode.PICTURE);
            params.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        this.mCamera.setParameters(params);
        this.mCamera.setPreviewCallbackWithBuffer(null);
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.mFrameManager.allocate(ImageFormat.getBitsPerPixel((int)this.mPreviewFormat), this.mPreviewSize);
        LOG.i(log, "Starting preview with startPreview().");
        try {
            this.mCamera.startPreview();
        }
        catch (Exception e) {
            LOG.e(log, "Failed to start preview.", e);
            throw new CameraException(e, 2);
        }
        LOG.i(log, "Started preview.");
    }

    private void stopPreview() {
        this.mPreviewFormat = 0;
        this.mFrameManager.release();
        this.mCamera.setPreviewCallbackWithBuffer(null);
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception e) {
            LOG.e("stopPreview", "Could not stop preview", e);
        }
    }

    private void createCamera() {
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            LOG.e("createCamera:", "Failed to connect. Maybe in use by another app?");
            throw new CameraException(e, 1);
        }
        this.mCamera.setErrorCallback((Camera.ErrorCallback)this);
        LOG.i("createCamera:", "Applying default parameters.");
        Camera.Parameters params = this.mCamera.getParameters();
        this.mCameraOptions = new CameraOptions(params, this.flip(0, 1));
        this.applyDefaultFocus(params);
        this.applyFlash(params, Flash.DEFAULT);
        this.applyLocation(params, null);
        this.applyWhiteBalance(params, WhiteBalance.DEFAULT);
        this.applyHdr(params, Hdr.DEFAULT);
        this.applyPlaySounds(this.mPlaySounds);
        params.setRecordingHint(this.mMode == Mode.VIDEO);
        this.mCamera.setParameters(params);
        this.mCamera.setDisplayOrientation(this.offset(0, 1));
    }

    private void destroyCamera() {
        try {
            LOG.i("destroyCamera:", "Clean up.", "Releasing camera.");
            this.mCamera.release();
            LOG.i("destroyCamera:", "Clean up.", "Released camera.");
        }
        catch (Exception e) {
            LOG.w("destroyCamera:", "Clean up.", "Exception while releasing camera.", e);
        }
        this.mCamera = null;
        this.mCameraOptions = null;
    }

    @Override
    @WorkerThread
    void onStart() {
        if (this.isCameraAvailable()) {
            LOG.w("onStart:", "Camera not available. Should not happen.");
            this.onStop();
        }
        if (this.collectCameraId()) {
            this.createCamera();
            if (this.shouldBindToSurface()) {
                this.bindToSurface();
            }
            if (this.shouldStartPreview()) {
                this.startPreview("onStart");
            }
        } else {
            LOG.e("onStart:", "No camera available for facing", this.mFacing);
            throw new CameraException(6);
        }
        LOG.i("onStart:", "Ended");
    }

    @Override
    @WorkerThread
    void onStop() {
        LOG.i("onStop:", "About to clean up.");
        this.mHandler.get().removeCallbacks(this.mPostFocusResetRunnable);
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop();
            this.mVideoRecorder = null;
        }
        if (this.mCamera != null) {
            this.stopPreview();
            if (this.mIsBound) {
                this.unbindFromSurface();
            }
            this.destroyCamera();
        }
        this.mCameraOptions = null;
        this.mCamera = null;
        this.mPreviewSize = null;
        this.mCaptureSize = null;
        this.mIsBound = false;
        LOG.w("onStop:", "Clean up.", "Returning.");
    }

    private boolean collectCameraId() {
        int internalFacing = (Integer)this.mMapper.map(this.mFacing);
        LOG.i("collectCameraId", "Facing:", this.mFacing, "Internal:", internalFacing, "Cameras:", Camera.getNumberOfCameras());
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internalFacing) continue;
            this.mSensorOffset = cameraInfo.orientation;
            this.mCameraId = i;
            return true;
        }
        return false;
    }

    @Override
    public void onBufferAvailable(@NonNull byte[] buffer) {
        if (this.isCameraAvailable()) {
            this.mCamera.addCallbackBuffer(buffer);
        }
    }

    public void onError(int error, Camera camera) {
        int reason;
        if (error == 100) {
            LOG.w("Recoverable error inside the onError callback.", "CAMERA_ERROR_SERVER_DIED");
            this.stopImmediately();
            this.start();
            return;
        }
        LOG.e("Error inside the onError callback.", error);
        RuntimeException runtime = new RuntimeException(CameraLogger.lastMessage);
        switch (error) {
            case 2: {
                reason = 3;
                break;
            }
            case 1: {
                reason = 0;
                break;
            }
            default: {
                reason = 0;
            }
        }
        throw new CameraException(runtime, reason);
    }

    @Override
    void setMode(@NonNull Mode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.schedule(null, true, new Runnable(){

                @Override
                public void run() {
                    Camera1.this.restart();
                }
            });
        }
    }

    @Override
    void setLocation(@Nullable Location location) {
        final Location oldLocation = this.mLocation;
        this.mLocation = location;
        this.schedule(this.mLocationTask, true, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                if (Camera1.this.applyLocation(params, oldLocation)) {
                    Camera1.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyLocation(@NonNull Camera.Parameters params, @Nullable Location oldLocation) {
        if (this.mLocation != null) {
            params.setGpsLatitude(this.mLocation.getLatitude());
            params.setGpsLongitude(this.mLocation.getLongitude());
            params.setGpsAltitude(this.mLocation.getAltitude());
            params.setGpsTimestamp(this.mLocation.getTime());
            params.setGpsProcessingMethod(this.mLocation.getProvider());
        }
        return true;
    }

    @Override
    void setFacing(@NonNull Facing facing) {
        final Facing old = this.mFacing;
        if (facing != old) {
            this.mFacing = facing;
            this.schedule(null, true, new Runnable(){

                @Override
                public void run() {
                    if (Camera1.this.collectCameraId()) {
                        Camera1.this.restart();
                    } else {
                        Camera1.this.mFacing = old;
                    }
                }
            });
        }
    }

    @Override
    void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        final WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        this.schedule(this.mWhiteBalanceTask, true, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                if (Camera1.this.applyWhiteBalance(params, old)) {
                    Camera1.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyWhiteBalance(@NonNull Camera.Parameters params, @NonNull WhiteBalance oldWhiteBalance) {
        if (this.mCameraOptions.supports(this.mWhiteBalance)) {
            params.setWhiteBalance((String)this.mMapper.map(this.mWhiteBalance));
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    @Override
    void setHdr(@NonNull Hdr hdr) {
        final Hdr old = this.mHdr;
        this.mHdr = hdr;
        this.schedule(this.mHdrTask, true, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                if (Camera1.this.applyHdr(params, old)) {
                    Camera1.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyHdr(@NonNull Camera.Parameters params, @NonNull Hdr oldHdr) {
        if (this.mCameraOptions.supports(this.mHdr)) {
            params.setSceneMode((String)this.mMapper.map(this.mHdr));
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @TargetApi(value=17)
    private boolean applyPlaySounds(boolean oldPlaySound) {
        if (Build.VERSION.SDK_INT >= 17) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
            if (info.canDisableShutterSound) {
                try {
                    return this.mCamera.enableShutterSound(this.mPlaySounds);
                }
                catch (RuntimeException exception) {
                    return false;
                }
            }
        }
        if (this.mPlaySounds) {
            return true;
        }
        this.mPlaySounds = oldPlaySound;
        return false;
    }

    @Override
    void setAudio(@NonNull Audio audio) {
        if (this.mAudio != audio) {
            if (this.isTakingVideo()) {
                LOG.w("Audio setting was changed while recording. Changes will take place starting from next video");
            }
            this.mAudio = audio;
        }
    }

    @Override
    void setFlash(@NonNull Flash flash) {
        final Flash old = this.mFlash;
        this.mFlash = flash;
        this.schedule(this.mFlashTask, true, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                if (Camera1.this.applyFlash(params, old)) {
                    Camera1.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyFlash(@NonNull Camera.Parameters params, @NonNull Flash oldFlash) {
        if (this.mCameraOptions.supports(this.mFlash)) {
            params.setFlashMode((String)this.mMapper.map(this.mFlash));
            return true;
        }
        this.mFlash = oldFlash;
        return false;
    }

    private void applyDefaultFocus(@NonNull Camera.Parameters params) {
        List modes = params.getSupportedFocusModes();
        if (this.mMode == Mode.VIDEO && modes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
            return;
        }
        if (modes.contains("continuous-picture")) {
            params.setFocusMode("continuous-picture");
            return;
        }
        if (modes.contains("infinity")) {
            params.setFocusMode("infinity");
            return;
        }
        if (modes.contains("fixed")) {
            params.setFocusMode("fixed");
            return;
        }
    }

    @Override
    public void onPictureShutter(boolean didPlaySound) {
        this.mCameraCallbacks.onShutter(!didPlaySound);
    }

    @Override
    public void onPictureResult(@Nullable PictureResult result) {
        this.mPictureRecorder = null;
        if (result != null) {
            this.mCameraCallbacks.dispatchOnPictureTaken(result);
        } else {
            this.mCameraCallbacks.dispatchError(new CameraException(4));
            LOG.e("onPictureResult", "result is null: something went wrong.");
        }
    }

    @Override
    void takePicture() {
        LOG.v("takePicture: scheduling");
        this.schedule(null, true, new Runnable(){

            @Override
            public void run() {
                if (Camera1.this.mMode == Mode.VIDEO) {
                    throw new IllegalStateException("Can't take hq pictures while in VIDEO mode");
                }
                LOG.v("takePicture: performing.", Camera1.this.isTakingPicture());
                if (Camera1.this.isTakingPicture()) {
                    return;
                }
                PictureResult result = new PictureResult();
                result.isSnapshot = false;
                result.location = Camera1.this.mLocation;
                result.rotation = Camera1.this.offset(0, 2);
                result.size = Camera1.this.getPictureSize(2);
                result.facing = Camera1.this.mFacing;
                Camera1.this.mPictureRecorder = new FullPictureRecorder(result, Camera1.this, Camera1.this.mCamera);
                Camera1.this.mPictureRecorder.take();
            }
        });
    }

    @Override
    void takePictureSnapshot(final @NonNull AspectRatio viewAspectRatio) {
        LOG.v("takePictureSnapshot: scheduling");
        this.schedule(null, true, new Runnable(){

            @Override
            public void run() {
                LOG.v("takePictureSnapshot: performing.", Camera1.this.isTakingPicture());
                if (Camera1.this.isTakingPicture()) {
                    return;
                }
                PictureResult result = new PictureResult();
                result.location = Camera1.this.mLocation;
                result.isSnapshot = true;
                result.facing = Camera1.this.mFacing;
                result.size = Camera1.this.getPreviewSize(2);
                result.rotation = Camera1.this.offset(0, 2);
                AspectRatio outputRatio = Camera1.this.flip(2, 1) ? viewAspectRatio.inverse() : viewAspectRatio;
                LOG.v("Rotations", "SV", Camera1.this.offset(0, 1), "VS", Camera1.this.offset(1, 0));
                LOG.v("Rotations", "SO", Camera1.this.offset(0, 2), "OS", Camera1.this.offset(2, 0));
                LOG.v("Rotations", "VO", Camera1.this.offset(1, 2), "OV", Camera1.this.offset(2, 1));
                Camera1.this.mPictureRecorder = new SnapshotPictureRecorder(result, Camera1.this, Camera1.this.mCamera, outputRatio);
                Camera1.this.mPictureRecorder.take();
            }
        });
    }

    public void onPreviewFrame(@NonNull byte[] data, Camera camera) {
        Frame frame = this.mFrameManager.getFrame(data, System.currentTimeMillis(), this.offset(0, 2), this.mPreviewSize, this.mPreviewFormat);
        this.mCameraCallbacks.dispatchFrame(frame);
    }

    private boolean isCameraAvailable() {
        switch (this.mState) {
            case 0: {
                return false;
            }
            case -1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return this.mCamera != null;
            }
        }
        return false;
    }

    @Override
    public void onVideoResult(@Nullable VideoResult result) {
        this.mVideoRecorder = null;
        if (result != null) {
            this.mCameraCallbacks.dispatchOnVideoTaken(result);
        } else {
            this.mCameraCallbacks.dispatchError(new CameraException(5));
            this.mCamera.lock();
        }
    }

    @Override
    void takeVideo(final @NonNull File videoFile) {
        this.schedule(this.mStartVideoTask, true, new Runnable(){

            @Override
            public void run() {
                if (Camera1.this.mMode == Mode.PICTURE) {
                    throw new IllegalStateException("Can't record video while in PICTURE mode");
                }
                if (Camera1.this.isTakingVideo()) {
                    return;
                }
                VideoResult videoResult = new VideoResult();
                videoResult.file = videoFile;
                videoResult.isSnapshot = false;
                videoResult.codec = Camera1.this.mVideoCodec;
                videoResult.location = Camera1.this.mLocation;
                videoResult.facing = Camera1.this.mFacing;
                videoResult.rotation = Camera1.this.offset(0, 2);
                videoResult.size = Camera1.this.flip(0, 2) ? Camera1.this.mCaptureSize.flip() : Camera1.this.mCaptureSize;
                videoResult.audio = Camera1.this.mAudio;
                videoResult.maxSize = Camera1.this.mVideoMaxSize;
                videoResult.maxDuration = Camera1.this.mVideoMaxDuration;
                videoResult.videoBitRate = Camera1.this.mVideoBitRate;
                videoResult.audioBitRate = Camera1.this.mAudioBitRate;
                try {
                    Camera1.this.mCamera.unlock();
                }
                catch (Exception e) {
                    Camera1.this.onVideoResult(null);
                    return;
                }
                Camera1.this.mVideoRecorder = new FullVideoRecorder(videoResult, Camera1.this, Camera1.this, Camera1.this.mCamera, Camera1.this.mCameraId);
                Camera1.this.mVideoRecorder.start();
            }
        });
    }

    @Override
    @SuppressLint(value={"NewApi"})
    void takeVideoSnapshot(final @NonNull File file, final @NonNull AspectRatio viewAspectRatio) {
        if (!(this.mPreview instanceof GlCameraPreview)) {
            throw new IllegalStateException("Video snapshots are only supported with GlCameraPreview.");
        }
        if (Build.VERSION.SDK_INT < 18) {
            throw new IllegalStateException("Video snapshots are only supported starting from API 18.");
        }
        this.schedule(this.mStartVideoTask, true, new Runnable(){

            @Override
            public void run() {
                if (Camera1.this.isTakingVideo()) {
                    return;
                }
                VideoResult videoResult = new VideoResult();
                videoResult.file = file;
                videoResult.isSnapshot = true;
                videoResult.codec = Camera1.this.mVideoCodec;
                videoResult.location = Camera1.this.mLocation;
                videoResult.facing = Camera1.this.mFacing;
                videoResult.videoBitRate = Camera1.this.mVideoBitRate;
                videoResult.audioBitRate = Camera1.this.mAudioBitRate;
                videoResult.audio = Camera1.this.mAudio;
                videoResult.maxSize = Camera1.this.mVideoMaxSize;
                videoResult.maxDuration = Camera1.this.mVideoMaxDuration;
                Facing realFacing = Camera1.this.mFacing;
                Camera1.this.mFacing = Facing.BACK;
                Size outputSize = Camera1.this.getPreviewSize(2);
                AspectRatio outputRatio = Camera1.this.flip(2, 1) ? viewAspectRatio.inverse() : viewAspectRatio;
                Rect outputCrop = CropHelper.computeCrop(outputSize, outputRatio);
                videoResult.size = outputSize = new Size(outputCrop.width(), outputCrop.height());
                videoResult.rotation = Camera1.this.offset(1, 2);
                Camera1.this.mFacing = realFacing;
                GlCameraPreview cameraPreview = (GlCameraPreview)Camera1.this.mPreview;
                Camera1.this.mVideoRecorder = new SnapshotVideoRecorder(videoResult, Camera1.this, cameraPreview);
                Camera1.this.mVideoRecorder.start();
            }
        });
    }

    @Override
    void stopVideo() {
        this.schedule(null, false, new Runnable(){

            @Override
            public void run() {
                LOG.i("stopVideo", "mVideoRecorder is null?", Camera1.this.mVideoRecorder == null);
                if (Camera1.this.mVideoRecorder != null) {
                    Camera1.this.mVideoRecorder.stop();
                    Camera1.this.mVideoRecorder = null;
                }
            }
        });
    }

    @Override
    void setZoom(final float zoom, final @Nullable PointF[] points, final boolean notify) {
        this.schedule(this.mZoomTask, true, new Runnable(){

            @Override
            public void run() {
                if (!Camera1.this.mCameraOptions.isZoomSupported()) {
                    return;
                }
                Camera1.this.mZoomValue = zoom;
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                float max = params.getMaxZoom();
                params.setZoom((int)(zoom * max));
                Camera1.this.mCamera.setParameters(params);
                if (notify) {
                    Camera1.this.mCameraCallbacks.dispatchOnZoomChanged(zoom, points);
                }
            }
        });
    }

    @Override
    void setExposureCorrection(final float EVvalue, final @NonNull float[] bounds, final @Nullable PointF[] points, final boolean notify) {
        this.schedule(this.mExposureCorrectionTask, true, new Runnable(){

            @Override
            public void run() {
                if (!Camera1.this.mCameraOptions.isExposureCorrectionSupported()) {
                    return;
                }
                float value = EVvalue;
                float max = Camera1.this.mCameraOptions.getExposureCorrectionMaxValue();
                float min = Camera1.this.mCameraOptions.getExposureCorrectionMinValue();
                Camera1.this.mExposureCorrectionValue = value = value < min ? min : (value > max ? max : value);
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                int indexValue = (int)(value / params.getExposureCompensationStep());
                params.setExposureCompensation(indexValue);
                Camera1.this.mCamera.setParameters(params);
                if (notify) {
                    Camera1.this.mCameraCallbacks.dispatchOnExposureCorrectionChanged(value, bounds, points);
                }
            }
        });
    }

    @Override
    void startAutoFocus(final @Nullable Gesture gesture, final @NonNull PointF point) {
        int viewWidth = 0;
        int viewHeight = 0;
        if (this.mPreview != null && this.mPreview.hasSurface()) {
            viewWidth = this.mPreview.getView().getWidth();
            viewHeight = this.mPreview.getView().getHeight();
        }
        final int viewWidthF = viewWidth;
        final int viewHeightF = viewHeight;
        this.schedule(null, true, new Runnable(){

            @Override
            public void run() {
                if (!Camera1.this.mCameraOptions.isAutoFocusSupported()) {
                    return;
                }
                final PointF p = new PointF(point.x, point.y);
                List meteringAreas2 = Camera1.computeMeteringAreas(p.x, p.y, viewWidthF, viewHeightF, Camera1.this.offset(0, 1));
                List meteringAreas1 = meteringAreas2.subList(0, 1);
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                int maxAF = params.getMaxNumFocusAreas();
                int maxAE = params.getMaxNumMeteringAreas();
                if (maxAF > 0) {
                    params.setFocusAreas(maxAF > 1 ? meteringAreas2 : meteringAreas1);
                }
                if (maxAE > 0) {
                    params.setMeteringAreas(maxAE > 1 ? meteringAreas2 : meteringAreas1);
                }
                params.setFocusMode("auto");
                Camera1.this.mCamera.setParameters(params);
                Camera1.this.mCameraCallbacks.dispatchOnFocusStart(gesture, p);
                try {
                    Camera1.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            Camera1.this.mCameraCallbacks.dispatchOnFocusEnd(gesture, success, p);
                            Camera1.this.mHandler.get().removeCallbacks(Camera1.this.mPostFocusResetRunnable);
                            Camera1.this.mHandler.get().postDelayed(Camera1.this.mPostFocusResetRunnable, 3000L);
                        }
                    });
                }
                catch (RuntimeException e) {
                    LOG.e("startAutoFocus:", "Error calling autoFocus", e);
                    Camera1.this.mCameraCallbacks.dispatchOnFocusEnd(gesture, false, p);
                }
            }
        });
    }

    @NonNull
    @WorkerThread
    private static List<Camera.Area> computeMeteringAreas(double viewClickX, double viewClickY, int viewWidth, int viewHeight, int sensorToDisplay) {
        int displayToSensor = -sensorToDisplay;
        viewClickX = -1000.0 + viewClickX / (double)viewWidth * 2000.0;
        viewClickY = -1000.0 + viewClickY / (double)viewHeight * 2000.0;
        double theta = (double)displayToSensor * Math.PI / 180.0;
        double sensorClickX = viewClickX * Math.cos(theta) - viewClickY * Math.sin(theta);
        double sensorClickY = viewClickX * Math.sin(theta) + viewClickY * Math.cos(theta);
        LOG.i("focus:", "viewClickX:", viewClickX, "viewClickY:", viewClickY);
        LOG.i("focus:", "sensorClickX:", sensorClickX, "sensorClickY:", sensorClickY);
        Rect rect1 = Camera1.computeMeteringArea(sensorClickX, sensorClickY, 150.0);
        int weight1 = 1000;
        Rect rect2 = Camera1.computeMeteringArea(sensorClickX, sensorClickY, 300.0);
        int weight2 = 100;
        ArrayList<Camera.Area> list = new ArrayList<Camera.Area>(2);
        list.add(new Camera.Area(rect1, weight1));
        list.add(new Camera.Area(rect2, weight2));
        return list;
    }

    @NonNull
    private static Rect computeMeteringArea(double centerX, double centerY, double size) {
        double delta = size / 2.0;
        int top = (int)Math.max(centerY - delta, -1000.0);
        int bottom = (int)Math.min(centerY + delta, 1000.0);
        int left = (int)Math.max(centerX - delta, -1000.0);
        int right = (int)Math.min(centerX + delta, 1000.0);
        LOG.i("focus:", "computeMeteringArea:", "top:", top, "left:", left, "bottom:", bottom, "right:", right);
        return new Rect(left, top, right, bottom);
    }

    @Nullable
    private List<Size> sizesFromList(@Nullable List<Camera.Size> sizes) {
        if (sizes == null) {
            return null;
        }
        ArrayList<Size> result = new ArrayList<Size>(sizes.size());
        for (Camera.Size size : sizes) {
            Size add = new Size(size.width, size.height);
            if (result.contains(add)) continue;
            result.add(add);
        }
        LOG.i("size:", "sizesFromList:", result);
        return result;
    }

    @Override
    void setPlaySounds(boolean playSounds) {
        final boolean old = this.mPlaySounds;
        this.mPlaySounds = playSounds;
        this.schedule(this.mPlaySoundsTask, true, new Runnable(){

            @Override
            public void run() {
                Camera1.this.applyPlaySounds(old);
            }
        });
    }
}

