/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.ByteBufferPool;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.InputBuffer;
import com.otaliastudios.cameraview.InputBufferPool;
import com.otaliastudios.cameraview.MediaEncoder;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;

@RequiresApi(api=18)
class AudioMediaEncoder
extends MediaEncoder {
    private static final String TAG = AudioMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final String MIME_TYPE = "audio/mp4a-latm";
    private static final int ENCODING = 2;
    private static final int CHANNELS = 16;
    private static final int SAMPLING_FREQUENCY = 44100;
    private static final int CHANNELS_COUNT = 1;
    private static final int SAMPLE_SIZE = 2;
    private static final int BYTE_RATE_PER_CHANNEL = 88200;
    private static final int BYTE_RATE = 88200;
    static final int BIT_RATE = 705600;
    private static final int FRAME_SIZE_PER_CHANNEL = 1024;
    private static final int FRAME_SIZE = 1024;
    private static final int BUFFER_POOL_MAX_SIZE = 200;
    private boolean mRequestStop = false;
    private AudioEncodingHandler mEncoder;
    private AudioRecordingThread mRecorder;
    private ByteBufferPool mByteBufferPool;
    private Config mConfig;

    AudioMediaEncoder(@NonNull Config config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    String getName() {
        return "AudioEncoder";
    }

    @Override
    @EncoderThread
    void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)44100, (int)1);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", 16);
        audioFormat.setInteger("bitrate", this.mConfig.bitRate);
        audioFormat.setInteger("channel-count", 1);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.mByteBufferPool = new ByteBufferPool(1024, 200);
        this.mEncoder = new AudioEncodingHandler();
        this.mRecorder = new AudioRecordingThread();
    }

    @Override
    @EncoderThread
    void onStart() {
        this.mRequestStop = false;
        this.mRecorder.start();
    }

    @Override
    @EncoderThread
    void onEvent(@NonNull String event, @Nullable Object data) {
    }

    @Override
    @EncoderThread
    void onStop() {
        this.mRequestStop = true;
    }

    @Override
    void onRelease() {
        this.mRequestStop = false;
        this.mEncoder = null;
        this.mRecorder = null;
        if (this.mByteBufferPool != null) {
            this.mByteBufferPool.clear();
            this.mByteBufferPool = null;
        }
    }

    @Override
    int getEncodedBitRate() {
        return this.mConfig.bitRate;
    }

    @SuppressLint(value={"HandlerLeak"})
    class AudioEncodingHandler
    extends Handler {
        InputBufferPool mInputBufferPool;
        LinkedBlockingQueue<InputBuffer> mPendingOps;

        AudioEncodingHandler() {
            super(WorkerHandler.get("AudioEncodingHandler").getLooper());
            this.mInputBufferPool = new InputBufferPool();
            this.mPendingOps = new LinkedBlockingQueue();
        }

        void sendInputBuffer(ByteBuffer buffer, long presentationTimeUs, boolean endOfStream) {
            int presentation1 = (int)(presentationTimeUs >> 32);
            int presentation2 = (int)presentationTimeUs;
            this.sendMessage(this.obtainMessage(endOfStream ? 1 : 0, presentation1, presentation2, buffer));
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            boolean endOfStream = msg.what == 1;
            long timestamp = (long)msg.arg1 << 32 | (long)msg.arg2 & 0xFFFFFFFFL;
            ByteBuffer buffer = (ByteBuffer)msg.obj;
            int readBytes = buffer.remaining();
            InputBuffer inputBuffer = (InputBuffer)this.mInputBufferPool.get();
            inputBuffer.source = buffer;
            inputBuffer.timestamp = timestamp;
            inputBuffer.length = readBytes;
            inputBuffer.isEndOfStream = endOfStream;
            this.mPendingOps.add(inputBuffer);
            this.performPendingOps(endOfStream);
        }

        private void performPendingOps(boolean force) {
            InputBuffer buffer;
            LOG.v("Performing", this.mPendingOps.size(), "Pending operations.");
            while ((buffer = this.mPendingOps.peek()) != null) {
                if (force) {
                    AudioMediaEncoder.this.acquireInputBuffer(buffer);
                    this.performPendingOp(buffer);
                    continue;
                }
                if (!AudioMediaEncoder.this.tryAcquireInputBuffer(buffer)) break;
                this.performPendingOp(buffer);
            }
        }

        private void performPendingOp(InputBuffer buffer) {
            buffer.data.put(buffer.source);
            AudioMediaEncoder.this.mByteBufferPool.recycle(buffer.source);
            this.mPendingOps.remove(buffer);
            AudioMediaEncoder.this.encodeInputBuffer(buffer);
            boolean eos = buffer.isEndOfStream;
            this.mInputBufferPool.recycle(buffer);
            AudioMediaEncoder.this.drainOutput(eos);
            if (eos) {
                this.mInputBufferPool.clear();
                WorkerHandler.get("AudioEncodingHandler").getThread().interrupt();
            }
        }
    }

    class AudioRecordingThread
    extends Thread {
        private AudioRecord mAudioRecord;
        private ByteBuffer mCurrentBuffer;
        private int mReadBytes;
        private long mLastTimeUs;
        private AudioTimestamp mApi24Timestamp;
        private long mStartTimeUs;
        private long mTotalReadBytes;

        AudioRecordingThread() {
            int bufferSize;
            int minBufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
            for (bufferSize = 25600; bufferSize < minBufferSize; bufferSize += 1024) {
            }
            this.mAudioRecord = new AudioRecord(5, 44100, 16, 2, bufferSize);
            this.setPriority(10);
        }

        @Override
        public void run() {
            this.mLastTimeUs = System.nanoTime() / 1000L;
            this.mAudioRecord.startRecording();
            while (!AudioMediaEncoder.this.mRequestStop) {
                this.read(false);
            }
            LOG.w("RECORDER: Stop was requested. We're out of the loop. Will post an endOfStream.");
            this.read(true);
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
        }

        private void read(boolean endOfStream) {
            this.mCurrentBuffer = (ByteBuffer)AudioMediaEncoder.this.mByteBufferPool.get();
            if (this.mCurrentBuffer == null) {
                LOG.e("Skipping audio frame, encoding is too slow.");
            } else {
                this.mCurrentBuffer.clear();
                this.mReadBytes = this.mAudioRecord.read(this.mCurrentBuffer, 1024);
                if (this.mReadBytes > 0) {
                    this.increaseTime(this.mReadBytes);
                    this.mCurrentBuffer.limit(this.mReadBytes);
                    this.onBuffer(endOfStream);
                } else if (this.mReadBytes == -3) {
                    LOG.e("Got AudioRecord.ERROR_INVALID_OPERATION");
                } else if (this.mReadBytes == -2) {
                    LOG.e("Got AudioRecord.ERROR_BAD_VALUE");
                }
            }
        }

        private void onBuffer(boolean endOfStream) {
            AudioMediaEncoder.this.mEncoder.sendInputBuffer(this.mCurrentBuffer, this.mLastTimeUs, endOfStream);
        }

        private void increaseTime(int readBytes) {
            this.increaseTime3(readBytes);
            LOG.v("Read", readBytes, "bytes, increasing PTS to", this.mLastTimeUs);
        }

        private void increaseTime1(int readBytes) {
            this.mLastTimeUs += 1000000L * (long)readBytes / 88200L;
        }

        @RequiresApi(value=24)
        private void increaseTime2(int readBytes) {
            if (this.mApi24Timestamp == null) {
                this.mApi24Timestamp = new AudioTimestamp();
            }
            this.mAudioRecord.getTimestamp(this.mApi24Timestamp, 0);
            this.mLastTimeUs = this.mApi24Timestamp.nanoTime / 1000L;
        }

        private void increaseTime3(int readBytes) {
            long correctedTime;
            long currentTime = System.nanoTime() / 1000L;
            long bufferDuration = 1000000 * readBytes / 88200;
            long bufferTime = currentTime - bufferDuration;
            if (this.mTotalReadBytes == 0L) {
                this.mStartTimeUs = bufferTime;
            }
            if (bufferTime - (correctedTime = this.mStartTimeUs + 1000000L * this.mTotalReadBytes / 88200L) >= 2L * bufferDuration) {
                this.mStartTimeUs = bufferTime;
                this.mTotalReadBytes = 0L;
                correctedTime = this.mStartTimeUs;
            }
            this.mTotalReadBytes += (long)readBytes;
            this.mLastTimeUs = correctedTime;
        }
    }

    static class Config {
        int bitRate;

        Config(int bitRate) {
            this.bitRate = bitRate;
        }
    }
}

