/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.Size;
import java.util.HashMap;

public class AspectRatio
implements Comparable<AspectRatio> {
    static final HashMap<String, AspectRatio> sCache = new HashMap(16);
    private final int mX;
    private final int mY;

    @NonNull
    public static AspectRatio of(Size size) {
        return AspectRatio.of(size.getWidth(), size.getHeight());
    }

    @NonNull
    public static AspectRatio of(int x, int y) {
        int gcd;
        String key;
        AspectRatio cached;
        if ((cached = sCache.get(key = (x /= (gcd = AspectRatio.gcd(x, y))) + ":" + (y /= gcd))) == null) {
            cached = new AspectRatio(x, y);
            sCache.put(key, cached);
        }
        return cached;
    }

    @NonNull
    public static AspectRatio parse(@NonNull String string) {
        String[] parts = string.split(":");
        if (parts.length != 2) {
            throw new NumberFormatException("Illegal AspectRatio string. Must be x:y");
        }
        int x = Integer.valueOf(parts[0]);
        int y = Integer.valueOf(parts[1]);
        return AspectRatio.of(x, y);
    }

    private AspectRatio(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public boolean matches(@NonNull Size size) {
        int gcd = AspectRatio.gcd(size.getWidth(), size.getHeight());
        int x = size.getWidth() / gcd;
        int y = size.getHeight() / gcd;
        return this.mX == x && this.mY == y;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof AspectRatio) {
            AspectRatio ratio = (AspectRatio)o;
            return this.mX == ratio.mX && this.mY == ratio.mY;
        }
        return false;
    }

    public String toString() {
        return this.mX + ":" + this.mY;
    }

    public float toFloat() {
        return (float)this.mX / (float)this.mY;
    }

    public int hashCode() {
        return this.mY ^ (this.mX << 16 | this.mX >>> 16);
    }

    @Override
    public int compareTo(@NonNull AspectRatio another) {
        if (this.equals(another)) {
            return 0;
        }
        if (this.toFloat() - another.toFloat() > 0.0f) {
            return 1;
        }
        return -1;
    }

    @NonNull
    public AspectRatio inverse() {
        return AspectRatio.of(this.mY, this.mX);
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        return a;
    }
}

