/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.opengl.EGLContext;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EglCore;
import com.otaliastudios.cameraview.EglViewport;
import com.otaliastudios.cameraview.EglWindowSurface;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import com.otaliastudios.cameraview.VideoMediaEncoder;

@RequiresApi(api=18)
class TextureMediaEncoder
extends VideoMediaEncoder<Config> {
    private static final String TAG = TextureMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final String FRAME_EVENT = "frame";
    private EglCore mEglCore;
    private EglWindowSurface mWindow;
    private EglViewport mViewport;

    TextureMediaEncoder(@NonNull Config config) {
        super(config);
    }

    @Override
    @EncoderThread
    void prepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        super.prepare(controller, maxLengthMillis);
        this.mEglCore = new EglCore(((Config)this.mConfig).eglContext, 1);
        this.mWindow = new EglWindowSurface(this.mEglCore, this.mSurface, true);
        this.mWindow.makeCurrent();
        this.mViewport = new EglViewport();
    }

    @Override
    @EncoderThread
    void release() {
        super.release();
        if (this.mWindow != null) {
            this.mWindow.release();
            this.mWindow = null;
        }
        if (this.mViewport != null) {
            this.mViewport.release(true);
            this.mViewport = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    @Override
    @EncoderThread
    void start() {
        super.start();
    }

    @Override
    @EncoderThread
    void notify(@NonNull String event, @Nullable Object data) {
        if (event.equals(FRAME_EVENT)) {
            Frame frame = (Frame)data;
            if (frame.timestamp == 0L) {
                return;
            }
            if (this.mFrameNum < 0) {
                return;
            }
            ++this.mFrameNum;
            int arg1 = (int)(frame.timestamp >> 32);
            int arg2 = (int)frame.timestamp;
            long timestamp = (long)arg1 << 32 | (long)arg2 & 0xFFFFFFFFL;
            float[] transform = frame.transform;
            float scaleX = ((Config)this.mConfig).scaleX;
            float scaleY = ((Config)this.mConfig).scaleY;
            float scaleTranslX = (1.0f - scaleX) / 2.0f;
            float scaleTranslY = (1.0f - scaleY) / 2.0f;
            Matrix.translateM((float[])transform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
            Matrix.scaleM((float[])transform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
            Matrix.translateM((float[])transform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])transform, (int)0, (float)((Config)this.mConfig).transformRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])transform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
            this.drain(false);
            this.mViewport.drawFrame(((Config)this.mConfig).textureId, transform);
            this.mWindow.setPresentationTime(timestamp);
            this.mWindow.swapBuffers();
        }
    }

    static class Config
    extends VideoMediaEncoder.Config {
        int textureId;
        float scaleX;
        float scaleY;
        boolean scaleFlipped;
        EGLContext eglContext;
        int transformRotation;

        Config(int width, int height, int bitRate, int frameRate, int rotation, String mimeType, int textureId, float scaleX, float scaleY, boolean scaleFlipped, EGLContext eglContext) {
            super(width, height, bitRate, frameRate, 0, mimeType);
            this.transformRotation = rotation;
            this.textureId = textureId;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleFlipped = scaleFlipped;
            this.eglContext = eglContext;
        }
    }

    static class Frame {
        float[] transform;
        long timestamp;

        Frame() {
        }
    }
}

