/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.AudioMediaEncoder;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.GlCameraPreview;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import com.otaliastudios.cameraview.RendererThread;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.TextureMediaEncoder;
import com.otaliastudios.cameraview.VideoRecorder;
import com.otaliastudios.cameraview.VideoResult;

@RequiresApi(api=18)
class SnapshotVideoRecorder
extends VideoRecorder
implements GlCameraPreview.RendererFrameCallback,
MediaEncoderEngine.Listener {
    private static final String TAG = SnapshotVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int DEFAULT_VIDEO_FRAMERATE = 30;
    private static final int DEFAULT_VIDEO_BITRATE = 1000000;
    private static final int DEFAULT_AUDIO_BITRATE = 64000;
    private static final int STATE_RECORDING = 0;
    private static final int STATE_NOT_RECORDING = 1;
    private MediaEncoderEngine mEncoderEngine;
    private GlCameraPreview mPreview;
    private int mCurrentState = 1;
    private int mDesiredState = 1;
    private int mTextureId = 0;

    SnapshotVideoRecorder(@NonNull VideoResult stub, @Nullable VideoRecorder.VideoResultListener listener, @NonNull GlCameraPreview preview) {
        super(stub, listener);
        this.mPreview = preview;
        this.mPreview.addRendererFrameCallback(this);
    }

    @Override
    void start() {
        this.mDesiredState = 0;
    }

    @Override
    void stop() {
        this.mDesiredState = 1;
    }

    @Override
    @RendererThread
    public void onRendererTextureCreated(int textureId) {
        this.mTextureId = textureId;
    }

    @Override
    @RendererThread
    public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, float scaleX, float scaleY) {
        if (this.mCurrentState == 1 && this.mDesiredState == 0) {
            Size size = this.mResult.getSize();
            int width = size.getWidth();
            int height = size.getHeight();
            width = width % 2 == 0 ? width : width + 1;
            height = height % 2 == 0 ? height : height + 1;
            String type = "";
            switch (this.mResult.codec) {
                case H_263: {
                    type = "video/3gpp";
                    break;
                }
                case H_264: {
                    type = "video/avc";
                    break;
                }
                case DEVICE_DEFAULT: {
                    type = "video/avc";
                }
            }
            if (this.mResult.videoBitRate <= 0) {
                this.mResult.videoBitRate = 1000000;
            }
            if (this.mResult.audioBitRate <= 0) {
                this.mResult.audioBitRate = 64000;
            }
            if (this.mResult.videoFrameRate <= 0) {
                this.mResult.videoFrameRate = 30;
            }
            LOG.w("Creating frame encoder. Rotation:", this.mResult.rotation);
            TextureMediaEncoder.Config config = new TextureMediaEncoder.Config(width, height, this.mResult.videoBitRate, this.mResult.videoFrameRate, this.mResult.rotation, type, this.mTextureId, scaleX, scaleY, this.mPreview.mInputFlipped, EGL14.eglGetCurrentContext());
            TextureMediaEncoder videoEncoder = new TextureMediaEncoder(config);
            AudioMediaEncoder audioEncoder = null;
            if (this.mResult.audio == Audio.ON) {
                audioEncoder = new AudioMediaEncoder(new AudioMediaEncoder.Config(this.mResult.audioBitRate));
            }
            this.mEncoderEngine = new MediaEncoderEngine(this.mResult.file, videoEncoder, audioEncoder, this.mResult.maxDuration, this.mResult.maxSize, this);
            this.mEncoderEngine.start();
            this.mResult.rotation = 0;
            this.mCurrentState = 0;
        }
        if (this.mCurrentState == 0) {
            TextureMediaEncoder.Frame frame = new TextureMediaEncoder.Frame();
            frame.timestamp = surfaceTexture.getTimestamp();
            frame.transform = new float[16];
            surfaceTexture.getTransformMatrix(frame.transform);
            this.mEncoderEngine.notify("frame", frame);
        }
        if (this.mCurrentState == 0 && this.mDesiredState == 1) {
            this.mCurrentState = 1;
            this.mEncoderEngine.stop();
            this.mEncoderEngine = null;
            this.mPreview.removeRendererFrameCallback(this);
            this.mPreview = null;
        }
    }

    @Override
    @EncoderThread
    public void onEncoderStop(int stopReason, @Nullable Exception e) {
        if (e != null) {
            this.mResult = null;
        } else if (stopReason == 1) {
            this.mResult.endReason = 2;
        } else if (stopReason == 2) {
            this.mResult.endReason = 1;
        }
        this.mEncoderEngine = null;
        if (this.mPreview != null) {
            this.mPreview.removeRendererFrameCallback(this);
            this.mPreview = null;
        }
        this.dispatchResult();
    }
}

