/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.BitmapFactory;
import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.BitmapCallback;
import com.otaliastudios.cameraview.CameraUtils;
import com.otaliastudios.cameraview.FileCallback;
import com.otaliastudios.cameraview.Size;
import java.io.File;

public class PictureResult {
    public static final int FORMAT_JPEG = 0;
    boolean isSnapshot;
    Location location;
    int rotation;
    Size size;
    byte[] data;
    int format;

    PictureResult() {
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public Size getSize() {
        return this.size;
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    public int getFormat() {
        return this.format;
    }

    public void toBitmap(int maxWidth, int maxHeight, @NonNull BitmapCallback callback) {
        CameraUtils.decodeBitmap(this.getData(), maxWidth, maxHeight, new BitmapFactory.Options(), this.rotation, callback);
    }

    public void toBitmap(@NonNull BitmapCallback callback) {
        this.toBitmap(-1, -1, callback);
    }

    public void toFile(@NonNull File file, @NonNull FileCallback callback) {
        CameraUtils.writeToFile(this.getData(), file, callback);
    }
}

