/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.AudioMediaEncoder;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoder;
import com.otaliastudios.cameraview.VideoMediaEncoder;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@RequiresApi(api=18)
class MediaEncoderEngine {
    private static final String TAG = MediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final int STOP_BY_USER = 0;
    static final int STOP_BY_MAX_DURATION = 1;
    static final int STOP_BY_MAX_SIZE = 2;
    private WorkerHandler mWorker;
    private ArrayList<MediaEncoder> mEncoders;
    private MediaMuxer mMediaMuxer;
    private int mMediaMuxerStartCount;
    private boolean mMediaMuxerStarted;
    private Controller mController;
    private Listener mListener;
    private int mStopReason = 0;
    private int mPossibleStopReason;
    private final Object mLock = new Object();

    MediaEncoderEngine(@NonNull File file, @NonNull VideoMediaEncoder videoEncoder, @Nullable AudioMediaEncoder audioEncoder, final int maxDuration, final long maxSize, @Nullable Listener listener) {
        this.mWorker = WorkerHandler.get("EncoderEngine");
        this.mListener = listener;
        this.mController = new Controller();
        this.mEncoders = new ArrayList();
        this.mEncoders.add(videoEncoder);
        if (audioEncoder != null) {
            this.mEncoders.add(audioEncoder);
        }
        try {
            this.mMediaMuxer = new MediaMuxer(file.toString(), 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaMuxerStartCount = 0;
        this.mMediaMuxerStarted = false;
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                int bitRate = 0;
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    bitRate += encoder.getBitRate();
                }
                int bytePerSecond = bitRate / 8;
                long sizeMaxDuration = maxSize / (long)bytePerSecond * 1000L;
                long finalMaxDuration = Long.MAX_VALUE;
                if (maxSize > 0L && maxDuration > 0) {
                    MediaEncoderEngine.this.mPossibleStopReason = sizeMaxDuration < (long)maxDuration ? 2 : 1;
                    finalMaxDuration = Math.min(sizeMaxDuration, (long)maxDuration);
                } else if (maxSize > 0L) {
                    MediaEncoderEngine.this.mPossibleStopReason = 2;
                    finalMaxDuration = sizeMaxDuration;
                } else if (maxDuration > 0) {
                    MediaEncoderEngine.this.mPossibleStopReason = 1;
                    finalMaxDuration = maxDuration;
                }
                LOG.i("Computed a max duration of", Float.valueOf((float)finalMaxDuration / 1000.0f));
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    encoder.prepare(MediaEncoderEngine.this.mController, finalMaxDuration);
                }
            }
        });
    }

    void start() {
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    encoder.start();
                }
            }
        });
    }

    void notify(final String event, final Object data) {
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    encoder.notify(event, data);
                }
            }
        });
    }

    void stop() {
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    encoder.stop();
                }
                for (MediaEncoder encoder : MediaEncoderEngine.this.mEncoders) {
                    encoder.release();
                }
                Exception error = null;
                if (MediaEncoderEngine.this.mMediaMuxer != null) {
                    try {
                        MediaEncoderEngine.this.mMediaMuxer.stop();
                        MediaEncoderEngine.this.mMediaMuxer.release();
                    }
                    catch (Exception e) {
                        error = e;
                    }
                    MediaEncoderEngine.this.mMediaMuxer = null;
                }
                if (MediaEncoderEngine.this.mListener != null) {
                    MediaEncoderEngine.this.mListener.onEncoderStop(MediaEncoderEngine.this.mStopReason, error);
                }
                MediaEncoderEngine.this.mStopReason = 0;
                MediaEncoderEngine.this.mListener = null;
                MediaEncoderEngine.this.mMediaMuxerStartCount = 0;
                MediaEncoderEngine.this.mMediaMuxerStarted = false;
            }
        });
    }

    static interface Listener {
        @EncoderThread
        public void onEncoderStop(int var1, @Nullable Exception var2);
    }

    class Controller {
        Controller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int start(MediaFormat format) {
            Object object = MediaEncoderEngine.this.mLock;
            synchronized (object) {
                if (MediaEncoderEngine.this.mMediaMuxerStarted) {
                    throw new IllegalStateException("Trying to start but muxer started already");
                }
                int track = MediaEncoderEngine.this.mMediaMuxer.addTrack(format);
                MediaEncoderEngine.this.mMediaMuxerStartCount++;
                if (MediaEncoderEngine.this.mMediaMuxerStartCount == MediaEncoderEngine.this.mEncoders.size()) {
                    MediaEncoderEngine.this.mMediaMuxer.start();
                    MediaEncoderEngine.this.mMediaMuxerStarted = true;
                }
                return track;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            Object object = MediaEncoderEngine.this.mLock;
            synchronized (object) {
                return MediaEncoderEngine.this.mMediaMuxerStarted;
            }
        }

        void write(int track, ByteBuffer encodedData, MediaCodec.BufferInfo info) {
            if (!MediaEncoderEngine.this.mMediaMuxerStarted) {
                throw new IllegalStateException("Trying to write before muxer started");
            }
            MediaEncoderEngine.this.mMediaMuxer.writeSampleData(track, encodedData, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestStop() {
            Object object = MediaEncoderEngine.this.mLock;
            synchronized (object) {
                MediaEncoderEngine.this.mMediaMuxerStartCount--;
                if (MediaEncoderEngine.this.mMediaMuxerStartCount == 0) {
                    MediaEncoderEngine.this.mStopReason = MediaEncoderEngine.this.mPossibleStopReason;
                    MediaEncoderEngine.this.stop();
                }
            }
        }
    }
}

