/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
abstract class MediaEncoder {
    private static final int TIMEOUT_USEC = 10000;
    protected MediaCodec mMediaCodec;
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaEncoderEngine.Controller mController;
    private int mTrackIndex;
    private long mMaxLengthMillis;
    private boolean mMaxLengthReached;
    private long mStartPresentationTime = 0L;
    private long mLastPresentationTime = 0L;

    MediaEncoder() {
    }

    @EncoderThread
    void prepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        this.mController = controller;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        this.mMaxLengthMillis = maxLengthMillis;
    }

    @EncoderThread
    abstract void start();

    @EncoderThread
    abstract void notify(@NonNull String var1, @Nullable Object var2);

    @EncoderThread
    abstract void stop();

    @EncoderThread
    void release() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
    }

    protected void encode(@Nullable ByteBuffer buffer, int length, long presentationTimeUs) {
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (true) {
            int inputBufferIndex;
            if ((inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L)) >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null) {
                    inputBuffer.put(buffer);
                }
                if (length <= 0) {
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                break;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drain(boolean endOfStream) {
        if (endOfStream) {
            this.mMediaCodec.signalEndOfInputStream();
        }
        ByteBuffer[] encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        while (true) {
            boolean isCodecConfig;
            int encoderStatus;
            if ((encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L)) == -1) {
                if (endOfStream) continue;
                return;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mController.isStarted()) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat newFormat = this.mMediaCodec.getOutputFormat();
                this.mTrackIndex = this.mController.start(newFormat);
                continue;
            }
            if (encoderStatus < 0) {
                Log.w((String)"VideoMediaEncoder", (String)("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus));
                continue;
            }
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            boolean bl = isCodecConfig = (this.mBufferInfo.flags & 2) != 0;
            if (!isCodecConfig && this.mController.isStarted() && this.mBufferInfo.size != 0) {
                encodedData.position(this.mBufferInfo.offset);
                encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                this.mController.write(this.mTrackIndex, encodedData, this.mBufferInfo);
                this.mLastPresentationTime = this.mBufferInfo.presentationTimeUs;
                if (this.mStartPresentationTime == 0L) {
                    this.mStartPresentationTime = this.mLastPresentationTime;
                }
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
            if (!this.mMaxLengthReached && this.mLastPresentationTime / 1000L - this.mStartPresentationTime / 1000L > this.mMaxLengthMillis) {
                this.mMaxLengthReached = true;
                this.mController.requestStop();
                return;
            }
            if ((this.mBufferInfo.flags & 4) != 0) return;
        }
    }

    long getPresentationTime() {
        long result = System.nanoTime() / 1000L;
        if (result < this.mLastPresentationTime) {
            result = this.mLastPresentationTime - result + result;
        }
        return result;
    }

    abstract int getBitRate();
}

