/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.EglViewport;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.RendererThread;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class GlCameraPreview
extends CameraPreview<GLSurfaceView, SurfaceTexture>
implements GLSurfaceView.Renderer {
    private boolean mDispatched;
    private final float[] mTransformMatrix = new float[16];
    private int mOutputTextureId = 0;
    private SurfaceTexture mInputSurfaceTexture;
    private EglViewport mOutputViewport;
    private Set<RendererFrameCallback> mRendererFrameCallbacks = Collections.synchronizedSet(new HashSet());
    float mScaleX = 1.0f;
    float mScaleY = 1.0f;
    private View mRootView;

    GlCameraPreview(@NonNull Context context, @NonNull ViewGroup parent, @Nullable CameraPreview.SurfaceCallback callback) {
        super(context, parent, callback);
    }

    @Override
    @NonNull
    protected GLSurfaceView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        ViewGroup root = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.cameraview_gl_view, parent, false);
        GLSurfaceView glView = (GLSurfaceView)root.findViewById(R.id.gl_surface_view);
        glView.setEGLContextClientVersion(2);
        glView.setRenderer((GLSurfaceView.Renderer)this);
        glView.setRenderMode(0);
        glView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                GlCameraPreview.this.dispatchOnOutputSurfaceDestroyed();
                GlCameraPreview.this.mDispatched = false;
            }
        });
        parent.addView((View)root, 0);
        this.mRootView = root;
        return glView;
    }

    @Override
    @NonNull
    View getRootView() {
        return this.mRootView;
    }

    @Override
    public void onResume() {
        super.onResume();
        ((GLSurfaceView)this.getView()).onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
        ((GLSurfaceView)this.getView()).onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRendererFrameCallbacks.clear();
        if (this.mInputSurfaceTexture != null) {
            this.mInputSurfaceTexture.setOnFrameAvailableListener(null);
            this.mInputSurfaceTexture.release();
            this.mInputSurfaceTexture = null;
        }
        this.mOutputTextureId = 0;
        if (this.mOutputViewport != null) {
            this.mOutputViewport.release();
            this.mOutputViewport = null;
        }
    }

    @RendererThread
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mOutputViewport = new EglViewport();
        this.mOutputTextureId = this.mOutputViewport.createTexture();
        this.mInputSurfaceTexture = new SurfaceTexture(this.mOutputTextureId);
        ((GLSurfaceView)this.getView()).queueEvent(new Runnable(){

            @Override
            public void run() {
                for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                    callback.onRendererTextureCreated(GlCameraPreview.this.mOutputTextureId);
                }
            }
        });
        this.mInputSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                ((GLSurfaceView)GlCameraPreview.this.getView()).requestRender();
            }
        });
    }

    @RendererThread
    public void onSurfaceChanged(GL10 gl, final int width, final int height) {
        if (!this.mDispatched) {
            this.dispatchOnOutputSurfaceAvailable(width, height);
            this.mDispatched = true;
        } else if (this.mOutputSurfaceWidth != width || this.mOutputSurfaceHeight != height) {
            this.dispatchOnOutputSurfaceDestroyed();
            ((GLSurfaceView)this.getView()).post(new Runnable(){

                @Override
                public void run() {
                    ((GLSurfaceView)GlCameraPreview.this.getView()).onPause();
                    ((GLSurfaceView)GlCameraPreview.this.getView()).onResume();
                    GlCameraPreview.this.dispatchOnOutputSurfaceAvailable(width, height);
                }
            });
        }
    }

    @RendererThread
    public void onDrawFrame(GL10 gl) {
        this.mInputSurfaceTexture.updateTexImage();
        if (this.mInputStreamWidth <= 0 || this.mInputStreamHeight <= 0) {
            return;
        }
        this.mInputSurfaceTexture.getTransformMatrix(this.mTransformMatrix);
        if (this.isCropping()) {
            float translX = (1.0f - this.mScaleX) / 2.0f;
            float translY = (1.0f - this.mScaleY) / 2.0f;
            Matrix.translateM((float[])this.mTransformMatrix, (int)0, (float)translX, (float)translY, (float)0.0f);
            Matrix.scaleM((float[])this.mTransformMatrix, (int)0, (float)this.mScaleX, (float)this.mScaleY, (float)1.0f);
        }
        this.mOutputViewport.drawFrame(this.mOutputTextureId, this.mTransformMatrix);
        for (RendererFrameCallback callback : this.mRendererFrameCallbacks) {
            callback.onRendererFrame(this.mInputSurfaceTexture, this.mScaleX, this.mScaleY);
        }
    }

    @Override
    @NonNull
    Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    @NonNull
    SurfaceTexture getOutput() {
        return this.mInputSurfaceTexture;
    }

    @Override
    boolean supportsCropping() {
        return true;
    }

    @Override
    protected void crop() {
        this.mCropTask.start();
        if (this.mInputStreamWidth > 0 && this.mInputStreamHeight > 0 && this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            AspectRatio current = AspectRatio.of(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
            AspectRatio target = AspectRatio.of(this.mInputStreamWidth, this.mInputStreamHeight);
            if (current.toFloat() >= target.toFloat()) {
                scaleY = current.toFloat() / target.toFloat();
            } else {
                scaleX = target.toFloat() / current.toFloat();
            }
            this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
            this.mScaleX = 1.0f / scaleX;
            this.mScaleY = 1.0f / scaleY;
            ((GLSurfaceView)this.getView()).requestRender();
        }
        this.mCropTask.end(null);
    }

    void addRendererFrameCallback(final @NonNull RendererFrameCallback callback) {
        ((GLSurfaceView)this.getView()).queueEvent(new Runnable(){

            @Override
            public void run() {
                GlCameraPreview.this.mRendererFrameCallbacks.add(callback);
                if (GlCameraPreview.this.mOutputTextureId != 0) {
                    callback.onRendererTextureCreated(GlCameraPreview.this.mOutputTextureId);
                }
            }
        });
    }

    void removeRendererFrameCallback(@NonNull RendererFrameCallback callback) {
        this.mRendererFrameCallbacks.remove(callback);
    }

    static interface RendererFrameCallback {
        @RendererThread
        public void onRendererTextureCreated(int var1);

        @RendererThread
        public void onRendererFrame(SurfaceTexture var1, float var2, float var3);
    }
}

