/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.Nullable;

public enum GestureAction {
    NONE(0),
    FOCUS(1),
    FOCUS_WITH_MARKER(2),
    CAPTURE(3),
    ZOOM(4),
    EXPOSURE_CORRECTION(5);

    static final GestureAction DEFAULT_PINCH;
    static final GestureAction DEFAULT_TAP;
    static final GestureAction DEFAULT_LONG_TAP;
    static final GestureAction DEFAULT_SCROLL_HORIZONTAL;
    static final GestureAction DEFAULT_SCROLL_VERTICAL;
    private int value;

    private GestureAction(int value) {
        this.value = value;
    }

    int value() {
        return this.value;
    }

    @Nullable
    static GestureAction fromValue(int value) {
        GestureAction[] list;
        for (GestureAction action : list = GestureAction.values()) {
            if (action.value() != value) continue;
            return action;
        }
        return null;
    }

    static {
        DEFAULT_PINCH = NONE;
        DEFAULT_TAP = NONE;
        DEFAULT_LONG_TAP = NONE;
        DEFAULT_SCROLL_HORIZONTAL = NONE;
        DEFAULT_SCROLL_VERTICAL = NONE;
    }
}

