/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.Camera1;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.VideoRecorder;
import com.otaliastudios.cameraview.VideoResult;

class FullVideoRecorder
extends VideoRecorder {
    private static final String TAG = FullVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private MediaRecorder mMediaRecorder;
    private CamcorderProfile mProfile;
    private Camera1 mController;
    private Camera mCamera;

    FullVideoRecorder(@NonNull VideoResult stub, @Nullable VideoRecorder.VideoResultListener listener, @NonNull Camera1 controller, @NonNull Camera camera, int cameraId) {
        super(stub, listener);
        this.mCamera = camera;
        this.mController = controller;
        this.mMediaRecorder = new MediaRecorder();
        this.mMediaRecorder.setCamera(camera);
        this.mMediaRecorder.setVideoSource(1);
        this.mProfile = CamcorderProfile.get((int)cameraId, (int)1);
    }

    @Override
    void start() {
        if (this.mResult.getAudio() == Audio.ON) {
            this.mMediaRecorder.setAudioSource(0);
        }
        Size size = this.mResult.getRotation() % 180 != 0 ? this.mResult.getSize().flip() : this.mResult.getSize();
        this.mMediaRecorder.setOutputFormat(this.mProfile.fileFormat);
        if (this.mResult.videoFrameRate <= 0) {
            this.mMediaRecorder.setVideoFrameRate(this.mProfile.videoFrameRate);
            this.mResult.videoFrameRate = this.mProfile.videoFrameRate;
        } else {
            this.mMediaRecorder.setVideoFrameRate(this.mResult.videoFrameRate);
        }
        this.mMediaRecorder.setVideoSize(size.getWidth(), size.getHeight());
        switch (this.mResult.getVideoCodec()) {
            case H_263: {
                this.mMediaRecorder.setVideoEncoder(1);
                break;
            }
            case H_264: {
                this.mMediaRecorder.setVideoEncoder(2);
                break;
            }
            case DEVICE_DEFAULT: {
                this.mMediaRecorder.setVideoEncoder(this.mProfile.videoCodec);
            }
        }
        if (this.mResult.videoBitRate <= 0) {
            this.mMediaRecorder.setVideoEncodingBitRate(this.mProfile.videoBitRate);
            this.mResult.videoBitRate = this.mProfile.videoBitRate;
        } else {
            this.mMediaRecorder.setVideoEncodingBitRate(this.mResult.videoBitRate);
        }
        if (this.mResult.getAudio() == Audio.ON) {
            this.mMediaRecorder.setAudioChannels(this.mProfile.audioChannels);
            this.mMediaRecorder.setAudioSamplingRate(this.mProfile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(this.mProfile.audioCodec);
            if (this.mResult.audioBitRate <= 0) {
                this.mMediaRecorder.setAudioEncodingBitRate(this.mProfile.audioBitRate);
                this.mResult.audioBitRate = this.mProfile.audioBitRate;
            } else {
                this.mMediaRecorder.setAudioEncodingBitRate(this.mResult.audioBitRate);
            }
        }
        if (this.mResult.getLocation() != null) {
            this.mMediaRecorder.setLocation((float)this.mResult.getLocation().getLatitude(), (float)this.mResult.getLocation().getLongitude());
        }
        this.mMediaRecorder.setOutputFile(this.mResult.getFile().getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(this.mResult.getRotation());
        this.mMediaRecorder.setMaxFileSize(this.mResult.getMaxSize());
        this.mMediaRecorder.setMaxDuration(this.mResult.getMaxDuration());
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                switch (what) {
                    case 800: {
                        FullVideoRecorder.this.mResult.endReason = 2;
                        FullVideoRecorder.this.stop();
                        break;
                    }
                    case 801: {
                        FullVideoRecorder.this.mResult.endReason = 1;
                        FullVideoRecorder.this.stop();
                    }
                }
            }
        });
        try {
            this.mMediaRecorder.prepare();
            this.mMediaRecorder.start();
        }
        catch (Exception e) {
            this.mResult = null;
            this.stop();
        }
    }

    @Override
    void stop() {
        if (this.mMediaRecorder != null) {
            try {
                this.mMediaRecorder.stop();
            }
            catch (Exception e) {
                this.mResult = null;
                LOG.w("stop:", "Error while closing media recorder. Swallowing", e);
            }
            this.mMediaRecorder.release();
            if (this.mController != null) {
                this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.mController);
            }
        }
        this.mProfile = null;
        this.mMediaRecorder = null;
        this.mCamera = null;
        this.mController = null;
        this.dispatchResult();
    }
}

