/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.hardware.Camera;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraUtils;
import com.otaliastudios.cameraview.PictureRecorder;
import com.otaliastudios.cameraview.PictureResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

class FullPictureRecorder
extends PictureRecorder {
    private static final String TAG = FullPictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Camera mCamera;

    FullPictureRecorder(@NonNull PictureResult stub, @Nullable PictureRecorder.PictureResultListener listener, @NonNull Camera camera) {
        super(stub, listener);
        this.mCamera = camera;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(this.mResult.rotation);
        this.mCamera.setParameters(params);
    }

    @Override
    void take() {
        this.mCamera.takePicture(new Camera.ShutterCallback(){

            public void onShutter() {
                FullPictureRecorder.this.dispatchOnShutter(true);
            }
        }, null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                int exifRotation;
                try {
                    ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(data));
                    int exifOrientation = exif.getAttributeInt("Orientation", 1);
                    exifRotation = CameraUtils.readExifOrientation(exifOrientation);
                }
                catch (IOException e) {
                    exifRotation = 0;
                }
                FullPictureRecorder.this.mResult.format = 0;
                FullPictureRecorder.this.mResult.data = data;
                FullPictureRecorder.this.mResult.rotation = exifRotation;
                camera.startPreview();
                FullPictureRecorder.this.dispatchResult();
            }
        });
    }

    @Override
    protected void dispatchResult() {
        this.mCamera = null;
        super.dispatchResult();
    }
}

