/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.Frame;
import com.otaliastudios.cameraview.Size;
import java.util.concurrent.LinkedBlockingQueue;

class FrameManager {
    private int mPoolSize;
    private int mBufferSize;
    private BufferCallback mCallback;
    private LinkedBlockingQueue<Frame> mQueue;

    FrameManager(int poolSize, @Nullable BufferCallback callback) {
        this.mPoolSize = poolSize;
        this.mCallback = callback;
        this.mQueue = new LinkedBlockingQueue(this.mPoolSize);
        this.mBufferSize = -1;
    }

    void release() {
        for (Frame frame : this.mQueue) {
            frame.releaseManager();
            frame.release();
        }
        this.mQueue.clear();
        this.mBufferSize = -1;
    }

    void onFrameReleased(Frame frame) {
        int reqSize;
        int currSize;
        byte[] buffer = frame.getData();
        boolean willRecycle = this.mQueue.offer(frame);
        if (!willRecycle) {
            frame.releaseManager();
        }
        if (buffer != null && this.mCallback != null && (currSize = buffer.length) == (reqSize = this.mBufferSize)) {
            this.mCallback.onBufferAvailable(buffer);
        }
    }

    Frame getFrame(@NonNull byte[] data, long time, int rotation, @NonNull Size previewSize, int previewFormat) {
        Frame frame = this.mQueue.poll();
        if (frame == null) {
            frame = new Frame(this);
        }
        frame.set(data, time, rotation, previewSize, previewFormat);
        return frame;
    }

    int allocate(int bitsPerPixel, @NonNull Size previewSize) {
        this.mBufferSize = this.getBufferSize(bitsPerPixel, previewSize);
        for (int i = 0; i < this.mPoolSize; ++i) {
            this.mCallback.onBufferAvailable(new byte[this.mBufferSize]);
        }
        return this.mBufferSize;
    }

    private int getBufferSize(int bitsPerPixel, @NonNull Size previewSize) {
        long sizeInBits = previewSize.getHeight() * previewSize.getWidth() * bitsPerPixel;
        return (int)Math.ceil((double)sizeInBits / 8.0);
    }

    static interface BufferCallback {
        public void onBufferAvailable(@NonNull byte[] var1);
    }
}

