/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.FrameManager;
import com.otaliastudios.cameraview.Size;

public class Frame {
    FrameManager mManager;
    private byte[] mData = null;
    private long mTime = -1L;
    private int mRotation = 0;
    private Size mSize = null;
    private int mFormat = -1;

    Frame(@NonNull FrameManager manager) {
        this.mManager = manager;
    }

    void set(@NonNull byte[] data, long time, int rotation, @NonNull Size size, int format) {
        this.mData = data;
        this.mTime = time;
        this.mRotation = rotation;
        this.mSize = size;
        this.mFormat = format;
    }

    public boolean equals(Object obj) {
        return obj instanceof Frame && ((Frame)obj).mTime == this.mTime;
    }

    @NonNull
    public Frame freeze() {
        byte[] data = new byte[this.mData.length];
        System.arraycopy(this.mData, 0, data, 0, this.mData.length);
        Frame other = new Frame(this.mManager);
        other.set(data, this.mTime, this.mRotation, this.mSize, this.mFormat);
        return other;
    }

    public void release() {
        if (this.mManager != null) {
            this.mManager.onFrameReleased(this);
        }
        this.mData = null;
        this.mRotation = 0;
        this.mTime = -1L;
        this.mSize = null;
        this.mFormat = -1;
    }

    void releaseManager() {
        this.mManager = null;
    }

    @NonNull
    public byte[] getData() {
        return this.mData;
    }

    public long getTime() {
        return this.mTime;
    }

    public int getRotation() {
        return this.mRotation;
    }

    @NonNull
    public Size getSize() {
        return this.mSize;
    }

    public int getFormat() {
        return this.mFormat;
    }
}

