/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.location.Location;
import android.media.MediaActionSound;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.Camera1;
import com.otaliastudios.cameraview.CameraController;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraListener;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.Control;
import com.otaliastudios.cameraview.CropHelper;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Frame;
import com.otaliastudios.cameraview.FrameProcessor;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GestureAction;
import com.otaliastudios.cameraview.GestureLayout;
import com.otaliastudios.cameraview.GlCameraPreview;
import com.otaliastudios.cameraview.Grid;
import com.otaliastudios.cameraview.GridLinesLayout;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mode;
import com.otaliastudios.cameraview.OrientationHelper;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.PinchGestureLayout;
import com.otaliastudios.cameraview.Preview;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.ScrollGestureLayout;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.SizeSelector;
import com.otaliastudios.cameraview.SizeSelectors;
import com.otaliastudios.cameraview.SurfaceCameraPreview;
import com.otaliastudios.cameraview.TapGestureLayout;
import com.otaliastudios.cameraview.TextureCameraPreview;
import com.otaliastudios.cameraview.VideoCodec;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.WhiteBalance;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CameraView
extends FrameLayout
implements LifecycleObserver {
    private static final String TAG = CameraView.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final int PERMISSION_REQUEST_CODE = 16;
    static final boolean DEFAULT_PLAY_SOUNDS = true;
    private boolean mPlaySounds;
    private HashMap<Gesture, GestureAction> mGestureMap = new HashMap(4);
    private Preview mPreview;
    CameraCallbacks mCameraCallbacks;
    private CameraPreview mCameraPreview;
    private OrientationHelper mOrientationHelper;
    private CameraController mCameraController;
    private MediaActionSound mSound;
    List<CameraListener> mListeners = new CopyOnWriteArrayList<CameraListener>();
    List<FrameProcessor> mFrameProcessors = new CopyOnWriteArrayList<FrameProcessor>();
    private Lifecycle mLifecycle;
    GridLinesLayout mGridLinesLayout;
    PinchGestureLayout mPinchGestureLayout;
    TapGestureLayout mTapGestureLayout;
    ScrollGestureLayout mScrollGestureLayout;
    private boolean mKeepScreenOn;
    private boolean mExperimental;
    private Handler mUiHandler;
    private WorkerHandler mFrameProcessorsHandler;

    public CameraView(@NonNull Context context) {
        super(context, null);
        this.init(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CameraView, 0, 0);
        boolean playSounds = a.getBoolean(R.styleable.CameraView_cameraPlaySounds, true);
        this.mExperimental = a.getBoolean(R.styleable.CameraView_cameraExperimental, false);
        this.mPreview = Preview.fromValue(a.getInteger(R.styleable.CameraView_cameraPreview, Preview.DEFAULT.value()));
        Facing facing = Facing.fromValue(a.getInteger(R.styleable.CameraView_cameraFacing, Facing.DEFAULT(context).value()));
        Flash flash = Flash.fromValue(a.getInteger(R.styleable.CameraView_cameraFlash, Flash.DEFAULT.value()));
        Grid grid = Grid.fromValue(a.getInteger(R.styleable.CameraView_cameraGrid, Grid.DEFAULT.value()));
        int gridColor = a.getColor(R.styleable.CameraView_cameraGrid, GridLinesLayout.DEFAULT_COLOR);
        WhiteBalance whiteBalance = WhiteBalance.fromValue(a.getInteger(R.styleable.CameraView_cameraWhiteBalance, WhiteBalance.DEFAULT.value()));
        Mode mode = Mode.fromValue(a.getInteger(R.styleable.CameraView_cameraMode, Mode.DEFAULT.value()));
        Hdr hdr = Hdr.fromValue(a.getInteger(R.styleable.CameraView_cameraHdr, Hdr.DEFAULT.value()));
        Audio audio = Audio.fromValue(a.getInteger(R.styleable.CameraView_cameraAudio, Audio.DEFAULT.value()));
        VideoCodec codec = VideoCodec.fromValue(a.getInteger(R.styleable.CameraView_cameraVideoCodec, VideoCodec.DEFAULT.value()));
        long videoMaxSize = (long)a.getFloat(R.styleable.CameraView_cameraVideoMaxSize, 0.0f);
        int videoMaxDuration = a.getInteger(R.styleable.CameraView_cameraVideoMaxDuration, 0);
        int videoBitRate = a.getInteger(R.styleable.CameraView_cameraVideoBitRate, 0);
        int audioBitRate = a.getInteger(R.styleable.CameraView_cameraAudioBitRate, 0);
        ArrayList<SizeSelector> pictureConstraints = new ArrayList<SizeSelector>(3);
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMinWidth)) {
            pictureConstraints.add(SizeSelectors.minWidth(a.getInteger(R.styleable.CameraView_cameraPictureSizeMinWidth, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMaxWidth)) {
            pictureConstraints.add(SizeSelectors.maxWidth(a.getInteger(R.styleable.CameraView_cameraPictureSizeMaxWidth, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMinHeight)) {
            pictureConstraints.add(SizeSelectors.minHeight(a.getInteger(R.styleable.CameraView_cameraPictureSizeMinHeight, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMaxHeight)) {
            pictureConstraints.add(SizeSelectors.maxHeight(a.getInteger(R.styleable.CameraView_cameraPictureSizeMaxHeight, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMinArea)) {
            pictureConstraints.add(SizeSelectors.minArea(a.getInteger(R.styleable.CameraView_cameraPictureSizeMinArea, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeMaxArea)) {
            pictureConstraints.add(SizeSelectors.maxArea(a.getInteger(R.styleable.CameraView_cameraPictureSizeMaxArea, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraPictureSizeAspectRatio)) {
            pictureConstraints.add(SizeSelectors.aspectRatio(AspectRatio.parse(a.getString(R.styleable.CameraView_cameraPictureSizeAspectRatio)), 0.0f));
        }
        if (a.getBoolean(R.styleable.CameraView_cameraPictureSizeSmallest, false)) {
            pictureConstraints.add(SizeSelectors.smallest());
        }
        if (a.getBoolean(R.styleable.CameraView_cameraPictureSizeBiggest, false)) {
            pictureConstraints.add(SizeSelectors.biggest());
        }
        SizeSelector pictureSelector = !pictureConstraints.isEmpty() ? SizeSelectors.and(pictureConstraints.toArray(new SizeSelector[0])) : SizeSelectors.biggest();
        ArrayList<SizeSelector> videoConstraints = new ArrayList<SizeSelector>(3);
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMinWidth)) {
            videoConstraints.add(SizeSelectors.minWidth(a.getInteger(R.styleable.CameraView_cameraVideoSizeMinWidth, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMaxWidth)) {
            videoConstraints.add(SizeSelectors.maxWidth(a.getInteger(R.styleable.CameraView_cameraVideoSizeMaxWidth, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMinHeight)) {
            videoConstraints.add(SizeSelectors.minHeight(a.getInteger(R.styleable.CameraView_cameraVideoSizeMinHeight, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMaxHeight)) {
            videoConstraints.add(SizeSelectors.maxHeight(a.getInteger(R.styleable.CameraView_cameraVideoSizeMaxHeight, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMinArea)) {
            videoConstraints.add(SizeSelectors.minArea(a.getInteger(R.styleable.CameraView_cameraVideoSizeMinArea, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeMaxArea)) {
            videoConstraints.add(SizeSelectors.maxArea(a.getInteger(R.styleable.CameraView_cameraVideoSizeMaxArea, 0)));
        }
        if (a.hasValue(R.styleable.CameraView_cameraVideoSizeAspectRatio)) {
            videoConstraints.add(SizeSelectors.aspectRatio(AspectRatio.parse(a.getString(R.styleable.CameraView_cameraVideoSizeAspectRatio)), 0.0f));
        }
        if (a.getBoolean(R.styleable.CameraView_cameraVideoSizeSmallest, false)) {
            videoConstraints.add(SizeSelectors.smallest());
        }
        if (a.getBoolean(R.styleable.CameraView_cameraVideoSizeBiggest, false)) {
            videoConstraints.add(SizeSelectors.biggest());
        }
        SizeSelector videoSelector = !videoConstraints.isEmpty() ? SizeSelectors.and(videoConstraints.toArray(new SizeSelector[0])) : SizeSelectors.biggest();
        GestureAction tapGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureTap, GestureAction.DEFAULT_TAP.value()));
        GestureAction longTapGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureLongTap, GestureAction.DEFAULT_LONG_TAP.value()));
        GestureAction pinchGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGesturePinch, GestureAction.DEFAULT_PINCH.value()));
        GestureAction scrollHorizontalGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureScrollHorizontal, GestureAction.DEFAULT_SCROLL_HORIZONTAL.value()));
        GestureAction scrollVerticalGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureScrollVertical, GestureAction.DEFAULT_SCROLL_VERTICAL.value()));
        a.recycle();
        this.mCameraCallbacks = new Callbacks();
        this.mCameraController = this.instantiateCameraController(this.mCameraCallbacks);
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mFrameProcessorsHandler = WorkerHandler.get("FrameProcessorsWorker");
        this.mGridLinesLayout = new GridLinesLayout(context);
        this.mPinchGestureLayout = new PinchGestureLayout(context);
        this.mTapGestureLayout = new TapGestureLayout(context);
        this.mScrollGestureLayout = new ScrollGestureLayout(context);
        this.addView(this.mGridLinesLayout);
        this.addView((View)this.mPinchGestureLayout);
        this.addView((View)this.mTapGestureLayout);
        this.addView((View)this.mScrollGestureLayout);
        this.setPlaySounds(playSounds);
        this.setFacing(facing);
        this.setFlash(flash);
        this.setMode(mode);
        this.setWhiteBalance(whiteBalance);
        this.setGrid(grid);
        this.setGridColor(gridColor);
        this.setHdr(hdr);
        this.setAudio(audio);
        this.setAudioBitRate(audioBitRate);
        this.setPictureSize(pictureSelector);
        this.setVideoSize(videoSelector);
        this.setVideoCodec(codec);
        this.setVideoMaxSize(videoMaxSize);
        this.setVideoMaxDuration(videoMaxDuration);
        this.setVideoBitRate(videoBitRate);
        this.mapGesture(Gesture.TAP, tapGesture);
        this.mapGesture(Gesture.LONG_TAP, longTapGesture);
        this.mapGesture(Gesture.PINCH, pinchGesture);
        this.mapGesture(Gesture.SCROLL_HORIZONTAL, scrollHorizontalGesture);
        this.mapGesture(Gesture.SCROLL_VERTICAL, scrollVerticalGesture);
        if (!this.isInEditMode()) {
            this.mOrientationHelper = new OrientationHelper(context, this.mCameraCallbacks);
        }
    }

    protected CameraController instantiateCameraController(CameraCallbacks callbacks) {
        return new Camera1(callbacks);
    }

    protected CameraPreview instantiatePreview(Context context, ViewGroup container) {
        LOG.w("preview:", "isHardwareAccelerated:", this.isHardwareAccelerated());
        switch (this.mPreview) {
            case SURFACE: {
                return new SurfaceCameraPreview(context, container, null);
            }
            case TEXTURE: {
                if (!this.isHardwareAccelerated()) break;
                return new TextureCameraPreview(context, container, null);
            }
        }
        this.mPreview = Preview.GL_SURFACE;
        return new GlCameraPreview(context, container, null);
    }

    void instantiatePreview() {
        this.mCameraPreview = this.instantiatePreview(this.getContext(), (ViewGroup)this);
        this.mCameraController.setPreview(this.mCameraPreview);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mCameraPreview == null) {
            this.instantiatePreview();
        }
        if (!this.isInEditMode()) {
            this.mOrientationHelper.enable(this.getContext());
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mOrientationHelper.disable();
        }
        super.onDetachedFromWindow();
    }

    private String ms(int mode) {
        switch (mode) {
            case -2147483648: {
                return "AT_MOST";
            }
            case 0x40000000: {
                return "EXACTLY";
            }
            case 0: {
                return "UNSPECIFIED";
            }
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        Size previewSize = this.mCameraController.getPreviewSize(1);
        if (previewSize == null) {
            LOG.w("onMeasure:", "surface is not ready. Calling default behavior.");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthValue = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightValue = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float previewWidth = previewSize.getWidth();
        float previewHeight = previewSize.getHeight();
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (!this.mCameraPreview.supportsCropping()) {
            if (widthMode == 0x40000000) {
                widthMode = Integer.MIN_VALUE;
            }
            if (heightMode == 0x40000000) {
                heightMode = Integer.MIN_VALUE;
            }
        } else {
            if (widthMode == Integer.MIN_VALUE && lp.width == -1) {
                widthMode = 0x40000000;
            }
            if (heightMode == Integer.MIN_VALUE && lp.height == -1) {
                heightMode = 0x40000000;
            }
        }
        LOG.i("onMeasure:", "requested dimensions are", "(" + widthValue + "[" + this.ms(widthMode) + "]x" + heightValue + "[" + this.ms(heightMode) + "])");
        LOG.i("onMeasure:", "previewSize is", "(" + previewWidth + "x" + previewHeight + ")");
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            LOG.w("onMeasure:", "both are MATCH_PARENT or fixed value. We adapt.", "This means CROP_CENTER.", "(" + widthValue + "x" + heightValue + ")");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (widthMode == 0 && heightMode == 0) {
            LOG.i("onMeasure:", "both are completely free.", "We respect that and extend to the whole preview size.", "(" + previewWidth + "x" + previewHeight + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)((int)previewWidth), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)previewHeight), (int)0x40000000));
            return;
        }
        float ratio = previewHeight / previewWidth;
        if (widthMode == 0 || heightMode == 0) {
            int width2;
            int height2;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == 0;
            if (freeWidth) {
                height2 = heightValue;
                width2 = (int)((float)height2 / ratio);
            } else {
                width2 = widthValue;
                height2 = (int)((float)width2 * ratio);
            }
            LOG.i("onMeasure:", "one dimension was free, we adapted it to fit the aspect ratio.", "(" + width2 + "x" + height2 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height2, (int)0x40000000));
            return;
        }
        if (widthMode == 0x40000000 || heightMode == 0x40000000) {
            int width3;
            int height3;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == Integer.MIN_VALUE;
            if (freeWidth) {
                height3 = heightValue;
                width3 = Math.min((int)((float)height3 / ratio), widthValue);
            } else {
                width3 = widthValue;
                height3 = Math.min((int)((float)width3 * ratio), heightValue);
            }
            LOG.i("onMeasure:", "one dimension was EXACTLY, another AT_MOST.", "We have TRIED to fit the aspect ratio, but it's not guaranteed.", "(" + width3 + "x" + height3 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height3, (int)0x40000000));
            return;
        }
        float atMostRatio = (float)heightValue / (float)widthValue;
        if (atMostRatio >= ratio) {
            width = widthValue;
            height = (int)((float)width * ratio);
        } else {
            height = heightValue;
            width = (int)((float)height / ratio);
        }
        LOG.i("onMeasure:", "both dimension were AT_MOST.", "We fit the preview aspect ratio.", "(" + width + "x" + height + ")");
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public boolean mapGesture(@NonNull Gesture gesture, @NonNull GestureAction action) {
        GestureAction none = GestureAction.NONE;
        if (gesture.isAssignableTo(action)) {
            this.mGestureMap.put(gesture, action);
            switch (gesture) {
                case PINCH: {
                    this.mPinchGestureLayout.enable(this.mGestureMap.get((Object)Gesture.PINCH) != none);
                    break;
                }
                case TAP: 
                case LONG_TAP: {
                    this.mTapGestureLayout.enable(this.mGestureMap.get((Object)Gesture.TAP) != none || this.mGestureMap.get((Object)Gesture.LONG_TAP) != none);
                    break;
                }
                case SCROLL_HORIZONTAL: 
                case SCROLL_VERTICAL: {
                    this.mScrollGestureLayout.enable(this.mGestureMap.get((Object)Gesture.SCROLL_HORIZONTAL) != none || this.mGestureMap.get((Object)Gesture.SCROLL_VERTICAL) != none);
                }
            }
            return true;
        }
        this.mapGesture(gesture, none);
        return false;
    }

    public void clearGesture(@NonNull Gesture gesture) {
        this.mapGesture(gesture, GestureAction.NONE);
    }

    @NonNull
    public GestureAction getGestureAction(@NonNull Gesture gesture) {
        return this.mGestureMap.get((Object)gesture);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isOpened()) {
            return true;
        }
        CameraOptions options = this.mCameraController.getCameraOptions();
        if (this.mPinchGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "pinch!");
            this.onGesture(this.mPinchGestureLayout, options);
        } else if (this.mScrollGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "scroll!");
            this.onGesture(this.mScrollGestureLayout, options);
        } else if (this.mTapGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "tap!");
            this.onGesture(this.mTapGestureLayout, options);
        }
        return true;
    }

    private void onGesture(GestureLayout source, @NonNull CameraOptions options) {
        Gesture gesture = source.getGestureType();
        GestureAction action = this.mGestureMap.get((Object)gesture);
        PointF[] points = source.getPoints();
        switch (action) {
            case CAPTURE: {
                this.mCameraController.takePicture();
                break;
            }
            case FOCUS: 
            case FOCUS_WITH_MARKER: {
                this.mCameraController.startAutoFocus(gesture, points[0]);
                break;
            }
            case ZOOM: {
                float oldValue = this.mCameraController.getZoomValue();
                float newValue = source.scaleValue(oldValue, 0.0f, 1.0f);
                if (newValue == oldValue) break;
                this.mCameraController.setZoom(newValue, points, true);
                break;
            }
            case EXPOSURE_CORRECTION: {
                float oldValue = this.mCameraController.getExposureCorrectionValue();
                float minValue = options.getExposureCorrectionMinValue();
                float maxValue = options.getExposureCorrectionMaxValue();
                float newValue = source.scaleValue(oldValue, minValue, maxValue);
                if (newValue == oldValue) break;
                float[] bounds = new float[]{minValue, maxValue};
                this.mCameraController.setExposureCorrection(newValue, bounds, points, true);
            }
        }
    }

    public boolean isOpened() {
        return this.mCameraController.getState() >= 2;
    }

    private boolean isClosed() {
        return this.mCameraController.getState() == 0;
    }

    public void setLifecycleOwner(@NonNull LifecycleOwner owner) {
        if (this.mLifecycle != null) {
            this.mLifecycle.removeObserver((LifecycleObserver)this);
        }
        this.mLifecycle = owner.getLifecycle();
        this.mLifecycle.addObserver((LifecycleObserver)this);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void open() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onResume();
        }
        if (this.checkPermissions(this.getMode(), this.getAudio())) {
            this.mOrientationHelper.enable(this.getContext());
            this.mCameraController.setDisplayOffset(this.mOrientationHelper.getDisplayOffset());
            this.mCameraController.start();
        }
    }

    @SuppressLint(value={"NewApi"})
    protected boolean checkPermissions(@NonNull Mode mode, @NonNull Audio audio) {
        this.checkPermissionsManifestOrThrow(mode, audio);
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        Context c = this.getContext();
        boolean needsCamera = true;
        boolean needsAudio = audio == Audio.ON;
        needsCamera = needsCamera && c.checkSelfPermission("android.permission.CAMERA") != 0;
        boolean bl = needsAudio = needsAudio && c.checkSelfPermission("android.permission.RECORD_AUDIO") != 0;
        if (needsCamera || needsAudio) {
            this.requestPermissions(needsCamera, needsAudio);
            return false;
        }
        return true;
    }

    private void checkPermissionsManifestOrThrow(@NonNull Mode mode, @NonNull Audio audio) {
        if (mode == Mode.VIDEO && audio == Audio.ON) {
            try {
                PackageManager manager = this.getContext().getPackageManager();
                PackageInfo info = manager.getPackageInfo(this.getContext().getPackageName(), 4096);
                for (String requestedPermission : info.requestedPermissions) {
                    if (!requestedPermission.equals("android.permission.RECORD_AUDIO")) continue;
                    return;
                }
                LOG.e("Permission error:", "When the session type is set to video,", "the RECORD_AUDIO permission should be added to the app manifest file.");
                throw new IllegalStateException(CameraLogger.lastMessage);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void close() {
        this.mCameraController.stop();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onPause();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void destroy() {
        this.clearCameraListeners();
        this.clearFrameProcessors();
        this.mCameraController.destroy();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onDestroy();
        }
    }

    public void set(@NonNull Control control) {
        if (control instanceof Audio) {
            this.setAudio((Audio)control);
        } else if (control instanceof Facing) {
            this.setFacing((Facing)control);
        } else if (control instanceof Flash) {
            this.setFlash((Flash)control);
        } else if (control instanceof Grid) {
            this.setGrid((Grid)control);
        } else if (control instanceof Hdr) {
            this.setHdr((Hdr)control);
        } else if (control instanceof Mode) {
            this.setMode((Mode)control);
        } else if (control instanceof WhiteBalance) {
            this.setWhiteBalance((WhiteBalance)control);
        } else if (control instanceof VideoCodec) {
            this.setVideoCodec((VideoCodec)control);
        } else if (control instanceof Preview) {
            this.setPreview((Preview)control);
        }
    }

    @Nullable
    public CameraOptions getCameraOptions() {
        return this.mCameraController.getCameraOptions();
    }

    public void setExposureCorrection(float EVvalue) {
        CameraOptions options = this.getCameraOptions();
        if (options != null) {
            float min = options.getExposureCorrectionMinValue();
            float max = options.getExposureCorrectionMaxValue();
            if (EVvalue < min) {
                EVvalue = min;
            }
            if (EVvalue > max) {
                EVvalue = max;
            }
            float[] bounds = new float[]{min, max};
            this.mCameraController.setExposureCorrection(EVvalue, bounds, null, false);
        }
    }

    public float getExposureCorrection() {
        return this.mCameraController.getExposureCorrectionValue();
    }

    public void setZoom(float zoom) {
        if (zoom < 0.0f) {
            zoom = 0.0f;
        }
        if (zoom > 1.0f) {
            zoom = 1.0f;
        }
        this.mCameraController.setZoom(zoom, null, false);
    }

    public float getZoom() {
        return this.mCameraController.getZoomValue();
    }

    public void setGrid(@NonNull Grid gridMode) {
        this.mGridLinesLayout.setGridMode(gridMode);
    }

    @NonNull
    public Grid getGrid() {
        return this.mGridLinesLayout.getGridMode();
    }

    public void setGridColor(@ColorInt int color) {
        this.mGridLinesLayout.setGridColor(color);
    }

    public int getGridColor() {
        return this.mGridLinesLayout.getGridColor();
    }

    public void setHdr(@NonNull Hdr hdr) {
        this.mCameraController.setHdr(hdr);
    }

    public void setPreview(@NonNull Preview preview) {
        this.mPreview = preview;
    }

    @NonNull
    public Hdr getHdr() {
        return this.mCameraController.getHdr();
    }

    public void setLocation(double latitude, double longitude) {
        Location location = new Location("Unknown");
        location.setTime(System.currentTimeMillis());
        location.setAltitude(0.0);
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        this.mCameraController.setLocation(location);
    }

    public void setLocation(@Nullable Location location) {
        this.mCameraController.setLocation(location);
    }

    @Nullable
    public Location getLocation() {
        return this.mCameraController.getLocation();
    }

    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        this.mCameraController.setWhiteBalance(whiteBalance);
    }

    @NonNull
    public WhiteBalance getWhiteBalance() {
        return this.mCameraController.getWhiteBalance();
    }

    public void setFacing(@NonNull Facing facing) {
        this.mCameraController.setFacing(facing);
    }

    @NonNull
    public Facing getFacing() {
        return this.mCameraController.getFacing();
    }

    public Facing toggleFacing() {
        Facing facing = this.mCameraController.getFacing();
        switch (facing) {
            case BACK: {
                this.setFacing(Facing.FRONT);
                break;
            }
            case FRONT: {
                this.setFacing(Facing.BACK);
            }
        }
        return this.mCameraController.getFacing();
    }

    public void setFlash(@NonNull Flash flash) {
        this.mCameraController.setFlash(flash);
    }

    @NonNull
    public Flash getFlash() {
        return this.mCameraController.getFlash();
    }

    public void setAudio(@NonNull Audio audio) {
        if (audio == this.getAudio() || this.isClosed()) {
            this.mCameraController.setAudio(audio);
        } else if (this.checkPermissions(this.getMode(), audio)) {
            this.mCameraController.setAudio(audio);
        } else {
            this.close();
        }
    }

    @NonNull
    public Audio getAudio() {
        return this.mCameraController.getAudio();
    }

    public void startAutoFocus(float x, float y) {
        if (x < 0.0f || x > (float)this.getWidth()) {
            throw new IllegalArgumentException("x should be >= 0 and <= getWidth()");
        }
        if (y < 0.0f || y > (float)this.getHeight()) {
            throw new IllegalArgumentException("y should be >= 0 and <= getHeight()");
        }
        this.mCameraController.startAutoFocus(null, new PointF(x, y));
    }

    public void setPreviewSize(@NonNull SizeSelector selector) {
        this.mCameraController.setPreviewSizeSelector(selector);
    }

    public void setMode(@NonNull Mode mode) {
        if (mode == this.getMode() || this.isClosed()) {
            this.mCameraController.setMode(mode);
        } else if (this.checkPermissions(mode, this.getAudio())) {
            this.mCameraController.setMode(mode);
        } else {
            this.close();
        }
    }

    @NonNull
    public Mode getMode() {
        return this.mCameraController.getMode();
    }

    public void setPictureSize(@NonNull SizeSelector selector) {
        this.mCameraController.setPictureSizeSelector(selector);
    }

    public void setVideoSize(@NonNull SizeSelector selector) {
        this.mCameraController.setVideoSizeSelector(selector);
    }

    public void setVideoBitRate(int bitRate) {
        this.mCameraController.setVideoBitRate(bitRate);
    }

    public int getVideoBitRate() {
        return this.mCameraController.getVideoBitRate();
    }

    public void setAudioBitRate(int bitRate) {
        this.mCameraController.setAudioBitRate(bitRate);
    }

    public int getAudioBitRate() {
        return this.mCameraController.getAudioBitRate();
    }

    public void addCameraListener(@NonNull CameraListener cameraListener) {
        this.mListeners.add(cameraListener);
    }

    public void removeCameraListener(@NonNull CameraListener cameraListener) {
        this.mListeners.remove(cameraListener);
    }

    public void clearCameraListeners() {
        this.mListeners.clear();
    }

    public void addFrameProcessor(@Nullable FrameProcessor processor) {
        if (processor != null) {
            this.mFrameProcessors.add(processor);
        }
    }

    public void removeFrameProcessor(@Nullable FrameProcessor processor) {
        if (processor != null) {
            this.mFrameProcessors.remove(processor);
        }
    }

    public void clearFrameProcessors() {
        this.mFrameProcessors.clear();
    }

    public void takePicture() {
        this.mCameraController.takePicture();
    }

    public void takePictureSnapshot() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.mCameraController.takePictureSnapshot(AspectRatio.of(this.getWidth(), this.getHeight()));
    }

    public void takeVideo(@NonNull File file) {
        this.mCameraController.takeVideo(file);
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mKeepScreenOn = CameraView.this.getKeepScreenOn();
                if (!CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(true);
                }
            }
        });
    }

    public void takeVideoSnapshot(@NonNull File file) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.mCameraController.takeVideoSnapshot(file, AspectRatio.of(this.getWidth(), this.getHeight()));
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mKeepScreenOn = CameraView.this.getKeepScreenOn();
                if (!CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(true);
                }
            }
        });
    }

    public void takeVideo(@NonNull File file, int durationMillis) {
        final int old = this.getVideoMaxDuration();
        this.addCameraListener(new CameraListener(){

            @Override
            public void onVideoTaken(@NonNull VideoResult result) {
                CameraView.this.setVideoMaxDuration(old);
                CameraView.this.removeCameraListener(this);
            }

            @Override
            public void onCameraError(@NonNull CameraException exception) {
                super.onCameraError(exception);
                if (exception.getReason() == 5) {
                    CameraView.this.setVideoMaxDuration(old);
                    CameraView.this.removeCameraListener(this);
                }
            }
        });
        this.setVideoMaxDuration(durationMillis);
        this.takeVideo(file);
    }

    public void takeVideoSnapshot(@NonNull File file, int durationMillis) {
        final int old = this.getVideoMaxDuration();
        this.addCameraListener(new CameraListener(){

            @Override
            public void onVideoTaken(@NonNull VideoResult result) {
                CameraView.this.setVideoMaxDuration(old);
                CameraView.this.removeCameraListener(this);
            }

            @Override
            public void onCameraError(@NonNull CameraException exception) {
                super.onCameraError(exception);
                if (exception.getReason() == 5) {
                    CameraView.this.setVideoMaxDuration(old);
                    CameraView.this.removeCameraListener(this);
                }
            }
        });
        this.setVideoMaxDuration(durationMillis);
        this.takeVideoSnapshot(file);
    }

    public void stopVideo() {
        this.mCameraController.stopVideo();
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.getKeepScreenOn() != CameraView.this.mKeepScreenOn) {
                    CameraView.this.setKeepScreenOn(CameraView.this.mKeepScreenOn);
                }
            }
        });
    }

    @Nullable
    public Size getSnapshotSize() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return null;
        }
        Size preview = this.mCameraController.getPreviewSize(1);
        AspectRatio viewRatio = AspectRatio.of(this.getWidth(), this.getHeight());
        Rect crop = CropHelper.computeCrop(preview, viewRatio);
        Size cropSize = new Size(crop.width(), crop.height());
        if (this.mCameraController.flip(1, 2)) {
            return cropSize.flip();
        }
        return cropSize;
    }

    @Nullable
    public Size getPictureSize() {
        return this.mCameraController.getPictureSize(2);
    }

    @Nullable
    public Size getVideoSize() {
        return this.mCameraController.getVideoSize(2);
    }

    @TargetApi(value=23)
    private void requestPermissions(boolean requestCamera, boolean requestAudio) {
        Activity activity = null;
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestCamera) {
            permissions.add("android.permission.CAMERA");
        }
        if (requestAudio) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        if (activity != null) {
            activity.requestPermissions(permissions.toArray(new String[permissions.size()]), 16);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void playSound(int soundType) {
        if (this.mPlaySounds) {
            if (this.mSound == null) {
                this.mSound = new MediaActionSound();
            }
            this.mSound.play(soundType);
        }
    }

    public void setPlaySounds(boolean playSounds) {
        this.mPlaySounds = playSounds && Build.VERSION.SDK_INT >= 16;
        this.mCameraController.setPlaySounds(playSounds);
    }

    public boolean getPlaySounds() {
        return this.mPlaySounds;
    }

    public void setVideoCodec(@NonNull VideoCodec codec) {
        this.mCameraController.setVideoCodec(codec);
    }

    @NonNull
    public VideoCodec getVideoCodec() {
        return this.mCameraController.getVideoCodec();
    }

    public void setVideoMaxSize(long videoMaxSizeInBytes) {
        this.mCameraController.setVideoMaxSize(videoMaxSizeInBytes);
    }

    public long getVideoMaxSize() {
        return this.mCameraController.getVideoMaxSize();
    }

    public void setVideoMaxDuration(int videoMaxDurationMillis) {
        this.mCameraController.setVideoMaxDuration(videoMaxDurationMillis);
    }

    public int getVideoMaxDuration() {
        return this.mCameraController.getVideoMaxDuration();
    }

    public boolean isTakingVideo() {
        return this.mCameraController.isTakingVideo();
    }

    public boolean isTakingPicture() {
        return this.mCameraController.isTakingPicture();
    }

    private class Callbacks
    implements CameraCallbacks {
        private CameraLogger mLogger = CameraLogger.create(CameraCallbacks.class.getSimpleName());

        Callbacks() {
        }

        @Override
        public void dispatchOnCameraOpened(final CameraOptions options) {
            this.mLogger.i("dispatchOnCameraOpened", options);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraOpened(options);
                    }
                }
            });
        }

        @Override
        public void dispatchOnCameraClosed() {
            this.mLogger.i("dispatchOnCameraClosed");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraClosed();
                    }
                }
            });
        }

        @Override
        public void onCameraPreviewSizeChanged() {
            this.mLogger.i("onCameraPreviewSizeChanged");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.requestLayout();
                }
            });
        }

        @Override
        public void onShutter(boolean shouldPlaySound) {
            if (shouldPlaySound && CameraView.this.mPlaySounds) {
                CameraView.this.playSound(0);
            }
        }

        @Override
        public void dispatchOnPictureTaken(final PictureResult result) {
            this.mLogger.i("dispatchOnPictureTaken");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onPictureTaken(result);
                    }
                }
            });
        }

        @Override
        public void dispatchOnVideoTaken(final VideoResult video) {
            this.mLogger.i("dispatchOnVideoTaken", video);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onVideoTaken(video);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusStart(final @Nullable Gesture gesture, final @NonNull PointF point) {
            this.mLogger.i(new Object[]{"dispatchOnFocusStart", gesture, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (gesture != null && CameraView.this.mGestureMap.get((Object)gesture) == GestureAction.FOCUS_WITH_MARKER) {
                        CameraView.this.mTapGestureLayout.onFocusStart(point);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onFocusStart(point);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusEnd(final @Nullable Gesture gesture, final boolean success, final @NonNull PointF point) {
            this.mLogger.i(new Object[]{"dispatchOnFocusEnd", gesture, success, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (success && CameraView.this.mPlaySounds) {
                        CameraView.this.playSound(1);
                    }
                    if (gesture != null && CameraView.this.mGestureMap.get((Object)gesture) == GestureAction.FOCUS_WITH_MARKER) {
                        CameraView.this.mTapGestureLayout.onFocusEnd(success);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onFocusEnd(success, point);
                    }
                }
            });
        }

        @Override
        public void onDeviceOrientationChanged(int deviceOrientation) {
            this.mLogger.i("onDeviceOrientationChanged", deviceOrientation);
            CameraView.this.mCameraController.setDeviceOrientation(deviceOrientation);
            int displayOffset = CameraView.this.mOrientationHelper.getDisplayOffset();
            final int value = (deviceOrientation + displayOffset) % 360;
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onOrientationChanged(value);
                    }
                }
            });
        }

        @Override
        public void dispatchOnZoomChanged(final float newValue, final @Nullable PointF[] fingers) {
            this.mLogger.i("dispatchOnZoomChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onZoomChanged(newValue, new float[]{0.0f, 1.0f}, fingers);
                    }
                }
            });
        }

        @Override
        public void dispatchOnExposureCorrectionChanged(final float newValue, final @NonNull float[] bounds, final @Nullable PointF[] fingers) {
            this.mLogger.i("dispatchOnExposureCorrectionChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onExposureCorrectionChanged(newValue, bounds, fingers);
                    }
                }
            });
        }

        @Override
        public void dispatchFrame(final Frame frame) {
            if (CameraView.this.mFrameProcessors.isEmpty()) {
                frame.release();
            } else {
                this.mLogger.v("dispatchFrame:", frame.getTime(), "processors:", CameraView.this.mFrameProcessors.size());
                CameraView.this.mFrameProcessorsHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (FrameProcessor processor : CameraView.this.mFrameProcessors) {
                            processor.process(frame);
                        }
                        frame.release();
                    }
                });
            }
        }

        @Override
        public void dispatchError(final CameraException exception) {
            this.mLogger.i("dispatchError", exception);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraError(exception);
                    }
                }
            });
        }
    }

    static interface CameraCallbacks
    extends OrientationHelper.Callback {
        public void dispatchOnCameraOpened(CameraOptions var1);

        public void dispatchOnCameraClosed();

        public void onCameraPreviewSizeChanged();

        public void onShutter(boolean var1);

        public void dispatchOnVideoTaken(VideoResult var1);

        public void dispatchOnPictureTaken(PictureResult var1);

        public void dispatchOnFocusStart(@Nullable Gesture var1, @NonNull PointF var2);

        public void dispatchOnFocusEnd(@Nullable Gesture var1, boolean var2, @NonNull PointF var3);

        public void dispatchOnZoomChanged(float var1, @Nullable PointF[] var2);

        public void dispatchOnExposureCorrectionChanged(float var1, @NonNull float[] var2, @Nullable PointF[] var3);

        public void dispatchFrame(Frame var1);

        public void dispatchError(CameraException var1);
    }
}

