/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.PointF;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.CameraView;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.FrameManager;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mapper;
import com.otaliastudios.cameraview.Mode;
import com.otaliastudios.cameraview.PictureRecorder;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.SizeSelector;
import com.otaliastudios.cameraview.SizeSelectors;
import com.otaliastudios.cameraview.Task;
import com.otaliastudios.cameraview.VideoCodec;
import com.otaliastudios.cameraview.VideoRecorder;
import com.otaliastudios.cameraview.WhiteBalance;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class CameraController
implements CameraPreview.SurfaceCallback,
FrameManager.BufferCallback,
Thread.UncaughtExceptionHandler {
    private static final String TAG = CameraController.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final int STATE_STOPPING = -1;
    static final int STATE_STOPPED = 0;
    static final int STATE_STARTING = 1;
    static final int STATE_STARTED = 2;
    static final int REF_SENSOR = 0;
    static final int REF_VIEW = 1;
    static final int REF_OUTPUT = 2;
    protected final CameraView.CameraCallbacks mCameraCallbacks;
    protected CameraPreview mPreview;
    protected WorkerHandler mHandler;
    Handler mCrashHandler;
    protected Facing mFacing;
    protected Flash mFlash;
    protected WhiteBalance mWhiteBalance;
    protected VideoCodec mVideoCodec;
    protected Mode mMode;
    protected Hdr mHdr;
    protected Location mLocation;
    protected Audio mAudio;
    protected float mZoomValue;
    protected float mExposureCorrectionValue;
    protected boolean mPlaySounds;
    @Nullable
    private SizeSelector mPreviewSizeSelector;
    private SizeSelector mPictureSizeSelector;
    private SizeSelector mVideoSizeSelector;
    protected int mCameraId;
    protected CameraOptions mCameraOptions;
    protected Mapper mMapper;
    protected FrameManager mFrameManager;
    protected PictureRecorder mPictureRecorder;
    protected VideoRecorder mVideoRecorder;
    protected long mVideoMaxSize;
    protected int mVideoMaxDuration;
    protected int mVideoBitRate;
    protected int mAudioBitRate;
    protected Size mCaptureSize;
    protected Size mPreviewSize;
    protected int mPreviewFormat;
    protected int mSensorOffset;
    private int mDisplayOffset;
    private int mDeviceOrientation;
    protected int mState = 0;
    Task<Void> mZoomTask = new Task();
    Task<Void> mExposureCorrectionTask = new Task();
    Task<Void> mFlashTask = new Task();
    Task<Void> mWhiteBalanceTask = new Task();
    Task<Void> mHdrTask = new Task();
    Task<Void> mLocationTask = new Task();
    Task<Void> mStartVideoTask = new Task();
    Task<Void> mPlaySoundsTask = new Task();

    CameraController(CameraView.CameraCallbacks callback) {
        this.mCameraCallbacks = callback;
        this.mCrashHandler = new Handler(Looper.getMainLooper());
        this.mHandler = WorkerHandler.get("CameraViewController");
        this.mHandler.getThread().setUncaughtExceptionHandler(this);
        this.mFrameManager = new FrameManager(2, this);
    }

    void setPreview(CameraPreview cameraPreview) {
        this.mPreview = cameraPreview;
        this.mPreview.setSurfaceCallback(this);
    }

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        if (!(throwable instanceof CameraException)) {
            LOG.e("uncaughtException:", "Unexpected exception:", throwable);
            this.destroy();
            this.mCrashHandler.post(new Runnable(){

                @Override
                public void run() {
                    RuntimeException exception = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
                    throw exception;
                }
            });
        } else {
            final CameraException error = (CameraException)throwable;
            LOG.e("uncaughtException:", "Interrupting thread with state:", this.ss(), "due to CameraException:", error);
            thread.interrupt();
            this.mHandler = WorkerHandler.get("CameraViewController");
            this.mHandler.getThread().setUncaughtExceptionHandler(this);
            LOG.i("uncaughtException:", "Calling stopImmediately and notifying.");
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraController.this.stopImmediately();
                    CameraController.this.mCameraCallbacks.dispatchError(error);
                }
            });
        }
    }

    public void destroy() {
        LOG.i("destroy:", "state:", this.ss());
        this.mHandler.getThread().setUncaughtExceptionHandler(new NoOpExceptionHandler());
        this.stopImmediately();
    }

    @NonNull
    private String ss() {
        switch (this.mState) {
            case -1: {
                return "STATE_STOPPING";
            }
            case 0: {
                return "STATE_STOPPED";
            }
            case 1: {
                return "STATE_STARTING";
            }
            case 2: {
                return "STATE_STARTED";
            }
        }
        return "null";
    }

    final void start() {
        LOG.i("Start:", "posting runnable. State:", this.ss());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LOG.i("Start:", "executing. State:", CameraController.this.ss());
                if (CameraController.this.mState >= 1) {
                    return;
                }
                CameraController.this.mState = 1;
                LOG.i("Start:", "about to call onStart()", CameraController.this.ss());
                CameraController.this.onStart();
                LOG.i("Start:", "returned from onStart().", "Dispatching.", CameraController.this.ss());
                CameraController.this.mState = 2;
                CameraController.this.mCameraCallbacks.dispatchOnCameraOpened(CameraController.this.mCameraOptions);
            }
        });
    }

    public void stop() {
        LOG.i("Stop:", "posting runnable. State:", this.ss());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LOG.i("Stop:", "executing. State:", CameraController.this.ss());
                if (CameraController.this.mState <= 0) {
                    return;
                }
                CameraController.this.mState = -1;
                LOG.i("Stop:", "about to call onStop()");
                CameraController.this.onStop();
                LOG.i("Stop:", "returned from onStop().", "Dispatching.");
                CameraController.this.mState = 0;
                CameraController.this.mCameraCallbacks.dispatchOnCameraClosed();
            }
        });
    }

    final void stopImmediately() {
        try {
            LOG.i("stopImmediately:", "State was:", this.ss());
            if (this.mState == 0) {
                return;
            }
            this.mState = -1;
            this.onStop();
            this.mState = 0;
            LOG.i("stopImmediately:", "Stopped. State is:", this.ss());
        }
        catch (Exception e) {
            LOG.i("stopImmediately:", "Swallowing exception while stopping.", e);
            this.mState = 0;
        }
    }

    protected final void restart() {
        LOG.i("Restart:", "posting runnable");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LOG.i("Restart:", "executing. Needs stopping:", CameraController.this.mState > 0, CameraController.this.ss());
                if (CameraController.this.mState > 0) {
                    CameraController.this.mState = -1;
                    CameraController.this.onStop();
                    CameraController.this.mState = 0;
                    LOG.i("Restart:", "stopped. Dispatching.", CameraController.this.ss());
                    CameraController.this.mCameraCallbacks.dispatchOnCameraClosed();
                }
                LOG.i("Restart: about to start. State:", CameraController.this.ss());
                CameraController.this.mState = 1;
                CameraController.this.onStart();
                CameraController.this.mState = 2;
                LOG.i("Restart: returned from start. Dispatching. State:", CameraController.this.ss());
                CameraController.this.mCameraCallbacks.dispatchOnCameraOpened(CameraController.this.mCameraOptions);
            }
        });
    }

    @WorkerThread
    abstract void onStart();

    @WorkerThread
    abstract void onStop();

    final int getState() {
        return this.mState;
    }

    final void setDisplayOffset(int displayOffset) {
        this.mDisplayOffset = displayOffset;
    }

    final void setDeviceOrientation(int deviceOrientation) {
        this.mDeviceOrientation = deviceOrientation;
    }

    final void setPreviewSizeSelector(@Nullable SizeSelector selector) {
        this.mPreviewSizeSelector = selector;
    }

    final void setPictureSizeSelector(@NonNull SizeSelector selector) {
        this.mPictureSizeSelector = selector;
    }

    final void setVideoSizeSelector(@NonNull SizeSelector selector) {
        this.mVideoSizeSelector = selector;
    }

    final void setVideoMaxSize(long videoMaxSizeBytes) {
        this.mVideoMaxSize = videoMaxSizeBytes;
    }

    final void setVideoMaxDuration(int videoMaxDurationMillis) {
        this.mVideoMaxDuration = videoMaxDurationMillis;
    }

    final void setVideoCodec(@NonNull VideoCodec codec) {
        this.mVideoCodec = codec;
    }

    final void setVideoBitRate(int videoBitRate) {
        this.mVideoBitRate = videoBitRate;
    }

    final void setAudioBitRate(int audioBitRate) {
        this.mAudioBitRate = audioBitRate;
    }

    abstract void setMode(@NonNull Mode var1);

    abstract void setFacing(@NonNull Facing var1);

    abstract void setZoom(float var1, @Nullable PointF[] var2, boolean var3);

    abstract void setExposureCorrection(float var1, @NonNull float[] var2, @Nullable PointF[] var3, boolean var4);

    abstract void setFlash(@NonNull Flash var1);

    abstract void setWhiteBalance(@NonNull WhiteBalance var1);

    abstract void setHdr(@NonNull Hdr var1);

    abstract void setLocation(@Nullable Location var1);

    abstract void setAudio(@NonNull Audio var1);

    abstract void takePicture();

    abstract void takePictureSnapshot(@NonNull AspectRatio var1);

    abstract void takeVideo(@NonNull File var1);

    abstract void takeVideoSnapshot(@NonNull File var1, @NonNull AspectRatio var2);

    abstract void stopVideo();

    abstract void startAutoFocus(@Nullable Gesture var1, @NonNull PointF var2);

    abstract void setPlaySounds(boolean var1);

    @Nullable
    final CameraOptions getCameraOptions() {
        return this.mCameraOptions;
    }

    @NonNull
    final Facing getFacing() {
        return this.mFacing;
    }

    @NonNull
    final Flash getFlash() {
        return this.mFlash;
    }

    @NonNull
    final WhiteBalance getWhiteBalance() {
        return this.mWhiteBalance;
    }

    final VideoCodec getVideoCodec() {
        return this.mVideoCodec;
    }

    final int getVideoBitRate() {
        return this.mVideoBitRate;
    }

    final long getVideoMaxSize() {
        return this.mVideoMaxSize;
    }

    final int getVideoMaxDuration() {
        return this.mVideoMaxDuration;
    }

    @NonNull
    final Mode getMode() {
        return this.mMode;
    }

    @NonNull
    final Hdr getHdr() {
        return this.mHdr;
    }

    @Nullable
    final Location getLocation() {
        return this.mLocation;
    }

    @NonNull
    final Audio getAudio() {
        return this.mAudio;
    }

    final int getAudioBitRate() {
        return this.mAudioBitRate;
    }

    @Nullable
    final SizeSelector getPreviewSizeSelector() {
        return this.mPreviewSizeSelector;
    }

    @NonNull
    final SizeSelector getPictureSizeSelector() {
        return this.mPictureSizeSelector;
    }

    @NonNull
    final SizeSelector getVideoSizeSelector() {
        return this.mVideoSizeSelector;
    }

    final float getZoomValue() {
        return this.mZoomValue;
    }

    final float getExposureCorrectionValue() {
        return this.mExposureCorrectionValue;
    }

    final boolean isTakingVideo() {
        return this.mVideoRecorder != null;
    }

    final boolean isTakingPicture() {
        return this.mPictureRecorder != null;
    }

    private int computeSensorToViewOffset() {
        if (this.mFacing == Facing.FRONT) {
            return (360 - (this.mSensorOffset + this.mDisplayOffset) % 360) % 360;
        }
        return (this.mSensorOffset - this.mDisplayOffset + 360) % 360;
    }

    private int computeSensorToOutputOffset() {
        if (this.mFacing == Facing.FRONT) {
            return (this.mSensorOffset - this.mDeviceOrientation + 360) % 360;
        }
        return (this.mSensorOffset + this.mDeviceOrientation) % 360;
    }

    final int offset(int fromReference, int toReference) {
        if (fromReference == toReference) {
            return 0;
        }
        if (fromReference == 0) {
            return toReference == 1 ? this.computeSensorToViewOffset() : this.computeSensorToOutputOffset();
        }
        if (toReference == 0) {
            return (-this.offset(toReference, fromReference) + 360) % 360;
        }
        return (this.offset(0, toReference) - this.offset(0, fromReference) + 360) % 360;
    }

    final boolean flip(int reference1, int reference2) {
        return this.offset(reference1, reference2) % 180 != 0;
    }

    final Size getPictureSize(int reference) {
        if (this.mCaptureSize == null || this.mMode == Mode.VIDEO) {
            return null;
        }
        return this.flip(0, reference) ? this.mCaptureSize.flip() : this.mCaptureSize;
    }

    final Size getVideoSize(int reference) {
        if (this.mCaptureSize == null || this.mMode == Mode.PICTURE) {
            return null;
        }
        return this.flip(0, reference) ? this.mCaptureSize.flip() : this.mCaptureSize;
    }

    final Size getPreviewSize(int reference) {
        if (this.mPreviewSize == null) {
            return null;
        }
        return this.flip(0, reference) ? this.mPreviewSize.flip() : this.mPreviewSize;
    }

    @NonNull
    protected final Size computeCaptureSize() {
        Collection<Size> sizes;
        SizeSelector selector;
        boolean flip = this.flip(0, 1);
        if (this.mMode == Mode.PICTURE) {
            selector = this.mPictureSizeSelector;
            sizes = this.mCameraOptions.getSupportedPictureSizes();
        } else {
            selector = this.mVideoSizeSelector;
            sizes = this.mCameraOptions.getSupportedVideoSizes();
        }
        selector = SizeSelectors.or(selector, SizeSelectors.biggest());
        ArrayList<Size> list = new ArrayList<Size>(sizes);
        Size result = selector.select(list).get(0);
        LOG.i("computeCaptureSize:", "result:", result, "flip:", flip);
        if (flip) {
            result = result.flip();
        }
        return result;
    }

    @NonNull
    protected final Size computePreviewSize(@NonNull List<Size> previewSizes) {
        boolean flip = this.flip(0, 1);
        ArrayList<Size> sizes = new ArrayList<Size>(previewSizes.size());
        for (Size size : previewSizes) {
            sizes.add(flip ? size.flip() : size);
        }
        Size targetMinSize = this.mPreview.getOutputSurfaceSize();
        AspectRatio targetRatio = AspectRatio.of(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        if (flip) {
            targetRatio = targetRatio.inverse();
        }
        LOG.i("size:", "computePreviewSize:", "targetRatio:", targetRatio, "targetMinSize:", targetMinSize);
        SizeSelector matchRatio = SizeSelectors.and(SizeSelectors.aspectRatio(targetRatio, 0.0f), SizeSelectors.biggest());
        SizeSelector matchSize = SizeSelectors.and(SizeSelectors.minHeight(targetMinSize.getHeight()), SizeSelectors.minWidth(targetMinSize.getWidth()), SizeSelectors.smallest());
        SizeSelector matchAll = SizeSelectors.or(SizeSelectors.and(matchRatio, matchSize), matchSize, matchRatio, SizeSelectors.biggest());
        SizeSelector selector = this.mPreviewSizeSelector != null ? SizeSelectors.or(this.mPreviewSizeSelector, matchAll) : matchAll;
        Size result = selector.select(sizes).get(0);
        if (flip) {
            result = result.flip();
        }
        LOG.i("computePreviewSize:", "result:", result, "flip:", flip);
        return result;
    }

    private static class NoOpExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private NoOpExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    }
}

