/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoder;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
class AudioMediaEncoder
extends MediaEncoder {
    private static final String MIME_TYPE = "audio/mp4a-latm";
    private static final int SAMPLE_RATE = 44100;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    private final Object mLock = new Object();
    private boolean mRequestStop = false;
    private Config mConfig;

    AudioMediaEncoder(@NonNull Config config) {
        this.mConfig = config;
    }

    @Override
    @EncoderThread
    void prepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        super.prepare(controller, maxLengthMillis);
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)44100, (int)1);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", 16);
        audioFormat.setInteger("bitrate", this.mConfig.bitRate);
        audioFormat.setInteger("channel-count", 1);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
    }

    @Override
    @EncoderThread
    void start() {
        this.mRequestStop = false;
        new AudioThread().start();
    }

    @Override
    @EncoderThread
    void notify(@NonNull String event, @Nullable Object data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EncoderThread
    void stop() {
        this.mRequestStop = true;
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    void release() {
        super.release();
        this.mRequestStop = false;
    }

    @Override
    int getBitRate() {
        return this.mConfig.bitRate;
    }

    class AudioThread
    extends Thread {
        private AudioRecord mAudioRecord;

        AudioThread() {
            int minBufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
            int bufferSize = 25600;
            if (bufferSize < minBufferSize) {
                bufferSize = (minBufferSize / 1024 + 1) * 1024 * 2;
            }
            this.mAudioRecord = new AudioRecord(5, 44100, 16, 2, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            this.mAudioRecord.startRecording();
            ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
            while (!AudioMediaEncoder.this.mRequestStop) {
                buffer.clear();
                int readBytes = this.mAudioRecord.read(buffer, 1024);
                if (readBytes <= 0) continue;
                buffer.position(readBytes);
                buffer.flip();
                AudioMediaEncoder.this.encode(buffer, readBytes, AudioMediaEncoder.this.getPresentationTime());
                AudioMediaEncoder.this.drain(false);
            }
            AudioMediaEncoder.this.encode(null, 0, AudioMediaEncoder.this.getPresentationTime());
            AudioMediaEncoder.this.drain(false);
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
            Object object = AudioMediaEncoder.this.mLock;
            synchronized (object) {
                AudioMediaEncoder.this.mLock.notify();
            }
        }
    }

    static class Config {
        int bitRate;

        Config(int bitRate) {
            this.bitRate = bitRate;
        }
    }
}

