/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import oracle.net.ns.NetException;
import oracle.net.resolver.AddrResolution;
import oracle.net.resolver.NamingAdapterInterface;

public class HostnameNamingAdapter
implements NamingAdapterInterface {
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_PROTOCOL = "TCP";
    String osuser;
    String programName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    private HostnameNamingAdapter() {
    }

    public HostnameNamingAdapter(String _osuser, String _programName) {
        this.osuser = _osuser;
        this.programName = _programName;
    }

    @Override
    public String resolve(String TNSdesc) throws NetException {
        String connStr;
        int colonOff = 0;
        int sSlashOff = 0;
        int hostOff = 0;
        int rightSqurBrktOff = 0;
        boolean secondFormat = false;
        if (TNSdesc.startsWith("//")) {
            TNSdesc = TNSdesc.substring(2);
        }
        if (TNSdesc.charAt(0) == '[') {
            secondFormat = true;
            rightSqurBrktOff = TNSdesc.indexOf(93);
            if (rightSqurBrktOff != -1) {
                colonOff = TNSdesc.indexOf(58, rightSqurBrktOff);
            }
            if (rightSqurBrktOff == -1 || colonOff != -1 && colonOff != rightSqurBrktOff + 1) {
                throw new NetException(117);
            }
            hostOff = 1;
            sSlashOff = TNSdesc.indexOf(47, rightSqurBrktOff);
        } else {
            hostOff = 0;
            colonOff = TNSdesc.indexOf(58);
            sSlashOff = TNSdesc.indexOf(47, hostOff);
        }
        if (sSlashOff != -1 && colonOff > sSlashOff || TNSdesc.endsWith("/") || TNSdesc.endsWith(":")) {
            throw new NetException(117);
        }
        try {
            String service_name;
            String host = secondFormat ? TNSdesc.substring(hostOff, rightSqurBrktOff) : (colonOff != -1 ? TNSdesc.substring(hostOff, colonOff) : (sSlashOff != -1 ? TNSdesc.substring(hostOff, sSlashOff) : TNSdesc.substring(hostOff)));
            int port = colonOff != -1 ? (sSlashOff != -1 ? Integer.parseInt(TNSdesc.substring(colonOff + 1, sSlashOff)) : Integer.parseInt(TNSdesc.substring(colonOff + 1))) : 1521;
            boolean isServerModePresent = false;
            String serverMode = "";
            if (sSlashOff != -1) {
                int pIndex = TNSdesc.indexOf(58, sSlashOff + 1);
                if (pIndex != -1) {
                    serverMode = TNSdesc.substring(pIndex + 1);
                    isServerModePresent = AddrResolution.SERVER_MODES.contains(serverMode.toUpperCase());
                }
                service_name = isServerModePresent ? TNSdesc.substring(sSlashOff + 1, pIndex) : TNSdesc.substring(sSlashOff + 1);
            } else {
                service_name = "";
            }
            InetAddress[] inetAdd = InetAddress.getAllByName(host);
            StringBuilder addrList = new StringBuilder();
            for (int i2 = 0; i2 < inetAdd.length; ++i2) {
                host = inetAdd[i2].getHostAddress();
                addrList.append(String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", DEFAULT_PROTOCOL, host, port));
            }
            connStr = String.format("(DESCRIPTION=%s%s)", String.format("(CONNECT_DATA=%s%s%s)", String.format("(SERVICE_NAME=%s)", service_name), isServerModePresent ? String.format("(SERVER=%s)", serverMode) : "", ""), addrList.toString());
        }
        catch (NumberFormatException nfe) {
            throw new NetException(116);
        }
        catch (UnknownHostException uhe) {
            throw new NetException(118);
        }
        return connStr;
    }

    static {
        try {
            $$$methodRef$$$2 = HostnameNamingAdapter.class.getDeclaredConstructor(String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = HostnameNamingAdapter.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = HostnameNamingAdapter.class.getDeclaredMethod("resolve", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

