/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected int leftOverFromPreviousRead;
    protected int nextPacketOffset;
    public SessionAtts sAtts;
    StringBuilder sb;
    StringBuilder tmpBuf;
    public static final String[] toHex;
    public static final char[] toChar;
    public static final String DIVIDER = "     |";
    public static final String BLANK_SPACE = "   ";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    public Packet(SessionAtts sAtts) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, sAtts);
            }
            this.leftOverFromPreviousRead = 0;
            this.nextPacketOffset = 0;
            this.sb = null;
            this.tmpBuf = null;
            this.sAtts = sAtts;
            this.sdu = sAtts.getSDU();
            this.tdu = sAtts.getTDU();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(SessionAtts sAtts, int bufferSize) {
        this(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, sAtts, bufferSize);
            }
            this.createBuffer(bufferSize);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(SessionAtts sAtts, int bufferSize, int type, int flags) {
        this(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, sAtts, bufferSize, type, flags);
            }
            this.createBuffer(bufferSize, type, flags);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(Packet pkt) {
        this(pkt.sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, pkt);
            }
            this.length = pkt.length;
            this.type = pkt.type;
            this.flags = pkt.flags;
            this.dataLen = pkt.dataLen;
            this.dataOff = pkt.dataOff;
            this.buffer = pkt.buffer;
            this.leftOverFromPreviousRead = pkt.leftOverFromPreviousRead;
            this.nextPacketOffset = pkt.nextPacketOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createBuffer(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, n2);
            }
            this.buffer = new byte[length];
            if (this.sAtts.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15)) {
                this.buffer[3] = (byte)(length & 0xFF);
                this.buffer[2] = (byte)(length >> 8 & 0xFF);
                this.buffer[1] = (byte)(length >> 16 & 0xFF);
                this.buffer[0] = (byte)(length >> 24 & 0xFF);
            } else {
                this.buffer[0] = (byte)(length / 256);
                this.buffer[1] = (byte)(length % 256);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createBuffer(int n2, int n3, int n4) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flags;
            void length;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, n2, n3, n4);
            }
            this.type = type;
            this.createBuffer((int)length);
            this.buffer[5] = (byte)flags;
            this.buffer[4] = (byte)type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void receive() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, new Object[0]);
            }
            int bytesRead = 0;
            int nBytes = 0;
            int bytesToRead = this.sdu;
            boolean needToReadHeader = true;
            while (bytesToRead > 0) {
                if (this.leftOverFromPreviousRead > 0) {
                    System.arraycopy(this.buffer, this.nextPacketOffset, this.buffer, 0, this.leftOverFromPreviousRead);
                    bytesRead = this.leftOverFromPreviousRead;
                    if (bytesRead >= 8) {
                        this.processHeader();
                        needToReadHeader = false;
                        if (this.length >= this.leftOverFromPreviousRead) {
                            bytesToRead = this.length - this.leftOverFromPreviousRead;
                            this.leftOverFromPreviousRead = 0;
                            this.nextPacketOffset = 0;
                        } else {
                            this.leftOverFromPreviousRead -= this.length;
                            bytesToRead = 0;
                            this.nextPacketOffset = this.length;
                        }
                    } else {
                        bytesToRead -= bytesRead;
                        this.leftOverFromPreviousRead -= bytesRead;
                        this.nextPacketOffset = 0;
                    }
                }
                try {
                    if (bytesToRead > 0) {
                        nBytes = this.sAtts.ntInputStream.read(this.buffer, bytesRead, bytesToRead);
                        if (nBytes <= 0) {
                            NetException netException = new NetException(0);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, netException);
                            }
                            throw netException;
                        }
                        bytesRead += nBytes;
                    }
                    if (needToReadHeader && bytesRead >= 8) {
                        needToReadHeader = false;
                        this.processHeader();
                        bytesToRead = this.length;
                        if (bytesRead > this.length) {
                            this.leftOverFromPreviousRead = bytesRead - this.length;
                            bytesToRead = 0;
                            this.nextPacketOffset = this.length;
                            continue;
                        }
                        this.leftOverFromPreviousRead = 0;
                        this.nextPacketOffset = 0;
                        bytesToRead -= bytesRead;
                        continue;
                    }
                    bytesToRead -= nBytes;
                }
                catch (InterruptedIOException exp) {
                    try {
                        this.sAtts.cOption.nt.sendUrgentByte(33);
                        this.sAtts.cOption.nt.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NetException netException = new NetException(504);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, netException);
                    }
                    throw netException;
                }
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "type=" + this.type + ", length=" + this.length + ", flags=" + this.flags + "\n" + this.dumpBytes(this.buffer, 0, this.length) + ", sessionTraceId=" + this.sAtts.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    void processHeader() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.length = this.buffer[0] & 0xFF;
            this.length <<= 8;
            this.length |= this.buffer[1] & 0xFF;
            this.type = this.buffer[4];
            this.flags = this.buffer[5];
            if (this.sAtts.isLargeSDU && (this.type == 6 || this.type == 14 || this.type == 12 || this.type == 15)) {
                this.length = Packet.toUb4(this.buffer, 0);
            }
            if (this.type > 19) {
                NetException netException = new NetException(204);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (this.length > 0x200000 || this.length > this.sdu) {
                NetException netException = new NetException(203);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (this.length < 8) {
                NetException netException = new NetException(207);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, new Object[0]);
            }
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                try {
                    if (bl) {
                        this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "\n" + this.dumpBytes(this.buffer, 0, this.buffer.length) + ", sessionTraceId=" + this.sAtts.traceId);
                    }
                    this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    protected void extractData() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.dataLen <= 0) {
                this.data = new String();
            } else if (this.length > this.dataOff) {
                this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
            } else {
                byte[] tempBuffer = new byte[this.dataLen + 10];
                byte[] dataBuffer = new byte[this.dataLen];
                int count = this.readLocal(tempBuffer, 0, this.dataLen + 10);
                if (count != 0) {
                    if (count >= 10) {
                        System.arraycopy(tempBuffer, 10, dataBuffer, 0, count -= 10);
                    } else {
                        NetException netException = new NetException(207);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, netException);
                        }
                        throw netException;
                    }
                }
                if (count < this.dataLen && this.sAtts.nsInputStream.read(dataBuffer, count, this.dataLen - count) < 0) {
                    NetException netException = new NetException(0);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, netException);
                    }
                    throw netException;
                }
                this.data = new String(dataBuffer, 0);
            }
            if (bl) {
                this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "data=" + this.data + ", sessionTraceId=" + this.sAtts.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected String getData() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, new Object[0]);
            }
            String string = this.data;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, string);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setFlags(int n2) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _flags;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, Packet.class, $$$methodRef$$$7, this, n2);
            }
            this.flags = _flags;
            this.buffer[5] = (byte)this.flags;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, Packet.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Packet.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Packet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void reinitialize(SessionAtts sessionAtts) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _sAtts;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, Packet.class, $$$methodRef$$$8, this, sessionAtts);
            }
            this.sAtts = _sAtts;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, Packet.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, Packet.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, Packet.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int toUb2(byte[] byArray, int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, Packet.class, $$$methodRef$$$9, null, byArray, n2);
            }
            int x2 = 0;
            x2 = b2[offset] & 0xFF;
            x2 <<= 8;
            int n3 = x2 |= b2[offset + true] & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, Packet.class, $$$methodRef$$$9, null, n3);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, Packet.class, $$$methodRef$$$9, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, Packet.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int toUb4(byte[] byArray, int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, Packet.class, $$$methodRef$$$10, null, byArray, n2);
            }
            int value = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                void offset;
                byte[] b2;
                int shift = (3 - i2) * 8;
                value += (b2[i2 + offset] & 0xFF) << shift;
            }
            int n3 = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, Packet.class, $$$methodRef$$$10, null, n3);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, Packet.class, $$$methodRef$$$10, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, Packet.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void setUb2ToBytes(byte[] byArray, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, Packet.class, $$$methodRef$$$11, null, byArray, n2, n3);
            }
            b[offset] = (byte)(value << 8 & 0xFF);
            b[offset + true] = (byte)(value & 0xFF);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, Packet.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, Packet.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, Packet.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    int available() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, Packet.class, $$$methodRef$$$12, this, new Object[0]);
            }
            int n2 = this.leftOverFromPreviousRead;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, Packet.class, $$$methodRef$$$12, this, n2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, Packet.class, $$$methodRef$$$12, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, Packet.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int readLocal(byte[] byArray, int n2, int n3) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, Packet.class, $$$methodRef$$$13, this, byArray, n2, n3);
            }
            int bytesRead = 0;
            if (this.leftOverFromPreviousRead > 0) {
                void _offset;
                void userBuffer;
                void size;
                if (this.leftOverFromPreviousRead > size) {
                    bytesRead = size;
                    System.arraycopy(this.buffer, this.nextPacketOffset, userBuffer, (int)_offset, bytesRead);
                    this.leftOverFromPreviousRead -= bytesRead;
                    this.nextPacketOffset += bytesRead;
                } else {
                    bytesRead = this.leftOverFromPreviousRead;
                    System.arraycopy(this.buffer, this.nextPacketOffset, userBuffer, (int)_offset, bytesRead);
                    this.leftOverFromPreviousRead -= bytesRead;
                    this.nextPacketOffset = 0;
                }
            }
            int n4 = bytesRead;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, Packet.class, $$$methodRef$$$13, this, n4);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, Packet.class, $$$methodRef$$$13, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, Packet.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String dumpBytes(byte[] byArray, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void start;
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, Packet.class, $$$methodRef$$$14, this, byArray, n2, n3);
            }
            if (this.sb == null) {
                this.sb = new StringBuilder(16384);
                this.tmpBuf = new StringBuilder(80);
            }
            String string = this.dumpBytes((byte[])b2, (int)start, (int)nbytes, 8, this.sb, this.tmpBuf);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, Packet.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, Packet.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, Packet.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String dumpBytes(byte[] byArray, int n2, int n3, int n4, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytesPerLine;
            void nBytes;
            void start;
            void tmpBuf;
            void sb;
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, byArray, n2, n3, n4, stringBuilder, stringBuilder2);
            }
            if (b2 == null) {
                String string = "NULL";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, string);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, null);
                }
                return "NULL";
            }
            sb.delete(0, sb.length());
            tmpBuf.delete(0, tmpBuf.length());
            void length = start + nBytes;
            boolean noOfLines = false;
            int bytesThisLine = 0;
            for (void i2 = start; i2 < length; ++i2) {
                int x2 = b2[i2] & 0xFF;
                sb.append(toHex[x2]);
                tmpBuf.append(toChar[x2]);
                if (++bytesThisLine != bytesPerLine) continue;
                sb.append(DIVIDER);
                sb.append(tmpBuf.substring(0, tmpBuf.length()));
                sb.append("|\n");
                tmpBuf.delete(0, tmpBuf.length());
                bytesThisLine = 0;
            }
            if (bytesThisLine > 0) {
                int j2;
                void spaces = bytesPerLine - bytesThisLine - true;
                for (j2 = 0; j2 <= spaces; ++j2) {
                    sb.append(BLANK_SPACE);
                }
                sb.append(DIVIDER);
                sb.append(tmpBuf.substring(0, tmpBuf.length()));
                for (j2 = 0; j2 <= spaces; ++j2) {
                    sb.append(" ");
                }
                sb.append("|\n");
                tmpBuf.delete(0, tmpBuf.length());
            }
            String string = sb.substring(0, sb.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, Packet.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void dump(byte[] byArray, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            void offset;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, Packet.class, $$$methodRef$$$16, this, byArray, n2, n3);
            }
            int bytes = 0;
            System.out.println("Packet dump");
            System.out.println("buffer.length=" + ((void)buffer).length);
            System.out.println("offset       =" + (int)offset);
            System.out.println("len          =" + (int)len);
            for (void i2 = offset; i2 < len; i2 += 8) {
                System.out.print("|");
                for (int j2 = 0; j2 < 8 && bytes < len - true; ++j2) {
                    bytes = i2 + j2;
                    RepConversion.printInHex((byte)buffer[bytes]);
                    System.out.print(" ");
                }
                System.out.println("|");
            }
            System.out.println("finish dump");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, Packet.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, Packet.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, Packet.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$20 = Packet.class.getDeclaredConstructor(Packet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = Packet.class.getDeclaredConstructor(SessionAtts.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = Packet.class.getDeclaredConstructor(SessionAtts.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = Packet.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = Packet.class.getDeclaredMethod("dump", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = Packet.class.getDeclaredMethod("dumpBytes", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, StringBuilder.class, StringBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = Packet.class.getDeclaredMethod("dumpBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = Packet.class.getDeclaredMethod("readLocal", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = Packet.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = Packet.class.getDeclaredMethod("setUb2ToBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = Packet.class.getDeclaredMethod("toUb4", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = Packet.class.getDeclaredMethod("toUb2", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = Packet.class.getDeclaredMethod("reinitialize", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = Packet.class.getDeclaredMethod("setFlags", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = Packet.class.getDeclaredMethod("getData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = Packet.class.getDeclaredMethod("extractData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = Packet.class.getDeclaredMethod("send", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = Packet.class.getDeclaredMethod("processHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = Packet.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = Packet.class.getDeclaredMethod("createBuffer", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = Packet.class.getDeclaredMethod("createBuffer", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
        toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    }
}

