/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit;
    protected boolean savedXAConnectionAutoCommit;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMPROMOTE = 8;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection;
    protected OracleXAConnection xaconnection;
    protected int timeout;
    protected String dblink;
    private Connection logicalConnection;
    private String synchronizeBeforeRecoverNewCall;
    private String synchronizeBeforeRecoverOldCall;
    private String recoverySqlRows;
    protected boolean canBeMigratablySuspended;
    private boolean isTMRScanStarted;
    private static final Xid[] NO_XID;
    Xid lastActiveXid;
    protected Xid activeXid;
    protected Hashtable<Xid, XidListEntry> xidHash;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    public OracleXAResource() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleXAResource.class, $$$methodRef$$$34, null, new Object[0]);
            }
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleXAResource.class, $$$methodRef$$$34, null);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleXAResource.class, $$$methodRef$$$34, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleXAResource.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleXAResource.class, $$$methodRef$$$35, null, pm_conn, xaconn);
            }
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            this.connection = pm_conn;
            this.xaconnection = xaconn;
            if (this.connection == null) {
                XAException xAException = (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$35, Level.FINEST, OracleXAResource.class, $$$methodRef$$$35, null, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleXAResource.class, $$$methodRef$$$35, null);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleXAResource.class, $$$methodRef$$$35, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleXAResource.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnection(Connection connection) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pm_conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, connection);
            }
            this.connection = pm_conn;
            if (this.connection == null) {
                XAException xAException = (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            XidListEntry x2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, xid);
            }
            XidListEntry xidListEntry = x2 = this.xidHash.get(xid2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, xidListEntry);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, null);
            }
            return xidListEntry;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean removeXidFromList(Xid xid) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, xid);
            }
            if (this.isSameXid(this.activeXid, (Xid)xid2)) {
                this.activeXid = null;
            }
            boolean bl3 = bl2 = this.xidHash.remove(xid2) != null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean isSameXid(Xid xid, Xid xid2) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid22;
            void xid1;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, xid, xid2);
            }
            if (xid1 == null) {
                boolean bl2;
                boolean bl3 = bl2 = xid1 == xid22;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, null);
                }
                return bl3;
            }
            boolean bl4 = xid1.equals(xid22);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DefaultLevel(value=Logging.FINEST)
    protected final boolean isOnStack(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, xid);
            }
            boolean bl2 = this.xidHash.containsKey(xid2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean isXidListEmpty() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean bl2 = this.xidHash.isEmpty();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void createOrUpdateXid(Xid xid, boolean bl, boolean[] blArray) {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            XidListEntry x2;
            void isSuspended;
            void xid2;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, xid, bl, blArray);
            }
            if (bl2) {
                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.putXidToList (xid = " + xid2 + ", isSusended = " + (boolean)isSuspended + " ): stacking xid");
            }
            if ((x2 = this.getMatchingXidListEntry((Xid)xid2)) != null) {
                if (bl2) {
                    this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.putXidToList (xid = " + xid2 + ", isSusended = " + (boolean)isSuspended + " ): x(not supposed to be null) = " + x2);
                }
                isLocallySuspended[0] = true;
                x2.isSuspended = isSuspended;
            } else {
                x2 = new XidListEntry((Xid)xid2, (boolean)isSuspended);
                this.xidHash.put((Xid)xid2, x2);
            }
            if (isSuspended != false) {
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            } else {
                this.enterGlobalTxnMode();
                if (this.lastActiveXid != null && this.isSameXid((Xid)xid2, this.lastActiveXid)) {
                    this.lastActiveXid = null;
                }
                this.activeXid = x2.xid;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, xid, blArray);
            }
            if (bl) {
                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "OracleXAResource.updateXidList (" + xid2 + "): trying to clear stacked xid");
            }
            boolean foundXid = false;
            XidListEntry x2 = this.getMatchingXidListEntry((Xid)xid2);
            if (x2 != null) {
                foundXid = true;
                flags[0] = true;
                flags[1] = x2.isSuspended;
                if (x2.isSuspended) {
                    this.enterGlobalTxnMode();
                } else {
                    this.exitGlobalTxnMode();
                }
            }
            boolean bl2 = foundXid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, xid);
            }
            boolean returnValue = false;
            XidListEntry x2 = this.getMatchingXidListEntry((Xid)xid2);
            if (x2 != null) {
                returnValue = x2.isSuspended;
            }
            boolean bl2 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Xid suspendStacked(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, xid);
            }
            Xid stackedXid = null;
            if (this.activeXid != null && !this.isSameXid(this.activeXid, (Xid)xid2)) {
                stackedXid = this.activeXid;
                if (bl) {
                    this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleXAResource.suspendStacked(xid): Before calling end()");
                }
                if (!this.isXidSuspended(this.activeXid)) {
                    this.end(this.activeXid, 0x2000000);
                    this.lastActiveXid = this.activeXid;
                    this.activeXid = null;
                }
            }
            Xid xid3 = stackedXid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, xid3);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, null);
            }
            return xid3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void resumeStacked(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, xid);
            }
            if (xid2 != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "OracleXAResource.resumeStacked(xid): Before calling start()");
                }
                this.start((Xid)xid2, 0x8000000);
                this.activeXid = xid2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Xid[] recover(int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Xid[] xidArray;
            Xid[] xids;
            Connection physicalConnection;
            block33: {
                void flag;
                block34: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, n2);
                    }
                    try {
                        if (this.connection instanceof ReplayableConnection) {
                            ((ReplayableConnection)((Object)this.connection)).disableReplay();
                            physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                        } else {
                            physicalConnection = this.connection;
                        }
                    }
                    catch (SQLException sqle) {
                        physicalConnection = this.connection;
                        this.checkError(sqle, -3);
                    }
                    Connection connection = physicalConnection;
                    // MONITORENTER : connection
                    if ((flag & 0x1800000) != flag) {
                        if (bl) {
                            this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleXAResource.recover(flag): XAER_INVAL, invalid flag");
                        }
                        XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        if (!bl) throw xAException;
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xAException);
                        throw xAException;
                    }
                    if (flag == 0x1000000) {
                        this.isTMRScanStarted = true;
                        break block33;
                    }
                    if (!this.isTMRScanStarted || flag != 0x800000) break block34;
                    this.isTMRScanStarted = false;
                    // MONITOREXIT : connection
                    Xid[] xidArray2 = NO_XID;
                    if (!bl) return NO_XID;
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xidArray2);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, null);
                    return NO_XID;
                }
                if (!this.isTMRScanStarted || flag != false) break block33;
                // MONITOREXIT : connection
                Xid[] xidArray3 = NO_XID;
                if (!bl) return NO_XID;
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xidArray3);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, null);
                return NO_XID;
            }
            try {
                ArrayList<OracleXid> xidCollection;
                block35: {
                    Statement stmt = null;
                    ResultSet rset = null;
                    xidCollection = new ArrayList<OracleXid>(50);
                    stmt = physicalConnection.createStatement();
                    try {
                        stmt.execute(this.synchronizeBeforeRecoverNewCall);
                    }
                    catch (Exception exc) {
                        if (bl) {
                            this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleXAResource.recover(flag): DBMS_XA.dist_txn_sync failed: " + exc);
                        }
                        stmt.execute(this.synchronizeBeforeRecoverOldCall);
                    }
                    rset = stmt.executeQuery(this.recoverySqlRows);
                    while (rset.next()) {
                        xidCollection.add(new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3)));
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (rset != null) {
                            rset.close();
                        }
                        break block35;
                    }
                    catch (Exception exc) {}
                    break block35;
                    catch (SQLException sqe) {
                        try {
                            if (bl) {
                                this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleXAResource.recover(flag): SQLException(internal) " + sqe);
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
                            if (!bl) throw xAException;
                            ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xAException);
                            throw xAException;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                if (rset != null) {
                                    rset.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Throwable throwable2 = throwable;
                            if (!bl) throw throwable2;
                            ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, throwable2);
                            throw throwable2;
                        }
                    }
                }
                int xidSize = xidCollection.size();
                xids = new Xid[xidSize];
                System.arraycopy(xidCollection.toArray(), 0, xids, 0, xidSize);
                // MONITOREXIT : connection
                xidArray = xids;
                if (!bl) return xids;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : connection
                Throwable throwable3 = throwable;
                if (!bl) throw throwable3;
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, throwable3);
                throw throwable3;
            }
            ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xidArray);
            ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, null);
            return xids;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (!bl) throw throwable;
            ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, throwable4);
            throw throwable;
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, new Object[0]);
                }
                if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
                    try {
                        this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                        this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
                    }
                    catch (SQLException ignoreException) {
                        if (!bl) break block8;
                        this.debug($$$loggerRef$$$12, Level.FINEST, $$$methodRef$$$12, "OracleXAResource.restoreAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, new Object[0]);
                }
                if (((OracleConnection)this.connection).getTxnMode() != 1) {
                    try {
                        this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                        this.connection.setAutoCommit(false);
                        this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                        this.xaconnection.setAutoCommit(false);
                    }
                    catch (SQLException ignoreException) {
                        if (!bl) break block8;
                        this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "OracleXAResource.saveAndAlterAutoCommitModeForGlobalTransaction got exception: " + ignoreException);
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resume(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, this, xid);
            }
            this.start((Xid)xid2, 0x8000000);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void join(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, this, xid);
            }
            this.start((Xid)xid2, 0x200000);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void suspend(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, this, xid);
            }
            this.end((Xid)xid2, 0x2000000);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void join(Xid xid, int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleXAResource.class, $$$methodRef$$$17, this, xid, n2);
            }
            this.timeout = timeout;
            this.start((Xid)xid2, 0x200000);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleXAResource.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXAResource.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXAResource.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resume(Xid xid, int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xid2;
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleXAResource.class, $$$methodRef$$$18, this, xid, n2);
            }
            this.timeout = timeout;
            this.start((Xid)xid2, 0x8000000);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleXAResource.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleXAResource.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleXAResource.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public Connection getConnection() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleXAResource.class, $$$methodRef$$$19, this, new Object[0]);
            }
            Connection connection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleXAResource.class, $$$methodRef$$$19, this, connection);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleXAResource.class, $$$methodRef$$$19, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleXAResource.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleXAResource.class, $$$methodRef$$$20, this, new Object[0]);
            }
            int n2 = this.timeout;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleXAResource.class, $$$methodRef$$$20, this, n2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleXAResource.class, $$$methodRef$$$20, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleXAResource.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            block13: {
                boolean bl2;
                block14: {
                    boolean _returnVal;
                    Connection conn1;
                    block11: {
                        boolean bl3;
                        block12: {
                            boolean bl4;
                            void xares;
                            if (bl) {
                                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, xAResource);
                            }
                            conn1 = null;
                            if (!(xares instanceof OracleXAResource)) {
                                boolean bl5 = false;
                                if (bl) {
                                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, bl5);
                                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, null);
                                }
                                return false;
                            }
                            conn1 = ((OracleXAResource)xares).getConnection();
                            try {
                                if (this.connection != null && !((OracleConnection)this.connection).isClosed()) break block11;
                                bl3 = bl4 = false;
                                if (!bl) break block12;
                            }
                            catch (SQLException sqe) {
                                XAException xAException = (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, xAException);
                                }
                                throw xAException;
                            }
                            ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, bl4);
                            ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, null);
                        }
                        return bl3;
                    }
                    String l_url = ((OracleConnection)this.connection).getURL();
                    String l_prt = ((OracleConnection)this.connection).getProtocolType();
                    if (conn1 == null) break block13;
                    bl2 = _returnVal = conn1.equals(this.connection) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
                    if (!bl) break block14;
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, null);
                }
                return bl2;
            }
            boolean bl6 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, bl6);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleXAResource.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void seconds;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleXAResource.class, $$$methodRef$$$22, this, n2);
            }
            if (seconds < 0) {
                XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleXAResource.class, $$$methodRef$$$22, this, xAException);
                }
                throw xAException;
            }
            this.timeout = seconds;
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleXAResource.class, $$$methodRef$$$22, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleXAResource.class, $$$methodRef$$$22, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleXAResource.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getDBLink() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleXAResource.class, $$$methodRef$$$23, this, new Object[0]);
            }
            String string = this.dblink;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleXAResource.class, $$$methodRef$$$23, this, string);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleXAResource.class, $$$methodRef$$$23, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleXAResource.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDBLink(String string) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dblink;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleXAResource.class, $$$methodRef$$$24, this, string);
            }
            this.dblink = dblink;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleXAResource.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleXAResource.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleXAResource.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLogicalConnection(Connection connection) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleXAResource.class, $$$methodRef$$$25, this, connection);
            }
            this.logicalConnection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleXAResource.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleXAResource.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleXAResource.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void allowGlobalTxnModeOnly(int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleXAResource.class, $$$methodRef$$$26, this, n2);
            }
            if (((OracleConnection)this.connection).getTxnMode() != 1) {
                void errorCode;
                XAException xAException = (XAException)DatabaseError.createXAException((int)errorCode).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleXAResource.class, $$$methodRef$$$26, this, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleXAResource.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleXAResource.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleXAResource.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void exitGlobalTxnMode() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleXAResource.class, $$$methodRef$$$27, this, new Object[0]);
            }
            ((OracleConnection)this.connection).setTxnMode(0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleXAResource.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleXAResource.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleXAResource.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void enterGlobalTxnMode() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleXAResource.class, $$$methodRef$$$28, this, new Object[0]);
            }
            ((OracleConnection)this.connection).setTxnMode(1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleXAResource.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleXAResource.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleXAResource.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkError(int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleXAResource.class, $$$methodRef$$$29, this, n2);
            }
            if ((error & 0xFFFF) != 0) {
                XAException xAException = (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), (int)error).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, OracleXAResource.class, $$$methodRef$$$29, this, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleXAResource.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleXAResource.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleXAResource.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkError(int n2, SQLException sQLException) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleXAResource.class, $$$methodRef$$$30, this, n2, sQLException);
            }
            if ((error & 0xFFFF) != 0) {
                void sqlException;
                XAException xAException = (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), (int)error, (SQLException)sqlException).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleXAResource.class, $$$methodRef$$$30, this, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleXAResource.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleXAResource.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleXAResource.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkError(int n2, int n3) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleXAResource.class, $$$methodRef$$$31, this, n2, n3);
            }
            if ((error & 0xFFFF) != 0) {
                void defaultXAError;
                XAException xAException = (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), (int)error, (int)defaultXAError).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, OracleXAResource.class, $$$methodRef$$$31, this, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleXAResource.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleXAResource.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleXAResource.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkError(SQLException sQLException, int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultXAError;
            void sqlex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleXAResource.class, $$$methodRef$$$32, this, sQLException, n2);
            }
            XAException xAException = (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), (SQLException)sqlex, (int)defaultXAError).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, OracleXAResource.class, $$$methodRef$$$32, this, xAException);
            }
            throw xAException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleXAResource.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleXAResource.class, $$$methodRef$$$33, this, new Object[0]);
            }
            OracleConnection oracleConnection = (OracleConnection)this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleXAResource.class, $$$methodRef$$$33, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleXAResource.class, $$$methodRef$$$33, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleXAResource.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$35 = OracleXAResource.class.getDeclaredConstructor(Connection.class, OracleXAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleXAResource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleXAResource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleXAResource.class.getDeclaredMethod("checkError", SQLException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleXAResource.class.getDeclaredMethod("checkError", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleXAResource.class.getDeclaredMethod("enterGlobalTxnMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleXAResource.class.getDeclaredMethod("exitGlobalTxnMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleXAResource.class.getDeclaredMethod("allowGlobalTxnModeOnly", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleXAResource.class.getDeclaredMethod("setLogicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleXAResource.class.getDeclaredMethod("setDBLink", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleXAResource.class.getDeclaredMethod("getDBLink", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleXAResource.class.getDeclaredMethod("setTransactionTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleXAResource.class.getDeclaredMethod("isSameRM", XAResource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleXAResource.class.getDeclaredMethod("getTransactionTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleXAResource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleXAResource.class.getDeclaredMethod("resume", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleXAResource.class.getDeclaredMethod("join", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleXAResource.class.getDeclaredMethod("suspend", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXAResource.class.getDeclaredMethod("join", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXAResource.class.getDeclaredMethod("resume", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXAResource.class.getDeclaredMethod("saveAndAlterAutoCommitModeForGlobalTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXAResource.class.getDeclaredMethod("restoreAutoCommitModeForGlobalTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXAResource.class.getDeclaredMethod("recover", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXAResource.class.getDeclaredMethod("resumeStacked", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAResource.class.getDeclaredMethod("suspendStacked", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAResource.class.getDeclaredMethod("isXidSuspended", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAResource.class.getDeclaredMethod("updateXidList", Xid.class, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAResource.class.getDeclaredMethod("createOrUpdateXid", Xid.class, Boolean.TYPE, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAResource.class.getDeclaredMethod("isXidListEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAResource.class.getDeclaredMethod("isOnStack", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAResource.class.getDeclaredMethod("isSameXid", Xid.class, Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAResource.class.getDeclaredMethod("removeXidFromList", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAResource.class.getDeclaredMethod("getMatchingXidListEntry", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAResource.class.getDeclaredMethod("setConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_XID = new Xid[0];
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        XidListEntry(Xid x2, boolean s2) {
            this.xid = x2;
            this.isSuspended = s2;
        }

        static {
            try {
                $$$methodRef$$$0 = XidListEntry.class.getDeclaredConstructor(OracleXAResource.class, Xid.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

