/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleJoinRowSet
extends OracleWebRowSet
implements JoinRowSet {
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins;
    private int joinType;
    private Vector addedRowSets;
    private Vector addedRowSetNames;
    private Object lockForJoinActions;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    public OracleJoinRowSet() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$20, null, new Object[0]);
            }
            this.joinType = 1;
            this.addedRowSets = new Vector();
            this.addedRowSetNames = new Vector();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addRowSet(Joinable joinable) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, joinable);
            }
            if (rowSet == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(350).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            if (!(rowSet instanceof RowSet)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(351).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            OracleCachedRowSet addedRowSet = this.checkAndWrapRowSet((RowSet)rowSet);
            String tblName = this.getMatchColumnTableName((RowSet)rowSet);
            switch (this.joinType) {
                case 1: {
                    this.doInnerJoin(addedRowSet);
                    this.addedRowSets.add(rowSet);
                    this.addedRowSetNames.add(tblName);
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(352).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addRowSet(RowSet rowSet, int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void matchColumnIndex;
            void rowSet2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$1, this, rowSet, n2);
            }
            ((OracleRowSet)rowSet2).setMatchColumn((int)matchColumnIndex);
            this.addRowSet((Joinable)rowSet2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addRowSet(RowSet rowSet, String string) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void matchColumnName;
            void rowSet2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$2, this, rowSet, string);
            }
            ((OracleRowSet)rowSet2).setMatchColumn((String)matchColumnName);
            this.addRowSet((Joinable)rowSet2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void matchColumnIndexes;
            void rowSets;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$3, this, rowSetArray, nArray);
            }
            if (((void)rowSets).length != ((void)matchColumnIndexes).length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(353).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            for (int i2 = 0; i2 < ((void)rowSets).length; ++i2) {
                ((OracleRowSet)rowSets[i2]).setMatchColumn((int)matchColumnIndexes[i2]);
                this.addRowSet((Joinable)rowSets[i2]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void matchColumnNames;
            void rowSets;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$4, this, rowSetArray, stringArray);
            }
            if (((void)rowSets).length != ((void)matchColumnNames).length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(353).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            for (int i2 = 0; i2 < ((void)rowSets).length; ++i2) {
                ((OracleRowSet)rowSets[i2]).setMatchColumn((String)matchColumnNames[i2]);
                this.addRowSet((Joinable)rowSets[i2]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public Collection getRowSets() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$5, this, new Object[0]);
            }
            Vector vector = this.addedRowSets;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$5, this, vector);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$5, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String[] getRowSetNames() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$6, this, new Object[0]);
            }
            Object[] objs = this.addedRowSetNames.toArray();
            String[] names = new String[objs.length];
            for (int i2 = 0; i2 < objs.length; ++i2) {
                names[i2] = (String)objs[i2];
            }
            String[] stringArray = names;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$6, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$6, this, null);
            }
            return names;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createCopy();
            ocrs.setCommand("");
            OracleCachedRowSet oracleCachedRowSet = ocrs;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$7, this, oracleCachedRowSet);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$7, this, null);
            }
            return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getJoinType() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$8, this, new Object[0]);
            }
            int n2 = this.joinType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$8, this, n2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$8, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsCrossJoin() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl2 = supportedJoins[0];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsInnerJoin() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl2 = supportedJoins[1];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsLeftOuterJoin() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$11, this, new Object[0]);
            }
            boolean bl2 = supportedJoins[2];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$11, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$11, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsRightOuterJoin() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$12, this, new Object[0]);
            }
            boolean bl2 = supportedJoins[3];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$12, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsFullJoin() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$13, this, new Object[0]);
            }
            boolean bl2 = supportedJoins[4];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$13, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$13, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setJoinType(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void jtype;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$14, this, n2);
            }
            if (jtype != true) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(352).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$14, this, sQLException);
                }
                throw sQLException;
            }
            this.joinType = jtype;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getWhereClause() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (this.addedRowSets.size() < 2) {
                String string = "WHERE";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, string);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, null);
                }
                return "WHERE";
            }
            StringBuffer whereClause = new StringBuffer();
            whereClause.append("WHERE\n");
            OracleRowSet leftRowSet = (OracleRowSet)this.addedRowSets.get(0);
            int[] matchIndexesLeft = leftRowSet.getMatchColumnIndexes();
            ResultSetMetaData leftMd = leftRowSet.getMetaData();
            String leftTable = leftRowSet.getTableName();
            for (int i2 = 1; i2 < this.addedRowSets.size(); ++i2) {
                if (i2 > 1) {
                    whereClause.append("\nAND\n");
                }
                OracleRowSet rightRowSet = (OracleRowSet)this.addedRowSets.get(i2);
                int[] matchIndexesRight = rightRowSet.getMatchColumnIndexes();
                ResultSetMetaData rightMd = rightRowSet.getMetaData();
                String rightTable = rightRowSet.getTableName();
                for (int j2 = 0; j2 < matchIndexesLeft.length; ++j2) {
                    if (j2 > 0) {
                        whereClause.append("\nAND\n");
                    }
                    whereClause.append("(" + leftTable + "." + leftMd.getColumnName(matchIndexesLeft[j2]) + " = " + rightTable + "." + rightMd.getColumnName(matchIndexesRight[j2]) + ")");
                }
                leftRowSet = rightRowSet;
                matchIndexesLeft = matchIndexesRight;
                leftMd = rightMd;
                leftTable = rightTable;
            }
            whereClause.append(";");
            String string = whereClause.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doInnerJoin(OracleCachedRowSet oracleCachedRowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void addedRowSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$16, this, oracleCachedRowSet);
            }
            if (this.addedRowSets.isEmpty()) {
                this.setMetaData((RowSetMetaData)addedRowSet.getMetaData());
                this.populate((ResultSet)addedRowSet);
                this.setMatchColumn(addedRowSet.getMatchColumnIndexes());
            } else {
                boolean isMatchColumn;
                Vector<OracleRow> newRows = new Vector<OracleRow>(100);
                OracleRowSetMetaData newMd = new OracleRowSetMetaData(10);
                int[] matchIndexesLeft = this.getMatchColumnIndexes();
                int[] matchIndexesRight = addedRowSet.getMatchColumnIndexes();
                int newColCount = this.getMetaData().getColumnCount() + addedRowSet.getMetaData().getColumnCount() - matchIndexesRight.length;
                newMd.setColumnCount(newColCount);
                String tableNameForMatchColumn = this.getTableName() + "#" + addedRowSet.getTableName();
                for (int indexLeft = 1; indexLeft <= this.colCount; ++indexLeft) {
                    isMatchColumn = false;
                    for (int j2 = 0; j2 < matchIndexesLeft.length; ++j2) {
                        if (indexLeft != matchIndexesLeft[j2]) continue;
                        isMatchColumn = true;
                        break;
                    }
                    this.setNewColumnMetaData(indexLeft, newMd, indexLeft, (RowSetMetaData)this.rowsetMetaData, isMatchColumn, tableNameForMatchColumn);
                }
                RowSetMetaData addedRowSetMd = (RowSetMetaData)addedRowSet.getMetaData();
                int addedRowSetColCount = addedRowSetMd.getColumnCount();
                int indexRightNew = this.colCount + 1;
                int[] indexesRightNew = new int[addedRowSetColCount];
                for (int indexRight = 1; indexRight <= addedRowSetColCount; ++indexRight) {
                    isMatchColumn = false;
                    for (int j3 = 0; j3 < matchIndexesRight.length; ++j3) {
                        if (indexRight != matchIndexesLeft[j3]) continue;
                        isMatchColumn = true;
                        break;
                    }
                    if (!isMatchColumn) {
                        this.setNewColumnMetaData(indexRightNew, newMd, indexRight, addedRowSetMd, isMatchColumn, tableNameForMatchColumn);
                        indexesRightNew[indexRight - 1] = indexRightNew++;
                        continue;
                    }
                    indexesRightNew[indexRight - 1] = -1;
                }
                this.beforeFirst();
                int addedRowSetRowCount = addedRowSet.size();
                boolean matchFound = false;
                for (int leftRow = 1; leftRow <= this.rowCount; ++leftRow) {
                    this.next();
                    addedRowSet.beforeFirst();
                    for (int rightRow = 1; rightRow <= addedRowSetRowCount; ++rightRow) {
                        addedRowSet.next();
                        matchFound = true;
                        for (int i2 = 0; i2 < matchIndexesLeft.length; ++i2) {
                            Object rightObj;
                            Object leftObj = this.getObject(matchIndexesLeft[i2]);
                            if (leftObj.equals(rightObj = addedRowSet.getObject(matchIndexesRight[i2]))) continue;
                            matchFound = false;
                            break;
                        }
                        if (!matchFound) continue;
                        OracleRow newRow = new OracleRow(newColCount, true);
                        for (int colLeft = 1; colLeft <= this.colCount; ++colLeft) {
                            newRow.updateObject(colLeft, this.getObject(colLeft));
                        }
                        for (int colRight = 1; colRight <= addedRowSetColCount; ++colRight) {
                            if (indexesRightNew[colRight - 1] == -1) continue;
                            newRow.updateObject(indexesRightNew[colRight - 1], addedRowSet.getObject(colRight));
                        }
                        newRows.add(newRow);
                    }
                }
                this.rows = newRows;
                this.presentRow = 0;
                this.rowCount = this.rows.size();
                this.setMetaData(newMd);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setNewColumnMetaData(int n2, RowSetMetaData rowSetMetaData, int n3, RowSetMetaData rowSetMetaData2, boolean bl, String string) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isMatchColumn;
            void origColIndex;
            void origMd;
            void newColIndex;
            void newMd;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$17, this, n2, rowSetMetaData, n3, rowSetMetaData2, bl, string);
            }
            newMd.setAutoIncrement((int)newColIndex, origMd.isAutoIncrement((int)origColIndex));
            newMd.setCaseSensitive((int)newColIndex, origMd.isCaseSensitive((int)origColIndex));
            newMd.setCatalogName((int)newColIndex, origMd.getCatalogName((int)origColIndex));
            newMd.setColumnDisplaySize((int)newColIndex, origMd.getColumnDisplaySize((int)origColIndex));
            if (isMatchColumn != false) {
                newMd.setColumnName((int)newColIndex, origMd.getColumnName((int)newColIndex) + MATCH_COLUMN_SUFFIX);
            } else {
                newMd.setColumnName((int)newColIndex, origMd.getColumnName((int)origColIndex));
            }
            newMd.setColumnLabel((int)newColIndex, newMd.getColumnName((int)origColIndex));
            newMd.setColumnType((int)newColIndex, origMd.getColumnType((int)origColIndex));
            newMd.setColumnTypeName((int)newColIndex, origMd.getColumnTypeName((int)origColIndex));
            newMd.setCurrency((int)newColIndex, origMd.isCurrency((int)origColIndex));
            newMd.setNullable((int)newColIndex, origMd.isNullable((int)origColIndex));
            newMd.setPrecision((int)newColIndex, origMd.getPrecision((int)origColIndex));
            newMd.setScale((int)newColIndex, origMd.getScale((int)origColIndex));
            newMd.setSchemaName((int)newColIndex, origMd.getSchemaName((int)origColIndex));
            newMd.setSearchable((int)newColIndex, origMd.isSearchable((int)origColIndex));
            newMd.setSigned((int)newColIndex, origMd.isSigned((int)origColIndex));
            if (isMatchColumn != false) {
                void tableNameForMatchColumn;
                newMd.setTableName((int)newColIndex, (String)tableNameForMatchColumn);
            } else {
                newMd.setTableName((int)newColIndex, origMd.getTableName((int)origColIndex));
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowSet2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$18, this, rowSet);
            }
            OracleCachedRowSet ocrs = null;
            if (rowSet2 instanceof OracleCachedRowSet) {
                ocrs = (OracleCachedRowSet)rowSet2;
            } else if (rowSet2 instanceof OracleJDBCRowSet) {
                ocrs = new OracleCachedRowSet();
                ocrs.populate((ResultSet)rowSet2);
                int[] matchIndexes = ((OracleJDBCRowSet)rowSet2).getMatchColumnIndexes();
                ocrs.setMatchColumn(matchIndexes);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(354).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            OracleCachedRowSet oracleCachedRowSet = ocrs;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$18, this, oracleCachedRowSet);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$18, this, null);
            }
            return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getMatchColumnTableName(RowSet rowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$19, this, rowSet);
            }
            String tblName = null;
            if (rowset instanceof OracleRowSet) {
                tblName = ((OracleRowSet)rowset).getTableName();
            }
            String string = tblName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$19, this, string);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$19, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleJoinRowSet.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = OracleJoinRowSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleJoinRowSet.class.getDeclaredMethod("getMatchColumnTableName", RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleJoinRowSet.class.getDeclaredMethod("checkAndWrapRowSet", RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleJoinRowSet.class.getDeclaredMethod("setNewColumnMetaData", Integer.TYPE, RowSetMetaData.class, Integer.TYPE, RowSetMetaData.class, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleJoinRowSet.class.getDeclaredMethod("doInnerJoin", OracleCachedRowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleJoinRowSet.class.getDeclaredMethod("getWhereClause", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleJoinRowSet.class.getDeclaredMethod("setJoinType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleJoinRowSet.class.getDeclaredMethod("supportsFullJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleJoinRowSet.class.getDeclaredMethod("supportsRightOuterJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleJoinRowSet.class.getDeclaredMethod("supportsLeftOuterJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJoinRowSet.class.getDeclaredMethod("supportsInnerJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJoinRowSet.class.getDeclaredMethod("supportsCrossJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJoinRowSet.class.getDeclaredMethod("getJoinType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJoinRowSet.class.getDeclaredMethod("toCachedRowSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJoinRowSet.class.getDeclaredMethod("getRowSetNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJoinRowSet.class.getDeclaredMethod("getRowSets", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJoinRowSet.class.getDeclaredMethod("addRowSet", RowSet[].class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJoinRowSet.class.getDeclaredMethod("addRowSet", RowSet[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJoinRowSet.class.getDeclaredMethod("addRowSet", RowSet.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJoinRowSet.class.getDeclaredMethod("addRowSet", RowSet.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJoinRowSet.class.getDeclaredMethod("addRowSet", Joinable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        supportedJoins = new boolean[]{false, true, false, false, false};
    }
}

