/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
public class T4CXAConnection
extends OracleXAConnection {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    public T4CXAConnection(Connection _physicalConnection) throws XAException {
        super(_physicalConnection);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$1, null, _physicalConnection);
            }
            this.xaResource = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized XAResource getXAResource() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, new Object[0]);
            }
            try {
                if (this.xaResource == null) {
                    OracleConnection physicalConnection = this.physicalConn instanceof BabelfishConnection ? (T4CConnection)((_Proxy_)((Object)this.physicalConn))._getDelegate_() : this.physicalConn;
                    this.xaResource = new T4CXAResource(physicalConnection, this, this.isXAResourceTransLoose);
                    if (this.logicalHandle != null) {
                        ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xae) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "T4CXAConnection.getXAResource: Exception caught : " + xae);
                }
                this.xaResource = null;
                if (xae.getCause() instanceof SQLException) {
                    SQLException sQLException = (SQLException)xae.getCause();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            XAResource xAResource = this.xaResource;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, xAResource);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, null);
            }
            return xAResource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CXAConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$1 = T4CXAConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CXAConnection.class.getDeclaredMethod("getXAResource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

