/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIiov
extends T4CTTIMsg {
    T4C8TTIrxh rxh;
    T4CTTIrxd rxd;
    short bindtype;
    byte[] iovector;
    int bindcnt;
    int inbinds;
    int outbinds;
    static final byte BV_IN_V = 32;
    static final byte BV_OUT_V = 16;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_20:58:27_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T4CTTIiov(T4CConnection _conn, T4C8TTIrxh _rxh, T4CTTIrxd _rxd) throws SQLException, IOException {
        super(_conn, (byte)0);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$6, null, _conn, _rxh, _rxd);
            }
            this.bindtype = 0;
            this.bindcnt = 0;
            this.inbinds = 0;
            this.outbinds = 0;
            this.rxh = _rxh;
            this.rxd = _rxd;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    void init() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Accessor[] processRXD(Accessor[] accessorArray, int n2, byte[] byArray, char[] cArray, short[] sArray, int n3, DBConversion dBConversion, byte[] byArray2, byte[] byArray3, InputStream[][] inputStreamArray, OracleStatement oracleStatement, byte[] byArray4, char[] cArray2, short[] sArray2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            Accessor[] outBindAccessors;
            void ioVector;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$1, this, new Object[]{accessorArray, n2, byArray, cArray, sArray, n3, dBConversion, byArray2, byArray3, inputStreamArray, oracleStatement, byArray4, cArray2, sArray2});
            }
            if (ioVector != null) {
                for (int i2 = 0; i2 < ((void)ioVector).length; ++i2) {
                    if ((ioVector[i2] & 0x10) != 0 && (outBindAccessors == null || outBindAccessors.length <= i2 || outBindAccessors[i2] == null)) {
                        void oracleStatement2;
                        void bindIndicators;
                        int type;
                        void bindIndicatorSubRange;
                        if (bl) {
                            this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "The OUT paramter at index " + i2 + " was not registered with registerOutParamter. All the OUT paramters of a PL/SQL procedure need to be registered.");
                        }
                        void subRangeOffset = bindIndicatorSubRange + 5 + 10 * i2;
                        int external_type = type = bindIndicators[subRangeOffset + false] & 0xFFFF;
                        if (type == 9) {
                            type = 1;
                        }
                        Accessor acc = oracleStatement2.allocateAccessor(type, type, i2, 0, (short)0, null, false);
                        acc.rowSpaceIndicator = null;
                        if (outBindAccessors == null) {
                            outBindAccessors = new Accessor[i2 + 1];
                            outBindAccessors[i2] = acc;
                            continue;
                        }
                        if (outBindAccessors.length <= i2) {
                            Accessor[] outBindAccessorsNew = new Accessor[i2 + 1];
                            outBindAccessorsNew[i2] = acc;
                            for (int ii = 0; ii < outBindAccessors.length; ++ii) {
                                if (outBindAccessors[ii] == null) continue;
                                outBindAccessorsNew[ii] = outBindAccessors[ii];
                            }
                            outBindAccessors = outBindAccessorsNew;
                            continue;
                        }
                        outBindAccessors[i2] = acc;
                        continue;
                    }
                    if ((ioVector[i2] & 0x10) != 0 || outBindAccessors == null || i2 >= outBindAccessors.length || outBindAccessors[i2] == null) continue;
                    outBindAccessors[i2].isUseLess = true;
                }
            }
            void var23_23 = outBindAccessors;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$1, this, var23_23);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$1, this, null);
            }
            return var23_23;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalV10() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.rxh.unmarshalV10(this.rxd);
            this.bindcnt = this.rxh.numRqsts;
            if (TRACE) {
                this.rxh.print();
                if (bl) {
                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10: bindcnt = " + this.bindcnt);
                }
            }
            this.iovector = new byte[this.connection.all8.numberOfBindPositions];
            for (int i2 = 0; i2 < this.iovector.length; ++i2) {
                this.bindtype = this.meg.unmarshalUB1();
                if (this.bindtype == 0) {
                    if (bl) {
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10: bindtype == 0");
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                if (bl) {
                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10: bindtype = " + this.bindtype);
                }
                if ((this.bindtype & 0x20) > 0) {
                    int n2 = i2;
                    this.iovector[n2] = (byte)(this.iovector[n2] | 0x20);
                    ++this.inbinds;
                }
                if ((this.bindtype & 0x10) <= 0) continue;
                int n3 = i2;
                this.iovector[n3] = (byte)(this.iovector[n3] | 0x10);
                ++this.outbinds;
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10: inbinds = " + this.inbinds);
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10: outbinds = " + this.outbinds);
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "T4CTTIiov.unmarshalV10:return");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getIOVector() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte[] byArray = this.iovector;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$3, this, null);
            }
            return this.iovector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isIOVectorEmpty() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$4, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.iovector.length == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$5, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.driver");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$5, null, logger);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$5, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIiov.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = T4CTTIiov.class.getDeclaredConstructor(T4CConnection.class, T4C8TTIrxh.class, T4CTTIrxd.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIiov.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIiov.class.getDeclaredMethod("isIOVectorEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIiov.class.getDeclaredMethod("getIOVector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIiov.class.getDeclaredMethod("unmarshalV10", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIiov.class.getDeclaredMethod("processRXD", Accessor[].class, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, DBConversion.class, byte[].class, byte[].class, InputStream[][].class, OracleStatement.class, byte[].class, char[].class, short[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIiov.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIiov"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

