/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCache
implements oracle.jdbc.internal.ResultSetCache {
    static final int COMPILE_KEY_SIZE = 16;
    static final int RUNTIME_KEY_SIZE = 16;
    private static final int CACHE_ID_SIZE = 16;
    private static final long STAT_SEND_INTERVAL = 30000L;
    private final byte[] cacheId;
    private final byte[] cacheIdAsNibbles;
    private boolean isCacheIdAsNibblesReady;
    private final long cacheLagInMillis;
    private long nextPingTime;
    private AtomicLong invalidationCount;
    private AtomicLong invalidatedQueryCount;
    private AtomicLong validQueriesPurged;
    private AtomicLong invalidatedBeforeCompletion;
    private AtomicInteger cacheHits;
    private long lastStatSentAt;
    private T4CTTIOqcsta oqcsta;
    private AtomicBoolean needToSendStats;
    private long registrationId;
    private ResultSetCacheState state;
    private long visibleSCN;
    private final CacheStorage cacheStorage;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;

    ResultSetCache(long cacheMaxSize, int cacheLag) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null, cacheMaxSize, cacheLag);
            }
            this.cacheId = new byte[16];
            this.cacheIdAsNibbles = new byte[32];
            this.isCacheIdAsNibblesReady = false;
            this.nextPingTime = 0L;
            this.invalidationCount = new AtomicLong(0L);
            this.invalidatedQueryCount = new AtomicLong(0L);
            this.validQueriesPurged = new AtomicLong(0L);
            this.invalidatedBeforeCompletion = new AtomicLong(0L);
            this.cacheHits = new AtomicInteger(0);
            this.needToSendStats = new AtomicBoolean(false);
            this.registrationId = -1L;
            this.state = ResultSetCacheState.INIT;
            if (!$assertionsDisabled && cacheMaxSize <= 0L) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && cacheLag < 0) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            new Random().nextBytes(this.cacheId);
            this.cacheStorage = new CacheStorage(cacheMaxSize);
            this.cacheLagInMillis = cacheLag;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ResultSetCache.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setState(ResultSetCacheState resultSetCacheState) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void state;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this, new Object[]{resultSetCacheState});
            }
            if (state == this.state) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this, null);
                }
                return;
            }
            this.state = state;
            if (state == ResultSetCacheState.STARTED) {
                this.notifyAll();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetCache.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized ResultSetCacheState getState() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ResultSetCache.class, $$$methodRef$$$1, this, new Object[0]);
            }
            ResultSetCacheState resultSetCacheState = this.state;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ResultSetCache.class, $$$methodRef$$$1, this, (Object)resultSetCacheState);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetCache.class, $$$methodRef$$$1, this, null);
            }
            return resultSetCacheState;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetCache.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized byte[] getCacheId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ResultSetCache.class, $$$methodRef$$$2, this, new Object[0]);
            }
            byte[] byArray = this.cacheId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ResultSetCache.class, $$$methodRef$$$2, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetCache.class, $$$methodRef$$$2, this, null);
            }
            return this.cacheId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetCache.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized byte[] getCacheIdAsNibbles() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ResultSetCache.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (!this.isCacheIdAsNibblesReady) {
                RepConversion.bArray2Nibbles(this.cacheId, this.cacheIdAsNibbles);
                this.isCacheIdAsNibblesReady = true;
            }
            byte[] byArray = this.cacheIdAsNibbles;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ResultSetCache.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetCache.class, $$$methodRef$$$3, this, null);
            }
            return this.cacheIdAsNibbles;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetCache.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized long getRegistrationId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ResultSetCache.class, $$$methodRef$$$4, this, new Object[0]);
            }
            long l2 = this.registrationId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ResultSetCache.class, $$$methodRef$$$4, this, l2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ResultSetCache.class, $$$methodRef$$$4, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ResultSetCache.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setRegistrationId(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void registrationId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ResultSetCache.class, $$$methodRef$$$5, this, l2);
            }
            this.registrationId = registrationId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ResultSetCache.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ResultSetCache.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ResultSetCache.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setOQCSTA(T4CTTIOqcsta t4CTTIOqcsta) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ResultSetCache.class, $$$methodRef$$$6, this, t4CTTIOqcsta);
            }
            this.oqcsta = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ResultSetCache.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ResultSetCache.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ResultSetCache.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized T4CTTIOqcsta getOQCSTA() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ResultSetCache.class, $$$methodRef$$$7, this, new Object[0]);
            }
            T4CTTIOqcsta t4CTTIOqcsta = this.oqcsta;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ResultSetCache.class, $$$methodRef$$$7, this, t4CTTIOqcsta);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ResultSetCache.class, $$$methodRef$$$7, this, null);
            }
            return t4CTTIOqcsta;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ResultSetCache.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setVisibleSCN(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void visibleSCN;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ResultSetCache.class, $$$methodRef$$$8, this, l2);
            }
            this.visibleSCN = visibleSCN;
            this.nextPingTime = System.currentTimeMillis() + this.cacheLagInMillis;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ResultSetCache.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ResultSetCache.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ResultSetCache.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized long getVisibleSCN() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ResultSetCache.class, $$$methodRef$$$9, this, new Object[0]);
            }
            long l2 = this.visibleSCN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ResultSetCache.class, $$$methodRef$$$9, this, l2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ResultSetCache.class, $$$methodRef$$$9, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ResultSetCache.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void processCommittedInvalidation(T4CTTIqcinv t4CTTIqcinv) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void invalidation;
            long queryId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this, t4CTTIqcinv);
            }
            if ((queryId = invalidation.kpdqcqid) == 0L) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this, null);
                }
                return;
            }
            this.invalidationCount.incrementAndGet();
            long invalidationScn = invalidation.kpdqcscn.getSCN();
            if (!T4CTTIkscn.isLessThanUnsigned(invalidationScn, this.visibleSCN)) {
                int noOfEntriesInvalidated = this.cacheStorage.removeResultsetCacheEntries(queryId);
                this.invalidatedQueryCount.addAndGet(noOfEntriesInvalidated);
            }
            this.needToSendStats.set(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ResultSetCache.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized ResultSetCacheEntry getResultSetCacheEntry(OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            ResultSetCacheEntry value;
            void stmt;
            byte[] compileKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, oracleStatement);
            }
            if ((compileKey = stmt.getCompileKey()) == null || compileKey.length == 0) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, resultSetCacheEntry);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, null);
                }
                return resultSetCacheEntry;
            }
            byte[] runtimeKey = stmt.getRuntimeKey();
            if (runtimeKey == null) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, resultSetCacheEntry);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, null);
                }
                return resultSetCacheEntry;
            }
            ResultSetCacheEntryKey key = new ResultSetCacheEntryKey(compileKey, runtimeKey);
            long queryId = stmt.getQueryId();
            ArrayList<Long> localInvalidations = stmt.connection.getResultSetCacheLocalInvalidations();
            if (queryId == 0L || localInvalidations.contains(queryId)) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, resultSetCacheEntry);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, null);
                }
                return null;
            }
            if (System.currentTimeMillis() > this.nextPingTime) {
                stmt.connection.pingDatabase();
            }
            if ((value = this.cacheStorage.getResultsetCacheEntry(key, queryId, stmt.connection.userName)) != null && value.userName.equals(stmt.connection.userName)) {
                if (value.isValid()) {
                    this.cacheHits.incrementAndGet();
                    this.needToSendStats.set(true);
                    if (this.lastStatSentAt == 0L) {
                        this.lastStatSentAt = System.currentTimeMillis();
                    }
                }
                ResultSetCacheEntry resultSetCacheEntry = value;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, resultSetCacheEntry);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, null);
                }
                return resultSetCacheEntry;
            }
            ResultSetCacheEntry resultSetCacheEntry = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, resultSetCacheEntry);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCache.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void registerConnection(OracleConnection oracleConnection) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ResultSetCache.class, $$$methodRef$$$12, this, oracleConnection);
            }
            if (this.state == ResultSetCacheState.INIT) {
                this.setState(ResultSetCacheState.STARTING);
            } else if (this.state == ResultSetCacheState.STARTING) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ResultSetCache.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ResultSetCache.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ResultSetCache.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized boolean needToSendStatsResetIfTrue() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (System.currentTimeMillis() - this.lastStatSentAt > 30000L && this.needToSendStats.weakCompareAndSet(true, false)) {
                this.lastStatSentAt = System.currentTimeMillis();
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ResultSetCache.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getCacheLag() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, ResultSetCache.class, $$$methodRef$$$14, this, new Object[0]);
            }
            int n2 = (int)this.cacheLagInMillis;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, ResultSetCache.class, $$$methodRef$$$14, this, n2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ResultSetCache.class, $$$methodRef$$$14, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ResultSetCache.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getInvalidationCount() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ResultSetCache.class, $$$methodRef$$$15, this, new Object[0]);
            }
            long l2 = this.invalidationCount.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ResultSetCache.class, $$$methodRef$$$15, this, l2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ResultSetCache.class, $$$methodRef$$$15, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ResultSetCache.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getInvalidatedQueryCount() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, ResultSetCache.class, $$$methodRef$$$16, this, new Object[0]);
            }
            long l2 = this.invalidatedQueryCount.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ResultSetCache.class, $$$methodRef$$$16, this, l2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ResultSetCache.class, $$$methodRef$$$16, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ResultSetCache.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getInvalidatedBeforeCompletion() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, ResultSetCache.class, $$$methodRef$$$17, this, new Object[0]);
            }
            long l2 = this.invalidatedBeforeCompletion.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ResultSetCache.class, $$$methodRef$$$17, this, l2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ResultSetCache.class, $$$methodRef$$$17, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ResultSetCache.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getValidQueriesPurged() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, ResultSetCache.class, $$$methodRef$$$18, this, new Object[0]);
            }
            long l2 = this.validQueriesPurged.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ResultSetCache.class, $$$methodRef$$$18, this, l2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ResultSetCache.class, $$$methodRef$$$18, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ResultSetCache.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getCacheHits() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, ResultSetCache.class, $$$methodRef$$$19, this, new Object[0]);
            }
            int n2 = this.cacheHits.get();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, ResultSetCache.class, $$$methodRef$$$19, this, n2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ResultSetCache.class, $$$methodRef$$$19, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ResultSetCache.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void updateCurrentCacheSize(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void changeInSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, ResultSetCache.class, $$$methodRef$$$20, this, l2);
            }
            this.cacheStorage.incrementCacheSize((long)changeInSize);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, ResultSetCache.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ResultSetCache.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ResultSetCache.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getCurrentCacheSize() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, ResultSetCache.class, $$$methodRef$$$21, this, new Object[0]);
            }
            long l2 = this.cacheStorage.getCacheSize();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ResultSetCache.class, $$$methodRef$$$21, this, l2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ResultSetCache.class, $$$methodRef$$$21, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ResultSetCache.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getMaxCacheSize() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, ResultSetCache.class, $$$methodRef$$$22, this, new Object[0]);
            }
            long l2 = this.cacheStorage.maxSize();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, ResultSetCache.class, $$$methodRef$$$22, this, l2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ResultSetCache.class, $$$methodRef$$$22, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ResultSetCache.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getNumberOfCacheEntries() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, ResultSetCache.class, $$$methodRef$$$23, this, new Object[0]);
            }
            long l2 = this.cacheStorage.size();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, ResultSetCache.class, $$$methodRef$$$23, this, l2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ResultSetCache.class, $$$methodRef$$$23, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ResultSetCache.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$24 = ResultSetCache.class.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ResultSetCache.class.getDeclaredMethod("getNumberOfCacheEntries", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ResultSetCache.class.getDeclaredMethod("getMaxCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ResultSetCache.class.getDeclaredMethod("getCurrentCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ResultSetCache.class.getDeclaredMethod("updateCurrentCacheSize", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ResultSetCache.class.getDeclaredMethod("getCacheHits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ResultSetCache.class.getDeclaredMethod("getValidQueriesPurged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ResultSetCache.class.getDeclaredMethod("getInvalidatedBeforeCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ResultSetCache.class.getDeclaredMethod("getInvalidatedQueryCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ResultSetCache.class.getDeclaredMethod("getInvalidationCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ResultSetCache.class.getDeclaredMethod("getCacheLag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ResultSetCache.class.getDeclaredMethod("needToSendStatsResetIfTrue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ResultSetCache.class.getDeclaredMethod("registerConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ResultSetCache.class.getDeclaredMethod("getResultSetCacheEntry", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ResultSetCache.class.getDeclaredMethod("processCommittedInvalidation", T4CTTIqcinv.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ResultSetCache.class.getDeclaredMethod("getVisibleSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ResultSetCache.class.getDeclaredMethod("setVisibleSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ResultSetCache.class.getDeclaredMethod("getOQCSTA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ResultSetCache.class.getDeclaredMethod("setOQCSTA", T4CTTIOqcsta.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ResultSetCache.class.getDeclaredMethod("setRegistrationId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ResultSetCache.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ResultSetCache.class.getDeclaredMethod("getCacheIdAsNibbles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetCache.class.getDeclaredMethod("getCacheId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetCache.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCache.class.getDeclaredMethod("setState", ResultSetCacheState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static class CacheStorage
    extends LinkedHashMap<ResultSetCacheEntryKey, ResultSetCacheEntry> {
        private static final int INITIAL_SIZE = 10;
        private static final long serialVersionUID = 1L;
        private long currentCacheSize;
        private final long maxCacheSize;
        private final Map<Long, LinkedList<ResultSetCacheEntry>> queryIdIndex = new HashMap<Long, LinkedList<ResultSetCacheEntry>>(10);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        CacheStorage(long maxCacheSize) {
            super(10);
            this.maxCacheSize = maxCacheSize;
        }

        synchronized ResultSetCacheEntry getResultsetCacheEntry(ResultSetCacheEntryKey key, long queryId, String userName) {
            ResultSetCacheEntry entry = (ResultSetCacheEntry)super.get(key);
            if (entry == null) {
                entry = new ResultSetCacheEntry(key, queryId);
                entry.userName = userName;
                super.put(key, entry);
                this.currentCacheSize += entry.getSizeInMemory();
                this.queryIdIndex.computeIfAbsent(queryId, k2 -> new LinkedList()).add(entry);
            }
            return entry;
        }

        synchronized int removeResultsetCacheEntries(Long queryId) {
            int invalidateCount = 0;
            LinkedList<ResultSetCacheEntry> cacheEntriesList = this.queryIdIndex.remove(queryId);
            if (cacheEntriesList != null) {
                for (ResultSetCacheEntry cacheEntry : cacheEntriesList) {
                    if (this.remove(cacheEntry.getResultSetCacheEntryKey()) != null) {
                        this.currentCacheSize -= cacheEntry.getSizeInMemory();
                    }
                    cacheEntry.invalidate();
                    ++invalidateCount;
                }
            }
            return invalidateCount;
        }

        synchronized void incrementCacheSize(long changeInSize) {
            this.currentCacheSize += changeInSize;
        }

        synchronized long getCacheSize() {
            return this.currentCacheSize;
        }

        synchronized long maxSize() {
            return this.maxCacheSize;
        }

        @Override
        protected synchronized boolean removeEldestEntry(Map.Entry<ResultSetCacheEntryKey, ResultSetCacheEntry> eldest) {
            boolean hasExceededMaxSize;
            boolean bl = hasExceededMaxSize = this.currentCacheSize >= this.maxCacheSize;
            if (hasExceededMaxSize) {
                ResultSetCacheEntry eldestValue = eldest.getValue();
                this.currentCacheSize = -1L * eldestValue.getSizeInMemory();
                LinkedList<ResultSetCacheEntry> entries = this.queryIdIndex.get(eldestValue.getQueryId());
                entries.remove(eldestValue);
            }
            return hasExceededMaxSize;
        }

        static {
            try {
                $$$methodRef$$$7 = CacheStorage.class.getDeclaredConstructor(Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = CacheStorage.class.getDeclaredMethod("lambda$getResultsetCacheEntry$0", Long.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = CacheStorage.class.getDeclaredMethod("removeEldestEntry", Map.Entry.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = CacheStorage.class.getDeclaredMethod("maxSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = CacheStorage.class.getDeclaredMethod("getCacheSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = CacheStorage.class.getDeclaredMethod("incrementCacheSize", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = CacheStorage.class.getDeclaredMethod("removeResultsetCacheEntries", Long.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = CacheStorage.class.getDeclaredMethod("getResultsetCacheEntry", ResultSetCacheEntryKey.class, Long.TYPE, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    static final class ResultSetCacheState
    extends Enum<ResultSetCacheState> {
        public static final /* enum */ ResultSetCacheState INIT;
        public static final /* enum */ ResultSetCacheState STARTING;
        public static final /* enum */ ResultSetCacheState STARTED;
        public static final /* enum */ ResultSetCacheState STARTUP_FAILED;
        private static final /* synthetic */ ResultSetCacheState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ResultSetCacheState[] values() {
            return (ResultSetCacheState[])$VALUES.clone();
        }

        public static ResultSetCacheState valueOf(String name) {
            return Enum.valueOf(ResultSetCacheState.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = ResultSetCacheState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ResultSetCacheState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ResultSetCacheState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            INIT = new ResultSetCacheState();
            STARTING = new ResultSetCacheState();
            STARTED = new ResultSetCacheState();
            STARTUP_FAILED = new ResultSetCacheState();
            $VALUES = new ResultSetCacheState[]{INIT, STARTING, STARTED, STARTUP_FAILED};
        }
    }
}

