/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class LobCommonAccessor
extends Accessor {
    long[] prefetchedDataOffset;
    int[] prefetchedDataLength;
    long[] prefetchedLength;
    int[] prefetchedChunkSize;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    LobCommonAccessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean forBind) {
        super(_representation, _statement, _representationMaxLength, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$22, null, _representation, _statement, _representationMaxLength, forBind);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$22, null);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$22, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setNull(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void currentRow;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$0, this, n2, bl);
            }
            super.setNull((int)currentRow, (boolean)value);
            if (value != false && this.isPrefetched()) {
                this.prefetchedDataOffset[currentRow] = -1L;
                this.prefetchedDataLength[currentRow] = -1;
                this.prefetchedLength[currentRow] = -1L;
                this.prefetchedChunkSize[currentRow] = -1;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setCapacity(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void capacity;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$1, this, n2);
            }
            super.setCapacity((int)capacity);
            if (this.isPrefetched() && this.prefetchedDataOffset == null) {
                this.prefetchedDataOffset = new long[capacity];
                this.prefetchedDataLength = new int[capacity];
                this.prefetchedLength = new long[capacity];
                this.prefetchedChunkSize = new int[capacity];
            } else if (this.isPrefetched() && capacity > this.prefetchedDataOffset.length) {
                Object[] tmp = new long[capacity];
                System.arraycopy(this.prefetchedDataOffset, 0, tmp, 0, this.prefetchedDataOffset.length);
                this.prefetchedDataOffset = tmp;
                tmp = new int[capacity];
                System.arraycopy(this.prefetchedDataLength, 0, tmp, 0, this.prefetchedDataLength.length);
                this.prefetchedDataLength = (int[])tmp;
                tmp = new long[capacity];
                System.arraycopy(this.prefetchedLength, 0, tmp, 0, this.prefetchedLength.length);
                this.prefetchedLength = tmp;
                tmp = new int[capacity];
                System.arraycopy(this.prefetchedChunkSize, 0, tmp, 0, this.prefetchedChunkSize.length);
                this.prefetchedChunkSize = (int[])tmp;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void insertNull(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.isPrefetched()) {
                System.arraycopy(this.prefetchedDataOffset, (int)rowIndex, this.prefetchedDataOffset, (int)(rowIndex + true), this.prefetchedDataOffset.length - rowIndex - 1);
                System.arraycopy(this.prefetchedDataLength, (int)rowIndex, this.prefetchedDataLength, (int)(rowIndex + true), this.prefetchedDataLength.length - rowIndex - 1);
                System.arraycopy(this.prefetchedLength, (int)rowIndex, this.prefetchedLength, (int)(rowIndex + true), this.prefetchedLength.length - rowIndex - 1);
                System.arraycopy(this.prefetchedChunkSize, (int)rowIndex, this.prefetchedChunkSize, (int)(rowIndex + true), this.prefetchedChunkSize.length - rowIndex - 1);
            }
            super.insertNull((int)rowIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$3, this, oracleStatement);
            }
            LobCommonAccessor acc = (LobCommonAccessor)super.copyForDefine((OracleStatement)dest);
            acc.prefetchedDataOffset = null;
            acc.prefetchedDataLength = null;
            acc.prefetchedLength = null;
            acc.prefetchedChunkSize = null;
            LobCommonAccessor lobCommonAccessor = acc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$3, this, lobCommonAccessor);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$3, this, null);
            }
            return lobCommonAccessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void destRow;
            void srcRow;
            void srcAcc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$4, this, accessor, n2, n3);
            }
            super.copyFromInternal((Accessor)srcAcc, (int)srcRow, (int)destRow);
            if (this.isPrefetched()) {
                long destOff;
                LobCommonAccessor srcLobAcc = (LobCommonAccessor)srcAcc;
                if (!$assertionsDisabled && !srcLobAcc.isPrefetched()) {
                    AssertionError assertionError = new AssertionError((Object)"srcLobAcc is not prefetched");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$4, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                int srcLen = srcLobAcc.getPrefetchedDataLength((int)srcRow);
                long l2 = destOff = srcLen <= this.getPrefetchedDataLength((int)destRow) ? this.getPrefetchedDataOffset((int)destRow) : this.statement.allocateRowDataSpace(srcLen);
                if (srcLen > 0) {
                    this.rowData.put(destOff, srcLobAcc.rowData, srcLobAcc.getPrefetchedDataOffset((int)srcRow), srcLen);
                }
                this.setPrefetchedDataOffset((int)destRow, destOff);
                this.setPrefetchedDataLength((int)destRow, srcLen);
                this.setPrefetchedLength((int)destRow, srcLobAcc.getPrefetchedLength((int)srcRow));
                this.setPrefetchedChunkSize((int)destRow, srcLobAcc.getPrefetchedChunkSize((int)srcRow));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void deleteRow(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$5, this, n2);
            }
            super.deleteRow((int)row);
            if (this.isPrefetched()) {
                this.rowData.freeSpace(this.getPrefetchedDataOffset((int)row), this.getPrefetchedDataLength((int)row));
                this.delete(this.prefetchedDataOffset, (int)row);
                this.delete(this.prefetchedDataLength, (int)row);
                this.delete(this.prefetchedLength, (int)row);
                this.delete(this.prefetchedChunkSize, (int)row);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isPrefetched() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl3 = bl2 = !this.isDMLReturnedParam && this.lobPrefetchSizeForThisColumn > -1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$6, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void setNoPrefetch() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.lobPrefetchSizeForThisColumn = -1;
            this.prefetchedDataOffset = null;
            this.prefetchedDataLength = null;
            this.prefetchedLength = null;
            this.prefetchedChunkSize = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    final int getPrefetchLength() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            int n2 = this.lobPrefetchSizeForThisColumn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$8, this, n2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$8, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setPrefetchLength(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if (length == -1) {
                this.setNoPrefetch();
            } else {
                this.lobPrefetchSizeForThisColumn = length;
                if (this.rowNull != null) {
                    this.setCapacity(this.rowNull.length);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedDataOffset(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (!$assertionsDisabled && this.prefetchedDataOffset.length <= currentRow) {
                AssertionError assertionError = new AssertionError((Object)("prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + (int)currentRow));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$10, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.prefetchedDataOffset[currentRow] = this.rowData.getPosition();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedDataOffset(int n2, long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$11, this, n2, l2);
            }
            if (!$assertionsDisabled && this.prefetchedDataOffset.length <= currentRow) {
                AssertionError assertionError = new AssertionError((Object)("prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + (int)currentRow));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$11, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.prefetchedDataOffset[currentRow] = offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedDataLength(int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$12, this, n2, n3);
            }
            if (!$assertionsDisabled && this.prefetchedDataLength.length <= currentRow) {
                AssertionError assertionError = new AssertionError((Object)("prefetchedDataLength.length: " + this.prefetchedDataLength.length + " currentRow: " + (int)currentRow));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$12, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.prefetchedDataLength[currentRow] = length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedLength(int n2, long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void size;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$13, this, n2, l2);
            }
            if (!$assertionsDisabled && this.prefetchedLength.length <= currentRow) {
                AssertionError assertionError = new AssertionError((Object)("prefetchedLength.length: " + this.prefetchedLength.length + " currentRow: " + (int)currentRow));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$13, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.prefetchedLength[currentRow] = size;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void setPrefetchedChunkSize(int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void chunkSize;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$14, this, n2, n3);
            }
            if (!$assertionsDisabled && this.prefetchedChunkSize.length <= currentRow) {
                AssertionError assertionError = new AssertionError((Object)("prefetchedChunkSize.length: " + this.prefetchedChunkSize.length + " currentRow: " + (int)currentRow));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$14, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.prefetchedChunkSize[currentRow] = chunkSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final long getPrefetchedDataOffset(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$15, this, n2);
            }
            long l2 = this.prefetchedDataOffset[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$15, this, l2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$15, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int getPrefetchedDataLength(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$16, this, n2);
            }
            int n3 = this.prefetchedDataLength[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$16, this, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$16, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final long getPrefetchedLength(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$17, this, n2);
            }
            long l2 = this.prefetchedLength[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$17, this, l2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$17, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int getPrefetchedChunkSize(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$18, this, n2);
            }
            int n3 = this.prefetchedChunkSize[currentRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$18, this, n3);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$18, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final byte[] getPrefetchedData(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, n2);
            }
            if (this.getPrefetchLength() > -1) {
                void currentRow;
                if (this.getPrefetchedDataLength((int)currentRow) == 0) {
                    byte[] byArray = new byte[]{};
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, null);
                    }
                    return byArray;
                }
                byte[] byArray = this.rowData.get(this.getPrefetchedDataOffset((int)currentRow), this.getPrefetchedDataLength((int)currentRow));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, null);
                }
                return byArray;
            }
            byte[] byArray = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$20, this, n2);
            }
            Datum datum = this.getOracleObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$20, this, datum);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$20, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$21, this, n2, map);
            }
            Datum datum = this.getOracleObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$21, this, datum);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$21, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, LobCommonAccessor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$22 = LobCommonAccessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = LobCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = LobCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedChunkSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedDataLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedDataOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedChunkSize", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedLength", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataLength", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataOffset", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LobCommonAccessor.class.getDeclaredMethod("setNoPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LobCommonAccessor.class.getDeclaredMethod("isPrefetched", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LobCommonAccessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LobCommonAccessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LobCommonAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LobCommonAccessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LobCommonAccessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LobCommonAccessor.class.getDeclaredMethod("setNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

