/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;

public class TIMEZONETAB {
    private static int OFFSET_HOUR;
    private static int OFFSET_MINUTE;
    private static int HOUR_MILLISECOND;
    private static int MINUTE_MILLISECOND;
    private static int BYTE_SIZE;
    private final Hashtable zonetab = new Hashtable();
    private static Map<Integer, TIMEZONETAB> instanceCache;
    private int instanceCount = 0;
    private int versionNumber = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    private TIMEZONETAB(int _versionNumber) {
        this.versionNumber = _versionNumber;
    }

    public static TIMEZONETAB getInstance(int versionNumber) throws SQLException {
        TIMEZONETAB tzTab = instanceCache.computeIfAbsent(versionNumber, TIMEZONETAB::new);
        return tzTab.returnInstance();
    }

    private synchronized TIMEZONETAB returnInstance() {
        ++this.instanceCount;
        instanceCache.put(this.versionNumber, this);
        return this;
    }

    public synchronized void freeInstance() throws SQLException {
        --this.instanceCount;
        if (this.instanceCount < 1) {
            instanceCache.remove(this.versionNumber);
        }
    }

    public void addTrans(byte[] transarray, int regionID) {
        int[] result = new int[BYTE_SIZE];
        int num_trans = transarray[0] & 0xFF;
        OffsetDST[] trans = new OffsetDST[num_trans];
        int transIndex = 0;
        for (int i2 = 1; i2 < num_trans * BYTE_SIZE; i2 += BYTE_SIZE) {
            for (int j2 = 0; j2 < BYTE_SIZE; ++j2) {
                result[j2] = transarray[j2 + i2] & 0xFF;
            }
            int year = (result[0] - 100) * 100 + (result[1] - 100);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            cal.set(14, 0);
            long millis = cal.getTime().getTime();
            int offset = (result[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (result[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte dstflag = (byte)result[9];
            trans[transIndex++] = new OffsetDST(new Timestamp(millis), offset, dstflag);
        }
        this.zonetab.put(regionID & 0x1FF, trans);
    }

    public byte getLocalOffset(Calendar cal, int regionID, OffsetDST trans_data) throws SQLException {
        byte olap;
        block13: {
            byte isdst2;
            byte isdst1;
            boolean tempdate1 = false;
            boolean tempdate2 = false;
            olap = 0;
            Calendar tempCal1 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar tempCal2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar caltemp = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            caltemp.set(1, cal.get(1));
            caltemp.set(2, cal.get(2));
            caltemp.set(5, cal.get(5));
            caltemp.set(11, cal.get(11));
            caltemp.set(12, cal.get(12));
            caltemp.set(13, cal.get(13));
            caltemp.set(14, cal.get(14));
            Calendar auxCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            auxCal.set(1, caltemp.get(1));
            auxCal.set(2, caltemp.get(2));
            auxCal.set(5, 1);
            auxCal.set(11, 0);
            auxCal.set(12, 0);
            auxCal.set(13, 0);
            auxCal.set(14, 0);
            OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
            int i2 = this.findCloseMatch(localTrans, auxCal.getTimeInMillis());
            while (true) {
                tempCal1.setTime(localTrans[i2].getTimestamp());
                int offset1 = localTrans[i2].getOFFSET();
                tempCal1.add(10, offset1 / HOUR_MILLISECOND);
                tempCal1.add(12, offset1 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                isdst1 = localTrans[i2].getDSTFLAG();
                if (caltemp.equals(tempCal1)) {
                    trans_data.setOFFSET(localTrans[i2].getOFFSET());
                    trans_data.setDSTFLAG(localTrans[i2].getDSTFLAG());
                    olap = 0;
                    if (i2 > 0) {
                        isdst2 = localTrans[i2 - 1].getDSTFLAG();
                        if (isdst1 == 0 && isdst2 == 1) {
                            olap = 1;
                        }
                    }
                    break block13;
                }
                if (caltemp.before(tempCal1)) {
                    if (i2 == 0) {
                        trans_data.setOFFSET(0);
                        trans_data.setDSTFLAG((byte)0);
                        olap = 0;
                        if (isdst1 == 1) {
                            tempCal1.add(10, -1);
                            if (!caltemp.before(tempCal1)) {
                                throw new SQLException("Illegal local time.");
                            }
                        }
                        break block13;
                    }
                    if (--i2 < 0) continue;
                    isdst2 = localTrans[i2].getDSTFLAG();
                    if (isdst1 != 1 || isdst2 != 0) continue;
                    tempCal1.add(10, -1);
                    if (caltemp.before(tempCal1)) continue;
                    throw new SQLException("Illegal local time.");
                }
                if (i2 == localTrans.length - 1) break;
                tempCal2.setTime(localTrans[i2 + 1].getTimestamp());
                int offset2 = localTrans[i2 + 1].getOFFSET();
                tempCal2.add(10, offset2 / HOUR_MILLISECOND);
                tempCal2.add(12, offset2 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                if (caltemp.before(tempCal2)) break;
                ++i2;
            }
            trans_data.setOFFSET(localTrans[i2].getOFFSET());
            trans_data.setDSTFLAG(localTrans[i2].getDSTFLAG());
            olap = 0;
            if (isdst1 == 0) {
                if (i2 > 0 && (isdst2 = localTrans[i2 - 1].getDSTFLAG()) == 1) {
                    tempCal1.add(10, 1);
                    if (caltemp.before(tempCal1)) {
                        olap = 1;
                    }
                }
                if (i2 != localTrans.length - 1 && (isdst2 = localTrans[i2 + 1].getDSTFLAG()) == 1) {
                    tempCal2.add(10, -1);
                    if (!caltemp.before(tempCal2)) {
                        throw new SQLException("Illegal local time.");
                    }
                }
            }
        }
        return olap;
    }

    public int getOffset(Calendar cal, int regionID) throws SQLException {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        return this.getOffset(cal, localTrans);
    }

    public int getOffset(long millis, int regionID) throws SQLException {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        int index = this.findCloseMatch(localTrans, millis);
        return localTrans[index].getOFFSET();
    }

    public int getOffset(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getOFFSET();
    }

    public boolean isDST(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getDSTFLAG() == 1;
    }

    public OffsetDST[] getOffsetDST(int regionID) {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        return localTrans;
    }

    final int findCloseMatch(OffsetDST[] localTrans, long keyDate) {
        int mid;
        int max = localTrans.length;
        int min = 0;
        int mid2 = mid = max / 2;
        if (keyDate < localTrans[min].getTime()) {
            int n2;
            for (n2 = 0; localTrans[n2].getDSTFLAG() == 1 && n2 < localTrans.length; ++n2) {
            }
            return n2 < localTrans.length ? n2 : 0;
        }
        while (mid > 0) {
            if (keyDate > localTrans[mid].getTime()) {
                min = mid;
            } else if (keyDate < localTrans[mid].getTime()) {
                max = mid;
            } else if (mid == min) break;
            mid = min + (max - min) / 2;
            if (mid2 == mid) break;
            mid2 = mid;
        }
        return mid;
    }

    public void displayTable(int regionID) {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        if (localTrans == null) {
            return;
        }
        for (OffsetDST lOffset : localTrans) {
            System.out.print(lOffset.getTimestamp().toString());
            System.out.print("    " + lOffset.getOFFSET());
            System.out.println("    " + lOffset.getDSTFLAG());
        }
    }

    public boolean checkID(int regionID) {
        return this.zonetab.get(regionID & 0x1FF) == null;
    }

    public void updateTable(Connection conn, int regionID) throws SQLException, NullPointerException {
        byte[] transarray = TRANSDUMP.getTransitions(conn, regionID);
        if (transarray == null) {
            throw new NullPointerException();
        }
        this.addTrans(transarray, regionID);
    }

    static {
        try {
            $$$methodRef$$$14 = TIMEZONETAB.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TIMEZONETAB.class.getDeclaredMethod("updateTable", Connection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TIMEZONETAB.class.getDeclaredMethod("checkID", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TIMEZONETAB.class.getDeclaredMethod("displayTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TIMEZONETAB.class.getDeclaredMethod("findCloseMatch", OffsetDST[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TIMEZONETAB.class.getDeclaredMethod("getOffsetDST", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TIMEZONETAB.class.getDeclaredMethod("isDST", Calendar.class, OffsetDST[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TIMEZONETAB.class.getDeclaredMethod("getOffset", Calendar.class, OffsetDST[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TIMEZONETAB.class.getDeclaredMethod("getOffset", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TIMEZONETAB.class.getDeclaredMethod("getOffset", Calendar.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TIMEZONETAB.class.getDeclaredMethod("getLocalOffset", Calendar.class, Integer.TYPE, OffsetDST.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TIMEZONETAB.class.getDeclaredMethod("addTrans", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TIMEZONETAB.class.getDeclaredMethod("freeInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TIMEZONETAB.class.getDeclaredMethod("returnInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TIMEZONETAB.class.getDeclaredMethod("getInstance", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        HOUR_MILLISECOND = 3600000;
        MINUTE_MILLISECOND = 60000;
        BYTE_SIZE = 10;
        instanceCache = new ConcurrentHashMap<Integer, TIMEZONETAB>(5);
    }
}

