/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.TimeoutSocketChannel;
import oracle.net.nt.WSSSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    String matchSSLServerCertDNWith;
    boolean fullDNMatch;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SocketChannel underlyingSocketChannel = null;
    InetAddress[] inetAddresses = null;
    int count;
    int attempts;
    SSLSocket socketWithListener;
    SSLEngine l_sslEngine;
    boolean useNio;
    private String httpProxy;
    private int httpProxyPort;
    private String websocketURI = "/sqlnet";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public TcpsNTAdapter(String address, Properties socketOptions) throws NLException {
        super(address, socketOptions);
        NVPair nvpWebSockUri;
        NVPair nvpHttpProxy = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY");
        NVPair nvpHttpProxyPort = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY_PORT");
        if (nvpHttpProxy != null) {
            this.httpProxy = nvpHttpProxy.getAtom();
            if (nvpHttpProxyPort != null) {
                this.httpProxyPort = Integer.parseInt(nvpHttpProxyPort.getAtom());
            }
        }
        if ((nvpWebSockUri = this.nav.findNVPair(this.nvpAddr, "WEBSOCK_URI")) != null) {
            this.websocketURI = nvpWebSockUri.getAtom();
        }
    }

    @Override
    public void connect() throws IOException {
        this.useNio = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!this.useNio) {
            this.l_sslSockFac = CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions);
            this.underlyingSocket = new Socket();
        } else {
            this.l_sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(this.host, this.port, this.socketOptions);
        }
        String c_timeout = (String)this.socketOptions.get(2);
        int connectTimeout = c_timeout == null ? 0 : Integer.parseInt(c_timeout);
        boolean forceDNSLoadBalancing = Boolean.parseBoolean((String)this.socketOptions.get(18));
        if (this.inetAddresses == null) {
            this.inetAddresses = InetAddress.getAllByName(this.host);
            if (forceDNSLoadBalancing && this.inetAddresses.length > 1) {
                this.inetAddresses = TcpsNTAdapter.getAddressesInCircularOrder(this.host, this.inetAddresses);
            }
            DownHostsCache.getInstance().reorderAddresses(this.inetAddresses, this.port);
            this.attempts = this.inetAddresses.length;
            this.count = 0;
        }
        do {
            InetAddress inet = this.inetAddresses[this.count];
            InetSocketAddress sockAddress = new InetSocketAddress(inet, this.port);
            ++this.count;
            --this.attempts;
            InetSocketAddress httpProxyAddress = null;
            if (this.httpProxy != null) {
                httpProxyAddress = new InetSocketAddress(this.httpProxy, this.httpProxyPort);
            }
            long socketConnectStartTime = System.currentTimeMillis();
            this.underlyingSocket = new Socket();
            try {
                if (!this.useNio) {
                    this.underlyingSocket.connect(sockAddress, connectTimeout);
                } else {
                    this.netStat = new NetStatImpl();
                    this.underlyingSocketChannel = new TimeoutSocketChannel(new InetSocketAddress(inet, this.port), connectTimeout, this.netStat, httpProxyAddress);
                    this.underlyingSocket = this.underlyingSocketChannel.socket();
                }
                if (!this.useNio) {
                    this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
                } else {
                    this.socketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine);
                    this.socket = this.socketChannel.socket();
                }
                String temp = (String)this.socketOptions.get(3);
                if (temp != null) {
                    this.setOption(3, temp);
                }
                this.setSSLSocketOptions();
                if (!this.useNio || this.protocol == null || !this.protocol.equalsIgnoreCase("wss")) break;
                String httpAuthUser = (String)this.socketOptions.get(26);
                String httpAuthPwd = (String)this.socketOptions.get(27);
                this.socketChannel = new WSSSocketChannel(this.socketChannel, this.websocketURI, this.host, this.port, httpAuthUser, httpAuthPwd);
                break;
            }
            catch (IOException eio) {
                DownHostsCache.getInstance().markDownHost(inet, this.port);
                try {
                    if (this.underlyingSocket != null) {
                        this.underlyingSocket.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception httpAuthPwd) {
                    // empty catch block
                }
                if (this.attempts > 0) continue;
                this.resetInetAddress();
                String newExMessage = String.format("%s, socket connect lapse %d ms. %s %d %s %d", eio.getMessage(), System.currentTimeMillis() - socketConnectStartTime, inet.toString(), this.port, c_timeout, this.count);
                IOException newEx = new IOException(newExMessage, eio);
                throw newEx;
            }
            catch (NumberFormatException ex) {
                throw new NetException(505);
            }
        } while (this.count < this.inetAddresses.length);
    }

    @Override
    public boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.count < this.inetAddresses.length;
    }

    @Override
    public void resetInetAddress() {
        this.inetAddresses = null;
    }

    public void renegotiateSession() throws IOException {
        if (this.useNio) {
            this.l_sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(this.host, this.port, this.socketOptions);
            SSLSocketChannel newSSLSocketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine);
            if (this.protocol.equalsIgnoreCase("wss")) {
                this.socketChannel.setUnderlyingChannel(newSSLSocketChannel);
            } else {
                this.socketChannel = newSSLSocketChannel;
            }
            this.socket = this.socketChannel.socket();
        } else {
            this.socketWithListener = (SSLSocket)this.socket;
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
        }
        String temp = (String)this.socketOptions.get(3);
        if (temp != null) {
            this.setOption(3, temp);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sslSocket = null;
        if (!this.useNio) {
            sslSocket = (SSLSocket)this.socket;
            sslSocket.setUseClientMode(true);
        }
        TcpsConfigure.configureVersion(sslSocket, this.l_sslEngine, (String)this.socketOptions.get(6), this.useNio);
        TcpsConfigure.configureCipherSuites(sslSocket, this.l_sslEngine, (String)this.socketOptions.get(7), this.useNio);
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        switch (option) {
            case 108: {
                this.setServerDNMatchValue((String[])value);
                break;
            }
            case 107: {
                if (((String)value).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(option, value);
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        SSLSocket sslSocket = null;
        SSLSession session = null;
        if (!this.useNio) {
            sslSocket = (SSLSocket)this.socket;
            session = sslSocket.getSession();
        } else {
            session = this.l_sslEngine.getSession();
        }
        switch (option) {
            case 102: {
                String cipherSuiteInUse = session.getCipherSuite();
                if (cipherSuiteInUse != null && cipherSuiteInUse.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return session.getCipherSuite();
            }
            case 103: {
                X509Certificate l_certificate = (X509Certificate)session.getPeerCertificates()[0];
                return l_certificate.getSubjectDN().getName();
            }
            case 104: {
                return session.getPeerCertificateChain();
            }
            case 106: {
                String sslServerDNMatchRequiredString = (String)this.socketOptions.get(4);
                if (sslServerDNMatchRequiredString == null) {
                    sslServerDNMatchRequiredString = System.getProperty("oracle.net.ssl_server_dn_match", "false");
                }
                if (sslServerDNMatchRequiredString.equalsIgnoreCase("YES") || sslServerDNMatchRequiredString.equalsIgnoreCase("ON") || sslServerDNMatchRequiredString.equalsIgnoreCase("TRUE")) {
                    X509Certificate peerCertificate = (X509Certificate)session.getPeerCertificates()[0];
                    String serverCertDN = peerCertificate.getSubjectDN().getName();
                    if (TcpsConfigure.matchServerDN(peerCertificate, this.matchSSLServerCertDNWith, this.fullDNMatch, this.host)) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "TRUE";
            }
        }
        return super.getOption(option);
    }

    public void setServerDNMatchValue(String[] value) {
        String origSSLServerCertDN = value[0];
        String origServiceName = value[1];
        String origSid = value[2];
        if (origSSLServerCertDN != null) {
            this.matchSSLServerCertDNWith = origSSLServerCertDN;
            this.fullDNMatch = true;
        } else if (origServiceName != null) {
            this.matchSSLServerCertDNWith = origServiceName.indexOf(46) != -1 ? "CN=" + origServiceName.substring(0, origServiceName.indexOf(46)) : "CN=" + origServiceName.trim();
        } else if (origSid != null) {
            this.matchSSLServerCertDNWith = origSid.indexOf(46) != -1 ? "CN=" + origSid.substring(0, origSid.indexOf(46)) : "CN=" + origSid.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }

    static {
        try {
            $$$methodRef$$$9 = TcpsNTAdapter.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpsNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpsNTAdapter.class.getDeclaredMethod("setServerDNMatchValue", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpsNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpsNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpsNTAdapter.class.getDeclaredMethod("setSSLSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpsNTAdapter.class.getDeclaredMethod("renegotiateSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsNTAdapter.class.getDeclaredMethod("connect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

