/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OraclePooledConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleConnectionPoolDataSource
extends OracleDataSource
implements oracle.jdbc.datasource.OracleConnectionPoolDataSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public OracleConnectionPoolDataSource() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$8, null, new Object[0]);
            }
            this.dataSourceName = "OracleConnectionPoolDataSource";
            this.isOracleDataSource = false;
            this.connCachingEnabled = false;
            this.fastConnFailover = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$0, this, new Object[0]);
            }
            String localUser = null;
            String localPassword = null;
            OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
            synchronized (oracleConnectionPoolDataSource) {
                try {
                    localUser = this.user;
                    localPassword = this.password != null ? this.password.get() : null;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_4
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$0, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            PooledConnection pooledConnection = this.getPooledConnection(localUser, localPassword);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$0, this, pooledConnection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$0, this, null);
            }
            return pooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$0, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            String _passwd;
            void _user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$1, this, string, "*****");
            }
            Connection conn = this.getPhysicalConnection((String)_user, _passwd);
            OraclePooledConnection opc = new OraclePooledConnection(conn);
            if (_passwd == null) {
                _passwd = this.password != null ? this.password.get() : null;
            }
            opc.setUserName((String)(this.user != null && !_user.startsWith("\"") ? _user.toLowerCase() : _user), _passwd);
            OraclePooledConnection oraclePooledConnection = opc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$1, this, oraclePooledConnection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$1, this, null);
            }
            return oraclePooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    PooledConnection getPooledConnection(Properties properties) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            String _passwd;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$2, this, properties);
            }
            Connection conn = this.getPhysicalConnection((Properties)prop, null);
            OraclePooledConnection opc = new OraclePooledConnection(conn);
            String _user = prop.getProperty("user");
            if (_user == null) {
                _user = ((OracleConnection)conn).getUserName();
            }
            if ((_passwd = prop.getProperty("password")) == null) {
                _passwd = this.password != null ? this.password.get() : null;
            }
            opc.setUserName(this.user != null && !_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd);
            OraclePooledConnection oraclePooledConnection = opc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$2, this, oraclePooledConnection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$2, this, null);
            }
            return oraclePooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    protected Connection getPhysicalConnection() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Connection connection = super.getConnection(this.user, this.password != null ? this.password.get() : null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$3, this, connection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$3, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getPhysicalConnection(String string, String string2, @Blind String string3) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _passwd;
            void _user;
            void _url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$4, this, string, string2, "*****");
            }
            this.url = _url;
            Connection connection = super.getConnection((String)_user, (String)_passwd);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$4, this, connection);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$4, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getPhysicalConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _passwd;
            void _user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$5, this, string, "*****");
            }
            Connection connection = super.getConnection((String)_user, (String)_passwd);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$5, this, connection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$5, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            String _passwd;
            void connBuilder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$6, this, oracleConnectionBuilderImpl);
            }
            Connection conn = super.getConnection((OracleConnectionBuilderImpl)connBuilder);
            OraclePooledConnection opc = new OraclePooledConnection(conn);
            String _user = connBuilder.getUser();
            if (_user == null) {
                _user = ((OracleConnection)conn).getUserName();
            }
            if ((_passwd = connBuilder.getPassword()) == null) {
                _passwd = this.password != null ? this.password.get() : null;
            }
            opc.setUserName(this.user != null && !_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd);
            OraclePooledConnection oraclePooledConnection = opc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$6, this, oraclePooledConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$6, this, null);
            }
            return oraclePooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OraclePooledConnectionBuilderImpl oraclePooledConnectionBuilderImpl = new OraclePooledConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public oracle.jdbc.datasource.OraclePooledConnection build() throws SQLException {
                    OracleConnectionBuilderImpl connBldr = OracleConnectionPoolDataSource.this.createConnectionBuilder().user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
                    if (this.gssCredential != null) {
                        connBldr = connBldr.gssCredential(this.gssCredential);
                    }
                    if (connBldr.getGSSCredential() != null && (connBldr.getUser() != null || connBldr.getPassword() != null)) {
                        throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                    }
                    return OracleConnectionPoolDataSource.this.getPooledConnection(connBldr);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleConnectionPoolDataSource.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$7, this, oraclePooledConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$7, this, null);
            }
            return oraclePooledConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConnectionPoolDataSource.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = OracleConnectionPoolDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConnectionPoolDataSource.class.getDeclaredMethod("createPooledConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

