/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.FDBigInt;
import oracle.jdbc.driver.VarnumCopyingBinder;
import oracle.sql.NUMBER;

abstract class VarnumBinder
extends Binder {
    static final boolean DEBUG = false;
    static final boolean SLOW_CONVERSIONS = true;
    Binder theVarnumCopyingBinder = null;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final int LNXEXPMX = 127;
    static final double[] factorTable;
    static final int MANTISSA_SIZE = 53;
    static final int expShift = 52;
    static final long fractHOB = 0x10000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expBias = 1023;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final long expOne = 0x3FF0000000000000L;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int[] small5pow;
    static final long[] long5pow;
    static final int[] n5bits;
    static volatile FDBigInt[] b5p;
    private static final Object m5Pow;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    static void init(Binder x2) {
        x2.type = (short)6;
        x2.bytelen = 22;
    }

    VarnumBinder() {
        VarnumBinder.init(this);
    }

    @Override
    Binder copyingBinder() {
        if (this.theVarnumCopyingBinder == null) {
            this.theVarnumCopyingBinder = new VarnumCopyingBinder();
        }
        return this.theVarnumCopyingBinder;
    }

    static int setLongInternal(byte[] b2, int offset, long val) {
        return NUMBER.toBytes(val, b2, offset);
    }

    static int countBits(long v2) {
        if (v2 == 0L) {
            return 0;
        }
        while ((v2 & 0xFF00000000000000L) == 0L) {
            v2 <<= 8;
        }
        while (v2 > 0L) {
            v2 <<= 1;
        }
        int n2 = 0;
        while ((v2 & 0xFFFFFFFFFFFFFFL) != 0L) {
            v2 <<= 8;
            n2 += 8;
        }
        while (v2 != 0L) {
            v2 <<= 1;
            ++n2;
        }
        return n2;
    }

    boolean roundup(char[] digits, int nDigits) {
        int i2 = nDigits - 1;
        char q2 = digits[i2];
        if (q2 == '9') {
            while (q2 == '9' && i2 > 0) {
                digits[i2] = 48;
                q2 = digits[--i2];
            }
            if (q2 == '9') {
                digits[0] = 49;
                return true;
            }
        }
        digits[i2] = (char)(q2 + '\u0001');
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FDBigInt big5pow(int p2) {
        if (p2 < 0) {
            throw new RuntimeException("Assertion botch: negative power of 5");
        }
        if (b5p != null && b5p.length > p2 && b5p[p2] != null) {
            return b5p[p2];
        }
        Object object = m5Pow;
        synchronized (object) {
            if (b5p != null && b5p.length > p2 && b5p[p2] != null) {
                return b5p[p2];
            }
            if (b5p == null) {
                b5p = new FDBigInt[p2 + 1];
            } else if (b5p.length <= p2) {
                FDBigInt[] t2 = new FDBigInt[p2 + 1];
                System.arraycopy(b5p, 0, t2, 0, b5p.length);
                b5p = t2;
            }
            if (b5p[p2] != null) {
                return b5p[p2];
            }
            if (p2 < small5pow.length) {
                VarnumBinder.b5p[p2] = new FDBigInt(small5pow[p2]);
                return VarnumBinder.b5p[p2];
            }
            if (p2 < long5pow.length) {
                VarnumBinder.b5p[p2] = new FDBigInt(long5pow[p2]);
                return VarnumBinder.b5p[p2];
            }
            int q2 = p2 >> 1;
            int r2 = p2 - q2;
            FDBigInt bigq = b5p[q2];
            if (bigq == null) {
                bigq = VarnumBinder.big5pow(q2);
            }
            if (r2 < small5pow.length) {
                VarnumBinder.b5p[p2] = bigq.mult(small5pow[r2]);
                return VarnumBinder.b5p[p2];
            }
            FDBigInt bigr = b5p[r2];
            if (bigr == null) {
                bigr = VarnumBinder.big5pow(r2);
            }
            VarnumBinder.b5p[p2] = bigq.mult(bigr);
            return VarnumBinder.b5p[p2];
        }
    }

    static FDBigInt multPow52(FDBigInt v2, int p5, int p2) {
        if (p5 != 0) {
            v2 = p5 < small5pow.length ? v2.mult(small5pow[p5]) : v2.mult(VarnumBinder.big5pow(p5));
        }
        if (p2 != 0) {
            v2.lshiftMe(p2);
        }
        return v2;
    }

    static FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v2 = new FDBigInt(VarnumBinder.big5pow(p5));
        if (p2 != 0) {
            v2.lshiftMe(p2);
        }
        return v2;
    }

    int dtoa(byte[] b2, int offset, double val, boolean neg, boolean forFloat, char[] digits, int binExp, long fractBits, int nSignificantBits) {
        int exp100;
        boolean oddExp;
        int decExponent = Integer.MAX_VALUE;
        int nDigits = -1;
        int nFractBits = VarnumBinder.countBits(fractBits);
        int nTinyBits = nFractBits - binExp - 1;
        boolean done = false;
        if (nTinyBits < 0) {
            nTinyBits = 0;
        }
        if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
            int c2;
            int digitno;
            int ndigits;
            long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
            fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
            decExponent = 0;
            long lvalue = fractBits;
            long insignificant = halfULP;
            int i2 = 0;
            while (insignificant >= 10L) {
                insignificant /= 10L;
                ++i2;
            }
            if (i2 != 0) {
                long pow10 = long5pow[i2] << i2;
                long residue = lvalue % pow10;
                lvalue /= pow10;
                decExponent += i2;
                if (residue >= pow10 >> 1) {
                    ++lvalue;
                }
            }
            if (lvalue <= Integer.MAX_VALUE) {
                int ivalue = (int)lvalue;
                ndigits = 10;
                digitno = ndigits - 1;
                c2 = ivalue % 10;
                ivalue /= 10;
                while (c2 == 0) {
                    ++decExponent;
                    c2 = ivalue % 10;
                    ivalue /= 10;
                }
                while (ivalue != 0) {
                    digits[digitno--] = (char)(c2 + 48);
                    ++decExponent;
                    c2 = ivalue % 10;
                    ivalue /= 10;
                }
                digits[digitno] = (char)(c2 + 48);
            } else {
                ndigits = 20;
                digitno = ndigits - 1;
                c2 = (int)(lvalue % 10L);
                lvalue /= 10L;
                while (c2 == 0) {
                    ++decExponent;
                    c2 = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                while (lvalue != 0L) {
                    digits[digitno--] = (char)(c2 + 48);
                    ++decExponent;
                    c2 = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                digits[digitno] = (char)(c2 + 48);
            }
            ndigits -= digitno;
            if (digitno != 0) {
                System.arraycopy(digits, digitno, digits, 0, ndigits);
            }
            ++decExponent;
            nDigits = ndigits;
            done = true;
        }
        if (!done) {
            long lowDigitDifference;
            boolean high;
            boolean low;
            int q2;
            double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
            int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
            int B5 = Math.max(0, -decExp);
            int B2 = B5 + nTinyBits + binExp;
            int S5 = Math.max(0, decExp);
            int S2 = S5 + nTinyBits;
            int M5 = B5;
            int M2 = B2 - nSignificantBits;
            fractBits >>>= 53 - nFractBits;
            int common2factor = Math.min(B2 -= nFractBits - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (nFractBits == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            int ndigit = 0;
            int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
            int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
            if (Bbits < 64 && tenSbits < 64) {
                if (Bbits < 32 && tenSbits < 32) {
                    int bi = (int)fractBits * small5pow[B5] << B2;
                    int s2 = small5pow[S5] << S2;
                    int m2 = small5pow[M5] << M2;
                    int tens = s2 * 10;
                    ndigit = 0;
                    q2 = bi / s2;
                    low = (bi = 10 * (bi % s2)) < (m2 *= 10);
                    boolean bl = high = bi + m2 > tens;
                    if (q2 == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q2);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q2 = bi / s2;
                        bi = 10 * (bi % s2);
                        if ((long)(m2 *= 10) > 0L) {
                            low = bi < m2;
                            high = bi + m2 > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q2);
                    }
                    lowDigitDifference = (bi << 1) - tens;
                } else {
                    long bl = fractBits * long5pow[B5] << B2;
                    long s3 = long5pow[S5] << S2;
                    long m3 = long5pow[M5] << M2;
                    long tens = s3 * 10L;
                    ndigit = 0;
                    q2 = (int)(bl / s3);
                    low = (bl = 10L * (bl % s3)) < (m3 *= 10L);
                    boolean bl2 = high = bl + m3 > tens;
                    if (q2 == 0 && !high) {
                        --decExp;
                    } else {
                        digits[ndigit++] = (char)(48 + q2);
                    }
                    if (decExp <= -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q2 = (int)(bl / s3);
                        bl = 10L * (bl % s3);
                        if ((m3 *= 10L) > 0L) {
                            low = bl < m3;
                            high = bl + m3 > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[ndigit++] = (char)(48 + q2);
                    }
                    lowDigitDifference = (bl << 1) - tens;
                }
            } else {
                FDBigInt Bval = VarnumBinder.multPow52(new FDBigInt(fractBits), B5, B2);
                FDBigInt Sval = VarnumBinder.constructPow52(S5, S2);
                FDBigInt Mval = VarnumBinder.constructPow52(M5, M2);
                int shiftBias = Sval.normalizeMe();
                Bval.lshiftMe(shiftBias);
                Mval.lshiftMe(shiftBias);
                FDBigInt tenSval = Sval.mult(10);
                ndigit = 0;
                q2 = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                low = Bval.cmp(Mval) < 0;
                boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
                if (q2 == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q2);
                }
                if (decExp <= -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q2 = Bval.quoRemIteration(Sval);
                    low = Bval.cmp(Mval = Mval.mult(10)) < 0;
                    high = Bval.add(Mval).cmp(tenSval) > 0;
                    digits[ndigit++] = (char)(48 + q2);
                }
                if (high && low) {
                    Bval.lshiftMe(1);
                    lowDigitDifference = Bval.cmp(tenSval);
                } else {
                    lowDigitDifference = 0L;
                }
            }
            decExponent = decExp + 1;
            nDigits = ndigit;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((digits[nDigits - 1] & '\u0001') != 0 && this.roundup(digits, nDigits)) {
                            ++decExponent;
                        }
                    } else if (lowDigitDifference > 0L && this.roundup(digits, nDigits)) {
                        ++decExponent;
                    }
                } else if (this.roundup(digits, nDigits)) {
                    ++decExponent;
                }
            }
        }
        while (nDigits - decExponent > 0 && digits[nDigits - 1] == '0') {
            --nDigits;
        }
        boolean bl = oddExp = decExponent % 2 != 0;
        if (oddExp) {
            if (nDigits % 2 == 0) {
                digits[nDigits++] = 48;
            }
            exp100 = (decExponent - 1) / 2;
        } else {
            if (nDigits % 2 == 1) {
                digits[nDigits++] = 48;
            }
            exp100 = (decExponent - 2) / 2;
        }
        int expola = 117 - exp100;
        int digidx = 0;
        int len = 1;
        if (neg) {
            b2[offset] = (byte)(62 - exp100);
            if (oddExp) {
                b2[offset + len] = (byte)(101 - (digits[digidx++] - 48));
                ++len;
            }
            while (digidx < nDigits) {
                b2[offset + len] = (byte)(101 - ((digits[digidx] - 48) * 10 + (digits[digidx + 1] - 48)));
                digidx += 2;
                ++len;
            }
            b2[offset + len++] = 102;
        } else {
            b2[offset] = (byte)(192 + (exp100 + 1));
            if (oddExp) {
                b2[offset + len] = (byte)(digits[digidx++] - 48 + 1);
                ++len;
            }
            while (digidx < nDigits) {
                b2[offset + len] = (byte)((digits[digidx] - 48) * 10 + (digits[digidx + 1] - 48) + 1);
                digidx += 2;
                ++len;
            }
        }
        return len;
    }

    static {
        try {
            $$$methodRef$$$9 = VarnumBinder.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = VarnumBinder.class.getDeclaredMethod("dtoa", byte[].class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, char[].class, Integer.TYPE, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = VarnumBinder.class.getDeclaredMethod("constructPow52", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = VarnumBinder.class.getDeclaredMethod("multPow52", FDBigInt.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = VarnumBinder.class.getDeclaredMethod("big5pow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = VarnumBinder.class.getDeclaredMethod("roundup", char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = VarnumBinder.class.getDeclaredMethod("countBits", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = VarnumBinder.class.getDeclaredMethod("setLongInternal", byte[].class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = VarnumBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = VarnumBinder.class.getDeclaredMethod("init", Binder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        factorTable = new double[]{1.0E254, 1.0E252, 1.0E250, 1.0E248, 1.0E246, 1.0E244, 1.0E242, 1.0E240, 1.0E238, 1.0E236, 1.0E234, 1.0E232, 1.0E230, 1.0E228, 1.0E226, 1.0E224, 1.0E222, 1.0E220, 1.0E218, 1.0E216, 1.0E214, 1.0E212, 1.0E210, 1.0E208, 1.0E206, 1.0E204, 1.0E202, 1.0E200, 1.0E198, 1.0E196, 1.0E194, 1.0E192, 1.0E190, 1.0E188, 1.0E186, 1.0E184, 1.0E182, 1.0E180, 1.0E178, 1.0E176, 1.0E174, 1.0E172, 1.0E170, 1.0E168, 1.0E166, 1.0E164, 1.0E162, 1.0E160, 1.0E158, 1.0E156, 1.0E154, 1.0E152, 1.0E150, 1.0E148, 1.0E146, 1.0E144, 1.0E142, 1.0E140, 1.0E138, 1.0E136, 1.0E134, 1.0E132, 1.0E130, 1.0E128, 1.0E126, 1.0E124, 1.0E122, 1.0E120, 1.0E118, 1.0E116, 1.0E114, 1.0E112, 1.0E110, 1.0E108, 1.0E106, 1.0E104, 1.0E102, 1.0E100, 1.0E98, 1.0E96, 1.0E94, 1.0E92, 1.0E90, 1.0E88, 1.0E86, 1.0E84, 1.0E82, 1.0E80, 1.0E78, 1.0E76, 1.0E74, 1.0E72, 1.0E70, 1.0E68, 1.0E66, 1.0E64, 1.0E62, 1.0E60, 1.0E58, 1.0E56, 1.0E54, 1.0E52, 1.0E50, 1.0E48, 1.0E46, 1.0E44, 1.0E42, 1.0E40, 1.0E38, 1.0E36, 1.0E34, 1.0E32, 1.0E30, 1.0E28, 1.0E26, 1.0E24, 1.0E22, 1.0E20, 1.0E18, 1.0E16, 1.0E14, 1.0E12, 1.0E10, 1.0E8, 1000000.0, 10000.0, 100.0, 1.0, 0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 1.0E-26, 1.0E-28, 1.0E-30, 1.0E-32, 1.0E-34, 1.0E-36, 1.0E-38, 1.0E-40, 1.0E-42, 1.0E-44, 1.0E-46, 1.0E-48, 1.0E-50, 1.0E-52, 1.0E-54, 1.0E-56, 1.0E-58, 1.0E-60, 1.0E-62, 1.0E-64, 1.0E-66, 1.0E-68, 1.0E-70, 1.0E-72, 1.0E-74, 1.0E-76, 1.0E-78, 1.0E-80, 1.0E-82, 1.0E-84, 1.0E-86, 1.0E-88, 1.0E-90, 1.0E-92, 1.0E-94, 1.0E-96, 1.0E-98, 1.0E-100, 1.0E-102, 1.0E-104, 1.0E-106, 1.0E-108, 1.0E-110, 1.0E-112, 1.0E-114, 1.0E-116, 1.0E-118, 1.0E-120, 1.0E-122, 1.0E-124, 1.0E-126, 1.0E-128, 1.0E-130, 1.0E-132, 1.0E-134, 1.0E-136, 1.0E-138, 1.0E-140, 1.0E-142, 1.0E-144, 1.0E-146, 1.0E-148, 1.0E-150, 1.0E-152, 1.0E-154, 1.0E-156, 1.0E-158, 1.0E-160, 1.0E-162, 1.0E-164, 1.0E-166, 1.0E-168, 1.0E-170, 1.0E-172, 1.0E-174, 1.0E-176, 1.0E-178, 1.0E-180, 1.0E-182, 1.0E-184, 1.0E-186, 1.0E-188, 1.0E-190, 1.0E-192, 1.0E-194, 1.0E-196, 1.0E-198, 1.0E-200, 1.0E-202, 1.0E-204, 1.0E-206, 1.0E-208, 1.0E-210, 1.0E-212, 1.0E-214, 1.0E-216, 1.0E-218, 1.0E-220, 1.0E-222, 1.0E-224, 1.0E-226, 1.0E-228, 1.0E-230, 1.0E-232, 1.0E-234, 1.0E-236, 1.0E-238, 1.0E-240, 1.0E-242, 1.0E-244, 1.0E-246, 1.0E-248, 1.0E-250, 1.0E-252, 1.0E-254};
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        m5Pow = new Object();
    }
}

