/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.TIMESTAMPLTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTimestampltzAccessor
extends TimestampltzAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    T4CTimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$11, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.underlyingLongRaw = false;
            this.mare = _mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CTimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$12, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.underlyingLongRaw = false;
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean isStream = false;
            if (!this.isUseless()) {
                if (this.isUnexpected()) {
                    long pos = this.rowData.getPosition();
                    this.unmarshalColumnMetadata();
                    this.unmarshalBytes();
                    this.rowData.setPosition(pos);
                    this.setNull(this.lastRowProcessed, true);
                } else if (this.isNullByDescribe()) {
                    this.setNull(this.lastRowProcessed, true);
                    this.unmarshalColumnMetadata();
                    if (this.statement.connection.versionNumber < 9200) {
                        this.processIndicator(0);
                    }
                } else {
                    this.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes();
                }
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            boolean bl2 = isStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.setOffset(this.lastRowProcessed);
            int len = this.statement.maxFieldSize > 0 ? ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize) : ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.processIndicator(len);
            this.setLength(this.lastRowProcessed, len);
            this.setNull(this.lastRowProcessed, len == 0);
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$6, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                if (this.previousRowProcessed == -1) {
                    this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
                }
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
                this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
            } else {
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void zone;
            void am2;
            void nanos;
            void sec;
            void min;
            void hour;
            void day;
            void month;
            void year;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, n2, n3, n4, n5, n6, n7, n8, bl, string);
            }
            if (this.definedColumnType == 0 || this.definedColumnType == -102) {
                String string2 = super.toText((int)year, (int)month, (int)day, (int)hour, (int)min, (int)sec, (int)nanos, (boolean)am2, (String)zone);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, string2);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, null);
                }
                return string2;
            }
            String format = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM");
            String string3 = T4CTimestampltzAccessor.nlsFormatToText((int)year, (int)month, (int)day, (int)hour, (int)min, (int)sec, (int)nanos, (boolean)am2, (String)zone, format);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, string3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String nlsFormatToText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string, String string2) throws SQLException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int year;
            void format;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$9, null, n2, n3, n4, n5, n6, n7, n8, bl, string, string2);
            }
            char[] fChars = ((String)format + "      ").toCharArray();
            int fLength = format.length();
            StringBuffer sb = new StringBuffer(fLength + 25);
            String[] sMonths = null;
            String[] lMonths = null;
            TimeZone tz = null;
            int normYear = year < 0 ? Math.abs(year) + 1 : year;
            boolean bJulianBC = false;
            block15: for (int i2 = 0; i2 < fLength; ++i2) {
                switch (fChars[i2]) {
                    case 'R': 
                    case 'r': {
                        if (fChars[i2 + 1] != 'R' && fChars[i2 + 1] != 'r') continue block15;
                        if (!(fChars[i2 + 2] != 'R' && fChars[i2 + 2] != 'r' || fChars[i2 + 3] != 'R' && fChars[i2 + 3] != 'r')) {
                            if (normYear < 1000) {
                                sb.append("0" + normYear);
                            } else if (normYear < 100) {
                                sb.append("00" + normYear);
                            } else if (normYear < 10) {
                                sb.append("000" + normYear);
                            } else {
                                sb.append(normYear);
                            }
                            i2 += 3;
                            continue block15;
                        }
                        if (normYear >= 100) {
                            normYear %= 100;
                        }
                        if (normYear < 10) {
                            sb.append("0" + normYear);
                        } else {
                            sb.append(normYear);
                        }
                        ++i2;
                        continue block15;
                    }
                    case 'Y': 
                    case 'y': {
                        if (fChars[i2 + 1] != 'Y' && fChars[i2 + 1] != 'y') continue block15;
                        if (!(fChars[i2 + 2] != 'Y' && fChars[i2 + 2] != 'y' || fChars[i2 + 3] != 'Y' && fChars[i2 + 3] != 'y')) {
                            int localYear;
                            int n9 = localYear = year < 0 && bJulianBC ? Math.abs(year) : normYear;
                            if (localYear < 1000) {
                                sb.append("0" + localYear);
                            } else if (localYear < 100) {
                                sb.append("00" + localYear);
                            } else if (localYear < 10) {
                                sb.append("000" + localYear);
                            } else {
                                sb.append(localYear);
                            }
                            i2 += 3;
                            continue block15;
                        }
                        if (normYear >= 100) {
                            normYear %= 100;
                        }
                        if (normYear < 10) {
                            sb.append("0" + normYear);
                        } else {
                            sb.append(normYear);
                        }
                        ++i2;
                        continue block15;
                    }
                    case 'D': 
                    case 'd': {
                        void day;
                        if (fChars[i2 + 1] != 'D' && fChars[i2 + 1] != 'd') continue block15;
                        sb.append((day < 10 ? "0" : "") + (int)day);
                        ++i2;
                        continue block15;
                    }
                    case 'M': 
                    case 'm': {
                        void month;
                        if (fChars[i2 + 1] == 'M' || fChars[i2 + 1] == 'm') {
                            sb.append((month < 10 ? "0" : "") + (int)month);
                            ++i2;
                            continue block15;
                        }
                        if (fChars[i2 + 1] == 'I' || fChars[i2 + 1] == 'i') {
                            void min;
                            sb.append((min < 10 ? "0" : "") + (int)min);
                            ++i2;
                            continue block15;
                        }
                        if (fChars[i2 + 1] != 'O' && fChars[i2 + 1] != 'o' || fChars[i2 + 2] != 'N' && fChars[i2 + 2] != 'n') continue block15;
                        if (!(fChars[i2 + 3] != 'T' && fChars[i2 + 3] != 't' || fChars[i2 + 4] != 'H' && fChars[i2 + 4] != 'h')) {
                            if (lMonths == null) {
                                lMonths = new DateFormatSymbols().getMonths();
                            }
                            if (fChars[i2] == 'm') {
                                sb.append(lMonths[month - true].toLowerCase());
                            } else if (fChars[i2 + 1] == 'O') {
                                sb.append(lMonths[month - true].toUpperCase());
                            } else {
                                sb.append(lMonths[month - true]);
                            }
                            i2 += 4;
                            continue block15;
                        }
                        if (sMonths == null) {
                            sMonths = new DateFormatSymbols().getShortMonths();
                        }
                        if (fChars[i2] == 'm') {
                            sb.append(sMonths[month - true].toLowerCase());
                        } else if (fChars[i2 + 1] == 'O') {
                            sb.append(sMonths[month - true].toUpperCase());
                        } else {
                            sb.append(sMonths[month - true]);
                        }
                        i2 += 2;
                        continue block15;
                    }
                    case 'H': 
                    case 'h': {
                        void hour;
                        if (fChars[i2 + 1] != 'H' && fChars[i2 + 1] != 'h') continue block15;
                        if (fChars[i2 + 2] == '2' || fChars[i2 + 3] == '4') {
                            sb.append((hour < 10 ? "0" : "") + (int)hour);
                            i2 += 3;
                            continue block15;
                        }
                        if (hour > 12) {
                            hour -= 12;
                        }
                        sb.append((hour < 10 ? "0" : "") + (int)hour);
                        ++i2;
                        continue block15;
                    }
                    case 'S': 
                    case 's': {
                        if (fChars[i2 + 1] == 'S' || fChars[i2 + 1] == 's') {
                            void sec;
                            sb.append((sec < 10 ? "0" : "") + (int)sec);
                            if (fChars[++i2 + 1] != 'X' && fChars[i2 + 1] != 'x' || fChars[i2 + 2] != 'F' && fChars[i2 + 2] != 'f' || fChars[i2 + 3] != 'F' && fChars[i2 + 3] != 'f') continue block15;
                            sb.append(".");
                            ++i2;
                            continue block15;
                        }
                        if (fChars[i2 + 1] != 'Y' && fChars[i2 + 1] != 'y' || fChars[i2 + 2] != 'Y' && fChars[i2 + 2] != 'y' || fChars[i2 + 3] != 'Y' && fChars[i2 + 3] != 'y' || year >= 0) continue block15;
                        sb.append("-");
                        bJulianBC = true;
                        continue block15;
                    }
                    case 'F': 
                    case 'f': {
                        void nanos;
                        if (fChars[i2 + 1] != 'F' && fChars[i2 + 1] != 'f') continue block15;
                        if (nanos >= 0) {
                            sb.append((int)nanos);
                        } else {
                            sb.append(0);
                        }
                        ++i2;
                        continue block15;
                    }
                    case 'T': 
                    case 't': {
                        void zone;
                        if (fChars[i2 + 1] != 'Z' && fChars[i2 + 1] != 'z') continue block15;
                        if (fChars[i2 + 2] == 'R' || fChars[i2 + 2] == 'r') {
                            if (zone.length() > 3 && zone.startsWith("GMT")) {
                                sb.append(zone.substring(3));
                            } else {
                                sb.append(zone.toUpperCase());
                            }
                            i2 += 2;
                            continue block15;
                        }
                        if (fChars[i2 + 2] == 'H' || fChars[i2 + 2] == 'h') {
                            if (tz == null) {
                                tz = TimeZone.getTimeZone((String)zone);
                            }
                            long offsetHr = tz.getRawOffset() / 3600000;
                            sb.append(offsetHr);
                            i2 += 2;
                            continue block15;
                        }
                        if (fChars[i2 + 2] != 'M' && fChars[i2 + 2] != 'm') continue block15;
                        if (tz == null) {
                            tz = TimeZone.getTimeZone((String)zone);
                        }
                        long offsetMin = Math.abs(tz.getRawOffset()) % 3600000 / 60000;
                        sb.append((offsetMin < 10L ? "0" : "") + offsetMin);
                        i2 += 2;
                        continue block15;
                    }
                    case 'A': 
                    case 'a': {
                        void am2;
                        if (fChars[i2 + 1] == 'M' || fChars[i2 + 1] == 'm') {
                            sb.append(am2 != false ? "AM" : "PM");
                            ++i2;
                            continue block15;
                        }
                        if (fChars[i2 + 1] != 'D' && fChars[i2 + 1] != 'd') continue block15;
                        sb.append(year < 0 ? "BC" : "AD");
                        ++i2;
                        continue block15;
                    }
                    case 'B': 
                    case 'b': {
                        if (fChars[i2 + 1] != 'C' && fChars[i2 + 1] != 'c') continue block15;
                        sb.append(year < 0 ? "BC" : "AD");
                        ++i2;
                        continue block15;
                    }
                    case 'P': 
                    case 'p': {
                        void am2;
                        if (fChars[i2 + 1] != 'M' && fChars[i2 + 1] != 'm') continue block15;
                        sb.append(am2 != false ? "AM" : "PM");
                        ++i2;
                        continue block15;
                    }
                    default: {
                        sb.append(fChars[i2]);
                    }
                }
            }
            String string3 = sb.substring(0, sb.length());
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$9, null, string3);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$9, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, object);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                }
                return object;
            }
            if (this.isUnexpected()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            switch (this.definedColumnType) {
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    String string = this.getString((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, string);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return string;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return timestamp;
                }
                case -102: {
                    TIMESTAMPLTZ tIMESTAMPLTZ = this.getTIMESTAMPLTZ((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, tIMESTAMPLTZ);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return tIMESTAMPLTZ;
                }
                case 91: {
                    Date date = this.getDate((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, date);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return date;
                }
                case 92: {
                    Time time = this.getTime((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, time);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return time;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = this.getBytes((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return byArray;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTimestampltzAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = T4CTimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTimestampltzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTimestampltzAccessor.class.getDeclaredMethod("nlsFormatToText", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTimestampltzAccessor.class.getDeclaredMethod("toText", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTimestampltzAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTimestampltzAccessor.class.getDeclaredMethod("unmarshalBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTimestampltzAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTimestampltzAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTimestampltzAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTimestampltzAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTimestampltzAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTimestampltzAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

