/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleType;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.sql.converter.CharacterSetMetaData;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class SQLUtil {
    private static final int CLASS_NOT_FOUND = -1;
    private static final int CLASS_STRING = 0;
    private static final int CLASS_BOOLEAN = 1;
    private static final int CLASS_INTEGER = 2;
    private static final int CLASS_LONG = 3;
    private static final int CLASS_FLOAT = 4;
    private static final int CLASS_DOUBLE = 5;
    private static final int CLASS_BIGDECIMAL = 6;
    private static final int CLASS_DATE = 7;
    private static final int CLASS_TIME = 8;
    private static final int CLASS_TIMESTAMP = 9;
    private static final int CLASS_SHORT = 10;
    private static final int CLASS_BYTE = 11;
    private static final int TOTAL_CLASSES = 12;
    private static Hashtable classTable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public SQLUtil() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, SQLUtil.class, $$$methodRef$$$19, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, SQLUtil.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SQLUtil.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SQLUtil.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object SQLToJava(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, Class clazz, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void javaClass;
            Object ret;
            void sqlTypeName;
            void sqlTypeCode;
            void sqlData;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SQLUtil.class, $$$methodRef$$$0, null, oracleConnection, byArray, n2, string, clazz, map);
            }
            Datum datum = SQLUtil.makeDatum(connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, 0);
            Object object = ret = SQLUtil.SQLToJava(connection, datum, (Class)javaClass, (Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SQLUtil.class, $$$methodRef$$$0, null, object);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SQLUtil.class, $$$methodRef$$$0, null, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SQLUtil.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CustomDatum SQLToJava(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, CustomDatumFactory customDatumFactory) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void factory;
            CustomDatum ret;
            void sqlTypeName;
            void sqlTypeCode;
            void sqlData;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SQLUtil.class, $$$methodRef$$$1, null, oracleConnection, byArray, n2, string, customDatumFactory);
            }
            Datum datum = SQLUtil.makeDatum(connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, 0);
            CustomDatum customDatum = ret = factory.create(datum, (int)sqlTypeCode);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SQLUtil.class, $$$methodRef$$$1, null, customDatum);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SQLUtil.class, $$$methodRef$$$1, null, null);
            }
            return customDatum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SQLUtil.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ORAData SQLToJava(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, ORADataFactory oRADataFactory) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void factory;
            ORAData ret;
            void sqlTypeName;
            void sqlTypeCode;
            void sqlData;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SQLUtil.class, $$$methodRef$$$2, null, oracleConnection, byArray, n2, string, oRADataFactory);
            }
            Datum datum = SQLUtil.makeDatum(connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, 0);
            ORAData oRAData = ret = factory.create(datum, (int)sqlTypeCode);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SQLUtil.class, $$$methodRef$$$2, null, oRAData);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLUtil.class, $$$methodRef$$$2, null, null);
            }
            return oRAData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SQLUtil.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static OracleData SQLToJava(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, OracleDataFactory oracleDataFactory) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void factory;
            OracleData ret;
            void sqlTypeName;
            void sqlTypeCode;
            void sqlData;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SQLUtil.class, $$$methodRef$$$3, null, oracleConnection, byArray, n2, string, oracleDataFactory);
            }
            Datum datum = SQLUtil.makeDatum(connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, 0);
            OracleData oracleData = ret = factory.create(datum.toJdbc(), (int)sqlTypeCode);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SQLUtil.class, $$$methodRef$$$3, null, oracleData);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SQLUtil.class, $$$methodRef$$$3, null, null);
            }
            return oracleData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SQLUtil.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object SQLToJava(oracle.jdbc.internal.OracleConnection oracleConnection, Datum datum, Class clazz, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void javaClass;
            void datum2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SQLUtil.class, $$$methodRef$$$4, null, oracleConnection, datum, clazz, map);
            }
            Object ret_obj = null;
            if (datum2 instanceof STRUCT) {
                void map2;
                ret_obj = javaClass == null ? (map2 != null ? ((STRUCT)datum2).toJdbc((Map)map2) : datum2.toJdbc()) : (map2 != null ? ((STRUCT)datum2).toClass((Class)javaClass, (Map)map2) : ((STRUCT)datum2).toClass((Class)javaClass));
            } else if (javaClass == null) {
                ret_obj = datum2.toJdbc();
            } else {
                int class_num = SQLUtil.classNumber((Class)javaClass);
                switch (class_num) {
                    case 0: {
                        ret_obj = datum2.stringValue();
                        break;
                    }
                    case 1: {
                        ret_obj = datum2.longValue() != 0L;
                        break;
                    }
                    case 10: {
                        ret_obj = (short)datum2.longValue();
                        break;
                    }
                    case 11: {
                        ret_obj = (byte)datum2.longValue();
                        break;
                    }
                    case 2: {
                        ret_obj = (int)datum2.longValue();
                        break;
                    }
                    case 3: {
                        ret_obj = datum2.longValue();
                        break;
                    }
                    case 4: {
                        ret_obj = Float.valueOf(datum2.bigDecimalValue().floatValue());
                        break;
                    }
                    case 5: {
                        ret_obj = datum2.bigDecimalValue().doubleValue();
                        break;
                    }
                    case 6: {
                        ret_obj = datum2.bigDecimalValue();
                        break;
                    }
                    case 7: {
                        ret_obj = datum2.dateValue();
                        break;
                    }
                    case 8: {
                        ret_obj = datum2.timeValue();
                        break;
                    }
                    case 9: {
                        ret_obj = datum2.timestampValue();
                        break;
                    }
                    default: {
                        ret_obj = datum2.toJdbc();
                        if (javaClass.isInstance(ret_obj)) break;
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(59, "invalid data conversion").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, SQLUtil.class, $$$methodRef$$$4, null, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            Object object = ret_obj;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SQLUtil.class, $$$methodRef$$$4, null, object);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SQLUtil.class, $$$methodRef$$$4, null, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SQLUtil.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] JavaToSQL(oracle.jdbc.internal.OracleConnection oracleConnection, Object object, int n2, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeName;
            void sqlTypeCode;
            oracle.jdbc.internal.OracleConnection connection;
            void inObject;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, oracleConnection, object, n2, string);
            }
            if (inObject == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, null);
                }
                return null;
            }
            Datum datum = null;
            if (inObject instanceof Datum) {
                datum = (Datum)inObject;
            } else if (inObject instanceof ORAData) {
                datum = ((ORAData)inObject).toDatum(connection);
            } else if (inObject instanceof CustomDatum) {
                datum = connection.toDatum((CustomDatum)inObject);
            } else if (inObject instanceof SQLData) {
                datum = STRUCT.toSTRUCT(inObject, connection);
            }
            if (datum != null) {
                if (!SQLUtil.checkDatumType(datum, (int)sqlTypeCode, (String)sqlTypeName)) {
                    datum = null;
                }
            } else {
                datum = SQLUtil.makeDatum(connection, inObject, (int)sqlTypeCode, (String)sqlTypeName);
            }
            byte[] ret = null;
            if (datum != null) {
                ret = datum instanceof STRUCT ? ((STRUCT)datum).toBytes() : (datum instanceof ARRAY ? ((ARRAY)datum).toBytes() : (datum instanceof OPAQUE ? ((OPAQUE)datum).toBytes() : datum.shareBytes()));
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "attempt to convert a Datum to incompatible SQL type").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SQLUtil.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeDatum(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, int n3) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeCode;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, oracleConnection, byArray, n2, string, n3);
            }
            Datum ret_datum = null;
            short dbCharSet = connection.getDbCsId();
            short jdbcCharSet = connection.getJdbcCsId();
            int nlsChrSetRatio = CharacterSetMetaData.getRatio(jdbcCharSet, dbCharSet);
            switch (sqlTypeCode) {
                case 96: {
                    void sqlData;
                    void maxLen;
                    if (maxLen != false && maxLen < ((void)sqlData).length && nlsChrSetRatio == 1) {
                        ret_datum = new CHAR((byte[])sqlData, 0, (int)maxLen, CharacterSet.make(connection.getJdbcCsId()));
                        break;
                    }
                    ret_datum = new CHAR((byte[])sqlData, CharacterSet.make(connection.getJdbcCsId()));
                    break;
                }
                case 1: 
                case 8: {
                    void sqlData;
                    ret_datum = new CHAR((byte[])sqlData, CharacterSet.make(connection.getJdbcCsId()));
                    break;
                }
                case 2: 
                case 6: {
                    void sqlData;
                    ret_datum = new NUMBER((byte[])sqlData);
                    break;
                }
                case 100: {
                    void sqlData;
                    ret_datum = new BINARY_FLOAT((byte[])sqlData);
                    break;
                }
                case 101: {
                    void sqlData;
                    ret_datum = new BINARY_DOUBLE((byte[])sqlData);
                    break;
                }
                case 23: 
                case 24: {
                    void sqlData;
                    ret_datum = new RAW((byte[])sqlData);
                    break;
                }
                case 104: {
                    void sqlData;
                    ret_datum = new ROWID((byte[])sqlData);
                    break;
                }
                case 102: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "need resolution: do we want to handle ResultSet?").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, sQLException);
                    }
                    throw sQLException;
                }
                case 12: {
                    void sqlData;
                    ret_datum = new DATE((byte[])sqlData);
                    break;
                }
                case 182: {
                    void sqlData;
                    ret_datum = new INTERVALYM((byte[])sqlData);
                    break;
                }
                case 183: {
                    void sqlData;
                    ret_datum = new INTERVALDS((byte[])sqlData);
                    break;
                }
                case 180: {
                    void sqlData;
                    ret_datum = new TIMESTAMP((byte[])sqlData);
                    break;
                }
                case 181: {
                    void sqlData;
                    ret_datum = new TIMESTAMPTZ((byte[])sqlData);
                    break;
                }
                case 231: {
                    void sqlData;
                    ret_datum = new TIMESTAMPLTZ((byte[])sqlData);
                    break;
                }
                case 113: {
                    void sqlData;
                    ret_datum = connection.createBlob((byte[])sqlData);
                    break;
                }
                case 112: {
                    void sqlData;
                    ret_datum = connection.createClob((byte[])sqlData);
                    break;
                }
                case 114: {
                    void sqlData;
                    ret_datum = connection.createBfile((byte[])sqlData);
                    break;
                }
                case 257: {
                    void sqlData;
                    ret_datum = XMLFactory.createXML(connection, new ByteArrayInputStream((byte[])sqlData));
                    break;
                }
                case 109: {
                    void sqlTypeName;
                    void sqlData;
                    TypeDescriptor desc = TypeDescriptor.getTypeDescriptor((String)sqlTypeName, connection, (byte[])sqlData, 0L);
                    switch (desc.getTypeCode()) {
                        case 2002: {
                            ret_datum = new STRUCT((StructDescriptor)desc, (byte[])sqlData, connection);
                            break;
                        }
                        case 2008: {
                            ret_datum = new JAVA_STRUCT((StructDescriptor)desc, (byte[])sqlData, connection);
                            break;
                        }
                        case 2003: {
                            ret_datum = new ARRAY((ArrayDescriptor)desc, (byte[])sqlData, connection);
                            break;
                        }
                        case 2009: {
                            ret_datum = XMLFactory.createXML(new OPAQUE((OpaqueDescriptor)desc, (byte[])sqlData, connection));
                            break;
                        }
                        case 2007: {
                            ret_datum = new OPAQUE((OpaqueDescriptor)desc, (byte[])sqlData, connection);
                        }
                    }
                    break;
                }
                case 111: {
                    void sqlTypeName;
                    void sqlData;
                    Object desc = SQLUtil.getTypeDescriptor((String)sqlTypeName, connection);
                    if (desc instanceof StructDescriptor) {
                        ret_datum = new REF((StructDescriptor)desc, (Connection)connection, (byte[])sqlData);
                        break;
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "program error: REF points to a non-STRUCT").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, sQLException);
                    }
                    throw sQLException;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "program error: invalid SQL type code").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            Datum datum = ret_datum;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, datum);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SQLUtil.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeNDatum(oracle.jdbc.internal.OracleConnection oracleConnection, byte[] byArray, int n2, String string, short s2, int n3) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, SQLUtil.class, $$$methodRef$$$7, null, oracleConnection, byArray, n2, string, s2, n3);
            }
            Datum ret_datum = null;
            switch (sqlTypeCode) {
                case 96: {
                    void sqlData;
                    oracle.jdbc.internal.OracleConnection connection;
                    void maxLen;
                    void len = maxLen * CharacterSetMetaData.getRatio(connection.getNCharSet(), 1);
                    if (maxLen != false && len < ((void)sqlData).length) {
                        ret_datum = new CHAR((byte[])sqlData, 0, (int)maxLen, CharacterSet.make(connection.getNCharSet()));
                        break;
                    }
                    ret_datum = new CHAR((byte[])sqlData, CharacterSet.make(connection.getNCharSet()));
                    break;
                }
                case 1: 
                case 8: {
                    void sqlData;
                    oracle.jdbc.internal.OracleConnection connection;
                    ret_datum = new CHAR((byte[])sqlData, CharacterSet.make(connection.getNCharSet()));
                    break;
                }
                case 112: {
                    void form;
                    void sqlData;
                    oracle.jdbc.internal.OracleConnection connection;
                    ret_datum = connection.createClob((byte[])sqlData, (short)form);
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "program error: invalid SQL type code").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, SQLUtil.class, $$$methodRef$$$7, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            CLOB cLOB = ret_datum;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, SQLUtil.class, $$$methodRef$$$7, null, cLOB);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SQLUtil.class, $$$methodRef$$$7, null, null);
            }
            return cLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SQLUtil.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeDatum(oracle.jdbc.internal.OracleConnection oracleConnection, Object object, int n2, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeName;
            void sqlTypeCode;
            void inObject;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, SQLUtil.class, $$$methodRef$$$8, null, oracleConnection, object, n2, string);
            }
            Datum datum = SQLUtil.makeDatum(connection, inObject, (int)sqlTypeCode, (String)sqlTypeName, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, SQLUtil.class, $$$methodRef$$$8, null, datum);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SQLUtil.class, $$$methodRef$$$8, null, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SQLUtil.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeDatum(oracle.jdbc.internal.OracleConnection oracleConnection, Object object, int n2, String string, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeCode;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, oracleConnection, object, n2, string, bl);
            }
            Datum ret_datum = null;
            switch (sqlTypeCode) {
                case 1: 
                case 8: 
                case 96: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void isNChar;
                    void inObject;
                    ret_datum = new CHAR(inObject, CharacterSet.make(isNChar != false ? connection.getNCharSet() : connection.getJdbcCsId()));
                    break;
                }
                case 2: 
                case 6: {
                    void inObject;
                    ret_datum = new NUMBER(inObject);
                    break;
                }
                case 100: {
                    void inObject;
                    if (inObject instanceof String) {
                        ret_datum = new BINARY_FLOAT((String)inObject);
                        break;
                    }
                    if (inObject instanceof Boolean) {
                        ret_datum = new BINARY_FLOAT((Boolean)inObject);
                        break;
                    }
                    ret_datum = new BINARY_FLOAT((Float)inObject);
                    break;
                }
                case 101: {
                    void inObject;
                    if (inObject instanceof String) {
                        ret_datum = new BINARY_DOUBLE((String)inObject);
                        break;
                    }
                    if (inObject instanceof Boolean) {
                        ret_datum = new BINARY_DOUBLE((Boolean)inObject);
                        break;
                    }
                    ret_datum = new BINARY_DOUBLE((Double)inObject);
                    break;
                }
                case 23: 
                case 24: {
                    void inObject;
                    ret_datum = new RAW(inObject);
                    break;
                }
                case 104: {
                    void inObject;
                    if (inObject instanceof String) {
                        ret_datum = new ROWID((String)inObject);
                        break;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new ROWID((byte[])inObject);
                    break;
                }
                case 102: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "need resolution: do we want to handle ResultSet").fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, sQLException);
                    }
                    throw sQLException;
                }
                case 12: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    ret_datum = JavaToJavaConverter.convert(inObject, DATE.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 182: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    ret_datum = JavaToJavaConverter.convert(inObject, INTERVALYM.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 183: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    ret_datum = JavaToJavaConverter.convert(inObject, INTERVALDS.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 180: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    if (inObject instanceof TIMESTAMP) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMP((Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMP((Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMP((Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMP((DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMP((String)inObject);
                        break;
                    }
                    if (inObject instanceof byte[]) {
                        ret_datum = new TIMESTAMP((byte[])inObject);
                        break;
                    }
                    ret_datum = JavaToJavaConverter.convert(inObject, TIMESTAMP.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 181: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    if (inObject instanceof TIMESTAMPTZ) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (String)inObject);
                        break;
                    }
                    if (inObject instanceof byte[]) {
                        ret_datum = new TIMESTAMPTZ((byte[])inObject);
                        break;
                    }
                    ret_datum = JavaToJavaConverter.convert(inObject, TIMESTAMPTZ.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 231: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    if (inObject instanceof TIMESTAMPLTZ) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (String)inObject);
                        break;
                    }
                    if (inObject instanceof byte[]) {
                        ret_datum = new TIMESTAMPLTZ((byte[])inObject);
                        break;
                    }
                    ret_datum = JavaToJavaConverter.convert(inObject, TIMESTAMPLTZ.class, (OracleConnection)connection, null, null);
                    break;
                }
                case 113: {
                    void inObject;
                    if (inObject instanceof BLOB) {
                        ret_datum = (Datum)inObject;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new RAW((byte[])inObject);
                    break;
                }
                case 112: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void isNChar;
                    void inObject;
                    if (inObject instanceof CLOB) {
                        ret_datum = (Datum)inObject;
                    }
                    if (!(inObject instanceof String)) break;
                    CharacterSet chset = CharacterSet.make(isNChar != false ? connection.getNCharSet() : connection.getJdbcCsId());
                    ret_datum = new CHAR((String)inObject, chset);
                    break;
                }
                case 114: {
                    void inObject;
                    if (!(inObject instanceof BFILE)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
                case 109: {
                    void inObject;
                    if (!(inObject instanceof STRUCT) && !(inObject instanceof ARRAY) && !(inObject instanceof OPAQUE)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
                case 257: {
                    oracle.jdbc.internal.OracleConnection connection;
                    void inObject;
                    if (!(inObject instanceof String)) break;
                    ret_datum = XMLFactory.createXML(connection, (String)inObject);
                    break;
                }
                case 111: {
                    void inObject;
                    if (!(inObject instanceof REF)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
            }
            if (ret_datum == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "Unable to construct a Datum from the specified input").fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, sQLException);
                }
                throw sQLException;
            }
            NUMBER nUMBER = ret_datum;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SQLUtil.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    private static int classNumber(Class clazz) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Class inClass;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, SQLUtil.class, $$$methodRef$$$10, null, clazz);
            }
            int ret = -1;
            Integer class_num = (Integer)classTable.get(inClass);
            if (class_num != null) {
                ret = class_num;
            }
            int n2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SQLUtil.class, $$$methodRef$$$10, null, n2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SQLUtil.class, $$$methodRef$$$10, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SQLUtil.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object getTypeDescriptor(String string, oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            String name;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, string, oracleConnection);
            }
            Object descriptor = null;
            SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
            String qname = sqlName.getName();
            descriptor = conn.getDescriptor(qname);
            if (descriptor != null) {
                Object object = descriptor;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, object);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, null);
                }
                return object;
            }
            OracleTypeADT otype = new OracleTypeADT(qname, (Connection)conn);
            otype.init((oracle.jdbc.internal.OracleConnection)conn);
            OracleNamedType realType = otype.cleanup();
            switch (realType.getTypeCode()) {
                case 2003: {
                    descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                    break;
                }
                case 2002: 
                case 2008: {
                    descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                    break;
                }
                case 2007: {
                    descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "Unrecognized type code").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            conn.putDescriptor(qname, descriptor);
            Object object = descriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, object);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SQLUtil.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkDatumType(Datum datum, int n2, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, SQLUtil.class, $$$methodRef$$$12, null, datum, n2, string);
            }
            boolean ret = false;
            switch (sqlType) {
                case 1: 
                case 8: 
                case 96: {
                    Datum datum2;
                    ret = datum2 instanceof CHAR;
                    break;
                }
                case 2: 
                case 6: {
                    Datum datum2;
                    ret = datum2 instanceof NUMBER;
                    break;
                }
                case 100: {
                    Datum datum2;
                    ret = datum2 instanceof BINARY_FLOAT;
                    break;
                }
                case 101: {
                    Datum datum2;
                    ret = datum2 instanceof BINARY_DOUBLE;
                    break;
                }
                case 23: 
                case 24: {
                    Datum datum2;
                    ret = datum2 instanceof RAW;
                    break;
                }
                case 104: {
                    Datum datum2;
                    ret = datum2 instanceof ROWID;
                    break;
                }
                case 12: {
                    Datum datum2;
                    ret = datum2 instanceof DATE;
                    break;
                }
                case 180: {
                    Datum datum2;
                    ret = datum2 instanceof TIMESTAMP;
                    break;
                }
                case 181: {
                    Datum datum2;
                    ret = datum2 instanceof TIMESTAMPTZ;
                    break;
                }
                case 231: {
                    Datum datum2;
                    ret = datum2 instanceof TIMESTAMPLTZ;
                    break;
                }
                case 113: {
                    Datum datum2;
                    ret = datum2 instanceof BLOB;
                    break;
                }
                case 112: {
                    Datum datum2;
                    ret = datum2 instanceof CLOB;
                    break;
                }
                case 114: {
                    Datum datum2;
                    ret = datum2 instanceof BFILE;
                    break;
                }
                case 111: {
                    void sqlTypeName;
                    Datum datum2;
                    ret = datum2 instanceof REF && ((REF)datum2).getBaseTypeName().equals(sqlTypeName);
                    break;
                }
                case 109: {
                    void sqlTypeName;
                    Datum datum2;
                    if (datum2 instanceof STRUCT) {
                        ret = ((STRUCT)datum2).isInHierarchyOf((String)sqlTypeName);
                        break;
                    }
                    if (datum2 instanceof ARRAY) {
                        ret = ((ARRAY)datum2).getSQLTypeName().equals(sqlTypeName);
                        break;
                    }
                    if (!(datum2 instanceof OPAQUE)) break;
                    ret = ((OPAQUE)datum2).getSQLTypeName().equals(sqlTypeName);
                    break;
                }
                default: {
                    ret = false;
                }
            }
            boolean bl2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, SQLUtil.class, $$$methodRef$$$12, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SQLUtil.class, $$$methodRef$$$12, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SQLUtil.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean implementsInterface(Class clazz, Class clazz2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void interfaze;
            Class clazz3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, clazz, clazz2);
            }
            if (clazz3 == null) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, bl2);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, null);
                }
                return false;
            }
            if (clazz3 == interfaze) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, bl3);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, null);
                }
                return true;
            }
            Class<?>[] interfazes = clazz3.getInterfaces();
            for (int i2 = 0; i2 < interfazes.length; ++i2) {
                if (!SQLUtil.implementsInterface(interfazes[i2], (Class)interfaze)) continue;
                boolean bl4 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, bl4);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, null);
                }
                return true;
            }
            boolean bl5 = SQLUtil.implementsInterface(clazz3.getSuperclass(), (Class)interfaze);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, bl5);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SQLUtil.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeOracleDatum(oracle.jdbc.internal.OracleConnection oracleConnection, Object object, int n2, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlTypeName;
            void typeCode;
            void inObject;
            oracle.jdbc.internal.OracleConnection connection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, SQLUtil.class, $$$methodRef$$$14, null, oracleConnection, object, n2, string);
            }
            Datum datum = SQLUtil.makeOracleDatum(connection, inObject, (int)typeCode, (String)sqlTypeName, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, SQLUtil.class, $$$methodRef$$$14, null, datum);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SQLUtil.class, $$$methodRef$$$14, null, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SQLUtil.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Datum makeOracleDatum(oracle.jdbc.internal.OracleConnection oracleConnection, Object object, int n2, String string, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void isNChar;
            void sqlTypeName;
            void typeCode;
            void inObject;
            oracle.jdbc.internal.OracleConnection connection;
            Datum ret;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, SQLUtil.class, $$$methodRef$$$15, null, oracleConnection, object, n2, string, bl);
            }
            Datum datum = ret = SQLUtil.makeDatum(connection, inObject, SQLUtil.getInternalType((int)typeCode), (String)sqlTypeName, (boolean)isNChar);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SQLUtil.class, $$$methodRef$$$15, null, datum);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SQLUtil.class, $$$methodRef$$$15, null, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SQLUtil.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public static int getInternalType(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, SQLUtil.class, $$$methodRef$$$16, null, n2);
            }
            int ret = 0;
            switch (external_type) {
                case -7: 
                case -6: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    ret = 6;
                    break;
                }
                case 2: {
                    ret = 2;
                    break;
                }
                case 100: {
                    ret = 100;
                    break;
                }
                case 101: {
                    ret = 101;
                    break;
                }
                case 999: {
                    ret = 999;
                    break;
                }
                case 1: {
                    ret = 96;
                    break;
                }
                case -15: {
                    ret = 96;
                    break;
                }
                case 12: {
                    ret = 1;
                    break;
                }
                case -9: {
                    ret = 1;
                    break;
                }
                case -1: {
                    ret = 8;
                    break;
                }
                case 91: 
                case 92: {
                    ret = 12;
                    break;
                }
                case -100: 
                case 93: {
                    ret = 180;
                    break;
                }
                case -101: {
                    ret = 181;
                    break;
                }
                case -102: {
                    ret = 231;
                    break;
                }
                case -104: {
                    ret = 183;
                    break;
                }
                case -103: {
                    ret = 182;
                    break;
                }
                case -3: 
                case -2: {
                    ret = 23;
                    break;
                }
                case -4: {
                    ret = 24;
                    break;
                }
                case -8: {
                    ret = 104;
                    break;
                }
                case 2004: {
                    ret = 113;
                    break;
                }
                case 2005: {
                    ret = 112;
                    break;
                }
                case 2011: {
                    ret = 112;
                    break;
                }
                case -13: {
                    ret = 114;
                    break;
                }
                case -10: 
                case 2012: {
                    ret = 102;
                    break;
                }
                case 2009: {
                    ret = 257;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    ret = 109;
                    break;
                }
                case 2006: {
                    ret = 111;
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(4, "get_internal_type").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, SQLUtil.class, $$$methodRef$$$16, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n3 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, SQLUtil.class, $$$methodRef$$$16, null, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, SQLUtil.class, $$$methodRef$$$16, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, SQLUtil.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    public static SQLType getExternalType(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int internalTypeId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, SQLUtil.class, $$$methodRef$$$17, null, n2);
            }
            OracleType ret = OracleType.ANYTYPE;
            switch (internalTypeId) {
                case 1: {
                    ret = OracleType.VARCHAR2;
                    break;
                }
                case 96: {
                    ret = OracleType.CHAR;
                    break;
                }
                case 2: {
                    ret = OracleType.NUMBER;
                    break;
                }
                case 12: {
                    ret = OracleType.DATE;
                    break;
                }
                case 23: {
                    ret = OracleType.RAW;
                    break;
                }
                case 180: {
                    ret = OracleType.TIMESTAMP;
                    break;
                }
                case 231: {
                    ret = OracleType.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
                    break;
                }
                default: {
                    ret = OracleType.ANYTYPE;
                }
            }
            OracleType oracleType = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, SQLUtil.class, $$$methodRef$$$17, null, oracleType);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SQLUtil.class, $$$methodRef$$$17, null, null);
            }
            return oracleType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SQLUtil.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, SQLUtil.class, $$$methodRef$$$18, this, new Object[0]);
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, SQLUtil.class, $$$methodRef$$$18, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SQLUtil.class, $$$methodRef$$$18, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SQLUtil.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = SQLUtil.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SQLUtil.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SQLUtil.class.getDeclaredMethod("getExternalType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SQLUtil.class.getDeclaredMethod("getInternalType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SQLUtil.class.getDeclaredMethod("makeOracleDatum", oracle.jdbc.internal.OracleConnection.class, Object.class, Integer.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SQLUtil.class.getDeclaredMethod("makeOracleDatum", oracle.jdbc.internal.OracleConnection.class, Object.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SQLUtil.class.getDeclaredMethod("implementsInterface", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SQLUtil.class.getDeclaredMethod("checkDatumType", Datum.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SQLUtil.class.getDeclaredMethod("getTypeDescriptor", String.class, oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SQLUtil.class.getDeclaredMethod("classNumber", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SQLUtil.class.getDeclaredMethod("makeDatum", oracle.jdbc.internal.OracleConnection.class, Object.class, Integer.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SQLUtil.class.getDeclaredMethod("makeDatum", oracle.jdbc.internal.OracleConnection.class, Object.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SQLUtil.class.getDeclaredMethod("makeNDatum", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SQLUtil.class.getDeclaredMethod("makeDatum", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SQLUtil.class.getDeclaredMethod("JavaToSQL", oracle.jdbc.internal.OracleConnection.class, Object.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SQLUtil.class.getDeclaredMethod("SQLToJava", oracle.jdbc.internal.OracleConnection.class, Datum.class, Class.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SQLUtil.class.getDeclaredMethod("SQLToJava", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SQLUtil.class.getDeclaredMethod("SQLToJava", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SQLUtil.class.getDeclaredMethod("SQLToJava", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, CustomDatumFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SQLUtil.class.getDeclaredMethod("SQLToJava", oracle.jdbc.internal.OracleConnection.class, byte[].class, Integer.TYPE, String.class, Class.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        classTable = new Hashtable(12);
        try {
            classTable.put(Class.forName("java.lang.String"), 0);
            classTable.put(Class.forName("java.lang.Boolean"), 1);
            classTable.put(Class.forName("java.lang.Integer"), 2);
            classTable.put(Class.forName("java.lang.Long"), 3);
            classTable.put(Class.forName("java.lang.Float"), 4);
            classTable.put(Class.forName("java.lang.Double"), 5);
            classTable.put(Class.forName("java.math.BigDecimal"), 6);
            classTable.put(Class.forName("java.sql.Date"), 7);
            classTable.put(Class.forName("java.sql.Time"), 8);
            classTable.put(Class.forName("java.sql.Timestamp"), 9);
            classTable.put(Class.forName("java.lang.Short"), 10);
            classTable.put(Class.forName("java.lang.Byte"), 11);
        }
        catch (ClassNotFoundException e2) {
            OracleLog.log(null, Level.SEVERE, SQLUtil.class, null, e2.getMessage() + "\n", e2);
        }
    }

    private static class XMLFactory {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private XMLFactory() {
        }

        static Datum createXML(OPAQUE opq) throws SQLException {
            return XMLType.createXML((OPAQUE)opq);
        }

        static Datum createXML(oracle.jdbc.internal.OracleConnection conn, String xmlval) throws SQLException {
            return XMLType.createXML((Connection)conn, (String)xmlval);
        }

        static Datum createXML(oracle.jdbc.internal.OracleConnection conn, InputStream is) throws SQLException {
            return XMLType.createXML((Connection)conn, (InputStream)is);
        }

        static {
            try {
                $$$methodRef$$$3 = XMLFactory.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = XMLFactory.class.getDeclaredMethod("createXML", oracle.jdbc.internal.OracleConnection.class, InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = XMLFactory.class.getDeclaredMethod("createXML", oracle.jdbc.internal.OracleConnection.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = XMLFactory.class.getDeclaredMethod("createXML", OPAQUE.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

