/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    OracleClob clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public OracleClobOutputStream(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$7, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobOutputStream(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$8, null, clob, bufferSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobOutputStream(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$9, null, clob, bufferSize, beginOffset);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobOutputStream(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            PhysicalConnection pConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null, clob, bufferSize, beginOffset);
            }
            if (clob == null || bufferSize <= 0 || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.clob = clob;
            this.lobOffset = beginOffset;
            PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)clob.getInternalConnection();
            synchronized (physicalConnection) {
                try {
                    this.buf = pConnection.getByteBuffer(bufferSize);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var6_9
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null, throwable2);
                    }
                    throw throwable2;
                }
            }
            this.count = 0;
            this.bufSize = bufferSize;
            this.isClosed = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$10, null, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$0, this, n2);
            }
            this.ensureOpen();
            if (this.count >= this.bufSize) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            void len;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this, byArray, n2, n3);
            }
            this.ensureOpen();
            void start = off;
            int lengthToWrite = Math.min((int)len, ((void)b2).length - off);
            if (lengthToWrite >= 2 * this.bufSize) {
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    char[] charArr = new char[lengthToWrite];
                    for (int i2 = 0; i2 < lengthToWrite; ++i2) {
                        charArr[i2] = (char)b2[i2 + off];
                    }
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this, iOException);
                    }
                    throw iOException;
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            void end = start + lengthToWrite;
            while (start < end) {
                int bytesWritten = Math.min(this.bufSize - this.count, (int)(end - start));
                System.arraycopy(b2, (int)start, this.buf, this.count, bytesWritten);
                start += bytesWritten;
                this.count += bytesWritten;
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void flush() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.ensureOpen();
            this.flushBuffer();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.isClosed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            try {
                this.isClosed = true;
                this.flushBuffer();
            }
            catch (Throwable throwable) {
                try {
                    PhysicalConnection pConnection;
                    PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                    synchronized (physicalConnection) {
                        try {
                            if (this.buf != null) {
                                pConnection.cacheBuffer(this.buf);
                                this.buf = null;
                            }
                        }
                        catch (Throwable throwable2) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 10, 11] lbl44 : MonitorExitStatement: MONITOREXIT : var6_15
                            Throwable throwable3 = throwable2;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, throwable3);
                            }
                            throw throwable3;
                        }
                    }
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, iOException);
                    }
                    throw iOException;
                }
                Throwable throwable4 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, throwable4);
                }
                throw throwable4;
            }
            try {
                PhysicalConnection pConnection;
                PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection) {
                    try {
                        if (this.buf != null) {
                            pConnection.cacheBuffer(this.buf);
                            this.buf = null;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 7, 8] lbl23 : MonitorExitStatement: MONITOREXIT : var2_4
                        Throwable throwable5 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, throwable5);
                        }
                        throw throwable5;
                    }
                }
            }
            catch (SQLException e3) {
                IOException iOException = (IOException)DatabaseError.createIOException(e3).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable6 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$3, this, throwable6);
            }
            throw throwable;
        }
    }

    private void flushBuffer() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$4, this, new Object[0]);
            }
            try {
                if (this.count > 0) {
                    char[] charArr = new char[this.count];
                    for (int i2 = 0; i2 < this.count; ++i2) {
                        charArr[i2] = (char)this.buf[i2];
                    }
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
                    this.count = 0;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$4, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this, new Object[0]);
            }
            try {
                if (this.isClosed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, new Object[0]);
                }
                try {
                    oracleConnection = this.clob.getInternalConnection();
                    if (!bl) break block7;
                }
                catch (Exception exc) {
                    OracleConnection oracleConnection2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, oracleConnection2);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobOutputStream.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$10 = OracleClobOutputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleClobOutputStream.class.getDeclaredConstructor(CLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleClobOutputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleClobOutputStream.class.getDeclaredConstructor(CLOB.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleClobOutputStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleClobOutputStream.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleClobOutputStream.class.getDeclaredMethod("flushBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleClobOutputStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleClobOutputStream.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleClobOutputStream.class.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleClobOutputStream.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

