/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import oracle.net.resolver.TimeUnit;

public class TimeUnitSuffixUtility {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    private static int getTimeInMilliseconds(String value) {
        Optional<TimeUnit> suffix = Stream.of(TimeUnit.values()).filter(p2 -> value.toUpperCase().endsWith(p2.name())).findAny();
        if (suffix.isPresent()) {
            return Integer.parseInt(value.toUpperCase().replaceFirst(suffix.get().name(), "")) * suffix.get().getMultiplier();
        }
        return Integer.parseInt(value);
    }

    public static int getTimeInMilliseconds(String value, boolean valueInSeconds, int defaultValue) {
        try {
            if (!value.isEmpty() && value.matches("\\d*")) {
                return valueInSeconds ? Integer.parseInt(value) * 1000 : Integer.parseInt(value);
            }
            return TimeUnitSuffixUtility.getTimeInMilliseconds(value);
        }
        catch (NumberFormatException numberFormatException) {
            return valueInSeconds ? defaultValue * 1000 : defaultValue;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = TimeUnitSuffixUtility.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeUnitSuffixUtility.class.getDeclaredMethod("lambda$getTimeInMilliseconds$0", String.class, TimeUnit.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeUnitSuffixUtility.class.getDeclaredMethod("getTimeInMilliseconds", String.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeUnitSuffixUtility.class.getDeclaredMethod("getTimeInMilliseconds", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

