/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    private final String addressInfo;
    NetStatImpl netStat = null;
    Boolean useNio;
    int port;
    String host;
    String protocol;
    String uri;
    NVNavigator nav;
    NVPair nvpAddr;
    protected SocketChannelWrapper socketChannel;
    InetAddress[] inetAddresses = null;
    int count;
    int attempts;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private static Hashtable<String, InetAddress[]> inetaddressesCache;
    private static Hashtable<String, Integer> circularOffsets;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    public TcpNTAdapter(String address, Properties socketOptions) throws NLException {
        this.socketOptions = socketOptions;
        this.addressInfo = address;
        this.useNio = Boolean.parseBoolean((String)socketOptions.get(20));
        this.nav = new NVNavigator();
        this.nvpAddr = new NVFactory().createNVPair(address);
        NVPair nvpHost = this.nav.findNVPair(this.nvpAddr, "HOST");
        NVPair nvpPort = this.nav.findNVPair(this.nvpAddr, "PORT");
        NVPair nvpProtocol = this.nav.findNVPair(this.nvpAddr, "PROTOCOL");
        if (nvpHost == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nvpHost.getAtom();
        if (nvpPort != null) {
            try {
                this.port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e2) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(e2);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (nvpProtocol != null) {
            this.protocol = nvpProtocol.getAtom();
        }
    }

    @Override
    public void connect(NounIntf dmsParent) throws IOException {
        String c_timeout = (String)this.socketOptions.get(2);
        boolean forceDNSLoadBalancing = Boolean.parseBoolean((String)this.socketOptions.get(18));
        MetricsEnabledSocketFactory sockFactory = new MetricsEnabledSocketFactory(dmsParent);
        if (this.inetAddresses == null) {
            this.inetAddresses = InetAddress.getAllByName(this.host);
            if (forceDNSLoadBalancing && this.inetAddresses.length > 1) {
                this.inetAddresses = TcpNTAdapter.getAddressesInCircularOrder(this.host, this.inetAddresses);
            }
            DownHostsCache.getInstance().reorderAddresses(this.inetAddresses, this.port);
            this.attempts = this.inetAddresses.length;
            this.count = 0;
        }
        while (true) {
            InetAddress inet = this.inetAddresses[this.count];
            ++this.count;
            --this.attempts;
            long socketConnectStartTime = System.currentTimeMillis();
            if (!this.useNio.booleanValue()) {
                this.socket = ((SocketFactory)sockFactory).createSocket();
            }
            try {
                if (this.useNio.booleanValue()) {
                    this.netStat = new NetStatImpl();
                    this.socketChannel = new TimeoutSocketChannel(new InetSocketAddress(inet, this.port), Integer.parseInt(c_timeout), this.netStat);
                    this.socket = this.socketChannel.socket();
                    break;
                }
                this.socket.connect(new InetSocketAddress(inet, this.port), Integer.parseInt(c_timeout));
            }
            catch (IOException ea) {
                DownHostsCache.getInstance().markDownHost(inet, this.port);
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.attempts > 0) continue;
                this.resetInetAddress();
                String newExMessage = String.format("%s, socket connect lapse %d ms. %s %d %s %d %s", ea.getMessage(), System.currentTimeMillis() - socketConnectStartTime, inet.toString(), this.port, c_timeout, this.count, this.useNio);
                IOException newEx = new IOException(newExMessage, ea);
                throw newEx;
                if (this.count < this.inetAddresses.length) continue;
            }
            break;
        }
        this.setReadTimeoutIfRequired(this.socketOptions);
        this.setSocketOptions();
    }

    @Override
    public boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.count < this.inetAddresses.length;
    }

    @Override
    public void resetInetAddress() {
        this.inetAddresses = null;
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    public void setSocketOptions() throws IOException {
        String temp = (String)this.socketOptions.get(0);
        if (temp != null) {
            this.setOption(0, temp);
        }
        if ((temp = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, temp);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (option) {
            case 0: {
                String tmp = (String)value;
                this.socket.setTcpNoDelay(tmp.equals("YES"));
                break;
            }
            case 1: {
                String tmp = (String)value;
                if (!tmp.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: 
            case 101: {
                this.sockTimeout = Integer.parseInt((String)value);
                if (!this.useNio.booleanValue()) {
                    this.socket.setSoTimeout(this.sockTimeout);
                    break;
                }
                this.socketChannel.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (option) {
            case 101: {
                return "" + this.sockTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket != null) {
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.close();
        }
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = (String)prop.get(3);
        }
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    static final synchronized InetAddress[] getAddressesInCircularOrder(String hostname, InetAddress[] inetAddressesFromJVM) {
        InetAddress[] cachedAddresses = inetaddressesCache.get(hostname);
        Integer offset = circularOffsets.get(hostname);
        if (cachedAddresses == null || !TcpNTAdapter.areEquals(cachedAddresses, inetAddressesFromJVM)) {
            offset = new Integer(0);
            cachedAddresses = inetAddressesFromJVM;
            inetaddressesCache.put(hostname, inetAddressesFromJVM);
            circularOffsets.put(hostname, offset);
        }
        InetAddress[] addrb = TcpNTAdapter.getCopyAddresses(cachedAddresses, offset);
        circularOffsets.put(hostname, new Integer((offset + 1) % cachedAddresses.length));
        return addrb;
    }

    private static final boolean areEquals(InetAddress[] add1, InetAddress[] add2) {
        if (add1.length != add2.length) {
            return false;
        }
        for (int i2 = 0; i2 < add1.length; ++i2) {
            if (add1[i2].equals(add2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] add, int nbOfRotation) {
        InetAddress[] addcp = new InetAddress[add.length];
        for (int i2 = 0; i2 < add.length; ++i2) {
            addcp[i2] = add[(i2 + nbOfRotation) % add.length];
        }
        return addcp;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    static {
        try {
            $$$methodRef$$$23 = TcpNTAdapter.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TcpNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TcpNTAdapter.class.getDeclaredMethod("getSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TcpNTAdapter.class.getDeclaredMethod("getInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TcpNTAdapter.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TcpNTAdapter.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpNTAdapter.class.getDeclaredMethod("getCopyAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpNTAdapter.class.getDeclaredMethod("areEquals", InetAddress[].class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpNTAdapter.class.getDeclaredMethod("getAddressesInCircularOrder", String.class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpNTAdapter.class.getDeclaredMethod("getAddressInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpNTAdapter.class.getDeclaredMethod("setReadTimeoutIfRequired", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpNTAdapter.class.getDeclaredMethod("isCharacteristicUrgentSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpNTAdapter.class.getDeclaredMethod("sendUrgentByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpNTAdapter.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpNTAdapter.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpNTAdapter.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpNTAdapter.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpNTAdapter.class.getDeclaredMethod("setSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpNTAdapter.class.getDeclaredMethod("getNetStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpNTAdapter.class.getDeclaredMethod("connect", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        inetaddressesCache = new Hashtable();
        circularOffsets = new Hashtable();
    }
}

