/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class OpaqueString
implements Serializable,
AutoCloseable {
    private char[] c;

    public static OpaqueString newOpaqueString(String s2) {
        OpaqueString os = new OpaqueString(s2);
        return os;
    }

    private OpaqueString(String s2) {
        if (s2 != null) {
            this.c = new char[s2.length()];
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                this.c[i2] = s2.charAt(i2);
            }
            this.xor();
        } else {
            this.c = null;
        }
    }

    public synchronized String get() {
        if (this.c == null) {
            return null;
        }
        this.xor();
        String str = new String(this.c);
        this.xor();
        return str;
    }

    @Override
    public void close() {
        Random rand = new Random();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ (char)rand.nextInt());
        }
    }

    private synchronized void xor() {
        Random rand = new Random(super.hashCode() + this.getClass().hashCode());
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ rand.nextInt());
        }
    }

    public boolean isNull() {
        return this.c == null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        short[] sh = new short[this.c.length * 2];
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            sh[i2] = (short)this.c[i2];
        }
        Random rand = new Random(super.hashCode() + this.getClass().hashCode());
        int i3 = this.c.length;
        int j2 = 0;
        while (i3 < 2 * this.c.length) {
            sh[i3] = (short)rand.nextInt();
            ++i3;
            ++j2;
        }
        oos.writeObject(sh);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i2;
        short[] sh = (short[])ois.readObject();
        this.c = new char[sh.length / 2];
        char[] ui = new char[sh.length / 2];
        int l2 = sh.length / 2;
        for (i2 = 0; i2 < l2; ++i2) {
            this.c[i2] = (char)sh[i2];
        }
        i2 = l2;
        int j2 = 0;
        while (i2 < 2 * l2) {
            ui[j2] = (char)sh[i2];
            ++i2;
            ++j2;
        }
        for (i2 = 0; i2 < l2; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ ui[i2]);
        }
        this.xor();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object obj) {
        OpaqueString os = (OpaqueString)obj;
        boolean bool = this.get().equals(os);
        return bool;
    }

    public int hashCode() {
        String str = this.get();
        int hashcode = str == null ? "".hashCode() : this.get().hashCode();
        return hashcode;
    }
}

