/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoscid
extends T4CTTIfun {
    static final int KPDUSR_CID_RESET = 1;
    static final int KPDUSR_PROXY_RESET = 2;
    static final int KPDUSR_PROXY_TKTSENT = 4;
    static final int KPDUSR_MODULE_RESET = 8;
    static final int KPDUSR_ACTION_RESET = 16;
    static final int KPDUSR_EXECID_RESET = 32;
    static final int KPDUSR_EXECSQ_RESET = 64;
    static final int KPDUSR_COLLCT_RESET = 128;
    static final int KPDUSR_CLINFO_RESET = 256;
    static final int KPDUSR_DBOP_RESET = 512;
    private byte[] cidcid;
    private byte[] cidmod;
    private byte[] cidact;
    private byte[] cideci;
    private byte[] ciddbop;
    private boolean[] endToEndHasChanged;
    private String[] endToEndValues;
    private int endToEndECIDSequenceNumber;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    T4CTTIoscid(T4CConnection _conn) {
        super(_conn, (byte)17);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$2, null, _conn);
            }
            this.cidcid = null;
            this.cidmod = null;
            this.cidact = null;
            this.cideci = null;
            this.ciddbop = null;
            this.endToEndHasChanged = null;
            this.endToEndValues = null;
            this.setFunCode((short)135);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOSCID(boolean[] blArray, String[] stringArray, int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _endToEndECIDSequenceNumber;
            void _endToEndValues;
            void _endToEndHasChanged;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$0, this, blArray, stringArray, n2);
            }
            this.endToEndHasChanged = _endToEndHasChanged;
            this.endToEndValues = _endToEndValues;
            this.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber;
            if (this.endToEndValues[1] != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "CLIENT ID: " + this.endToEndValues[1]);
                }
                this.cidcid = this.meg.conv.StringToCharBytes(this.endToEndValues[1]);
            } else {
                this.cidcid = null;
            }
            if (this.endToEndValues[3] != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "MODULE NAME: " + this.endToEndValues[3]);
                }
                this.cidmod = this.meg.conv.StringToCharBytes(this.endToEndValues[3]);
            } else {
                this.cidmod = null;
            }
            if (this.endToEndValues[0] != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "ACTION NAME: " + this.endToEndValues[0]);
                }
                this.cidact = this.meg.conv.StringToCharBytes(this.endToEndValues[0]);
            } else {
                this.cidact = null;
            }
            if (this.endToEndValues[2] != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "ECID: " + this.endToEndValues[2]);
                }
                this.cideci = this.meg.conv.StringToCharBytes(this.endToEndValues[2]);
            } else {
                this.cideci = null;
            }
            if (this.endToEndValues[4] != null) {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "DBOP NAME: " + this.endToEndValues[4]);
                }
                this.ciddbop = this.meg.conv.StringToCharBytes(this.endToEndValues[4]);
            } else {
                this.ciddbop = null;
            }
            this.doPigRPC();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int cidflag = 64;
            if (this.endToEndHasChanged[0]) {
                cidflag |= 0x10;
            }
            if (this.endToEndHasChanged[1]) {
                cidflag |= 1;
            }
            if (this.endToEndHasChanged[2]) {
                cidflag |= 0x20;
            }
            if (this.endToEndHasChanged[3]) {
                cidflag |= 8;
            }
            if (this.endToEndHasChanged[4]) {
                cidflag |= 0x200;
            }
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(cidflag);
            boolean sendClientId = false;
            boolean sendModule = false;
            boolean sendAction = false;
            boolean sendEcid = false;
            boolean sendDbop = false;
            if (this.endToEndHasChanged[1]) {
                this.meg.marshalPTR();
                if (this.cidcid != null) {
                    this.meg.marshalUB4(this.cidcid.length);
                } else {
                    this.meg.marshalUB4(0L);
                }
                sendClientId = true;
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            if (this.endToEndHasChanged[3]) {
                this.meg.marshalPTR();
                if (this.cidmod != null) {
                    this.meg.marshalUB4(this.cidmod.length);
                } else {
                    this.meg.marshalUB4(0L);
                }
                sendModule = true;
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            if (this.endToEndHasChanged[0]) {
                this.meg.marshalPTR();
                if (this.cidact != null) {
                    this.meg.marshalUB4(this.cidact.length);
                } else {
                    this.meg.marshalUB4(0L);
                }
                sendAction = true;
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            if (this.endToEndHasChanged[2]) {
                this.meg.marshalPTR();
                if (this.cideci != null) {
                    this.meg.marshalUB4(this.cideci.length);
                } else {
                    this.meg.marshalUB4(0L);
                }
                sendEcid = true;
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB2(0);
            this.meg.marshalUB2(this.endToEndECIDSequenceNumber);
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
            if (this.connection.getTTCVersion() >= 7) {
                if (this.endToEndHasChanged[4]) {
                    this.meg.marshalPTR();
                    if (this.ciddbop != null) {
                        this.meg.marshalUB4(this.ciddbop.length);
                    } else {
                        this.meg.marshalUB4(0L);
                    }
                    sendDbop = true;
                } else {
                    this.meg.marshalNULLPTR();
                    this.meg.marshalUB4(0L);
                }
            }
            if (sendClientId && this.cidcid != null) {
                this.meg.marshalCHR(this.cidcid);
            }
            if (sendModule && this.cidmod != null) {
                this.meg.marshalCHR(this.cidmod);
            }
            if (sendAction && this.cidact != null) {
                this.meg.marshalCHR(this.cidact);
            }
            if (sendEcid && this.cideci != null) {
                this.meg.marshalCHR(this.cideci);
            }
            if (sendDbop && this.ciddbop != null) {
                this.meg.marshalCHR(this.ciddbop);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoscid.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = T4CTTIoscid.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoscid.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoscid.class.getDeclaredMethod("doOSCID", boolean[].class, String[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

