/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoaqenq
extends T4CTTIfun {
    static final int AQTTC_ENQ_STREAMING_DISABLED = 0;
    static final int AQTTC_ENQ_STREAMING_ENABLED = 1;
    static final int AQTCC_OCI_ONE_PIECE = 0;
    static final int AQTCC_OCI_FIRST_PIECE = 1;
    static final int AQTCC_OCI_NEXT_PIECE = 2;
    static final int AQTCC_OCI_LAST_PIECE = 3;
    static final int AQENQVER_DEFAULT = 1;
    static final int AQENQVER_12_2 = 2;
    static final int AQENQVER_12_1 = 1;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    T4CTTIaqjms aqjms;
    private JMSEnqueueOptions enqueueOptions;
    private AQMessagePropertiesI messageProperties;
    private JMSMessageProperties jmsProp;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private byte[] senderAgentName;
    private byte[] senderAgentAddress;
    private byte senderAgentProtocol;
    private byte[] messageData;
    private byte[] messageOid;
    private int aqenqver;
    private AQAgentI[] attrRecipientList;
    private byte[][] recipientTextValues;
    private byte[][] recipientBinaryValues;
    private int[] recipientKeywords;
    private byte[] queueNameBytes;
    private byte[] outMsgId;
    private int bitMappedEnqueueOption;
    private byte[] headerPropBytes;
    private byte[] userPropBytes;
    private boolean retrieveMessageId;
    private boolean bStreamingMode;
    private int blockSize;
    private InputStream payloadStream;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    T4CTTIoaqenq(T4CConnection _connection) {
        super(_connection, (byte)3);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$13, null, _connection);
            }
            this.enqueueOptions = null;
            this.messageProperties = null;
            this.jmsProp = null;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
            this.messageData = null;
            this.messageOid = null;
            this.aqenqver = 0;
            this.attrRecipientList = null;
            this.recipientTextValues = null;
            this.recipientBinaryValues = null;
            this.recipientKeywords = null;
            this.queueNameBytes = null;
            this.outMsgId = null;
            this.bitMappedEnqueueOption = 0;
            this.retrieveMessageId = false;
            this.bStreamingMode = false;
            this.blockSize = 8192;
            this.payloadStream = null;
            this.setFunCode((short)184);
            this.toh = new T4Ctoh(_connection);
            this.aqm = new T4CTTIaqm(this.connection, this.toh);
            this.aqjms = new T4CTTIaqjms(this.connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doJMSEnq(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, byte[] byArray2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _messageData;
            void _messageOid;
            void _jmsProperties;
            void _messageProperties;
            void _enqueueOptions;
            void _queueName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$0, this, string, jMSEnqueueOptions, aQMessagePropertiesI, jMSMessageProperties, byArray, byArray2);
            }
            this.setStreamingMode(false);
            this.setInputStream(null);
            this.doJMSEnqRPC((String)_queueName, (JMSEnqueueOptions)_enqueueOptions, (AQMessagePropertiesI)_messageProperties, (JMSMessageProperties)_jmsProperties, (byte[])_messageOid, (byte[])_messageData);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doJMSEnqRPC(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, byte[] byArray2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _queueName;
            void _messageOid;
            void _messageData;
            void jmsProperties;
            void _messageProperties;
            void _enqueueOptions;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$1, this, string, jMSEnqueueOptions, aQMessagePropertiesI, jMSMessageProperties, byArray, byArray2);
            }
            this.enqueueOptions = _enqueueOptions;
            this.messageProperties = _messageProperties;
            this.jmsProp = jmsProperties;
            this.messageData = _messageData;
            if (this.messageProperties != null) {
                String aqmcor = this.messageProperties.getCorrelation();
                this.aqmcorBytes = (byte[])(aqmcor != null && aqmcor.length() != 0 ? this.meg.conv.StringToCharBytes(aqmcor) : null);
                String aqmeqn = this.messageProperties.getExceptionQueue();
                this.aqmeqnBytes = (byte[])(aqmeqn != null && aqmeqn.length() != 0 ? this.meg.conv.StringToCharBytes(aqmeqn) : null);
                AQAgentI senderAgent = (AQAgentI)this.messageProperties.getSender();
                if (senderAgent != null) {
                    this.senderAgentName = (byte[])(senderAgent.getName() != null ? this.meg.conv.StringToCharBytes(senderAgent.getName()) : null);
                    this.senderAgentAddress = (byte[])(senderAgent.getAddress() != null ? this.meg.conv.StringToCharBytes(senderAgent.getAddress()) : null);
                    this.senderAgentProtocol = (byte)senderAgent.getProtocol();
                } else {
                    this.senderAgentName = null;
                    this.senderAgentAddress = null;
                    this.senderAgentProtocol = 0;
                }
                this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
                if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                    this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                    this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                    this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                    for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                        if (this.attrRecipientList[i2].getName() != null) {
                            this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                        }
                        if (this.attrRecipientList[i2].getAddress() != null) {
                            this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                        }
                        this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                        this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                        this.recipientKeywords[3 * i2] = 3 * i2;
                        this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                        this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
                    }
                }
            } else {
                this.aqmcorBytes = null;
                this.aqmeqnBytes = null;
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.messageData = _messageData;
            this.messageOid = _messageOid;
            this.queueNameBytes = (byte[])(_queueName != null && _queueName.length() != 0 ? this.meg.conv.StringToCharBytes((String)_queueName) : null);
            this.bitMappedEnqueueOption = _enqueueOptions.getDeliveryMode().getCode() + _enqueueOptions.getVisibility().getCode();
            if (this.jmsProp != null) {
                this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
                this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
            } else {
                this.headerPropBytes = null;
                this.userPropBytes = null;
            }
            this.outMsgId = null;
            try {
                this.aqenqver = this.connection.getVersionNumber() >= 12200 && TypeDescriptor.isV2available((byte[])_messageOid) ? 2 : 1;
            }
            catch (Exception e2) {
                this.aqenqver = 1;
            }
            this.doRPC();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setStreamingMode(boolean bl) {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$2, this, bl);
            }
            this.bStreamingMode = flag;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setBlockSize(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _blockSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$3, this, n2);
            }
            if (_blockSize > 0) {
                this.blockSize = _blockSize;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setInputStream(InputStream inputStream) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void inputStream2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$4, this, inputStream);
            }
            this.payloadStream = inputStream2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doJMSEnq(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, InputStream inputStream, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _messageOid;
            void _jmsProperties;
            void _messageProperties;
            void _enqueueOptions;
            void _queueName;
            void _inputStream;
            void blockSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$5, this, string, jMSEnqueueOptions, aQMessagePropertiesI, jMSMessageProperties, byArray, inputStream, n2);
            }
            this.setStreamingMode(true);
            this.setBlockSize((int)blockSize);
            this.setInputStream((InputStream)_inputStream);
            this.doJMSEnqRPC((String)_queueName, (JMSEnqueueOptions)_enqueueOptions, (AQMessagePropertiesI)_messageProperties, (JMSMessageProperties)_jmsProperties, (byte[])_messageOid, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.queueNameBytes.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.aqm.initToDefaultValues();
            if (this.messageProperties != null) {
                this.aqm.aqmpri = this.messageProperties.getPriority();
                this.aqm.aqmdel = this.messageProperties.getDelay();
                this.aqm.aqmexp = this.messageProperties.getExpiration();
                this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
            }
            this.aqm.aqmcorBytes = this.aqmcorBytes;
            this.aqm.aqmeqnBytes = this.aqmeqnBytes;
            this.aqm.senderAgentName = this.senderAgentName;
            this.aqm.senderAgentAddress = this.senderAgentAddress;
            this.aqm.senderAgentProtocol = this.senderAgentProtocol;
            this.aqm.marshal();
            this.meg.marshalSB4(this.bitMappedEnqueueOption);
            if (this.jmsProp != null) {
                this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
                this.aqjms.aqjmshdrpcnt = 0;
                this.aqjms.aqjmsusrprpcnt = 0;
            } else {
                this.aqjms.aqjmsflags = 0;
                this.aqjms.aqjmshdrpcnt = 0;
                this.aqjms.aqjmsusrprpcnt = 0;
            }
            this.aqjms.aqjmshdrprop = this.headerPropBytes;
            this.aqjms.aqjmsuserprop = this.userPropBytes;
            this.aqjms.marshal();
            if (this.messageOid != null) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(16);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalUB2(this.aqenqver);
            this.meg.marshalNULLPTR();
            if (this.messageData != null) {
                this.meg.marshalPTR();
                this.meg.marshalUB4(this.messageData.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
            if (this.bStreamingMode) {
                this.meg.marshalSB4(1);
            } else {
                this.meg.marshalSB4(0);
            }
            if (this.enqueueOptions.isRetrieveMessageId()) {
                this.retrieveMessageId = true;
                this.meg.marshalPTR();
                this.meg.marshalSWORD(16);
            } else {
                this.retrieveMessageId = false;
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
                this.meg.marshalCHR(this.queueNameBytes);
            }
            if (this.messageOid != null) {
                this.meg.marshalB1Array(this.messageOid);
            }
            if (this.messageData != null) {
                this.meg.marshalB1Array(this.messageData);
            }
            if (this.bStreamingMode) {
                this.writeStreamingPayload();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeStreamingPayload() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int noOfBytesRead;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$7, this, new Object[0]);
            }
            byte[] bytearray = new byte[this.blockSize];
            boolean firstTime = true;
            while (true) {
                if ((noOfBytesRead = this.payloadStream.read(bytearray)) < this.blockSize) break;
                if (firstTime) {
                    this.writeFirst(bytearray, noOfBytesRead);
                    firstTime = false;
                    continue;
                }
                this.writeNext(bytearray, noOfBytesRead);
            }
            this.writeLast(bytearray, noOfBytesRead);
            this.payloadStream.close();
            this.payloadStream = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFirst(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _byteArray;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$8, this, byArray, n2);
            }
            this.meg.marshalUB1((short)1);
            this.meg.marshalSB8((long)length);
            this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeNext(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _byteArray;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$9, this, byArray, n2);
            }
            this.meg.marshalUB1((short)2);
            this.meg.marshalSB8((long)length);
            this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLast(byte[] byArray, int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$10, this, byArray, n2);
            }
            if (length > 0) {
                void _byteArray;
                this.meg.marshalUB1((short)3);
                this.meg.marshalSB8((long)length);
                this.meg.marshalB1Array((byte[])_byteArray, 0, (int)length);
            } else {
                this.meg.marshalUB1((short)3);
                this.meg.marshalSB8(0L);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.retrieveMessageId) {
                this.outMsgId = new byte[16];
                this.meg.unmarshalBuffer(this.outMsgId, 0, 16);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] getMsgId() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$12, this, new Object[0]);
            }
            byte[] byArray = this.outMsgId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$12, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$12, this, null);
            }
            return this.outMsgId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoaqenq.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = T4CTTIoaqenq.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoaqenq.class.getDeclaredMethod("getMsgId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoaqenq.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoaqenq.class.getDeclaredMethod("writeLast", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoaqenq.class.getDeclaredMethod("writeNext", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoaqenq.class.getDeclaredMethod("writeFirst", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoaqenq.class.getDeclaredMethod("writeStreamingPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoaqenq.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoaqenq.class.getDeclaredMethod("doJMSEnq", String.class, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSMessageProperties.class, byte[].class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoaqenq.class.getDeclaredMethod("setInputStream", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoaqenq.class.getDeclaredMethod("setBlockSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoaqenq.class.getDeclaredMethod("setStreamingMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoaqenq.class.getDeclaredMethod("doJMSEnqRPC", String.class, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSMessageProperties.class, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoaqenq.class.getDeclaredMethod("doJMSEnq", String.class, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSMessageProperties.class, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

