/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.ROWID;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class RowidAccessor
extends Accessor {
    static final int MAXLENGTH = 4000;
    static final int EXTENDED_ROWID_MAX_LENGTH = 18;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    RowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.ROWID, stmt, 4000, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, RowidAccessor.class, $$$methodRef$$$6, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 104, 9, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, RowidAccessor.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RowidAccessor.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RowidAccessor.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    RowidAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.ROWID, stmt, 4000, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, RowidAccessor.class, $$$methodRef$$$7, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 104, 9, form, false);
            this.initForDescribe(104, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, RowidAccessor.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RowidAccessor.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RowidAccessor.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, RowidAccessor.class, $$$methodRef$$$0, this, n2, n3, string);
            }
            if (external_type != false) {
                this.externalType = external_type;
            }
            this.byteLength = this.representationMaxLength + 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RowidAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RowidAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RowidAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, string);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, null);
                }
                return null;
            }
            String string = this.rowData.getString(this.getOffset((int)currentRow), this.getLength((int)currentRow), this.statement.connection.conversion.getCharacterSet((short)1));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RowidAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, RowidAccessor.class, $$$methodRef$$$2, this, n2);
            }
            ROWID rOWID = this.getROWID((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RowidAccessor.class, $$$methodRef$$$2, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RowidAccessor.class, $$$methodRef$$$2, this, null);
            }
            return rOWID;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RowidAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, RowidAccessor.class, $$$methodRef$$$3, this, n2);
            }
            ROWID rOWID = this.getROWID((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, RowidAccessor.class, $$$methodRef$$$3, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RowidAccessor.class, $$$methodRef$$$3, this, null);
            }
            return rOWID;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RowidAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ROWID getROWID(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            ROWID rOWID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, RowidAccessor.class, $$$methodRef$$$4, this, n2);
            }
            ROWID rOWID2 = rOWID = (b2 = this.getBytes((int)currentRow)) == null ? null : new ROWID(b2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, RowidAccessor.class, $$$methodRef$$$4, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RowidAccessor.class, $$$methodRef$$$4, this, null);
            }
            return rOWID2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RowidAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, RowidAccessor.class, $$$methodRef$$$5, this, n2, map);
            }
            ROWID rOWID = this.getROWID((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RowidAccessor.class, $$$methodRef$$$5, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RowidAccessor.class, $$$methodRef$$$5, this, null);
            }
            return rOWID;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RowidAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = RowidAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = RowidAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = RowidAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = RowidAccessor.class.getDeclaredMethod("getROWID", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = RowidAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = RowidAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RowidAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RowidAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

