/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFDCNQueryChanges;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNEvent
extends DatabaseChangeEvent {
    private static final long serialVersionUID = -1176415051550965782L;
    private int notifVersion;
    private int notifRegid;
    private DatabaseChangeEvent.EventType eventType;
    private DatabaseChangeEvent.AdditionalEventType additionalEventType;
    private String databaseName;
    private byte[] notifXid;
    private int notifScn1;
    private int notifScn2;
    private int numberOfTables;
    private NTFDCNTableChanges[] tcdesc;
    private int numberOfQueries;
    private NTFDCNQueryChanges[] qdesc;
    private long registrationId;
    private NTFConnection conn;
    private int csid;
    private boolean isReady;
    private ByteBuffer dataBuffer;
    private boolean isDeregistrationEvent;
    private short databaseVersion;
    private boolean isClientInitiatedConnection;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    NTFDCNEvent(long regId, byte[] rawBytes, short databaseVersion, int csid) {
        super(new Object());
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$14, null, regId, rawBytes, databaseVersion, csid);
            }
            this.notifVersion = 0;
            this.notifRegid = 0;
            this.additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
            this.databaseName = null;
            this.notifXid = new byte[8];
            this.notifScn1 = 0;
            this.notifScn2 = 0;
            this.numberOfTables = 0;
            this.tcdesc = null;
            this.numberOfQueries = 0;
            this.qdesc = null;
            this.isReady = false;
            this.isDeregistrationEvent = false;
            this.isClientInitiatedConnection = false;
            this.dataBuffer = ByteBuffer.wrap(rawBytes);
            this.databaseVersion = databaseVersion;
            this.isClientInitiatedConnection = true;
            this.registrationId = regId;
            this.csid = csid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    NTFDCNEvent(NTFConnection _conn, short _databaseVersion) throws IOException, InterruptedException {
        super(_conn);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$15, null, _conn, _databaseVersion);
            }
            this.notifVersion = 0;
            this.notifRegid = 0;
            this.additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
            this.databaseName = null;
            this.notifXid = new byte[8];
            this.notifScn1 = 0;
            this.notifScn2 = 0;
            this.numberOfTables = 0;
            this.tcdesc = null;
            this.numberOfQueries = 0;
            this.qdesc = null;
            this.isReady = false;
            this.isDeregistrationEvent = false;
            this.isClientInitiatedConnection = false;
            this.conn = _conn;
            this.csid = this.conn.charset.getOracleId();
            int lengthDataHandle = this.conn.readInt();
            byte[] data = new byte[lengthDataHandle];
            this.conn.readBuffer(data, 0, lengthDataHandle);
            this.dataBuffer = ByteBuffer.wrap(data);
            this.databaseVersion = _databaseVersion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    private void initEvent() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (!this.isClientInitiatedConnection) {
                block16: {
                    byte registrationType = this.dataBuffer.get();
                    int registrationLength = this.dataBuffer.getInt();
                    byte[] registrationBuffer = new byte[registrationLength];
                    this.dataBuffer.get(registrationBuffer, 0, registrationLength);
                    String registrationString = null;
                    try {
                        registrationString = new String(registrationBuffer, "UTF-8");
                        registrationString = registrationString.replaceFirst("CHNF", "");
                        this.registrationId = Long.parseLong(registrationString);
                    }
                    catch (Exception ex1) {
                        if (!bl) break block16;
                        this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "NTFDCNEvent.initEvent(): " + ex1.getMessage());
                    }
                }
                byte namespaceType = this.dataBuffer.get();
                int namespaceLength = this.dataBuffer.getInt();
                byte[] namespaceBuffer = new byte[namespaceLength];
                this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
                byte notificationType = this.dataBuffer.get();
                int n2 = this.dataBuffer.getInt();
            }
            if (this.dataBuffer.hasRemaining()) {
                this.notifVersion = this.dataBuffer.getShort();
                this.notifRegid = this.dataBuffer.getInt();
                this.eventType = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
                short notifDatabaseNameLength = this.dataBuffer.getShort();
                byte[] notifDatabaseNameBuffer = new byte[notifDatabaseNameLength];
                this.dataBuffer.get(notifDatabaseNameBuffer, 0, notifDatabaseNameLength);
                try {
                    this.databaseName = new String(notifDatabaseNameBuffer, "UTF-8");
                }
                catch (Exception registrationBuffer) {
                    // empty catch block
                }
                this.dataBuffer.get(this.notifXid);
                this.notifScn1 = this.dataBuffer.getInt();
                this.notifScn2 = this.dataBuffer.getShort();
                if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                    this.numberOfTables = this.dataBuffer.getShort();
                    this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
                    for (int i2 = 0; i2 < this.tcdesc.length; ++i2) {
                        this.tcdesc[i2] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
                    }
                } else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                    this.numberOfQueries = this.dataBuffer.getShort();
                    this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
                    for (int i3 = 0; i3 < this.numberOfQueries; ++i3) {
                        this.qdesc[i3] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
                    }
                }
            }
            this.isReady = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getDatabaseName() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            String string = this.databaseName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                TableChangeDescription[] tableChangeDescriptionArray = this.tcdesc;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, tableChangeDescriptionArray);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, null);
                }
                return this.tcdesc;
            }
            TableChangeDescription[] tableChangeDescriptionArray = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, tableChangeDescriptionArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public QueryChangeDescription[] getQueryChangeDescription() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                QueryChangeDescription[] queryChangeDescriptionArray = this.qdesc;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, queryChangeDescriptionArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, null);
                }
                return this.qdesc;
            }
            QueryChangeDescription[] queryChangeDescriptionArray = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, queryChangeDescriptionArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getTransactionId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            byte[] byArray = this.notifXid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$4, this, null);
            }
            return this.notifXid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getTransactionId(boolean bl) {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String ret;
            long xid_seq;
            int xid_slot;
            int xid_undo_seg;
            void isLittleEndian;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$5, this, bl);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (isLittleEndian == false) {
                xid_undo_seg = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
                xid_slot = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
                xid_seq = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
            } else {
                xid_undo_seg = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
                xid_slot = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
                xid_seq = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
            }
            String string = ret = xid_undo_seg + "." + xid_slot + "." + xid_seq;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setEventType(DatabaseChangeEvent.EventType eventType) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$6, this, new Object[]{eventType});
            }
            if (!this.isReady) {
                this.initEvent();
            }
            this.eventType = _type;
            if (this.eventType == DatabaseChangeEvent.EventType.DEREG) {
                this.isDeregistrationEvent = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType additionalEventType) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _adtype;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$7, this, new Object[]{additionalEventType});
            }
            this.additionalEventType = _adtype;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public DatabaseChangeEvent.EventType getEventType() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            DatabaseChangeEvent.EventType eventType = this.eventType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$8, this, (Object)eventType);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$8, this, null);
            }
            return eventType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public DatabaseChangeEvent.AdditionalEventType getAdditionalEventType() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$9, this, new Object[0]);
            }
            DatabaseChangeEvent.AdditionalEventType additionalEventType = this.additionalEventType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$9, this, (Object)additionalEventType);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$9, this, null);
            }
            return additionalEventType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isDeregistrationEvent() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl2 = this.isDeregistrationEvent;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getConnectionInformation() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.conn == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, string);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, null);
                }
                return null;
            }
            String string = this.conn.connectionDescription;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getRegistrationId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            int n2 = (int)this.registrationId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$12, this, n2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$12, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getRegId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            long l2 = this.registrationId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$13, this, l2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$13, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFDCNEvent.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        QueryChangeDescription[] qcd;
        TableChangeDescription[] tcd;
        if (!this.isReady) {
            this.initEvent();
        }
        StringBuffer sb = new StringBuffer();
        if (this.conn != null) {
            sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
        }
        sb.append("Registration ID         : " + this.registrationId + "\n");
        sb.append("Notification version    : " + this.notifVersion + "\n");
        sb.append("Event type              : " + this.eventType + "\n");
        if (this.additionalEventType != DatabaseChangeEvent.AdditionalEventType.NONE) {
            sb.append("Additional event type   : " + this.additionalEventType + "\n");
        }
        if (this.databaseName != null) {
            sb.append("Database name           : " + this.databaseName + "\n");
        }
        if ((tcd = this.getTableChangeDescription()) != null) {
            sb.append("Table Change Description (length=" + this.numberOfTables + ")\n");
            for (int i2 = 0; i2 < tcd.length; ++i2) {
                sb.append(tcd[i2].toString());
            }
        }
        if ((qcd = this.getQueryChangeDescription()) != null) {
            sb.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
            for (int i3 = 0; i3 < qcd.length; ++i3) {
                sb.append(qcd[i3].toString());
            }
        }
        return sb.toString();
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$15 = NTFDCNEvent.class.getDeclaredConstructor(NTFConnection.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NTFDCNEvent.class.getDeclaredConstructor(Long.TYPE, byte[].class, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFDCNEvent.class.getDeclaredMethod("getRegId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFDCNEvent.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFDCNEvent.class.getDeclaredMethod("getConnectionInformation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFDCNEvent.class.getDeclaredMethod("isDeregistrationEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFDCNEvent.class.getDeclaredMethod("getAdditionalEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFDCNEvent.class.getDeclaredMethod("getEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFDCNEvent.class.getDeclaredMethod("setAdditionalEventType", DatabaseChangeEvent.AdditionalEventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFDCNEvent.class.getDeclaredMethod("setEventType", DatabaseChangeEvent.EventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFDCNEvent.class.getDeclaredMethod("getTransactionId", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFDCNEvent.class.getDeclaredMethod("getTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFDCNEvent.class.getDeclaredMethod("getQueryChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNEvent.class.getDeclaredMethod("getTableChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNEvent.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNEvent.class.getDeclaredMethod("initEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

