/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFAQEvent
extends AQNotificationEvent {
    private static final long serialVersionUID = 4073258592022522641L;
    private String registrationString;
    private int namespace;
    private byte[] payload;
    private String queueName;
    private byte[] messageId;
    private String consumerName;
    private NTFConnection conn;
    private AQMessagePropertiesI msgProp;
    private AQNotificationEvent.EventType eventType;
    private AQNotificationEvent.AdditionalEventType additionalEventType;
    private ByteBuffer dataBuffer;
    private boolean isReady;
    private short databaseVersion;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    NTFAQEvent(NTFConnection _conn, short _databaseVersion) throws IOException, InterruptedException {
        super(_conn);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$13, null, _conn, _databaseVersion);
            }
            this.queueName = null;
            this.messageId = null;
            this.consumerName = null;
            this.eventType = AQNotificationEvent.EventType.REGULAR;
            this.additionalEventType = AQNotificationEvent.AdditionalEventType.NONE;
            this.isReady = false;
            this.conn = _conn;
            int lengthDataHandle = this.conn.readInt();
            byte[] data = new byte[lengthDataHandle];
            this.conn.readBuffer(data, 0, lengthDataHandle);
            this.dataBuffer = ByteBuffer.wrap(data);
            this.databaseVersion = _databaseVersion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    private void initEvent() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$0, this, new Object[0]);
            }
            byte registrationType = this.dataBuffer.get();
            int registrationLength = this.dataBuffer.getInt();
            byte[] registrationBuffer = new byte[registrationLength];
            this.dataBuffer.get(registrationBuffer, 0, registrationLength);
            this.registrationString = this.conn.charset.toString(registrationBuffer, 0, registrationLength);
            byte namespaceType = this.dataBuffer.get();
            int namespaceLength = this.dataBuffer.getInt();
            byte[] namespaceBuffer = new byte[namespaceLength];
            this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
            this.namespace = namespaceBuffer[0];
            byte notificationType = this.dataBuffer.get();
            int notificationLength = this.dataBuffer.getInt();
            if (notificationLength > 0) {
                this.payload = new byte[notificationLength];
                this.dataBuffer.get(this.payload, 0, notificationLength);
            } else {
                this.payload = null;
            }
            if (this.dataBuffer.hasRemaining()) {
                int deliveryMode = 0;
                if (this.databaseVersion >= 10200) {
                    byte deliveryModeType = this.dataBuffer.get();
                    int deliveryModeLength = this.dataBuffer.getInt();
                    deliveryMode = this.dataBuffer.getInt();
                }
                byte queueNameType = this.dataBuffer.get();
                int queueNameLength = this.dataBuffer.getInt();
                byte[] queueNameBuffer = new byte[queueNameLength];
                this.dataBuffer.get(queueNameBuffer, 0, queueNameLength);
                this.queueName = this.conn.charset.toString(queueNameBuffer, 0, queueNameLength);
                byte messageIdType = this.dataBuffer.get();
                int messageIdLength = this.dataBuffer.getInt();
                this.messageId = new byte[messageIdLength];
                this.dataBuffer.get(this.messageId, 0, messageIdLength);
                byte consumerNameType = this.dataBuffer.get();
                int consumerNameLength = this.dataBuffer.getInt();
                byte[] consumerNameBuffer = new byte[consumerNameLength];
                this.dataBuffer.get(consumerNameBuffer, 0, consumerNameLength);
                this.consumerName = this.conn.charset.toString(consumerNameBuffer, 0, consumerNameLength);
                byte prioritySignType = this.dataBuffer.get();
                int prioritySignLength = this.dataBuffer.getInt();
                byte[] prioritySign = new byte[prioritySignLength];
                this.dataBuffer.get(prioritySign, 0, prioritySignLength);
                byte priorityType = this.dataBuffer.get();
                int priorityLength = this.dataBuffer.getInt();
                int priority_l = this.dataBuffer.getInt();
                if (prioritySign[0] == 1) {
                    priority_l = -priority_l;
                }
                int priority = priority_l;
                byte delayType = this.dataBuffer.get();
                int delayLength = this.dataBuffer.getInt();
                int delay = this.dataBuffer.getInt();
                byte expirationSignType = this.dataBuffer.get();
                int expirationSignLength = this.dataBuffer.getInt();
                byte[] expirationSign = new byte[expirationSignLength];
                this.dataBuffer.get(expirationSign, 0, expirationSignLength);
                byte expirationType = this.dataBuffer.get();
                int expirationLength = this.dataBuffer.getInt();
                int expiration_l = this.dataBuffer.getInt();
                if (expirationSign[0] == 1) {
                    expiration_l = -expiration_l;
                }
                int expiration = expiration_l;
                byte attemptsType = this.dataBuffer.get();
                int attemptsLength = this.dataBuffer.getInt();
                int attempts = this.dataBuffer.getInt();
                byte timestampType = this.dataBuffer.get();
                int timestampLength = this.dataBuffer.getInt();
                byte[] timestampBytes = new byte[timestampLength];
                this.dataBuffer.get(timestampBytes, 0, timestampLength);
                TIMESTAMP timestamp = new TIMESTAMP(timestampBytes);
                byte stateBType = this.dataBuffer.get();
                int stateBLength = this.dataBuffer.getInt();
                byte[] stateB = new byte[stateBLength];
                this.dataBuffer.get(stateB, 0, stateBLength);
                byte state = stateB[0];
                byte exceptionQueueType = this.dataBuffer.get();
                int exceptionQueueLength = this.dataBuffer.getInt();
                byte[] exceptionQueueBuffer = new byte[exceptionQueueLength];
                this.dataBuffer.get(exceptionQueueBuffer, 0, exceptionQueueLength);
                String exceptionQueue = this.conn.charset.toString(exceptionQueueBuffer, 0, exceptionQueueLength);
                byte correlationIdType = this.dataBuffer.get();
                int correlationIdLength = this.dataBuffer.getInt();
                byte[] correlationIdBuff = new byte[correlationIdLength];
                this.dataBuffer.get(correlationIdBuff, 0, correlationIdLength);
                String correlationId = this.conn.charset.toString(correlationIdBuff, 0, correlationIdLength);
                byte originalMessageIdType = this.dataBuffer.get();
                int originalMessageIdLength = this.dataBuffer.getInt();
                byte[] originalMessageId = null;
                if (originalMessageIdLength > 0) {
                    originalMessageId = new byte[originalMessageIdLength];
                    this.dataBuffer.get(originalMessageId, 0, originalMessageIdLength);
                }
                byte agentNameType = this.dataBuffer.get();
                int agentNameLength = this.dataBuffer.getInt();
                byte[] agentNameBuffer = new byte[agentNameLength];
                this.dataBuffer.get(agentNameBuffer, 0, agentNameLength);
                String agentName = this.conn.charset.toString(agentNameBuffer, 0, agentNameLength);
                byte agentAddressType = this.dataBuffer.get();
                int agentAddressLength = this.dataBuffer.getInt();
                byte[] agentAddressBuffer = new byte[agentAddressLength];
                this.dataBuffer.get(agentAddressBuffer, 0, agentAddressLength);
                String agentAddress = this.conn.charset.toString(agentAddressBuffer, 0, agentAddressLength);
                byte agentProtocolType = this.dataBuffer.get();
                int agentProtocolLength = this.dataBuffer.getInt();
                byte agentProtocol = this.dataBuffer.get();
                this.msgProp = new AQMessagePropertiesI();
                this.msgProp.setAttempts(attempts);
                this.msgProp.setCorrelation(correlationId);
                this.msgProp.setDelay(delay);
                this.msgProp.setEnqueueTime(timestamp.timestampValue());
                this.msgProp.setMessageState(AQMessageProperties.MessageState.getMessageState(state));
                if (this.databaseVersion >= 10200) {
                    this.msgProp.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(deliveryMode));
                }
                this.msgProp.setPreviousQueueMessageId(originalMessageId);
                AQAgentI senderAgent = new AQAgentI();
                senderAgent.setAddress(agentAddress);
                senderAgent.setName(agentName);
                senderAgent.setProtocol(agentProtocol);
                this.msgProp.setSender(senderAgent);
                this.msgProp.setPriority(priority);
                this.msgProp.setExpiration(expiration);
                this.msgProp.setExceptionQueue(exceptionQueue);
            }
            this.isReady = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AQMessageProperties getMessageProperties() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            AQMessagePropertiesI aQMessagePropertiesI = this.msgProp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$1, this, aQMessagePropertiesI);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$1, this, null);
            }
            return aQMessagePropertiesI;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getRegistration() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            String string = this.registrationString;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AQNotificationEvent.EventType getEventType() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$3, this, new Object[0]);
            }
            AQNotificationEvent.EventType eventType = this.eventType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$3, this, (Object)eventType);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$3, this, null);
            }
            return eventType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AQNotificationEvent.AdditionalEventType getAdditionalEventType() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$4, this, new Object[0]);
            }
            AQNotificationEvent.AdditionalEventType additionalEventType = this.additionalEventType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$4, this, (Object)additionalEventType);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$4, this, null);
            }
            return additionalEventType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setEventType(AQNotificationEvent.EventType eventType) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$5, this, new Object[]{eventType});
            }
            this.eventType = _type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setAdditionalEventType(AQNotificationEvent.AdditionalEventType additionalEventType) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _adtype;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$6, this, new Object[]{additionalEventType});
            }
            this.additionalEventType = _adtype;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getPayload() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            byte[] byArray = this.payload;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$7, this, null);
            }
            return this.payload;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getQueueName() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            String string = this.queueName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$8, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getMessageId() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            byte[] byArray = this.messageId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$9, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$9, this, null);
            }
            return this.messageId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getConsumerName() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (!this.isReady) {
                this.initEvent();
            }
            String string = this.consumerName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getConnectionInformation() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = this.conn.connectionDescription;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        if (!this.isReady) {
            try {
                this.initEvent();
            }
            catch (SQLException ex) {
                return ex.getMessage();
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
        sb.append("Event type              : " + this.eventType + "\n");
        if (this.additionalEventType != AQNotificationEvent.AdditionalEventType.NONE) {
            sb.append("Additional event type   : " + this.additionalEventType + "\n");
        }
        sb.append("Namespace               : " + this.namespace + "\n");
        sb.append("Registration            : " + this.registrationString + "\n");
        sb.append("Queue name              : " + this.queueName + "\n");
        sb.append("Consumer name           : " + this.consumerName + "\n");
        if (this.payload != null) {
            sb.append("Payload length          : " + this.payload.length + "\n");
            sb.append("Payload (first 50 bytes): " + NTFAQEvent.byteBufferToHexString(this.payload, 50) + "\n");
        } else {
            sb.append("Payload                 : null\n");
        }
        sb.append("Message ID              : " + NTFAQEvent.byteBufferToHexString(this.messageId, 50) + "\n");
        if (this.msgProp != null) {
            sb.append(this.msgProp.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    static final String byteBufferToHexString(byte[] byArray, int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String ret;
            void maxNbOfBytes;
            byte[] buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, byArray, n2);
            }
            if (buffer == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, string);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            boolean isFirst = true;
            StringBuffer sb = new StringBuffer();
            for (int offset = 0; offset < buffer.length && offset < maxNbOfBytes; ++offset) {
                if (!isFirst) {
                    sb.append(' ');
                } else {
                    isFirst = false;
                }
                Object hexrep = Integer.toHexString(buffer[offset] & 0xFF);
                if (((String)hexrep).length() == 1) {
                    hexrep = "0" + (String)hexrep;
                }
                sb.append((String)hexrep);
            }
            String string = ret = sb.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFAQEvent.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = NTFAQEvent.class.getDeclaredConstructor(NTFConnection.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFAQEvent.class.getDeclaredMethod("byteBufferToHexString", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFAQEvent.class.getDeclaredMethod("getConnectionInformation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFAQEvent.class.getDeclaredMethod("getConsumerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFAQEvent.class.getDeclaredMethod("getMessageId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFAQEvent.class.getDeclaredMethod("getQueueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFAQEvent.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFAQEvent.class.getDeclaredMethod("setAdditionalEventType", AQNotificationEvent.AdditionalEventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFAQEvent.class.getDeclaredMethod("setEventType", AQNotificationEvent.EventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFAQEvent.class.getDeclaredMethod("getAdditionalEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFAQEvent.class.getDeclaredMethod("getEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFAQEvent.class.getDeclaredMethod("getRegistration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFAQEvent.class.getDeclaredMethod("getMessageProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFAQEvent.class.getDeclaredMethod("initEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

