/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEvent;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.StateSignatures;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.EndReplayCallback;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnFailoverManager;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class TxnFailoverManagerImpl
implements TxnFailoverManager,
LogicalTransactionIdEventListener {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle;
    private static final int DIRECTIVE_ENQUEUE_CALL = 1;
    private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
    private static final int DIRECTIVE_REPLAY_ENABLED = 4;
    private static final int DIRECTIVE_EMPTY_QUEUE = 8;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries;
    private LogicalTransactionId ltxid;
    private LogicalTransactionId oldLtxidForPrepareReplay;
    private LogicalTransactionId ltxidAtOriginalOutage;
    private ReplayContext[] replayContext;
    private ReplayContext cxtBeforePrepareReplay;
    private OracleDataSource replayDataSource;
    private TxnReplayableBase connectionProxy;
    private oracle.jdbc.internal.OracleConnection originalOconn;
    private int lastCxtLenAtOriginalOutage;
    private String connectionProxyName;
    private Method callHittingOutage;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn;
    private boolean isReplayInDynamicMode;
    private boolean isStateRestorationEnabled;
    boolean isAutoAC;
    private Properties savedSessionProps;
    private Properties savedClientInfo;
    private boolean savedAutoCommit;
    private StateSignatures savedStateSignatures;
    private static final long SIG_FLAGS_NO_CHANGES = 1L;
    private static final long SIG_FLAGS_CLIENT_RESTORABLE_CHANGES = 2L;
    private static final long SIG_FLAGS_SERVER_RESTORABLE_CHANGES = 4L;
    private static final long SIG_FLAGS_SIDE_EFFECT_CHANGES = 8L;
    private static final long SIG_FLAGS_CAN_CHANGE_STATE = 16L;
    private static final long SIG_FLAGS_UNRESTORABLE_CHANGES = 32L;
    boolean needStateSignatureSyncUp;
    private static final int QUEUE_NUMBER = 2;
    private static final int NOT_IN_QUEUE = -1;
    private static int activeQueues;
    private static final int INIT_EMPTY_COUNT = 0;
    private static final int NA_EMPTY_COUNT = -1;
    private static final int REQ_SCOPE_EMPTY_COUNT = Integer.MAX_VALUE;
    private int[] queueEmptyCounts;
    boolean seenRoundtripCallInRequest;
    boolean didReplayingLastCallDisableReplay;
    short nestedLevelOfTopLevelCalls;
    private static final HashSet<String> postExecuteGetCalls;
    private static final String NULL_METHOD_NAME = "NULL METHOD";
    ReplayStatisticsImpl acStatistics;
    private boolean callingDisableFromEndRequest;
    boolean lobStreamInRequest;
    int originalReadTimeout;
    private static final int MIN_READ_TIMEOUT_RAC_DG = 120000;
    private static final ExecutorService executor;
    static boolean disabledDueToMemoryLimit;
    static long disabledDueToMemoryLimitTS;
    private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
    private static final String PREPARE_REPLAY_2 = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER, sig_flags IN NUMBER, client_sig IN NUMBER, server_sig IN NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded, sig_flags, client_sig, server_sig); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?,?,?,?); END;";
    static final String NLS_CALENDAR_PROPERTY = "AUTH_NLS_LXCCALENDAR";
    static final String NLS_CURRENCY_PROPERTY = "AUTH_NLS_LXCCURRENCY";
    static final String NLS_DATE_FORMAT_PROPERTY = "AUTH_NLS_LXCDATEFM";
    static final String NLS_DATE_LANGUAGE_PROPERTY = "AUTH_NLS_LXCDATELANG";
    static final String NLS_DUAL_CURRENCY_PROPERTY = "AUTH_NLS_LXCUNIONCUR";
    static final String NLS_ISO_CURRENCY_PROPERTY = "AUTH_NLS_LXCISOCURR";
    static final String NLS_LANGUAGE_PROPERTY = "AUTH_NLS_LXLAN";
    static final String NLS_LENGTH_SEMANTICS_PROPERTY = "SESSION_NLS_LXCNLSLENSEM";
    static final String NLS_NCHAR_CONV_EXCP_PROPERTY = "SESSION_NLS_LXCNCHAREXCP";
    static final String NLS_NUMERIC_CHARACTERS_PROPERTY = "AUTH_NLS_LXCNUMERICS";
    static final String NLS_SORT_PROPERTY = "AUTH_NLS_LXCSORT";
    static final String NLS_TERRITORY_PROPERTY = "AUTH_NLS_LXCTERRITORY";
    static final String NLS_TIME_FORMAT_PROPERTY = "AUTH_NLS_LXCTIMEFM";
    static final String NLS_TIME_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCTTZNFM";
    static final String NLS_TIMESTAMP_FORMAT_PROPERTY = "AUTH_NLS_LXCSTMPFM";
    static final String NLS_TIMESTAMP_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCSTZNFM";
    static final String TIME_ZONE_PROPERTY = "SESSION_TIME_ZONE";
    static final String CONTAINER_PROPERTY = "CONTAINER_NAME";
    static final String SERVICE_PROPERTY = "SERVICE_NAME";
    static final String ERROR_OVERLAP_PROPERTY = "AL8KW_ERR_OVLAP";
    static final String SCHEMA_NAME_PROPERTY = "AL8KW_SCHEMA_NAME";
    static final String ENABLED_ROLE_NAMES_PROPERTY = "AL8KW_ENABLED_ROLE_NAMES";
    static final String EDITION_PROPERTY = "AUTH_ORA_EDITION";
    static final String SQL_TXLP_PROPERTY = "AL8KW_SQL_TXLP";
    static final String FSQL_SNTX_PROPERTY = "AL8KW_FSQL_SNTX";
    static final String ROW_ARCHIVAL_PROPERTY = "AL8KW_ROW_ARCHIVAL";
    static final String OPENCURSORS_PROPERTY = "AL8KW_OPENCURSORS";
    static final String CLIENT_INFO_PROPERTY = "AL8KW_CLIENT_INFO";
    private static final String CONTAINER_QUERY = "select sys_context('userenv','con_name') from dual";
    private static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    private static final int FAILOVER_TYPE_TRANSACTION = 8;
    private static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    private static final int FAILOVER_TYPE_AUTO = 32;
    private static final int KWFCSFLAGS_RESTORE_AUTO = 2;
    private static final BigInteger MASK;
    private static final MemGuardListener MEMGUARD_LISTENER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;

    private TxnFailoverManagerImpl(TxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$68, null, connProxy, rds);
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            this.replayInitiationTimeout = 300L;
            this.replayRetries = 0;
            this.ltxid = null;
            this.oldLtxidForPrepareReplay = null;
            this.ltxidAtOriginalOutage = null;
            this.replayContext = null;
            this.replayDataSource = null;
            this.originalOconn = null;
            this.lastCxtLenAtOriginalOutage = 0;
            this.doNotAbortConn = false;
            this.isReplayInDynamicMode = true;
            this.isStateRestorationEnabled = false;
            this.isAutoAC = false;
            this.savedSessionProps = null;
            this.savedClientInfo = null;
            this.savedAutoCommit = true;
            this.savedStateSignatures = null;
            this.needStateSignatureSyncUp = false;
            this.queueEmptyCounts = new int[2];
            this.seenRoundtripCallInRequest = false;
            this.didReplayingLastCallDisableReplay = false;
            this.nestedLevelOfTopLevelCalls = 0;
            this.acStatistics = null;
            this.callingDisableFromEndRequest = false;
            this.lobStreamInRequest = false;
            this.originalReadTimeout = 0;
            this.connectionProxy = connProxy;
            this.connectionProxyName = this.connectionProxy.thisProxyNameInLog;
            this.replayDataSource = rds;
            oracle.jdbc.internal.OracleConnection pconn = (oracle.jdbc.internal.OracleConnection)connProxy.getDelegate();
            this.ltxid = pconn.getLogicalTransactionId();
            this.replayContext = null;
            activeQueues = 2;
            this.queueEmptyCounts = new int[2];
            for (int i2 = 0; i2 < activeQueues; ++i2) {
                this.queueEmptyCounts[i2] = 0;
            }
            pconn.addLogicalTransactionIdEventListener(this);
            if (bl) {
                OracleLog.log($$$loggerRef$$$68, Level.FINEST, this.getClass(), $$$methodRef$$$68, "On {0}, registered LTXID callback", this.connectionProxyName);
            }
            this.acStatistics = new ReplayStatisticsImpl();
            this.replayDataSource.updateReplayStatistics(this.acStatistics);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$68, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$68, null);
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$68, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$68, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static TxnFailoverManager getFailoverManager(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rds;
            TxnReplayableBase connProxy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$0, null, txnReplayableBase, oracleDataSource);
            }
            TxnFailoverManagerImpl txnFailoverManagerImpl = new TxnFailoverManagerImpl(connProxy, (OracleDataSource)rds);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$0, null, txnFailoverManagerImpl);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$0, null, null);
            }
            return txnFailoverManagerImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void append(CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$1, this, callHistoryEntry);
            }
            entry.prevEntry = this.tail;
            entry.nextEntry = null;
            if (this.tail != null) {
                this.tail.nextEntry = entry;
            }
            this.tail = entry;
            if (this.head == null) {
                this.head = entry;
            }
            JDBCReplayable jdbcProxy = (JDBCReplayable)entry.jdbcProxy;
            jdbcProxy.addToSameProxyList((CallHistoryEntry)entry);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void remove(CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$2, this, callHistoryEntry);
            }
            if (entry.nextEntry != null) {
                entry.nextEntry.prevEntry = entry.prevEntry;
            }
            if (entry.prevEntry != null) {
                entry.prevEntry.nextEntry = entry.nextEntry;
            }
            if (this.head == entry) {
                this.head = entry.nextEntry;
            }
            if (this.tail == entry) {
                this.tail = entry.prevEntry;
            }
            JDBCReplayable jdbcProxy = (JDBCReplayable)entry.jdbcProxy;
            jdbcProxy.removeFromSameProxyList((CallHistoryEntry)entry);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            CallHistoryEntry callHistoryEntry;
            block14: {
                void m2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, object, method, objectArray, string);
                }
                if (disabledDueToMemoryLimit) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$3, Level.WARNING, this.getClass(), $$$methodRef$$$3, "On {0}, DISABLE REPLAY due to insufficient memory", this.connectionProxyName);
                    }
                    this.disableReplayInternal((Method)m2, 367, "Replay disabled because of insufficient memory", null);
                    this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
                    CallHistoryEntry callHistoryEntry2 = null;
                    if (!bl) return null;
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, callHistoryEntry2);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, null);
                    return null;
                }
                this.acStatistics.incrementTotalProtectedCalls();
                if (this.tail != null && this.tail.method != null && "started".equals(this.tail.callStatus)) {
                    this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls + 1);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "On {0}, SKIP recording method {1}, nested-level: {2}", new Object[]{this.connectionProxyName, m2.getName(), this.nestedLevelOfTopLevelCalls});
                    }
                    CallHistoryEntry callHistoryEntry3 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, callHistoryEntry3);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, null);
                    }
                    return null;
                }
                TxnFailoverManagerImpl txnFailoverManagerImpl = this;
                synchronized (txnFailoverManagerImpl) {
                    try {
                        void callStatus;
                        void args;
                        void jdbcProxy;
                        CallHistoryEntry entry = new CallHistoryEntry(jdbcProxy, (Method)m2, (Object[])args, (String)callStatus);
                        this.append(entry);
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "On {0}, recording method {1}", new Object[]{this.connectionProxyName, m2.getName()});
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl32 : MonitorExitStatement: MONITOREXIT : txnFailoverManagerImpl
                        callHistoryEntry = entry;
                        if (!bl) break block14;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl37 : MonitorExitStatement: MONITOREXIT : txnFailoverManagerImpl
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, callHistoryEntry);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, null);
            }
            return callHistoryEntry;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    private String dumpHistory() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$4, this, new Object[0]);
            }
            Object ret = "Dump History: \n";
            if (this.head != null) {
                CallHistoryEntry entry = this.head;
                while (true) {
                    ret = (String)ret + entry.toString();
                    if (entry == this.tail) break;
                    entry = entry.nextEntry;
                }
            }
            String string = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$4, this, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$4, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            short thisReplayQueueId;
            int replayDirective;
            ReplayContext thisReplayContext;
            int i2;
            void e2;
            CallHistoryEntry entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, object, callHistoryEntry, object2, string, l2, sQLException);
            }
            if (this.nestedLevelOfTopLevelCalls > 0) {
                this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls - 1);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On {0}, SKIP updating method", this.connectionProxyName);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                }
                return;
            }
            ReplayContext[] drvrReplayContext = null;
            boolean disableReplayFlag = false;
            ReplayContext[] contextToRecord = null;
            int queueIdToRecord = -1;
            int queueEmptyCountToRecord = 0;
            boolean requestScopeCursor = false;
            boolean serverAsksToEnqueue = false;
            try {
                oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                drvrReplayContext = oconn.getReplayContext();
                Object object3 = entry = e2 == null ? this.tail : e2;
            }
            catch (SQLException exc) {
                try {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$5, Level.WARNING, this.getClass(), $$$methodRef$$$5, "On {0}, could not get ReplayContext: {1}", new Object[]{this.connectionProxyName, exc});
                    }
                    disableReplayFlag = true;
                    Object object4 = entry = e2 == null ? this.tail : e2;
                }
                catch (Throwable throwable) {
                    CallHistoryEntry entry2;
                    Object object5 = entry2 = e2 == null ? this.tail : e2;
                    if (!disableReplayFlag) {
                        if (drvrReplayContext != null) {
                            this.replayContext = drvrReplayContext;
                            contextToRecord = new ReplayContext[drvrReplayContext.length];
                            if (drvrReplayContext.length > 0) {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, roundtrip in current request", this.connectionProxyName);
                                }
                                this.seenRoundtripCallInRequest = true;
                                this.needStateSignatureSyncUp = false;
                            }
                            for (int i3 = 0; i3 < drvrReplayContext.length; ++i3) {
                                ReplayContext thisReplayContext2 = drvrReplayContext[i3];
                                int replayDirective2 = (int)thisReplayContext2.getDirectives();
                                short thisReplayQueueId2 = thisReplayContext2.getQueue();
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, new CM directive (in binary): {1}, queue Id: {2}", new Object[]{this.connectionProxyName, Integer.toBinaryString(replayDirective2), (int)thisReplayQueueId2});
                                }
                                if ((replayDirective2 & 4) == 0) {
                                    if (bl) {
                                        OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: DISABLE REPLAY", this.connectionProxyName);
                                    }
                                    disableReplayFlag = true;
                                    if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                        this.didReplayingLastCallDisableReplay = true;
                                    }
                                    long svrErrorCode = thisReplayContext2.getErrorCode();
                                    this.disableReplayInternal(entry2.method, 384, "Replay disabled by server Continuity Management", null);
                                    if (bl) {
                                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                                    }
                                    return;
                                }
                                if ((replayDirective2 & 8) == 8) {
                                    if (bl) {
                                        OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: EMPTY_QUEUE({1})", new Object[]{this.connectionProxyName, (int)thisReplayQueueId2});
                                    }
                                    short s2 = thisReplayQueueId2;
                                    this.queueEmptyCounts[s2] = this.queueEmptyCounts[s2] + 1;
                                }
                                if (!$assertionsDisabled && (replayDirective2 & 1) != 1 && serverAsksToEnqueue) {
                                    AssertionError assertionError = new AssertionError((Object)"AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call");
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                                    }
                                    throw assertionError;
                                }
                                if ((replayDirective2 & 1) == 1) {
                                    if (bl) {
                                        OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: RECORD CALL", this.connectionProxyName);
                                    }
                                    contextToRecord[i3] = thisReplayContext2;
                                    queueIdToRecord = thisReplayQueueId2;
                                    queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId2];
                                    serverAsksToEnqueue = true;
                                }
                                if ((replayDirective2 & 2) != 2) continue;
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: REQUEST-SCOPE CURSOR", this.connectionProxyName);
                                }
                                requestScopeCursor = true;
                            }
                        } else {
                            if (entry2.replayContext != null) {
                                if (bl) {
                                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                                }
                                return;
                            }
                            queueIdToRecord = -1;
                            queueEmptyCountToRecord = 0;
                        }
                    } else {
                        this.disableReplayInternal(entry2.method, 383, "Replay disabled because getting replay context failed", null);
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
                if (!disableReplayFlag) {
                    if (drvrReplayContext != null) {
                        this.replayContext = drvrReplayContext;
                        contextToRecord = new ReplayContext[drvrReplayContext.length];
                        if (drvrReplayContext.length > 0) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, roundtrip in current request", this.connectionProxyName);
                            }
                            this.seenRoundtripCallInRequest = true;
                            this.needStateSignatureSyncUp = false;
                        }
                        for (i2 = 0; i2 < drvrReplayContext.length; ++i2) {
                            thisReplayContext = drvrReplayContext[i2];
                            replayDirective = (int)thisReplayContext.getDirectives();
                            thisReplayQueueId = thisReplayContext.getQueue();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, new CM directive (in binary): {1}, queue Id: {2}", new Object[]{this.connectionProxyName, Integer.toBinaryString(replayDirective), (int)thisReplayQueueId});
                            }
                            if ((replayDirective & 4) == 0) {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: DISABLE REPLAY", this.connectionProxyName);
                                }
                                disableReplayFlag = true;
                                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                    this.didReplayingLastCallDisableReplay = true;
                                }
                                long svrErrorCode = thisReplayContext.getErrorCode();
                                this.disableReplayInternal(entry.method, 384, "Replay disabled by server Continuity Management", null);
                                if (bl) {
                                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                                }
                                return;
                            }
                            if ((replayDirective & 8) == 8) {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: EMPTY_QUEUE({1})", new Object[]{this.connectionProxyName, (int)thisReplayQueueId});
                                }
                                short s3 = thisReplayQueueId;
                                this.queueEmptyCounts[s3] = this.queueEmptyCounts[s3] + 1;
                            }
                            if (!$assertionsDisabled && (replayDirective & 1) != 1 && serverAsksToEnqueue) {
                                AssertionError assertionError = new AssertionError((Object)"AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call");
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                                }
                                throw assertionError;
                            }
                            if ((replayDirective & 1) == 1) {
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: RECORD CALL", this.connectionProxyName);
                                }
                                contextToRecord[i2] = thisReplayContext;
                                queueIdToRecord = thisReplayQueueId;
                                queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId];
                                serverAsksToEnqueue = true;
                            }
                            if ((replayDirective & 2) != 2) continue;
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: REQUEST-SCOPE CURSOR", this.connectionProxyName);
                            }
                            requestScopeCursor = true;
                        }
                    } else {
                        if (entry.replayContext != null) {
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                            }
                            return;
                        }
                        queueIdToRecord = -1;
                        queueEmptyCountToRecord = 0;
                    }
                } else {
                    this.disableReplayInternal(entry.method, 383, "Replay disabled because getting replay context failed", null);
                }
            }
            if (!disableReplayFlag) {
                if (drvrReplayContext != null) {
                    this.replayContext = drvrReplayContext;
                    contextToRecord = new ReplayContext[drvrReplayContext.length];
                    if (drvrReplayContext.length > 0) {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, roundtrip in current request", this.connectionProxyName);
                        }
                        this.seenRoundtripCallInRequest = true;
                        this.needStateSignatureSyncUp = false;
                    }
                    for (i2 = 0; i2 < drvrReplayContext.length; ++i2) {
                        thisReplayContext = drvrReplayContext[i2];
                        replayDirective = (int)thisReplayContext.getDirectives();
                        thisReplayQueueId = thisReplayContext.getQueue();
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, new CM directive (in binary): {1}, queue Id: {2}", new Object[]{this.connectionProxyName, Integer.toBinaryString(replayDirective), (int)thisReplayQueueId});
                        }
                        if ((replayDirective & 4) == 0) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINER, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: DISABLE REPLAY", this.connectionProxyName);
                            }
                            disableReplayFlag = true;
                            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                this.didReplayingLastCallDisableReplay = true;
                            }
                            long svrErrorCode = thisReplayContext.getErrorCode();
                            this.disableReplayInternal(entry.method, 384, "Replay disabled by server Continuity Management", null);
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                            }
                            return;
                        }
                        if ((replayDirective & 8) == 8) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINE, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: EMPTY_QUEUE({1})", new Object[]{this.connectionProxyName, (int)thisReplayQueueId});
                            }
                            short s4 = thisReplayQueueId;
                            this.queueEmptyCounts[s4] = this.queueEmptyCounts[s4] + 1;
                        }
                        if (!$assertionsDisabled && (replayDirective & 1) != 1 && serverAsksToEnqueue) {
                            AssertionError assertionError = new AssertionError((Object)"AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call");
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                            }
                            throw assertionError;
                        }
                        if ((replayDirective & 1) == 1) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: RECORD CALL", this.connectionProxyName);
                            }
                            contextToRecord[i2] = thisReplayContext;
                            queueIdToRecord = thisReplayQueueId;
                            queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId];
                            serverAsksToEnqueue = true;
                        }
                        if ((replayDirective & 2) != 2) continue;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, server instructs: REQUEST-SCOPE CURSOR", this.connectionProxyName);
                        }
                        requestScopeCursor = true;
                    }
                } else {
                    if (entry.replayContext != null) {
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                            ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
                        }
                        return;
                    }
                    queueIdToRecord = -1;
                    queueEmptyCountToRecord = 0;
                }
            } else {
                this.disableReplayInternal(entry.method, 383, "Replay disabled because getting replay context failed", null);
            }
            if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.tail != null) {
                TxnFailoverManagerImpl txnFailoverManagerImpl = this;
                synchronized (txnFailoverManagerImpl) {
                    try {
                        void callStatus;
                        void sqlexc;
                        void checksum;
                        void result;
                        CallHistoryEntry entry3 = e2 == null ? this.tail : e2;
                        String methodName = entry3 == null || entry3.method == null ? NULL_METHOD_NAME : entry3.method.getName();
                        entry3.result = result instanceof TxnReplayableBase || result instanceof OracleConcreteProxy ? result : null;
                        entry3.checksum = checksum;
                        if (contextToRecord != null) {
                            if (entry3.replayContext == null) {
                                entry3.replayContext = contextToRecord;
                            } else {
                                ReplayContext[] multipleRPCContexts = new ReplayContext[entry3.replayContext.length + contextToRecord.length];
                                System.arraycopy(entry3.replayContext, 0, multipleRPCContexts, 0, entry3.replayContext.length);
                                System.arraycopy(contextToRecord, 0, multipleRPCContexts, entry3.replayContext.length, contextToRecord.length);
                                entry3.replayContext = multipleRPCContexts;
                            }
                        }
                        entry3.callException = sqlexc;
                        entry3.queueId = queueIdToRecord;
                        entry3.queueEmptyCount = queueEmptyCountToRecord;
                        entry3.serverAsksToEnqueue = serverAsksToEnqueue;
                        entry3.callStatus = callStatus;
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, updated method {1} - result: {2}, ReplayContext: {3}, checksum: {4}, SQLException: {5}, queue Id: {6}, empty count: {7}", new Object[]{this.connectionProxyName, methodName, result, contextToRecord, (long)checksum, sqlexc, queueIdToRecord, queueEmptyCountToRecord});
                        }
                        if (contextToRecord != null) {
                            for (ReplayContext thisReplayContext3 : contextToRecord) {
                                if (thisReplayContext3 == null) {
                                    if (!bl) continue;
                                    OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, updated replay context: NULL", this.connectionProxyName);
                                    continue;
                                }
                                if (!bl) continue;
                                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On {0}, updated replay context: NOT NULL", this.connectionProxyName);
                            }
                        }
                        if (!this.isSessionStateConsistencyDynamic() && requestScopeCursor) {
                            CallHistoryEntry stmtExecEntry = ((TxnReplayableResultSet)entry3.jdbcProxy).creatorCallEntry;
                            stmtExecEntry.queueEmptyCount = Integer.MAX_VALUE;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 23, 7] lbl256 : MonitorExitStatement: MONITOREXIT : var15_15
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, throwable3);
                        }
                        throw throwable3;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$5, this, throwable4);
            }
            throw throwable;
        }
    }

    synchronized void purge() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.head = null;
            this.tail = null;
            this.connectionProxy.headSameProxy = null;
            this.connectionProxy.tailSameProxy = null;
            if (bl) {
                OracleLog.log($$$loggerRef$$$6, Level.FINER, this.getClass(), $$$methodRef$$$6, "On {0}, explicit purge succeeds", this.connectionProxyName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void headForProxy;
            Object jproxy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$7, this, set, callHistoryEntry);
            }
            Object object = jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
            if (bl) {
                OracleLog.log($$$loggerRef$$$7, Level.FINEST, this.getClass(), $$$methodRef$$$7, "On {0}, implicit purge for {1}", new Object[]{this.connectionProxyName, jproxy});
            }
            CallHistoryEntry entry = headForProxy;
            while (entry != null) {
                void visitedProxies;
                Object callResult = entry.result;
                if (callResult != null && callResult instanceof JDBCReplayable && !visitedProxies.contains(callResult)) {
                    JDBCReplayable resultProxy = (JDBCReplayable)callResult;
                    resultProxy.purgeSameProxyList();
                    visitedProxies.add(resultProxy);
                }
                if (bl) {
                    OracleLog.log($$$loggerRef$$$7, Level.FINEST, this.getClass(), $$$methodRef$$$7, "On {0}, implicit purge method {1}", new Object[]{this.connectionProxyName, entry.method.getName()});
                }
                this.remove(entry);
                entry = entry.nextEntrySameProxy;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized boolean isEmpty() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$8, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.head == null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$8, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    Object handleOutage(Method var1_1, SQLRecoverableException var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    synchronized Object handleOutageInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRetries;
            void origError;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, sQLRecoverableException, n2);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "On {0}, Entering replay, original error={1}", new Object[]{this.connectionProxyName, origError});
            }
            this.acStatistics.incrementTotalReplayAttempts();
            this.didReplayingLastCallDisableReplay = false;
            if (currentRetries == false) {
                this.ltxidAtOriginalOutage = this.ltxid;
                if (this.tail != null) {
                    this.lastCxtLenAtOriginalOutage = this.tail.replayContext == null ? 0 : this.tail.replayContext.length;
                }
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "current lifecycle:{0}", (Object)curLifecycle);
            }
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                if (this.replayErrorCode == 0) {
                    this.doNotAbortConn = true;
                    this.replayErrorCode = 370;
                    this.replayErrorMessage = "Replay disabled";
                }
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, (SQLRecoverableException)origError);
            }
            if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                this.acStatistics.incrementTotalCallsTriggeringReplay();
            }
            if (currentRetries == false) {
                this.originalOconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            }
            short fncode = this.originalOconn.getExecutingRPCFunctionCode();
            if (!this.seenRoundtripCallInRequest && fncode == 0) {
                this.replayResult = this.replayWithLocalCallsOnly((SQLRecoverableException)origError, (int)currentRetries);
            } else {
                oracle.jdbc.internal.OracleConnection newConn;
                oracle.jdbc.internal.OracleConnection oconnForPrepareReplayArgs;
                boolean wasOldConnProxySession = this.originalOconn.isProxySession();
                boolean ac2 = ((TxnReplayableConnection)this.connectionProxy).autoCommitBeforeOutage;
                oracle.jdbc.internal.OracleConnection oracleConnection = oconnForPrepareReplayArgs = this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL && this.tail.replayContext != null && this.tail.replayContext.length > this.lastCxtLenAtOriginalOutage ? (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate() : this.originalOconn;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On {0}, original connection: {1}", new Object[]{this.connectionProxyName, oconnForPrepareReplayArgs});
                }
                fncode = oconnForPrepareReplayArgs.getExecutingRPCFunctionCode();
                String sql = oconnForPrepareReplayArgs.getExecutingRPCSQL();
                ReplayContext cxtBeforePrepareReplayTmp = oconnForPrepareReplayArgs.getLastReplayContext();
                if (cxtBeforePrepareReplayTmp != null) {
                    this.cxtBeforePrepareReplay = cxtBeforePrepareReplayTmp;
                }
                if ((newConn = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINE, this.getClass(), $$$methodRef$$$10, "FAILOVER_RETRIES exceeded");
                    }
                    this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", (SQLRecoverableException)origError);
                }
                if (!this.checkACChange(newConn)) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINE, this.getClass(), $$$methodRef$$$10, "Reconnected to instance with different AC configuration");
                    }
                    this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", (SQLRecoverableException)origError);
                }
                if (bl) {
                    OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "Reconnect succeeded, new connection={0}", newConn);
                }
                this.connectionProxy.setDelegate(newConn);
                newConn.setACProxy(this.connectionProxy);
                this.originalReadTimeout = ((OracleConnection)newConn).getNetworkTimeout();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On reconnect, original READ_TIMEOUT={0}", this.originalReadTimeout);
                }
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)newConn).setNetworkTimeout(executor, 120000);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On reconnect, new temporary READ_TIMEOUT={0}", ((OracleConnection)newConn).getNetworkTimeout());
                    }
                }
                newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
                this.oldLtxidForPrepareReplay = this.ltxid;
                if (wasOldConnProxySession) {
                    this.invokeCallbackAfterReconnect(newConn, (SQLRecoverableException)origError);
                    this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                }
                this.ltxid = newConn.getLogicalTransactionId();
                newConn.addLogicalTransactionIdEventListener(this);
                String mname = this.tail.method.getName();
                newConn.setReplayContext(new ReplayContext[]{this.cxtBeforePrepareReplay});
                boolean committed = this.prepareReplay(newConn, (SQLRecoverableException)origError, ac2, fncode, sql);
                if (committed) {
                    if (this.isSessionStateConsistencyDynamic()) {
                        if (mname.equals("execute")) {
                            Boolean bl2 = false;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, bl2);
                                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, null);
                            }
                            return bl2;
                        }
                        if (mname.equals("commit")) {
                            Object var16_15 = null;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, var16_15);
                                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, null);
                            }
                            return null;
                        }
                        Object var16_16 = null;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, var16_16);
                            ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, null);
                        }
                        return null;
                    }
                    this.queueEmptyCounts[1] = this.queueEmptyCounts[1] + 1;
                }
                long currentTimestamp = System.currentTimeMillis();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "timestamp at replay start: {0}", currentTimestamp);
                }
                if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.WARNING, this.getClass(), $$$methodRef$$$10, "ReplayInitiationTimeout exceeded");
                    }
                    this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", (SQLRecoverableException)origError);
                }
                newConn.getReplayContext();
                if (!wasOldConnProxySession) {
                    this.invokeCallbackAfterReconnect(newConn, (SQLRecoverableException)origError);
                }
                this.lifecycle = ReplayLifecycle.REPLAYING;
                this.beginReplay(newConn, (SQLRecoverableException)origError);
                this.replayResult = this.replayAllBeforeLastCall((SQLRecoverableException)origError);
                if (this.tail.replayContext == null || this.tail.replayContext.length == 0) {
                    this.endReplay(newConn, (SQLRecoverableException)origError);
                } else {
                    newConn.registerEndReplayCallback(new EndReplayCallback(this, newConn, (SQLRecoverableException)origError));
                }
                if (!committed) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "On {0}, replaying last call", this.connectionProxyName);
                    }
                    this.replayResult = this.replayLastCall((SQLRecoverableException)origError);
                } else if (!this.isSessionStateConsistencyDynamic()) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.INFO, this.getClass(), $$$methodRef$$$10, "On {0}, last call committed, skipping replay", this.connectionProxyName);
                    }
                    this.tail.callStatus = "completed";
                    this.tail.queueId = 1;
                    this.tail.queueEmptyCount = this.queueEmptyCounts[1];
                    this.tail.serverAsksToEnqueue = false;
                    this.replayResult = mname.equals("execute") ? Boolean.valueOf(false) : (mname.equals("commit") ? null : null);
                } else if (bl) {
                    OracleLog.log($$$loggerRef$$$10, Level.INFO, this.getClass(), $$$methodRef$$$10, "On {0}, unexpected case: replay after committed in dynamic mode", this.connectionProxyName);
                }
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)newConn).setNetworkTimeout(executor, this.originalReadTimeout);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "Reset to original READ_TIMEOUT={0}", ((OracleConnection)newConn).getNetworkTimeout());
                    }
                }
                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL && this.tail != null && (this.tail.replayContext == null || this.tail.replayContext.length == 0)) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "last call was local, copy over last replay context: {0}", this.cxtBeforePrepareReplay);
                    }
                    newConn.setLastReplayContext(this.cxtBeforePrepareReplay);
                }
            }
            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            }
            this.acStatistics.incrementSuccessfulReplayCount();
            this.originalOconn = null;
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.INFO, this.getClass(), $$$methodRef$$$10, "On {0}, replay succeeds", this.connectionProxyName);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINER, this.getClass(), $$$methodRef$$$10, "On {0}, Exiting replay, result={2}", new Object[]{this.connectionProxyName, this.replayResult});
            }
            Object object = this.replayResult;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, object);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized Object replayWithLocalCallsOnly(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$11, this, sQLRecoverableException, n2);
            }
            boolean wasOldConnProxySession = this.originalOconn.isProxySession();
            oracle.jdbc.internal.OracleConnection newConn = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder);
            if (newConn == null) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$11, Level.FINE, this.getClass(), $$$methodRef$$$11, "FAILOVER_RETRIES exceeded");
                }
                this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", (SQLRecoverableException)origError);
            }
            if (!this.checkACChange(newConn)) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$11, Level.FINE, this.getClass(), $$$methodRef$$$11, "Reconnected to instance with different AC configuration");
                }
                this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", (SQLRecoverableException)origError);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$11, Level.FINER, this.getClass(), $$$methodRef$$$11, "Reconnect succeeded (LOCAL CALLS ONLY), new connection={0}", newConn);
            }
            this.connectionProxy.setDelegate(newConn);
            newConn.setACProxy(this.connectionProxy);
            this.originalReadTimeout = ((OracleConnection)newConn).getNetworkTimeout();
            if (bl) {
                OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "On reconnect, original READ_TIMEOUT={0}", this.originalReadTimeout);
            }
            if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                ((OracleConnection)newConn).setNetworkTimeout(executor, 120000);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "On reconnect, new temporary READ_TIMEOUT={0}", ((OracleConnection)newConn).getNetworkTimeout());
                }
            }
            newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
            if (wasOldConnProxySession) {
                this.invokeCallbackAfterReconnect(newConn, (SQLRecoverableException)origError);
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            }
            this.ltxid = newConn.getLogicalTransactionId();
            newConn.addLogicalTransactionIdEventListener(this);
            long currentTimestamp = System.currentTimeMillis();
            if (bl) {
                OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "timestamp at replay start: {0}", currentTimestamp);
            }
            if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$11, Level.WARNING, this.getClass(), $$$methodRef$$$11, "ReplayInitiationTimeout exceeded");
                }
                this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", (SQLRecoverableException)origError);
            }
            if (!wasOldConnProxySession) {
                this.invokeCallbackAfterReconnect(newConn, (SQLRecoverableException)origError);
            }
            newConn.getReplayContext();
            if (this.isReplayInDynamicMode) {
                newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$11, Level.FINER, this.getClass(), $$$methodRef$$$11, "Sent BEGIN_REQUEST and ENABLE to server");
            }
            this.lifecycle = ReplayLifecycle.REPLAYING;
            this.replayResult = this.replayAllBeforeLastCall((SQLRecoverableException)origError);
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
            if (bl) {
                OracleLog.log($$$loggerRef$$$11, Level.FINER, this.getClass(), $$$methodRef$$$11, "On {0}, replaying last call", this.connectionProxyName);
            }
            this.replayResult = this.replayLastCall((SQLRecoverableException)origError);
            if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                ((OracleConnection)newConn).setNetworkTimeout(executor, this.originalReadTimeout);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "Reset to original READ_TIMEOUT={0}", ((OracleConnection)newConn).getNetworkTimeout());
                }
            }
            Object object = this.replayResult;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$11, this, object);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$11, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeCallbackAfterReconnect(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$12, this, oracleConnection, sQLRecoverableException);
            }
            this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
            if (this.isStateRestorationEnabled) {
                this.restoreSavedSessionState((oracle.jdbc.internal.OracleConnection)newConnection);
            } else {
                this.restoreAutoCommit((oracle.jdbc.internal.OracleConnection)newConnection);
            }
            ConnectionInitializationCallback initCbk = this.replayDataSource.getConnectionInitializationCallback();
            if (initCbk != null) {
                void originalError;
                try {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$12, Level.FINER, this.getClass(), $$$methodRef$$$12, "Invoking Replay Driver initialization callback with {0}", this.connectionProxyName);
                    }
                    initCbk.initialize((Connection)((Object)this.connectionProxy));
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$12, Level.FINER, this.getClass(), $$$methodRef$$$12, "Invoking initialization callback with {0} succeeded", this.connectionProxyName);
                    }
                }
                catch (SQLRecoverableException sqlrexc) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$12, Level.FINER, this.getClass(), $$$methodRef$$$12, "Invoking initialization callback with {0} hit outage", this.connectionProxyName);
                    }
                    SQLRecoverableException sQLRecoverableException2 = sqlrexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$12, this, sQLRecoverableException2);
                    }
                    throw sQLRecoverableException2;
                }
                catch (SQLException sqlexc) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$12, Level.FINER, this.getClass(), $$$methodRef$$$12, "Invoking initialization callback with {0} failed", this.connectionProxyName);
                    }
                    this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", (SQLRecoverableException)originalError);
                }
                EnumSet<OracleConnection.TransactionState> eocs = newConnection.getTransactionState();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$12, Level.FINER, this.getClass(), $$$methodRef$$$12, "On {0}, after init-callback, transaction state={1}", new Object[]{this.connectionProxyName, eocs});
                }
                if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", (SQLRecoverableException)originalError);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$13, this, sQLRecoverableException);
            }
            Object replayResult = null;
            CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                TxnReplayableBase concreteProxy;
                void origError;
                String methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
                TxnReplayableBase jproxy = (TxnReplayableBase)entry.jdbcProxy;
                String jproxyNameInLog = jproxy.thisProxyNameInLog;
                if (disabledDueToMemoryLimit) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$13, Level.WARNING, this.getClass(), $$$methodRef$$$13, "On {0}, DISABLE REPLAY due to insufficient memory", this.connectionProxyName);
                    }
                    this.disableReplayAndThrowException(entry.method, 367, "Replay disabled because of insufficient memory", (SQLRecoverableException)origError);
                }
                if (this.isSessionStateConsistencyDynamic() && (entry.replayContext == null || entry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && jproxy.isCreatingCallReplayable && jproxy.isProxyReplayable && (entry.replayContext == null && !postExecuteGetCalls.contains(methodName) || entry.replayContext == null && postExecuteGetCalls.contains(methodName) && jproxy.isCurrentExecuteReplayable || entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId] || entry.queueEmptyCount == Integer.MAX_VALUE)) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$13, Level.FINER, this.getClass(), $$$methodRef$$$13, "On {0}, replaying method {1}", new Object[]{jproxyNameInLog, methodName});
                    }
                    replayResult = jproxy.replayOneCall(entry, (SQLRecoverableException)origError);
                    if (!this.isSessionStateConsistencyDynamic() && jproxy instanceof TxnReplayableStatement && methodName.startsWith("execute")) {
                        jproxy.isCurrentExecuteReplayable = true;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && entry.result != null) {
                        if (entry.result instanceof TxnReplayableBase) {
                            ((TxnReplayableBase)entry.result).isCreatingCallReplayable = true;
                        } else if (entry.result instanceof OracleConcreteProxy && (concreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy()) != null) {
                            concreteProxy.isCreatingCallReplayable = true;
                        }
                    }
                    if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                        this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, (SQLRecoverableException)origError);
                    }
                } else {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$13, Level.FINER, this.getClass(), $$$methodRef$$$13, "On {0}, skipping method {1}", new Object[]{jproxyNameInLog, methodName});
                    }
                    if (!this.isSessionStateConsistencyDynamic() && jproxy instanceof TxnReplayableStatement && methodName.startsWith("execute")) {
                        jproxy.isCurrentExecuteReplayable = false;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && (jproxy instanceof TxnReplayableBlob || jproxy instanceof TxnReplayableClob || jproxy instanceof TxnReplayableNClob || jproxy instanceof TxnReplayableBfile) && jproxy.isProxyReplayable) {
                        jproxy.isProxyReplayable = false;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && entry.result != null) {
                        if (entry.result instanceof TxnReplayableBase) {
                            ((TxnReplayableBase)entry.result).isCreatingCallReplayable = false;
                        } else if (entry.result instanceof OracleConcreteProxy && (concreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy()) != null) {
                            concreteProxy.isCreatingCallReplayable = false;
                        }
                    }
                    if (!this.isSessionStateConsistencyDynamic() && !jproxy.isCreatingCallReplayable && !"next".equals(methodName) && entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId]) {
                        this.disableReplayAndThrowException(entry.method, 399, "Replay disabled because server sent conflicting queueing instructions", (SQLRecoverableException)origError);
                    }
                }
                entry = entry.nextEntry;
            }
            Object object = replayResult;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$13, this, object);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$13, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object replayLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$14, this, sQLRecoverableException);
            }
            Object replayResult = null;
            if (this.tail != null) {
                void origError;
                CallHistoryEntry entry = this.tail;
                String methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
                TxnReplayableBase jproxy = (TxnReplayableBase)entry.jdbcProxy;
                String jproxyNameInLog = jproxy.thisProxyNameInLog;
                if (this.isSessionStateConsistencyDynamic() && (entry.replayContext == null || entry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && jproxy.isCreatingCallReplayable && (entry.replayContext == null && !postExecuteGetCalls.contains(methodName) || entry.replayContext == null && postExecuteGetCalls.contains(methodName) && jproxy.isCurrentExecuteReplayable || entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId] || entry.queueEmptyCount == Integer.MAX_VALUE)) {
                    replayResult = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, (SQLRecoverableException)origError);
                } else {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$14, Level.WARNING, this.getClass(), $$$methodRef$$$14, "On {0}, replaying last method {1}: NO replay because this method is not replayable", new Object[]{this.connectionProxyName, methodName});
                    }
                    this.disableReplayAndThrowException(this.tail.method, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)origError);
                }
            }
            Object object = replayResult;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$14, this, object);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$14, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    ReplayLifecycle getReplayLifecycle() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$15, this, new Object[0]);
            }
            ReplayLifecycle replayLifecycle = this.lifecycle;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$15, this, (Object)replayLifecycle);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$15, this, null);
            }
            return replayLifecycle;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDataSource(OracleDataSource oracleDataSource) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rds;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$16, this, oracleDataSource);
            }
            this.replayDataSource = rds;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReplayInitiationTimeout(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$17, this, n2);
            }
            this.replayInitiationTimeout = (long)timeout;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isSessionStateConsistencyDynamic() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$18, this, new Object[0]);
            }
            boolean bl2 = this.isReplayInDynamicMode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$18, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$18, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setSessionStateConsistency(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isStatic;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$19, this, bl);
            }
            boolean bl3 = this.isReplayInDynamicMode = isStatic == false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setSessionStateRestoration(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void enabled;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$20, this, bl);
            }
            this.isStateRestorationEnabled = enabled;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setAutoAC(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isAutoAC;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$21, this, bl);
            }
            this.isAutoAC = isAutoAC;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void beginRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$22, this, new Object[0]);
            }
            this.beginRequest(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void beginRequest(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void noOpenHandles;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, bl);
            }
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "On {0}, Entering beginRequest(), noOpenHandles: {1}", new Object[]{this.connectionProxyName, (boolean)noOpenHandles});
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "Exiting beginRequest(), MONITOR_TXN failed, no-op");
                }
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, null);
                }
                return;
            }
            if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "Exiting beginRequest(), redundant beginRequest call, no-op");
                }
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, null);
                }
                return;
            }
            if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
                SQLException sQLException = DatabaseError.createSqlException(391);
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, sQLException);
                }
                throw sQLException;
            }
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            if (this.isAutoAC || this.isStateRestorationEnabled) {
                this.saveCurrentSessionState(oconn);
            } else {
                this.saveAutoCommitAndStateSignatures(oconn);
            }
            this.requestStartTime = System.currentTimeMillis();
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINEST, this.getClass(), $$$methodRef$$$23, "Request start timestamp: {0}", this.requestStartTime);
            }
            oconn.getReplayContext();
            if (this.isAutoAC && (this.savedStateSignatures.getSignatureFlags() & 0x20L) == 32L) {
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "Exiting beginRequest(), session state unrestorable, replay remain disabled");
                }
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, null);
                }
                return;
            }
            if (noOpenHandles != false) {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NO_OPEN_HANDLES));
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "Sent NO_OPEN_HANDLES to server");
                }
            } else if (this.isReplayInDynamicMode) {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "Sent BEGIN_REQUEST to server");
            }
            EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "transaction state: {0}", eocs);
            }
            if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                SQLException sqlexc = DatabaseError.createSqlException(392);
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "beginRequest", sqlexc);
                }
                SQLException sQLException = sqlexc;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, sQLException);
                }
                throw sQLException;
            }
            this.replayErrorCode = 0;
            this.replayErrorMessage = "";
            this.callCausingReplayError = null;
            this.seenRoundtripCallInRequest = false;
            this.needStateSignatureSyncUp = false;
            this.callingDisableFromEndRequest = false;
            oconn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
            this.lobStreamInRequest = false;
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            this.acStatistics.incrementTotalRequests();
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "On {0}, Recording begins", this.connectionProxyName);
            }
            if (bl2) {
                OracleLog.log($$$loggerRef$$$23, Level.FINER, this.getClass(), $$$methodRef$$$23, "On {0}, Exiting beginRequest()", this.connectionProxyName);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void endRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "On {0}, Entering endRequest()", this.connectionProxyName);
            }
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
            if (bl) {
                OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "Sent END_REQUEST to server");
            }
            this.callingDisableFromEndRequest = true;
            boolean isConnClosed = oconn.isClosed();
            if (!isConnClosed) {
                boolean autoCommitMode = oconn.getAutoCommit();
                int txnMode = oconn.getTxnMode();
                EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "auto-commit: {0}, transaction state: {1}, transaction mode: {2}", new Object[]{autoCommitMode, eocs, txnMode});
                }
                if (!autoCommitMode && txnMode != 1 && eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    block21: {
                        try {
                            oconn.rollback();
                        }
                        catch (SQLException sqlexc) {
                            if (!bl) break block21;
                            OracleLog.log($$$loggerRef$$$24, Level.FINEST, this.getClass(), $$$methodRef$$$24, "Rollback open transaction failed before throwing exception");
                        }
                    }
                    SQLException sqlexc = DatabaseError.createSqlException(393);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "endRequest", sqlexc);
                    }
                    SQLException sQLException = sqlexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            this.acStatistics.incrementTotalCompletedRequests();
            this.lobStreamInRequest = false;
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "Exiting endRequest() -- MONITOR_TXN failed");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this);
                    ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, null);
                }
                return;
            }
            if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "Exiting endRequest() -- replay already disabled");
                }
                this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this);
                    ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, null);
                }
                return;
            }
            this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
            this.callingDisableFromEndRequest = false;
            if (bl) {
                OracleLog.log($$$loggerRef$$$24, Level.FINER, this.getClass(), $$$methodRef$$$24, "On {0}, Exiting endRequest()", this.connectionProxyName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    void disableReplay() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$25, Level.FINER, this.getClass(), $$$methodRef$$$25, "On {0}, Entering disableReplay()", this.connectionProxyName);
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$25, Level.FINER, this.getClass(), $$$methodRef$$$25, "Exiting disableReplay(), MONITOR_TXN failed, no-op");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this, null);
                }
                return;
            }
            this.disableReplayInternal(null, 370, "Replay disabled", null);
            this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
            if (bl) {
                OracleLog.log($$$loggerRef$$$25, Level.WARNING, this.getClass(), $$$methodRef$$$25, "On {0}, replay is externally disabled", this.connectionProxyName);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$25, Level.FINER, this.getClass(), $$$methodRef$$$25, "On {0}, Exiting disableReplay()", this.connectionProxyName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void errMesg;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$26, this, method, n2, string, sQLRecoverableException);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$26, Level.FINER, this.getClass(), $$$methodRef$$$26, "On {0}, Entering disableReplayInternal", this.connectionProxyName);
            }
            if (!this.callingDisableFromEndRequest) {
                this.acStatistics.incrementReplayDisablingCount();
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
                this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            }
            this.purge();
            this.replayErrorCode = errCode;
            this.replayErrorMessage = errMesg;
            this.callCausingReplayError = m2;
            for (int i2 = 0; i2 < activeQueues; ++i2) {
                this.queueEmptyCounts[i2] = 0;
            }
            if (disabledDueToMemoryLimit) {
                this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, replay is internally disabled", this.connectionProxyName);
            }
            try {
                oconn.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
                if (!this.seenRoundtripCallInRequest) {
                    if (!this.isReplayInDynamicMode) {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, STATIC + no roundtrip in current request", this.connectionProxyName);
                        }
                        oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                    } else {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, DYNAMIC + no roundtrip in current request", this.connectionProxyName);
                        }
                        oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
                    }
                } else if (!this.isReplayInDynamicMode) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, STATIC + with roundtrip in current request", this.connectionProxyName);
                    }
                    if (!this.callingDisableFromEndRequest) {
                        oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, still within request, sending STATIC", this.connectionProxyName);
                        }
                    } else if (bl) {
                        OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, after endRequest, no STATIC sent", this.connectionProxyName);
                    }
                } else {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$26, Level.FINEST, this.getClass(), $$$methodRef$$$26, "On {0}, DYNAMIC + with roundtrip in current request", this.connectionProxyName);
                    }
                    oconn.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$26, Level.FINER, this.getClass(), $$$methodRef$$$26, "Cleared ENABLED bit for driver and server");
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$26, Level.FINER, this.getClass(), $$$methodRef$$$26, "On {0}, Exiting disableReplayInternal", this.connectionProxyName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void errMesg;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$27, this, method, n2, string, sQLRecoverableException);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$27, Level.FINER, this.getClass(), $$$methodRef$$$27, "Entering failReplayInternal");
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
            }
            this.replayErrorCode = errCode;
            this.replayErrorMessage = errMesg;
            this.callCausingReplayError = m2;
            this.originalOconn = null;
            if (bl) {
                OracleLog.log($$$loggerRef$$$27, Level.WARNING, this.getClass(), $$$methodRef$$$27, "On {0}, replay failed", this.connectionProxyName);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$27, Level.FINER, this.getClass(), $$$methodRef$$$27, "Exiting failReplayInternal");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            SQLException replayErr;
            void errCode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$28, this, n2, string, sQLRecoverableException);
            }
            if (errCode == false) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$28, this);
                    ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$28, this, null);
                }
                return;
            }
            String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
            SQLException sQLException = replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$28, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$29, this, method, n2, string, sQLRecoverableException);
            }
            this.disableReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwReplayExceptionInternal((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayAndThrowSQLException(Method method, int n2, String string, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$30, this, method, n2, string, sQLException);
            }
            this.disableReplayInternal((Method)m2, (int)errCode, (String)errMesg, null);
            this.killConnectionBeforeReplayDisabledException();
            void var6_6 = origError;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$30, this, (Throwable)var6_6);
            }
            throw var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$31, this, method, n2, string, sQLRecoverableException);
            }
            this.disableReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwOriginalExceptionWithReplayError((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void errMesg;
            void errCode;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$32, this, method, n2, string, sQLRecoverableException);
            }
            this.failReplayInternal((Method)m2, (int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            this.throwReplayExceptionInternal((int)errCode, (String)errMesg, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$33, this, n2, string, sQLRecoverableException);
            }
            if (!this.doNotAbortConn) {
                this.killConnectionBeforeReplayDisabledException();
            }
            String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
            SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
            origError.setNextException(replayErr);
            this.acStatistics.incrementFailedReplayCount();
            this.originalOconn = null;
            if (!$assertionsDisabled && this.callHittingOutage == null) {
                AssertionError assertionError = new AssertionError((Object)"Failed-call Method object is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$33, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$33, Level.WARNING, this.getClass(), $$$methodRef$$$33, "On {0}, replay failed in method {1}, error code: {2}", new Object[]{this.connectionProxyName, this.callHittingOutage.getName(), this.replayErrorCode});
            }
            void var7_8 = origError;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$33, this, (Throwable)var7_8);
            }
            throw var7_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    void killConnectionBeforeReplayDisabledException() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block10: {
                oracle.jdbc.internal.OracleConnection oconn;
                block9: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$34, this, new Object[0]);
                    }
                    oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                    try {
                        oconn.abort();
                    }
                    catch (SQLException sqlexc) {
                        if (!bl) break block9;
                        OracleLog.log($$$loggerRef$$$34, Level.WARNING, this.getClass(), $$$methodRef$$$34, "Aborting connection failed before throwing replay-disabled exception");
                    }
                }
                try {
                    executor.submit(new Runnable(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public void run() {
                            TxnFailoverManagerImpl.access$000(TxnFailoverManagerImpl.this, oconn);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 2.class.getDeclaredConstructor(TxnFailoverManagerImpl.class, oracle.jdbc.internal.OracleConnection.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                }
                catch (Exception exc) {
                    if (!bl) break block10;
                    OracleLog.log($$$loggerRef$$$34, Level.WARNING, this.getClass(), $$$methodRef$$$34, "On {0}, ASYNC close() submission during replay failed", this.connectionProxyName);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void enableTxnMonitoring(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$35, this, oracleConnection);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                stmt.execute(MONITOR_TXN);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$35, Level.FINER, this.getClass(), $$$methodRef$$$35, "MONITOR_TXN succeeded");
                }
                stmt.close();
            }
            catch (SQLException sqlexc) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$35, Level.WARNING, this.getClass(), $$$methodRef$$$35, "MONITOR_TXN failed");
                }
                this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
                this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
                SQLException sQLException = DatabaseError.createSqlException(395);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$35, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$35, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void beginReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$36, this, oracleConnection, sQLRecoverableException);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                stmt.execute(BEGIN_REPLAY);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$36, Level.FINER, this.getClass(), $$$methodRef$$$36, "BEGIN_REPLAY succeeded");
                }
                stmt.close();
                oconn.setReplayingMode(true);
                this.lifecycle = ReplayLifecycle.REPLAYING;
            }
            catch (SQLRecoverableException sqlrexc) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$36, Level.FINER, this.getClass(), $$$methodRef$$$36, "BEGIN_REPLAY hit outage");
                }
                SQLRecoverableException sQLRecoverableException2 = sqlrexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$36, this, sQLRecoverableException2);
                }
                throw sQLRecoverableException2;
            }
            catch (SQLException sqlexc) {
                void origError;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$36, Level.WARNING, this.getClass(), $$$methodRef$$$36, "BEGIN_REPLAY failed");
                }
                this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", (SQLRecoverableException)origError);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void endReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$37, this, oracleConnection, sQLRecoverableException);
            }
            try {
                void oconn;
                Statement stmt = oconn.createStatement();
                stmt.execute(END_REPLAY);
                if (bl) {
                    OracleLog.log($$$loggerRef$$$37, Level.FINER, this.getClass(), $$$methodRef$$$37, "END_REPLAY succeeded");
                }
                stmt.close();
                oconn.setReplayingMode(false);
                oconn.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
                if (!this.isReplayInDynamicMode) {
                    oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
                } else {
                    oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
                }
                oconn.getReplayContext();
                this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
            }
            catch (SQLRecoverableException sqlrexc) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$37, Level.FINER, this.getClass(), $$$methodRef$$$37, "END_REPLAY hit outage");
                }
                SQLRecoverableException sQLRecoverableException2 = sqlrexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$37, this, sQLRecoverableException2);
                }
                throw sQLRecoverableException2;
            }
            catch (SQLException sqlexc) {
                void origError;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$37, Level.WARNING, this.getClass(), $$$methodRef$$$37, "END_REPLAY failed");
                }
                this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", (SQLRecoverableException)origError);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean prepareReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException, boolean bl, short s2, String string) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, oracleConnection, sQLRecoverableException, bl, s2, string);
            }
            boolean committed = false;
            boolean embedded = false;
            try {
                void sqlString;
                void fncode;
                void ac2;
                void oconn;
                if (!this.isReplayInDynamicMode) {
                    oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                }
                OracleCallableStatement cstmt = (OracleCallableStatement)oconn.prepareCall(PREPARE_REPLAY_2);
                cstmt.setObject(1, (Object)this.oldLtxidForPrepareReplay);
                cstmt.setInt(2, this.seenRoundtripCallInRequest ? 1 : 0);
                cstmt.setInt(3, ac2 != false ? 1 : 0);
                cstmt.setInt(4, (int)fncode);
                cstmt.setString(5, (String)sqlString);
                BigDecimal ub8Flags = this.longToUB8(this.savedStateSignatures.getSignatureFlags());
                BigDecimal ub8ClientSig = this.longToUB8(this.savedStateSignatures.getClientSignature());
                BigDecimal ub8ServerSig = this.longToUB8(this.savedStateSignatures.getServerSignature());
                cstmt.setBigDecimal(8, ub8Flags);
                cstmt.setBigDecimal(9, ub8ClientSig);
                cstmt.setBigDecimal(10, ub8ServerSig);
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$38, Level.FINER, this.getClass(), $$$methodRef$$$38, "On {0}, PREPARE_REPLAY RPC code: {1}, SQL text: {2}, {3}, (converted) SignatureFlags: {4}, ClientSignature: {5}, ServerSignature: {6}", new Object[]{this.connectionProxyName, (short)fncode, sqlString, this.savedStateSignatures, ub8Flags, ub8ClientSig, ub8ServerSig});
                }
                cstmt.registerOutParameter(6, -7);
                cstmt.registerOutParameter(7, -7);
                cstmt.execute();
                committed = cstmt.getBoolean(6);
                embedded = cstmt.getBoolean(7);
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$38, Level.FINER, this.getClass(), $$$methodRef$$$38, "PREPARE_REPLAY succeeded, committed: {0}, embedded: {1}", new Object[]{committed, embedded});
                }
                cstmt.close();
            }
            catch (SQLRecoverableException sqlrexc) {
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$38, Level.FINER, this.getClass(), $$$methodRef$$$38, "PREPARE_REPLAY hit outage");
                }
                SQLRecoverableException sQLRecoverableException2 = sqlrexc;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, sQLRecoverableException2);
                }
                throw sQLRecoverableException2;
            }
            catch (SQLException sqlexc) {
                if (bl2) {
                    OracleLog.log($$$loggerRef$$$38, Level.WARNING, this.getClass(), $$$methodRef$$$38, "PREPARE_REPLAY failed");
                }
                sqlexc.printStackTrace();
                this.disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", (SQLRecoverableException)origError);
            }
            if (!embedded) {
                boolean bl3 = committed;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, null);
                }
                return bl3;
            }
            if (bl2) {
                OracleLog.log($$$loggerRef$$$38, Level.FINER, this.getClass(), $$$methodRef$$$38, "EMBEDDED-COMMIT completed");
            }
            this.disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", (SQLRecoverableException)origError);
            boolean bl4 = false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    JDBCReplayable getConnectionProxy() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$39, this, new Object[0]);
            }
            TxnReplayableBase txnReplayableBase = this.connectionProxy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$39, this, txnReplayableBase);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$39, this, null);
            }
            return txnReplayableBase;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isReplayFailure(SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            int errCode;
            void t2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$40, this, sQLException);
            }
            boolean result = false;
            if (t2 instanceof SQLException && (errCode = t2.getErrorCode()) >= 370 && errCode < 400) {
                result = true;
            }
            boolean bl2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$40, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$40, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closePhysicalConnection(Connection connection) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$41, this, connection);
                }
                try {
                    void conn;
                    conn.close();
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block7;
                    OracleLog.log($$$loggerRef$$$41, Level.WARNING, this.getClass(), $$$methodRef$$$41, "On {0}, connection close() during replay failed", this.connectionProxyName);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    LogicalTransactionId getLogicalTransactionId() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$42, this, new Object[0]);
            }
            LogicalTransactionId logicalTransactionId = this.ltxid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$42, this, logicalTransactionId);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$42, this, null);
            }
            return logicalTransactionId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    LogicalTransactionId getLtxidAtOriginalOutage() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$43, this, new Object[0]);
            }
            LogicalTransactionId logicalTransactionId = this.ltxidAtOriginalOutage;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$43, this, logicalTransactionId);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$43, this, null);
            }
            return logicalTransactionId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setLogicalTransactionId(LogicalTransactionId logicalTransactionId) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newLtxid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$44, this, logicalTransactionId);
            }
            this.ltxid = newLtxid;
            if (bl) {
                OracleLog.log($$$loggerRef$$$44, Level.FINEST, this.getClass(), $$$methodRef$$$44, "On {0}, new LTXID set: {1}", new Object[]{this.connectionProxyName, this.ltxid});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent logicalTransactionIdEvent) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ltxidEvent;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$45, this, logicalTransactionIdEvent);
            }
            LogicalTransactionId newLtxid = ltxidEvent.getLogicalTransactionId();
            if (bl) {
                OracleLog.log($$$loggerRef$$$45, Level.FINEST, this.getClass(), $$$methodRef$$$45, "On {0}, LTXID in new LTXID event: {1}", new Object[]{this.connectionProxyName, newLtxid});
            }
            this.setLogicalTransactionId(newLtxid);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    ReplayContext[] getReplayContext() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$46, this, new Object[0]);
            }
            ReplayContext[] replayContextArray = this.replayContext;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$46, this, replayContextArray);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$46, this, null);
            }
            return this.replayContext;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReplayContext(ReplayContext[] replayContextArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newReplayContext;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$47, this, new Object[]{replayContextArray});
            }
            this.replayContext = newReplayContext;
            if (bl) {
                OracleLog.log($$$loggerRef$$$47, Level.FINER, this.getClass(), $$$methodRef$$$47, "On {0}, new ReplayContext set: {1}", new Object[]{this.connectionProxyName, this.replayContext});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void addActiveQueues(int n2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            void maxQueueId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$48, this, n2);
            }
            void addedLen = (maxQueueId + true - this.queueEmptyCounts.length) / 2 * 2;
            int newArrayLen = this.queueEmptyCounts.length + addedLen;
            int[] newQueueEmptyCounts = new int[newArrayLen];
            System.arraycopy(this.queueEmptyCounts, 0, newQueueEmptyCounts, 0, this.queueEmptyCounts.length);
            for (i2 = this.queueEmptyCounts.length; i2 <= maxQueueId; ++i2) {
                newQueueEmptyCounts[i2] = 0;
            }
            for (i2 = maxQueueId + true; i2 <= newArrayLen; ++i2) {
                newQueueEmptyCounts[i2] = 0;
            }
            TxnFailoverManagerImpl txnFailoverManagerImpl = this;
            synchronized (txnFailoverManagerImpl) {
                try {
                    this.queueEmptyCounts = newQueueEmptyCounts;
                    activeQueues = newArrayLen;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl23 : MonitorExitStatement: MONITOREXIT : var5_7
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$48, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$48, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$48, this);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$48, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$48, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void reportType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$49, this, new Object[]{statisticsReportType});
            }
            ReplayStatistics acStats = null;
            switch (3.$SwitchMap$oracle$jdbc$replay$ReplayableConnection$StatisticsReportType[reportType.ordinal()]) {
                case 1: {
                    acStats = this.acStatistics;
                    break;
                }
                case 2: {
                    acStats = this.replayDataSource.getReplayStatistics();
                }
            }
            ReplayStatisticsImpl replayStatisticsImpl = acStats;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$49, this, replayStatisticsImpl);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$49, this, null);
            }
            return replayStatisticsImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void reportType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$50, this, new Object[]{statisticsReportType});
            }
            switch (3.$SwitchMap$oracle$jdbc$replay$ReplayableConnection$StatisticsReportType[reportType.ordinal()]) {
                case 1: {
                    this.acStatistics.clear();
                    break;
                }
                case 2: {
                    this.replayDataSource.clearReplayStatistics();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$50, this);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$50, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    protected ProxyFactory getProxyFactory() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$51, this, new Object[0]);
            }
            ProxyFactory proxyFactory = this.replayDataSource.getProxyFactory();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$51, this, proxyFactory);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$51, this, null);
            }
            return proxyFactory;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isLobStreamInRequest() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$52, this, new Object[0]);
            }
            boolean bl2 = this.lobStreamInRequest;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$52, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$52, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setLobStreamInRequest(boolean bl) {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void streamPresent;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$53, this, bl);
            }
            this.lobStreamInRequest = streamPresent;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$53, this);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$53, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void saveAutoCommitAndStateSignatures(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$54, this, oracleConnection);
            }
            this.savedAutoCommit = oconn.getAutoCommitInternal();
            this.savedStateSignatures = oconn.getStateSignatures();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$54, this);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$54, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void saveCurrentSessionState(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$55, this, oracleConnection);
            }
            this.savedSessionProps = oconn.getServerSessionInfo();
            this.savedClientInfo = oconn.getClientInfoInternal();
            this.saveAutoCommitAndStateSignatures((oracle.jdbc.internal.OracleConnection)oconn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void restoreAutoCommit(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$56, this, oracleConnection);
            }
            newConnection.setAutoCommit(this.savedAutoCommit);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$56, this);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$56, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restoreSavedSessionState(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newConnection;
            block39: {
                Throwable throwable;
                block38: {
                    String _rolesStr;
                    block37: {
                        String _row_archival;
                        String _sql_txlp;
                        String _edition;
                        String _err_ovlap;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, oracleConnection);
                        }
                        StringBuilder sqlBuilder = new StringBuilder("ALTER SESSION SET").append(" NLS_CALENDAR = '").append(this.savedSessionProps.get(NLS_CALENDAR_PROPERTY)).append("'").append(" NLS_CURRENCY = '").append(this.savedSessionProps.get(NLS_CURRENCY_PROPERTY)).append("'").append(" NLS_DATE_FORMAT = '").append(this.savedSessionProps.get(NLS_DATE_FORMAT_PROPERTY)).append("'").append(" NLS_DATE_LANGUAGE = '").append(this.savedSessionProps.get(NLS_DATE_LANGUAGE_PROPERTY)).append("'").append(" NLS_DUAL_CURRENCY = '").append(this.savedSessionProps.get(NLS_DUAL_CURRENCY_PROPERTY)).append("'").append(" NLS_ISO_CURRENCY = '").append(this.savedSessionProps.get(NLS_ISO_CURRENCY_PROPERTY)).append("'").append(" NLS_LANGUAGE = '").append(this.savedSessionProps.get(NLS_LANGUAGE_PROPERTY)).append("'").append(" NLS_LENGTH_SEMANTICS = '").append(this.savedSessionProps.get(NLS_LENGTH_SEMANTICS_PROPERTY)).append("'").append(" NLS_NCHAR_CONV_EXCP = '").append(this.savedSessionProps.get(NLS_NCHAR_CONV_EXCP_PROPERTY)).append("'").append(" NLS_NUMERIC_CHARACTERS = '").append(this.savedSessionProps.get(NLS_NUMERIC_CHARACTERS_PROPERTY)).append("'").append(" NLS_SORT = '").append(this.savedSessionProps.get(NLS_SORT_PROPERTY)).append("'").append(" NLS_TERRITORY = '").append(this.savedSessionProps.get(NLS_TERRITORY_PROPERTY)).append("'").append(" NLS_TIME_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_FORMAT_PROPERTY)).append("'").append(" NLS_TIME_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_TZ_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_TZ_FORMAT_PROPERTY)).append("'");
                        String tzString = this.savedSessionProps.getProperty(TIME_ZONE_PROPERTY);
                        if (tzString != null && tzString.length() > 3 && tzString.startsWith("GMT")) {
                            tzString = tzString.substring(3);
                        }
                        sqlBuilder.append(" TIME_ZONE = '").append(tzString).append("'");
                        String currentSchema = this.savedSessionProps.getProperty(SCHEMA_NAME_PROPERTY);
                        if (currentSchema != null && !"".equals(currentSchema) && !currentSchema.equals(newConnection.getCurrentSchema())) {
                            sqlBuilder.append(" CURRENT_SCHEMA = ").append(currentSchema);
                        }
                        if ((_err_ovlap = this.savedSessionProps.getProperty(ERROR_OVERLAP_PROPERTY)) != null && !"".equals(_err_ovlap)) {
                            sqlBuilder.append(" ERROR_ON_OVERLAP_TIME = ").append(_err_ovlap);
                        }
                        if ((_edition = this.savedSessionProps.getProperty(EDITION_PROPERTY)) != null && !"".equals(_edition)) {
                            sqlBuilder.append(" EDITION = ").append(_edition);
                        }
                        if ((_sql_txlp = this.savedSessionProps.getProperty(SQL_TXLP_PROPERTY)) != null && !"".equals(_sql_txlp)) {
                            sqlBuilder.append(" SQL_TRANSLATION_PROFILE = ").append(_sql_txlp);
                        }
                        if ((_row_archival = this.savedSessionProps.getProperty(ROW_ARCHIVAL_PROPERTY)) != null && !"".equals(_row_archival)) {
                            sqlBuilder.append(" ROW ARCHIVAL VISIBILITY = ").append(_row_archival);
                        }
                        String savedContainer = this.savedSessionProps.getProperty(CONTAINER_PROPERTY);
                        String savedService = this.savedSessionProps.getProperty(SERVICE_PROPERTY);
                        Object setContainerSql = "";
                        if (savedContainer != null && !"".equals(savedContainer)) {
                            String containerOnNew = this.getContainer((oracle.jdbc.internal.OracleConnection)newConnection);
                            String serviceOnNew = this.getService((oracle.jdbc.internal.OracleConnection)newConnection);
                            if (!savedContainer.equals(containerOnNew) || !savedService.equals(serviceOnNew)) {
                                setContainerSql = "ALTER SESSION SET CONTAINER = " + savedContainer + " SERVICE = \"" + savedService + "\"";
                            }
                        }
                        String alterSessionSql = sqlBuilder.toString();
                        Statement stmt = newConnection.createStatement();
                        Throwable throwable2 = null;
                        try {
                            stmt.execute(alterSessionSql);
                            if (!"".equals(setContainerSql)) {
                                stmt.execute((String)setContainerSql);
                            }
                            if (stmt == null) break block37;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                Throwable throwable4 = throwable3;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable4);
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (stmt != null) {
                                    TxnFailoverManagerImpl.$closeResource(throwable2, stmt);
                                }
                                Throwable throwable6 = throwable5;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable6);
                                }
                                throw throwable6;
                            }
                        }
                        TxnFailoverManagerImpl.$closeResource(throwable2, stmt);
                    }
                    if ((_rolesStr = this.savedSessionProps.getProperty(ENABLED_ROLE_NAMES_PROPERTY)) != null && !"".equals(_rolesStr)) {
                        String _roles = _rolesStr.replaceAll("\"", "");
                        String setRoleSql = "SET ROLE " + _roles;
                        Statement stmt = newConnection.createStatement();
                        throwable = null;
                        try {
                            stmt.execute(setRoleSql);
                            if (stmt == null) break block38;
                        }
                        catch (Throwable throwable7) {
                            try {
                                throwable = throwable7;
                                Throwable throwable8 = throwable7;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable8);
                                }
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                if (stmt != null) {
                                    TxnFailoverManagerImpl.$closeResource(throwable, stmt);
                                }
                                Throwable throwable10 = throwable9;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable10);
                                }
                                throw throwable10;
                            }
                        }
                        TxnFailoverManagerImpl.$closeResource(throwable, stmt);
                    }
                }
                newConnection.setClientInfo(this.savedClientInfo);
                String _clntInfoStr = this.savedSessionProps.getProperty(CLIENT_INFO_PROPERTY);
                if (_clntInfoStr != null && !"".equals(_clntInfoStr)) {
                    String setClntInfoSql = "begin dbms_application_info.set_client_info(?); end;";
                    CallableStatement cstmt = newConnection.prepareCall(setClntInfoSql);
                    throwable = null;
                    try {
                        cstmt.setString(1, _clntInfoStr);
                        cstmt.execute();
                        if (cstmt == null) break block39;
                    }
                    catch (Throwable throwable11) {
                        try {
                            throwable = throwable11;
                            Throwable throwable12 = throwable11;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable12);
                            }
                            throw throwable12;
                        }
                        catch (Throwable throwable13) {
                            if (cstmt != null) {
                                TxnFailoverManagerImpl.$closeResource(throwable, cstmt);
                            }
                            Throwable throwable14 = throwable13;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable14);
                            }
                            throw throwable14;
                        }
                    }
                    TxnFailoverManagerImpl.$closeResource(throwable, cstmt);
                }
            }
            this.restoreAutoCommit((oracle.jdbc.internal.OracleConnection)newConnection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable15 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$57, this, throwable15);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContainer(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            String containerName;
            block21: {
                void newConnection;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, oracleConnection);
                }
                containerName = "";
                Statement stmt = newConnection.createStatement();
                Throwable throwable = null;
                try {
                    block20: {
                        ResultSet rs = stmt.executeQuery(CONTAINER_QUERY);
                        Throwable throwable2 = null;
                        try {
                            if (rs.next()) {
                                containerName = rs.getString(1);
                            }
                            if (rs == null) break block20;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                Throwable throwable4 = throwable3;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, throwable4);
                                }
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (rs != null) {
                                    TxnFailoverManagerImpl.$closeResource(throwable2, rs);
                                }
                                Throwable throwable6 = throwable5;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, throwable6);
                                }
                                throw throwable6;
                            }
                        }
                        TxnFailoverManagerImpl.$closeResource(throwable2, rs);
                    }
                    if (stmt == null) break block21;
                }
                catch (Throwable throwable7) {
                    try {
                        throwable = throwable7;
                        Throwable throwable8 = throwable7;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, throwable8);
                        }
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        if (stmt != null) {
                            TxnFailoverManagerImpl.$closeResource(throwable, stmt);
                        }
                        Throwable throwable10 = throwable9;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, throwable10);
                        }
                        throw throwable10;
                    }
                }
                TxnFailoverManagerImpl.$closeResource(throwable, stmt);
            }
            String string = containerName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, string);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable11 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$58, this, throwable11);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getService(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$59, this, oracleConnection);
            }
            String string = newConnection.getServerSessionInfo().getProperty(SERVICE_PROPERTY);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$59, this, string);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$59, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkACChange(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            Properties sessionProperties;
            String failoverType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, oracleConnection);
            }
            if ((failoverType = (sessionProperties = oconn.getServerSessionInfo()).getProperty(FAILOVER_TYPE_PROPERTY)) != null && !"".equals(failoverType)) {
                int wiredValue;
                try {
                    wiredValue = Integer.parseInt(failoverType);
                }
                catch (NumberFormatException exc) {
                    wiredValue = 0;
                }
                if (!this.isAutoAC) {
                    if ((wiredValue & 8) == 8 && this.isReplayInDynamicMode == ((wiredValue & 0x10) == 0) || (wiredValue & 0x20) == 32) {
                        boolean bl2 = true;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, bl2);
                            ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, null);
                        }
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, null);
                    }
                    return false;
                }
                if ((wiredValue & 0x20) == 32) {
                    boolean bl4 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, bl4);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, null);
                    }
                    return true;
                }
                boolean bl5 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, bl5);
                    ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, null);
                }
                return false;
            }
            boolean bl6 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, bl6);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isStateUnrestorable() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            oracle.jdbc.internal.OracleConnection oconn;
            StateSignatures stateSigs;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, new Object[0]);
            }
            if (this.isAutoAC && (stateSigs = (oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate()).getStateSignatures()) != null && (stateSigs.getSignatureFlags() & 0x24L) > 0L) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    void setStateSignatureSyncUp() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$62, this, new Object[0]);
            }
            if (this.tail.callException == null) {
                this.needStateSignatureSyncUp = true;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$62, Level.FINER, this.getClass(), $$$methodRef$$$62, "On {0}, need state signature sync up", this.connectionProxyName);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$62, this);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$62, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    void checkStateSignatureSyncUp() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block9: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$63, this, new Object[0]);
                }
                if (this.needStateSignatureSyncUp) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$63, Level.FINER, this.getClass(), $$$methodRef$$$63, "On {0}, need state signature sync at endRequest, forcing roundtrip", this.connectionProxyName);
                    }
                    oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                    try {
                        oconn.pingDatabase();
                    }
                    catch (Throwable error) {
                        if (!bl) break block9;
                        OracleLog.log($$$loggerRef$$$63, Level.FINER, this.getClass(), $$$methodRef$$$63, "On {0}, forced state signature sync at endRequest failed: {1}", new Object[]{this.connectionProxyName, error});
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$63, this);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$63, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BigDecimal longToUB8(long l2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void orig;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$64, this, l2);
            }
            BigInteger origBInt = BigInteger.valueOf((long)orig);
            BigInteger convertedBInt = orig >= 0L ? origBInt : origBInt.add(MASK);
            BigDecimal bigDecimal = new BigDecimal(convertedBInt);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$64, this, bigDecimal);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$64, this, null);
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    public static void cleanup() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$65, null, new Object[0]);
            }
            MEMGUARD_LISTENER.unregister();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$65, null);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$65, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$65, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(TxnFailoverManagerImpl txnFailoverManagerImpl, Connection connection) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x1;
            TxnFailoverManagerImpl x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$66, null, txnFailoverManagerImpl, connection);
            }
            x0.closePhysicalConnection((Connection)x1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$66, null);
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$66, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$66, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void $closeResource(Throwable throwable, AutoCloseable autoCloseable) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x1;
            Throwable x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$67, null, throwable, autoCloseable);
            }
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable2) {
                    x0.addSuppressed(throwable2);
                }
            } else {
                x1.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$67, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$67, null);
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$67, null, null);
            }
            return;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, TxnFailoverManagerImpl.class, $$$methodRef$$$67, null, throwable4);
            }
            throw throwable3;
        }
    }

    static {
        try {
            $$$methodRef$$$68 = TxnFailoverManagerImpl.class.getDeclaredConstructor(TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$67 = TxnFailoverManagerImpl.class.getDeclaredMethod("$closeResource", Throwable.class, AutoCloseable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$66 = TxnFailoverManagerImpl.class.getDeclaredMethod("access$000", TxnFailoverManagerImpl.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$65 = TxnFailoverManagerImpl.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$64 = TxnFailoverManagerImpl.class.getDeclaredMethod("longToUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$63 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkStateSignatureSyncUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$62 = TxnFailoverManagerImpl.class.getDeclaredMethod("setStateSignatureSyncUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$61 = TxnFailoverManagerImpl.class.getDeclaredMethod("isStateUnrestorable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$60 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkACChange", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$59 = TxnFailoverManagerImpl.class.getDeclaredMethod("getService", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$58 = TxnFailoverManagerImpl.class.getDeclaredMethod("getContainer", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$57 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreSavedSessionState", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreAutoCommit", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveCurrentSessionState", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveAutoCommitAndStateSignatures", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLobStreamInRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = TxnFailoverManagerImpl.class.getDeclaredMethod("isLobStreamInRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = TxnFailoverManagerImpl.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = TxnFailoverManagerImpl.class.getDeclaredMethod("clearReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = TxnFailoverManagerImpl.class.getDeclaredMethod("addActiveQueues", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayContext", ReplayContext[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = TxnFailoverManagerImpl.class.getDeclaredMethod("onLogicalTransactionIdEvent", LogicalTransactionIdEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLogicalTransactionId", LogicalTransactionId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = TxnFailoverManagerImpl.class.getDeclaredMethod("getLtxidAtOriginalOutage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = TxnFailoverManagerImpl.class.getDeclaredMethod("getLogicalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = TxnFailoverManagerImpl.class.getDeclaredMethod("closePhysicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = TxnFailoverManagerImpl.class.getDeclaredMethod("isReplayFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = TxnFailoverManagerImpl.class.getDeclaredMethod("getConnectionProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = TxnFailoverManagerImpl.class.getDeclaredMethod("prepareReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class, Boolean.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = TxnFailoverManagerImpl.class.getDeclaredMethod("endReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = TxnFailoverManagerImpl.class.getDeclaredMethod("enableTxnMonitoring", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = TxnFailoverManagerImpl.class.getDeclaredMethod("killConnectionBeforeReplayDisabledException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwOriginalExceptionWithReplayError", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowOriginalError", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowSQLException", Method.class, Integer.TYPE, String.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwReplayExceptionInternal", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnFailoverManagerImpl.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnFailoverManagerImpl.class.getDeclaredMethod("setAutoAC", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateRestoration", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateConsistency", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnFailoverManagerImpl.class.getDeclaredMethod("isSessionStateConsistencyDynamic", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnFailoverManagerImpl.class.getDeclaredMethod("setDataSource", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayAllBeforeLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnFailoverManagerImpl.class.getDeclaredMethod("invokeCallbackAfterReconnect", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayWithLocalCallsOnly", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutageInternal", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutage", Method.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnFailoverManagerImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnFailoverManagerImpl.class.getDeclaredMethod("purgeForSameProxy", Set.class, CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnFailoverManagerImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnFailoverManagerImpl.class.getDeclaredMethod("update", Object.class, CallHistoryEntry.class, Object.class, String.class, Long.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnFailoverManagerImpl.class.getDeclaredMethod("dumpHistory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnFailoverManagerImpl.class.getDeclaredMethod("record", Object.class, Method.class, Object[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnFailoverManagerImpl.class.getDeclaredMethod("remove", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnFailoverManagerImpl.class.getDeclaredMethod("append", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnFailoverManagerImpl.class.getDeclaredMethod("getFailoverManager", TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        activeQueues = 2;
        postExecuteGetCalls = new HashSet<String>(Arrays.asList("getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable"));
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable r2) {
                Thread newT = new Thread(null, r2, THREAD_NAME);
                newT.setPriority(5);
                newT.setDaemon(true);
                return newT;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        disabledDueToMemoryLimit = false;
        disabledDueToMemoryLimitTS = 0L;
        MASK = new BigInteger("18446744073709551616");
        MEMGUARD_LISTENER = MemGuardListener.access$100();
    }

    @DefaultLogger(value="oracle.jdbc.internal.replay")
    @Supports(value={Feature.APPLICATION_CONTINUITY})
    private static final class MemGuardListener
    implements NotificationListener {
        private static final MemGuardListener SOLE_INSTANCE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private MemGuardListener() {
            boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, MemGuardListener.class, $$$methodRef$$$3, null, new Object[0]);
                }
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                emitter.addNotificationListener(this, null, null);
                Pattern old = Pattern.compile(".*Old.*");
                for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || !old.matcher(pool.getName()).matches() || pool.getCollectionUsageThreshold() != 0L) continue;
                    MemoryUsage usage = pool.getUsage();
                    final long threshold = (long)(usage.getMax() == -1L ? (double)Runtime.getRuntime().maxMemory() * 0.9 : (double)usage.getMax() * 0.9);
                    final MemoryPoolMXBean memoryPool = pool;
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$3, Level.FINE, this.getClass(), $$$methodRef$$$3, "MEMGUARD: setCollectionUsageThreshold<" + pool.getName() + ">(" + threshold + ")");
                    }
                    AccessController.doPrivileged(new PrivilegedAction(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        public Object run() {
                            memoryPool.setCollectionUsageThreshold(threshold);
                            return null;
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(MemGuardListener.class, MemoryPoolMXBean.class, Long.TYPE);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, MemGuardListener.class, $$$methodRef$$$3, null);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, MemGuardListener.class, $$$methodRef$$$3, null, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, MemGuardListener.class, $$$methodRef$$$3, null, throwable2);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handleNotification(Notification notification, Object object) {
            boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
            try {
                void notification2;
                String notifType;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, MemGuardListener.class, $$$methodRef$$$0, this, notification, object);
                }
                if ((notifType = notification2.getType()).equals("java.management.memory.collection.threshold.exceeded")) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$0, Level.WARNING, this.getClass(), $$$methodRef$$$0, "MEMGUARD: MEMORY_COLLECTION_THRESHOLD_EXCEEDED");
                    }
                    disabledDueToMemoryLimitTS = System.currentTimeMillis();
                    disabledDueToMemoryLimit = true;
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, MemGuardListener.class, $$$methodRef$$$0, this);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, MemGuardListener.class, $$$methodRef$$$0, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, MemGuardListener.class, $$$methodRef$$$0, this, throwable2);
                }
                throw throwable;
            }
        }

        public void unregister() {
            boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
            try {
                block8: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, MemGuardListener.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                    NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$1, Level.FINE, this.getClass(), $$$methodRef$$$1, "MEMGUARD: removeNotificationListener");
                    }
                    try {
                        emitter.removeNotificationListener(this, null, null);
                    }
                    catch (ListenerNotFoundException e2) {
                        if (!bl) break block8;
                        OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, e2.getMessage() + "\n", e2);
                    }
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, MemGuardListener.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, MemGuardListener.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, MemGuardListener.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable;
            }
        }

        static /* synthetic */ MemGuardListener access$100() {
            boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
            try {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, MemGuardListener.class, $$$methodRef$$$2, null, new Object[0]);
                }
                MemGuardListener memGuardListener = SOLE_INSTANCE;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, MemGuardListener.class, $$$methodRef$$$2, null, memGuardListener);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, MemGuardListener.class, $$$methodRef$$$2, null, null);
                }
                return memGuardListener;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, MemGuardListener.class, $$$methodRef$$$2, null, throwable2);
                }
                throw throwable;
            }
        }

        static {
            try {
                $$$methodRef$$$3 = MemGuardListener.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$2 = MemGuardListener.class.getDeclaredMethod("access$100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$1 = MemGuardListener.class.getDeclaredMethod("unregister", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$0 = MemGuardListener.class.getDeclaredMethod("handleNotification", Notification.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            SOLE_INSTANCE = new MemGuardListener();
        }
    }

    static final class ReplayLifecycle
    extends Enum<ReplayLifecycle> {
        public static final /* enum */ ReplayLifecycle ENABLED_NOT_REPLAYING;
        public static final /* enum */ ReplayLifecycle INTERNALLY_FAILED;
        public static final /* enum */ ReplayLifecycle INTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle ALWAYS_DISABLED;
        public static final /* enum */ ReplayLifecycle EXTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle REPLAYING_CALLBACK;
        public static final /* enum */ ReplayLifecycle REPLAYING;
        public static final /* enum */ ReplayLifecycle REPLAYING_LASTCALL;
        private static final /* synthetic */ ReplayLifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayLifecycle[] values() {
            return (ReplayLifecycle[])$VALUES.clone();
        }

        public static ReplayLifecycle valueOf(String name) {
            return Enum.valueOf(ReplayLifecycle.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayLifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayLifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayLifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ENABLED_NOT_REPLAYING = new ReplayLifecycle();
            INTERNALLY_FAILED = new ReplayLifecycle();
            INTERNALLY_DISABLED = new ReplayLifecycle();
            ALWAYS_DISABLED = new ReplayLifecycle();
            EXTERNALLY_DISABLED = new ReplayLifecycle();
            REPLAYING_CALLBACK = new ReplayLifecycle();
            REPLAYING = new ReplayLifecycle();
            REPLAYING_LASTCALL = new ReplayLifecycle();
            $VALUES = new ReplayLifecycle[]{ENABLED_NOT_REPLAYING, INTERNALLY_FAILED, INTERNALLY_DISABLED, ALWAYS_DISABLED, EXTERNALLY_DISABLED, REPLAYING_CALLBACK, REPLAYING, REPLAYING_LASTCALL};
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long checksum;
        boolean openAcrossPurge;
        int queueId;
        int queueEmptyCount;
        ReplayContext[] replayContext;
        boolean serverAsksToEnqueue;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(Object jdbcProxy, Method m2, Object[] args, String callStatus) {
            this.jdbcProxy = jdbcProxy;
            this.method = m2;
            this.args = args;
            this.result = null;
            this.callStatus = callStatus;
            this.openAcrossPurge = false;
        }

        @DisableTrace
        public String toString() {
            String ret = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i2 = 0; i2 < this.replayContext.length; ++i2) {
                    ret = ret + this.replayContext[i2];
                }
            }
            return ret + "\n";
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(Object.class, Method.class, Object[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

