/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

@DefaultLogger(value="oracle.jdbc")
class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected OpaqueString defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    protected static final int ABORT_AND_CLOSE_ALL_CONNECTIONS = 32;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected boolean cacheUseLIFO = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final String LOCAL_TXN_COMMIT_ON_CLOSE = "LocalTransactionCommitOnClose";
    static final String USE_LIFO_KEY = "UseLIFO";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    Vector instancesToRetireQueue = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    protected int connectionClosedCount = 0;
    protected int connectionCreatedCount = 0;
    boolean cacheLocalTxnCommitOnClose = false;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_21:00:56_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;

    OracleImplicitConnectionCache(OracleDataSource ds, Properties cacheProps) throws SQLException {
        try {
            this.cacheEnabledDS = ds;
            this.initializeConnectionCache();
            this.setConnectionCacheProperties(cacheProps);
            this.defaultUserPrePopulateCache(this.cacheInitialLimit);
        }
        catch (SQLException e2) {
            this.cleanupTimeoutThread();
            this.cleanupRLBThreads();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultUserPrePopulateCache(int sz) throws SQLException {
        if (sz > 0) {
            String user = this.defaultUser;
            String passwd = this.defaultPassword.get();
            this.validateUser(user, passwd);
            OraclePooledConnection pc = null;
            for (int i2 = 0; i2 < sz; ++i2) {
                pc = this.makeOneConnection(user, passwd);
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (pc != null) {
                        --this.cacheSize;
                        this.storeCacheConnection(null, pc);
                    }
                    continue;
                }
            }
        }
    }

    protected void initializeConnectionCache() throws SQLException {
        this.userMap = new HashMap();
        this.checkedOutConnectionList = new Vector();
        if (this.cacheManager == null) {
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        this.defaultUser = this.cacheEnabledDS.user != null && !this.cacheEnabledDS.user.startsWith("\"") ? this.cacheEnabledDS.user.toLowerCase() : this.cacheEnabledDS.user;
        this.defaultPassword = this.cacheEnabledDS.password;
        if (this.connectionPoolDS == null) {
            this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
            this.cacheEnabledDS.copy(this.connectionPoolDS);
        }
        if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
            this.rand = new Random(0L);
            this.instancesToRetireQueue = new Vector();
            ++this.cacheManager.failoverEnabledCacheCount;
        }
    }

    private void validateUser(String user, @Blind String passwd) throws SQLException {
        if (user == null || passwd == null) {
            throw (SQLException)DatabaseError.createSqlException(79).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(String user, @Blind String passwd, Properties connAttr) throws SQLException {
        Connection conn;
        block20: {
            OraclePooledConnection pc = null;
            conn = null;
            try {
                if (this.disableConnectionRequest) {
                    throw (SQLException)DatabaseError.createSqlException(142).fillInStackTrace();
                }
                this.validateUser(user, passwd);
                if (!user.startsWith("\"")) {
                    user = user.toLowerCase();
                }
                if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                    pc = this.getCacheConnection(user, passwd, connAttr);
                }
                if (pc == null) {
                    this.processConnectionCacheCallback();
                    if (this.cacheSize > 0) {
                        pc = this.getCacheConnection(user, passwd, connAttr);
                    }
                    if (pc == null && this.cacheConnectionWaitTimeout > 0) {
                        long localCacheConnectionWaitTimeout = (long)this.cacheConnectionWaitTimeout * 1000L;
                        long beforeWait = System.currentTimeMillis();
                        long afterWait = 0L;
                        do {
                            this.processConnectionWaitTimeout(localCacheConnectionWaitTimeout);
                            if (this.cacheSize > 0) {
                                pc = this.getCacheConnection(user, passwd, connAttr);
                            }
                            afterWait = System.currentTimeMillis();
                            beforeWait = afterWait;
                        } while (pc == null && (localCacheConnectionWaitTimeout -= System.currentTimeMillis() - beforeWait) > 0L);
                    }
                }
                if (pc == null || pc.physicalConn == null || (conn = pc.getConnection()) == null) break block20;
                if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)conn) != 0) {
                    ((OracleConnection)conn).close(4096);
                    throw (SQLException)DatabaseError.createSqlException(143).fillInStackTrace();
                }
                if (this.cacheAbandonedConnectionTimeout > 0) {
                    ((OracleConnection)conn).setAbandonedTimeoutEnabled(true);
                }
                if (this.cacheTimeToLiveTimeout > 0) {
                    ((OracleConnection)conn).setStartTime(System.currentTimeMillis());
                }
                OracleImplicitConnectionCache localCacheConnectionWaitTimeout = this;
                synchronized (localCacheConnectionWaitTimeout) {
                    --this.cacheSize;
                    this.checkedOutConnectionList.addElement(pc);
                }
            }
            catch (SQLException ea) {
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (pc != null) {
                        --this.cacheSize;
                        this.abortConnection(pc);
                    }
                }
                throw ea;
            }
        }
        return conn;
    }

    private OraclePooledConnection getCacheConnection(String user, @Blind String passwd, Properties connAttr) throws SQLException {
        OraclePooledConnection pc = this.retrieveCacheConnection(user, passwd, connAttr);
        if (pc == null && (pc = this.makeOneConnection(user, passwd)) != null && connAttr != null && !connAttr.isEmpty()) {
            this.setUnMatchedAttributes(connAttr, pc);
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePooledConnection makeOneConnection(String _user, @Blind String _passwd) throws SQLException {
        OraclePooledConnection pc = null;
        boolean doMakeCacheConnection = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                ++this.pendingCreationRequests;
                doMakeCacheConnection = true;
            }
        }
        if (doMakeCacheConnection) {
            try {
                pc = this.makeCacheConnection(_user, _passwd);
            }
            finally {
                oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (pc != null) {
                        ++this.connectionCreatedCount;
                    }
                    --this.pendingCreationRequests;
                }
            }
        }
        return pc;
    }

    protected int getTotalCachedConnections() {
        return this.cacheSize + this.getNumberOfCheckedOutConnections();
    }

    protected int getNumberOfCheckedOutConnections() {
        return this.checkedOutConnectionList.size();
    }

    private synchronized OraclePooledConnection retrieveCacheConnection(String user, @Blind String passwd, Properties connAttr) throws SQLException {
        OraclePooledConnection pc = null;
        OracleConnectionCacheEntry m_userConnEntry = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(user, passwd));
        if (m_userConnEntry != null) {
            if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                if (m_userConnEntry.userConnList != null) {
                    pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                }
            } else if (m_userConnEntry.attrConnMap != null) {
                String attrKey = this.buildAttrKey(connAttr);
                Vector attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey);
                if (attrMapEntry != null) {
                    pc = this.retrieveFromConnectionList(attrMapEntry);
                }
                if (pc == null && this.cacheClosestConnectionMatch) {
                    pc = this.retrieveClosestConnectionMatch(m_userConnEntry.attrConnMap, connAttr);
                }
                if (pc == null && m_userConnEntry.userConnList != null) {
                    pc = this.retrieveFromConnectionList(m_userConnEntry.userConnList);
                }
            }
        }
        if (pc != null && connAttr != null && !connAttr.isEmpty()) {
            this.setUnMatchedAttributes(connAttr, pc);
        }
        return pc;
    }

    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap attrConnMap, Properties inAttr) throws SQLException {
        OraclePooledConnection opc = null;
        OraclePooledConnection currOpc = null;
        Vector currOpcVector = null;
        int reqMatchCount = inAttr.size();
        int reqWeightCount = 0;
        int actualWeightCount = 0;
        int currWeightCount = 0;
        int actualMatchCount = 0;
        int currMatchCount = 0;
        if (this.cacheAttributeWeights != null) {
            reqWeightCount = this.getAttributesWeightCount(inAttr, null);
        }
        if (attrConnMap != null && !attrConnMap.isEmpty()) {
            for (Map.Entry me : attrConnMap.entrySet()) {
                Vector aList = (Vector)me.getValue();
                Object[] aObjArr = aList.toArray();
                int asz = aList.size();
                for (int l2 = 0; l2 < asz; ++l2) {
                    opc = (OraclePooledConnection)aObjArr[l2];
                    if (opc.cachedConnectionAttributes == null || opc.cachedConnectionAttributes.isEmpty() || opc.cachedConnectionAttributes.size() > reqMatchCount) continue;
                    if (reqWeightCount > 0) {
                        currWeightCount = this.getAttributesWeightCount(inAttr, opc.cachedConnectionAttributes);
                        if (currWeightCount <= actualWeightCount) continue;
                        currOpc = opc;
                        actualWeightCount = currWeightCount;
                        currOpcVector = aList;
                        continue;
                    }
                    currMatchCount = this.getAttributesMatchCount(inAttr, opc.cachedConnectionAttributes);
                    if (currMatchCount <= actualMatchCount) continue;
                    currOpc = opc;
                    actualMatchCount = currMatchCount;
                    currOpcVector = aList;
                }
            }
        }
        if (currOpcVector != null) {
            currOpcVector.remove(currOpc);
        }
        return currOpc;
    }

    private int getAttributesMatchCount(Properties in, Properties curr) throws SQLException {
        int matchCount = 0;
        Map.Entry<Object, Object> me2 = null;
        Object inKeyObj = null;
        Object inValueObj = null;
        for (Map.Entry<Object, Object> me2 : in.entrySet()) {
            inKeyObj = me2.getKey();
            inValueObj = me2.getValue();
            if (!curr.containsKey(inKeyObj) || !inValueObj.equals(curr.get(inKeyObj))) continue;
            ++matchCount;
        }
        return matchCount;
    }

    private int getAttributesWeightCount(Properties inAttr, Properties currAttr) throws SQLException {
        Map.Entry<Object, Object> me2 = null;
        Object inKeyObj = null;
        Object inValueObj = null;
        int weightCount = 0;
        for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
            inKeyObj = me2.getKey();
            inValueObj = me2.getValue();
            if (currAttr == null) {
                if (!this.cacheAttributeWeights.containsKey(inKeyObj)) continue;
                weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                continue;
            }
            if (!currAttr.containsKey(inKeyObj) || !inValueObj.equals(currAttr.get(inKeyObj))) continue;
            if (this.cacheAttributeWeights.containsKey(inKeyObj)) {
                weightCount += Integer.parseInt((String)this.cacheAttributeWeights.get(inKeyObj));
                continue;
            }
            ++weightCount;
        }
        return weightCount;
    }

    private void setUnMatchedAttributes(Properties inAttr, OraclePooledConnection opc) throws SQLException {
        if (opc.unMatchedCachedConnAttr == null) {
            opc.unMatchedCachedConnAttr = new Properties();
        } else {
            opc.unMatchedCachedConnAttr.clear();
        }
        if (!this.cacheClosestConnectionMatch) {
            opc.unMatchedCachedConnAttr.putAll((Map<?, ?>)inAttr);
        } else {
            Properties curr = opc.cachedConnectionAttributes;
            Map.Entry<Object, Object> me2 = null;
            Object inKeyObj = null;
            Object inValueObj = null;
            for (Map.Entry<Object, Object> me2 : inAttr.entrySet()) {
                inKeyObj = me2.getKey();
                inValueObj = me2.getValue();
                if (curr.containsKey(inKeyObj) || inValueObj.equals(curr.get(inKeyObj))) continue;
                opc.unMatchedCachedConnAttr.put(inKeyObj, inValueObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private OraclePooledConnection retrieveFromConnectionList(Vector vector) throws SQLException {
        void list;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "OracleImplicitConnectionCache.retrieveFromConnectionList( of Conns=" + list.size() + ", list=" + (Vector)list + ")");
        }
        if (list.isEmpty()) {
            return null;
        }
        OraclePooledConnection pc = null;
        if (this.fastConnectionFailoverEnabled) {
            if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    int numInstances = this.databaseInstancesList.size();
                    OracleDatabaseInstance dbInstance = null;
                    int randomPercent = 0;
                    boolean[] tried = new boolean[numInstances];
                    int total = this.dbInstancePercentTotal;
                    block3: for (int j2 = 0; j2 < numInstances; ++j2) {
                        int percentSum = 0;
                        randomPercent = total <= 1 ? 0 : this.rand.nextInt(total - 1);
                        for (int i2 = 0; i2 < numInstances; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            if (tried[i2] || dbInstance.flag > 3) continue;
                            percentSum += dbInstance.percent;
                            if (bl) {
                                this.debug($$$loggerRef$$$13, Level.FINEST, $$$methodRef$$$13, "OracleImplicitConnectionCache.retrieveFromConnectionList()RandomPercent=" + randomPercent + ": percentSum=" + percentSum);
                            }
                            if (randomPercent > percentSum) continue;
                            if (j2 == 0) {
                                ++dbInstance.attemptedConnRequestCount;
                            }
                            if ((pc = this.selectConnectionFromList((Vector)list, dbInstance)) != null) break block3;
                            total -= dbInstance.percent;
                            tried[i2] = true;
                            continue block3;
                        }
                    }
                }
            }
            if (!this.cacheUseLIFO) {
                int sz = list.size();
                int pos = this.rand.nextInt(sz);
                OraclePooledConnection tmpPc = null;
                for (int i3 = 0; i3 < sz; ++i3) {
                    int position = (pos++ + sz) % sz;
                    tmpPc = (OraclePooledConnection)list.get(position);
                    if (tmpPc.connectionMarkedDown) continue;
                    pc = tmpPc;
                    list.remove(pc);
                    break;
                }
            } else {
                pc = (OraclePooledConnection)list.remove(0);
            }
        } else {
            pc = (OraclePooledConnection)list.remove(0);
        }
        return pc;
    }

    /*
     * WARNING - void declaration
     */
    private OraclePooledConnection selectConnectionFromList(Vector vector, OracleDatabaseInstance oracleDatabaseInstance) {
        void dbInstance;
        void list;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        OraclePooledConnection pc = null;
        OraclePooledConnection tmpPc = null;
        int sz = list.size();
        for (int i2 = 0; i2 < sz; ++i2) {
            tmpPc = (OraclePooledConnection)list.get(i2);
            if (tmpPc.connectionMarkedDown || tmpPc.dataSourceDbUniqNameKey != dbInstance.databaseUniqName || tmpPc.dataSourceInstanceNameKey != dbInstance.instanceName) continue;
            pc = tmpPc;
            list.remove(pc);
            break;
        }
        if (bl) {
            this.debug($$$loggerRef$$$14, Level.FINEST, $$$methodRef$$$14, "(RLB) OracleImplicitConnectionCache.selectConnectionFromList(pc=" + pc + ") <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
        }
        return pc;
    }

    private void removeCacheConnection(OraclePooledConnection pc) throws SQLException {
        boolean pcRemoved = false;
        OracleConnectionCacheEntry m_userConnEntry = pc.removeFromImplictCache(this.userMap);
        if (m_userConnEntry != null) {
            String attrKey;
            Vector attrMapEntry;
            Properties connAttr = pc.cachedConnectionAttributes;
            if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                if (m_userConnEntry.userConnList != null) {
                    pcRemoved = m_userConnEntry.userConnList.removeElement(pc);
                }
            } else if (m_userConnEntry.attrConnMap != null && (attrMapEntry = (Vector)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                if (pc.unMatchedCachedConnAttr != null) {
                    pc.unMatchedCachedConnAttr.clear();
                    pc.unMatchedCachedConnAttr = null;
                }
                if (pc.cachedConnectionAttributes != null) {
                    pc.cachedConnectionAttributes.clear();
                    pc.cachedConnectionAttributes = null;
                }
                connAttr = null;
                pcRemoved = attrMapEntry.removeElement(pc);
            }
        }
        if (pcRemoved) {
            --this.cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForEveryCachedConnection(int task) throws SQLException {
        int repSize = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                for (Map.Entry e2 : this.userMap.entrySet()) {
                    OraclePooledConnection pc;
                    OracleConnectionCacheEntry occe = (OracleConnectionCacheEntry)e2.getValue();
                    if (occe.userConnList != null && !occe.userConnList.isEmpty()) {
                        Vector uList = occe.userConnList;
                        Object[] objArr = uList.toArray();
                        for (int k2 = 0; k2 < objArr.length; ++k2) {
                            pc = (OraclePooledConnection)objArr[k2];
                            if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                            ++repSize;
                        }
                    }
                    if (occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                    for (Map.Entry me : occe.attrConnMap.entrySet()) {
                        Vector aList = (Vector)me.getValue();
                        Object[] objArr = aList.toArray();
                        for (int l2 = 0; l2 < objArr.length; ++l2) {
                            pc = (OraclePooledConnection)objArr[l2];
                            if (pc == null || !this.performPooledConnectionTask(pc, task)) continue;
                            ++repSize;
                        }
                    }
                    if (task != 1 && task != 32) continue;
                    occe.attrConnMap.clear();
                }
                if (task == 1 || task == 32) {
                    this.userMap.clear();
                    this.cacheSize = 0;
                }
            }
        }
        if (repSize > 0) {
            this.defaultUserPrePopulateCache(repSize);
        }
    }

    private boolean performPooledConnectionTask(OraclePooledConnection pc, int task) throws SQLException {
        boolean mustReplace = false;
        switch (task) {
            case 2: {
                if (!pc.connectionMarkedDown) break;
                pc.needToAbort = true;
                this.closeAndRemovePooledConnection(pc);
                break;
            }
            case 8: {
                if (this.connectionsToRemove <= 0) break;
                this.closeAndRemovePooledConnection(pc);
                --this.connectionsToRemove;
                break;
            }
            case 24: {
                if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) break;
                this.closeAndRemovePooledConnection(pc);
                --this.retireConnectionsCount;
                if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                mustReplace = true;
                break;
            }
            case 4096: {
                Connection conn = pc.getLogicalHandle();
                if (conn == null && (conn = pc.getPhysicalHandle()) == null || this.testDatabaseConnection((OracleConnection)conn) == 0) break;
                this.closeAndRemovePooledConnection(pc);
                mustReplace = true;
                break;
            }
            case 8192: {
                this.closeAndRemovePooledConnection(pc);
                mustReplace = true;
                break;
            }
            case 1: {
                this.closeAndRemovePooledConnection(pc);
                break;
            }
            case 4: {
                this.processInactivityTimeout(pc);
                break;
            }
            case 16: {
                this.setStatementCaching(pc, this.cacheMaxStatementsLimit, false);
                break;
            }
            case 18: {
                this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
                break;
            }
            case 32: {
                this.abortConnection(pc);
                this.closeAndRemovePooledConnection(pc);
                break;
            }
        }
        return mustReplace;
    }

    protected synchronized void doForEveryCheckedOutConnection(int task) throws SQLException {
        int sz = this.checkedOutConnectionList.size();
        switch (task) {
            case 1: {
                for (int i2 = 0; i2 < sz; ++i2) {
                    this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(i2), false);
                }
                this.checkedOutConnectionList.removeAllElements();
                break;
            }
            case 24: {
                for (int i3 = 0; i3 < sz && this.retireConnectionsCount > 0; ++i3) {
                    OraclePooledConnection pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i3);
                    if (this.instanceToRetire.databaseUniqName != pc.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != pc.dataSourceInstanceNameKey) continue;
                    pc.closeOption = 4096;
                    this.retireConnectionsCount -= 2;
                }
                break;
            }
            case 32: {
                for (int i4 = 0; i4 < sz; ++i4) {
                    OraclePooledConnection pc = null;
                    pc = (OraclePooledConnection)this.checkedOutConnectionList.get(i4);
                    this.abortConnection(pc);
                    this.closeCheckedOutConnection(pc, false);
                }
                this.checkedOutConnectionList.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closeCheckedOutConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        void pc;
        block12: {
            void isReuse;
            boolean bl2;
            boolean bl3 = bl2 = (0L & TraceControllerImpl.feature) != 0L;
            if (pc == null) return;
            OracleConnection lconn = (OracleConnection)pc.getLogicalHandle();
            OracleConnection pconn = (OracleConnection)pc.getPhysicalHandle();
            boolean savedAC = lconn.getAutoCommit();
            if (isReuse != false) {
                boolean savedValue = pc.localTxnCommitOnClose;
                try {
                    pc.localTxnCommitOnClose = false;
                    lconn.cleanupAndClose(true);
                    try {
                        if (savedAC || pc.needToAbort) return;
                        pconn.rollback();
                        return;
                    }
                    catch (SQLException e2) {
                        if (!bl2) return;
                        this.debug($$$loggerRef$$$19, Level.FINEST, $$$methodRef$$$19, "OracleImplicitConnectionCache.closeCheckedOutConnection():rollback() - SQLException Occurred " + e2.getMessage());
                    }
                    return;
                }
                catch (SQLException e3) {
                    if (!bl2) return;
                    this.debug($$$loggerRef$$$19, Level.FINEST, $$$methodRef$$$19, "OracleImplicitConnectionCache.closeCheckedOutConnection():close() - SQLException Occurred " + e3.getMessage());
                    return;
                }
                finally {
                    if (pc.localTxnCommitOnClose != savedValue) {
                        pc.localTxnCommitOnClose = savedValue;
                    }
                }
            }
            try {
                if (!savedAC && !pc.needToAbort) {
                    pconn.cancel();
                    pconn.rollback();
                }
            }
            catch (SQLException e4) {
                if (!bl2) break block12;
                this.debug($$$loggerRef$$$19, Level.FINEST, $$$methodRef$$$19, "OracleImplicitConnectionCache.closeCheckedOutConnection():cancel()/rollback() - SQLException Occurred " + e4.getMessage());
            }
        }
        this.actualPooledConnectionClose((OraclePooledConnection)pc);
    }

    synchronized void storeCacheConnection(Properties connAttr, OraclePooledConnection pc) throws SQLException {
        OracleConnectionCacheEntry m_userConnEntry;
        boolean pcAdded = false;
        if (pc == null || pc.physicalConn == null) {
            return;
        }
        if (this.cacheInactivityTimeout > 0) {
            pc.setLastAccessedTime(System.currentTimeMillis());
        }
        if (pc.unMatchedCachedConnAttr != null) {
            pc.unMatchedCachedConnAttr.clear();
            pc.unMatchedCachedConnAttr = null;
        }
        if ((m_userConnEntry = pc.removeFromImplictCache(this.userMap)) != null) {
            if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                if (m_userConnEntry.userConnList == null) {
                    m_userConnEntry.userConnList = new Vector();
                }
                if (this.cacheUseLIFO) {
                    m_userConnEntry.userConnList.add(0, pc);
                    pcAdded = true;
                } else {
                    pcAdded = m_userConnEntry.userConnList.add(pc);
                }
            } else {
                String attrKey;
                Vector<OraclePooledConnection> attrMapEntry;
                pc.cachedConnectionAttributes = connAttr;
                if (m_userConnEntry.attrConnMap == null) {
                    m_userConnEntry.attrConnMap = new HashMap();
                }
                if ((attrMapEntry = (Vector<OraclePooledConnection>)m_userConnEntry.attrConnMap.get(attrKey = this.buildAttrKey(connAttr))) != null) {
                    if (this.cacheUseLIFO) {
                        attrMapEntry.add(0, pc);
                        pcAdded = true;
                    } else {
                        pcAdded = attrMapEntry.add(pc);
                    }
                } else {
                    attrMapEntry = new Vector<OraclePooledConnection>();
                    pcAdded = attrMapEntry.add(pc);
                    m_userConnEntry.attrConnMap.put(attrKey, attrMapEntry);
                }
            }
        } else {
            m_userConnEntry = new OracleConnectionCacheEntry();
            pc.addToImplicitCache(this.userMap, m_userConnEntry);
            if (connAttr == null || connAttr != null && connAttr.isEmpty()) {
                Vector<OraclePooledConnection> userMapEntry = new Vector<OraclePooledConnection>();
                pcAdded = userMapEntry.add(pc);
                m_userConnEntry.userConnList = userMapEntry;
            } else {
                String attrKey = this.buildAttrKey(connAttr);
                pc.cachedConnectionAttributes = connAttr;
                HashMap userMapEntry = new HashMap();
                Vector<OraclePooledConnection> attrMapEntry = new Vector<OraclePooledConnection>();
                pcAdded = attrMapEntry.add(pc);
                userMapEntry.put(attrKey, attrMapEntry);
                m_userConnEntry.attrConnMap = userMapEntry;
            }
        }
        if (pcAdded) {
            ++this.cacheSize;
        }
        if (this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
    }

    private String buildAttrKey(Properties connAttr) throws SQLException {
        int i2;
        int sz = connAttr.keySet().size();
        Object[] origArray = connAttr.keySet().toArray();
        boolean isChanged = true;
        StringBuffer buf = new StringBuffer();
        while (isChanged) {
            isChanged = false;
            for (i2 = 0; i2 < sz - 1; ++i2) {
                if (((String)origArray[i2]).compareTo((String)origArray[i2 + 1]) <= 0) continue;
                isChanged = true;
                Object tempObj = origArray[i2];
                origArray[i2] = origArray[i2 + 1];
                origArray[i2 + 1] = tempObj;
            }
        }
        for (i2 = 0; i2 < sz; ++i2) {
            buf.append(origArray[i2] + ATTRKEY_DELIM + connAttr.get(origArray[i2]));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OraclePooledConnection makeCacheConnection(String user, @Blind String passwd) throws SQLException {
        OraclePooledConnection pc = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(user, passwd);
        if (pc != null) {
            if (this.cacheMaxStatementsLimit > 0) {
                this.setStatementCaching(pc, this.cacheMaxStatementsLimit, true);
            }
            pc.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
            pc.cachedConnectionAttributes = new Properties();
            if (this.fastConnectionFailoverEnabled) {
                this.initFailoverParameters(pc);
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                ++this.cacheSize;
                if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                    this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                    this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                }
            }
            pc.localTxnCommitOnClose = this.cacheLocalTxnCommitOnClose;
        }
        return pc;
    }

    private void setStatementCaching(OraclePooledConnection pc, int maxLimit, boolean flag) throws SQLException {
        if (maxLimit > 0) {
            pc.setStatementCacheSize(maxLimit);
        }
        pc.setImplicitCachingEnabled(flag);
        pc.setExplicitCachingEnabled(flag);
    }

    protected synchronized void reusePooledConnection(PooledConnection pc) throws SQLException {
        OraclePooledConnection opc = (OraclePooledConnection)pc;
        if (opc != null && opc.physicalConn != null) {
            if (opc.localTxnCommitOnClose) {
                opc.physicalConn.commit();
            } else if (opc.physicalConn.getProtocolType().equals("thin") && opc.physicalConn.getTransactionState().contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                opc.physicalConn.rollback();
            }
            this.storeCacheConnection(opc.cachedConnectionAttributes, opc);
            this.checkedOutConnectionList.removeElement(opc);
            opc.logicalHandle = null;
        }
    }

    protected void closePooledConnection(PooledConnection pc) throws SQLException {
        if (pc != null) {
            this.actualPooledConnectionClose((OraclePooledConnection)pc);
            if (((OraclePooledConnection)pc).closeOption == 4096) {
                this.checkedOutConnectionList.removeElement(pc);
            }
            pc = null;
            if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                this.defaultUserPrePopulateCache(1);
            }
        }
    }

    protected void refreshCacheConnections(int mode) throws SQLException {
        this.doForEveryCachedConnection(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitializeCacheConnections(Properties cp) throws SQLException {
        int connectionsToCreate = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            this.defaultUser = this.cacheEnabledDS.user;
            this.defaultPassword = this.cacheEnabledDS.password;
            this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
            this.cleanupTimeoutThread();
            this.doForEveryCheckedOutConnection(1);
            int origCacheInitialLimit = this.cacheInitialLimit;
            int origCacheMaxLimit = this.cacheMaxLimit;
            int origCacheMaxStatementsLimit = this.cacheMaxStatementsLimit;
            this.setConnectionCacheProperties(cp);
            if (this.cacheInitialLimit > origCacheInitialLimit) {
                connectionsToCreate = this.cacheInitialLimit - origCacheInitialLimit;
            }
            if (origCacheMaxLimit != Integer.MAX_VALUE && this.cacheMaxLimit < origCacheMaxLimit && this.cacheSize > this.cacheMaxLimit) {
                this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
                this.doForEveryCachedConnection(8);
                this.connectionsToRemove = 0;
            }
            if (this.cacheMaxStatementsLimit != origCacheMaxStatementsLimit) {
                if (this.cacheMaxStatementsLimit == 0) {
                    this.doForEveryCachedConnection(16);
                } else {
                    this.doForEveryCachedConnection(18);
                }
            }
        }
        if (connectionsToCreate > 0) {
            this.defaultUserPrePopulateCache(connectionsToCreate);
        }
    }

    protected synchronized void setConnectionCacheProperties(Properties cp) throws SQLException {
        try {
            if (cp != null) {
                Properties caw;
                String inVal = null;
                inVal = cp.getProperty(MIN_LIMIT_KEY);
                if (inVal != null && (this.cacheMinLimit = Integer.parseInt(inVal)) < 0) {
                    this.cacheMinLimit = 0;
                }
                if ((inVal = cp.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(inVal)) < 0) {
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                }
                if (this.cacheMaxLimit < this.cacheMinLimit) {
                    this.cacheMinLimit = this.cacheMaxLimit;
                }
                if ((inVal = cp.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(inVal)) < 0) {
                    this.cacheInitialLimit = 0;
                }
                if (this.cacheInitialLimit > this.cacheMaxLimit) {
                    this.cacheInitialLimit = this.cacheMaxLimit;
                }
                if ((inVal = cp.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(inVal)) < 0) {
                    this.cacheMaxStatementsLimit = 0;
                }
                if ((caw = (Properties)cp.get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                    Map.Entry<Object, Object> me2 = null;
                    int weight = 0;
                    Object inKeyObj = null;
                    for (Map.Entry<Object, Object> me2 : caw.entrySet()) {
                        inKeyObj = me2.getKey();
                        inVal = (String)caw.get(inKeyObj);
                        if (inVal == null || (weight = Integer.parseInt(inVal)) >= 0) continue;
                        caw.put(inKeyObj, DEFAULT_ATTRIBUTE_WEIGHT);
                    }
                    if (this.cacheAttributeWeights == null) {
                        this.cacheAttributeWeights = new Properties();
                    }
                    this.cacheAttributeWeights.putAll((Map<?, ?>)caw);
                }
                if ((inVal = cp.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(inVal)) < 0) {
                    this.cacheInactivityTimeout = 0;
                }
                if ((inVal = cp.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(inVal)) < 0) {
                    this.cacheTimeToLiveTimeout = 0;
                }
                if ((inVal = cp.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(inVal)) < 0) {
                    this.cacheAbandonedConnectionTimeout = 0;
                }
                if ((inVal = cp.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                    this.cacheLowerThresholdLimit = Integer.parseInt(inVal);
                    if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                        this.cacheLowerThresholdLimit = 20;
                    }
                }
                if ((inVal = cp.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(inVal)) < 0) {
                    this.cachePropertyCheckInterval = 900;
                }
                if ((inVal = cp.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                    this.cacheValidateConnection = Boolean.valueOf(inVal);
                }
                if ((inVal = cp.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                    this.cacheClosestConnectionMatch = Boolean.valueOf(inVal);
                }
                if ((inVal = cp.getProperty(USE_LIFO_KEY)) != null) {
                    this.cacheUseLIFO = Boolean.valueOf(inVal);
                }
                if ((inVal = cp.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(inVal)) < 0) {
                    this.cacheConnectionWaitTimeout = 0;
                }
                if ((inVal = cp.getProperty(LOCAL_TXN_COMMIT_ON_CLOSE)) != null) {
                    this.cacheLocalTxnCommitOnClose = inVal.equalsIgnoreCase("true");
                }
            } else {
                this.cacheMinLimit = 0;
                this.cacheMaxLimit = Integer.MAX_VALUE;
                this.cacheInitialLimit = 0;
                this.cacheMaxStatementsLimit = 0;
                this.cacheAttributeWeights = null;
                this.cacheInactivityTimeout = 0;
                this.cacheTimeToLiveTimeout = 0;
                this.cacheAbandonedConnectionTimeout = 0;
                this.cacheLowerThresholdLimit = 20;
                this.cachePropertyCheckInterval = 900;
                this.cacheClosestConnectionMatch = false;
                this.cacheValidateConnection = false;
                this.cacheConnectionWaitTimeout = 0;
                this.cacheLocalTxnCommitOnClose = false;
                this.cacheUseLIFO = false;
            }
            if ((this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) && this.cachePropertyCheckInterval > 0) {
                if (this.timeoutThread == null) {
                    this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                }
                this.cacheManager.checkAndStartThread(this.timeoutThread);
            }
            if (this.cachePropertyCheckInterval == 0) {
                this.cleanupTimeoutThread();
            }
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(139, "OracleImplicitConnectionCache:setConnectionCacheProperties() - NumberFormatException Occurred :" + nfe.getMessage()).fillInStackTrace();
        }
    }

    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties cacheProp = new Properties();
        cacheProp.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
        cacheProp.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
        cacheProp.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
        cacheProp.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
        if (this.cacheAttributeWeights != null) {
            cacheProp.put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
        } else {
            cacheProp.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
        }
        cacheProp.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
        cacheProp.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
        cacheProp.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
        cacheProp.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
        cacheProp.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
        cacheProp.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
        cacheProp.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
        cacheProp.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
        cacheProp.setProperty(LOCAL_TXN_COMMIT_ON_CLOSE, String.valueOf(this.cacheLocalTxnCommitOnClose));
        cacheProp.setProperty(USE_LIFO_KEY, String.valueOf(this.cacheUseLIFO));
        return cacheProp;
    }

    protected int testDatabaseConnection(OracleConnection conn) throws SQLException {
        return conn.pingDatabase();
    }

    protected synchronized void closeConnectionCache(int mode) throws SQLException {
        this.cleanupTimeoutThread();
        this.purgeCacheConnections(true, mode);
        this.connectionPoolDS = null;
        this.cacheEnabledDS = null;
        this.checkedOutConnectionList = null;
        this.userMap = null;
        this.cacheManager = null;
    }

    protected synchronized void disableConnectionCache() throws SQLException {
        this.disableConnectionRequest = true;
    }

    protected synchronized void enableConnectionCache() throws SQLException {
        this.disableConnectionRequest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void initFailoverParameters(OraclePooledConnection oraclePooledConnection) throws SQLException {
        void pc;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        String instanceNameKey = null;
        String DBUniqNameKey = null;
        String val = null;
        Properties prop = ((OracleConnection)pc.getPhysicalHandle()).getServerSessionInfo();
        val = prop.getProperty("INSTANCE_NAME");
        if (val != null) {
            instanceNameKey = pc.dataSourceInstanceNameKey = val.trim().toLowerCase().intern();
        }
        if (bl) {
            this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "Instance Name = " + val);
        }
        if ((val = prop.getProperty("SERVER_HOST")) != null) {
            pc.dataSourceHostNameKey = val.trim().toLowerCase().intern();
        }
        if (bl) {
            this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "Host Name = " + val);
        }
        if ((val = prop.getProperty("SERVICE_NAME")) != null) {
            this.dataSourceServiceName = val.trim();
        }
        if (bl) {
            this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "Service Name = " + val);
        }
        if ((val = prop.getProperty("DATABASE_NAME")) != null) {
            DBUniqNameKey = pc.dataSourceDbUniqNameKey = val.trim().toLowerCase().intern();
        }
        if (bl) {
            this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "DBUniq Name = " + val);
        }
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        int numInstances = this.databaseInstancesList.size();
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            OracleDatabaseInstance dbInstance = null;
            boolean found = false;
            for (int i2 = 0; i2 < numInstances; ++i2) {
                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                if (dbInstance.databaseUniqName != DBUniqNameKey || dbInstance.instanceName != instanceNameKey) continue;
                ++dbInstance.numberOfConnectionsCount;
                found = true;
                break;
            }
            if (!found) {
                OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(DBUniqNameKey, instanceNameKey);
                ++tmpInstance.numberOfConnectionsCount;
                this.databaseInstancesList.add(tmpInstance);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processFailoverEvent(int n2, String string, String string2, String string3, String string4, int n3) {
        void hostNameKey;
        void dbUniqNameKey;
        void instNameKey;
        void status;
        void eventType;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (eventType == 256) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                ++this.downEventCount;
                this.markDownLostConnections(true, false, (String)instNameKey, (String)dbUniqNameKey, (String)hostNameKey, (String)status);
                this.cleanupFailoverConnections(true, false, (String)instNameKey, (String)dbUniqNameKey, (String)hostNameKey, (String)status);
            } else if (status.equalsIgnoreCase("up")) {
                block11: {
                    if (this.downEventCount > 0) {
                        ++this.upEventCount;
                    }
                    try {
                        void card;
                        this.processUpEvent((int)card);
                    }
                    catch (Exception e2) {
                        if (!bl) break block11;
                        OracleLog.debug($$$loggerRef$$$35, Level.INFO, this.getClass(), $$$methodRef$$$35, "OracleImplicitConnectionCache:processFailoverEvent() - Exception Occurred :" + e2.getMessage());
                    }
                }
                this.isEntireServiceDownProcessed = false;
            }
        } else if (eventType == 512 && status.equalsIgnoreCase("nodedown")) {
            this.markDownLostConnections(false, true, (String)instNameKey, (String)dbUniqNameKey, (String)hostNameKey, (String)status);
            this.cleanupFailoverConnections(false, true, (String)instNameKey, (String)dbUniqNameKey, (String)hostNameKey, (String)status);
        } else if (bl) {
            OracleLog.debug($$$loggerRef$$$35, Level.INFO, this.getClass(), $$$methodRef$$$35, "OracleImplicitConnectionCache:processFailoverEvent UnKnown Event:" + (int)eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void processUpEvent(int n2) throws SQLException {
        int card;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        int selectedConnections = 0;
        int connectionsToLoadBalance = 0;
        int totalConnections = this.getTotalCachedConnections();
        boolean isRecreate = false;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        // MONITORENTER : oracleImplicitConnectionCache
        if (card <= 1) {
            card = 2;
        }
        if ((selectedConnections = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) <= 0) {
            if (this.getNumberOfDefaultUserConnections() <= 0) {
                // MONITOREXIT : oracleImplicitConnectionCache
                return;
            }
            connectionsToLoadBalance = (int)((double)this.cacheSize * 0.25);
            isRecreate = true;
        } else {
            connectionsToLoadBalance = selectedConnections / card;
            if (connectionsToLoadBalance + totalConnections > this.cacheMaxLimit) {
                isRecreate = true;
            }
        }
        if (bl) {
            this.debug($$$loggerRef$$$36, Level.FINEST, $$$methodRef$$$36, "OracleImplicitConnectionCache.processUpEvent()selectedConnections=" + selectedConnections + ": connectionsToLoadBalance=" + connectionsToLoadBalance);
        }
        if (this.downEventCount == this.upEventCount) {
            this.defaultUserPreFailureSize = 0;
            this.downEventCount = 0;
            this.upEventCount = 0;
        }
        // MONITOREXIT : oracleImplicitConnectionCache
        if (connectionsToLoadBalance <= 0) return;
        this.loadBalanceConnections(connectionsToLoadBalance, isRecreate);
    }

    /*
     * WARNING - void declaration
     */
    private void loadBalanceConnections(int n2, boolean bl) throws SQLException {
        block8: {
            void connectionsToLoadBalance;
            void isRecreate;
            boolean bl2;
            boolean bl3 = bl2 = (0L & TraceControllerImpl.feature) != 0L;
            if (isRecreate != false) {
                this.connectionsToRemove = connectionsToLoadBalance;
                this.doForEveryCachedConnection(8);
                this.connectionsToRemove = 0;
            }
            if (connectionsToLoadBalance <= 10) {
                try {
                    this.defaultUserPrePopulateCache((int)connectionsToLoadBalance);
                }
                catch (Exception e2) {
                    if (!bl2) break block8;
                    OracleLog.debug($$$loggerRef$$$37, Level.INFO, this.getClass(), $$$methodRef$$$37, "OracleImplicitConnectionCache:loadBalanceConnections():defaultUserPrePopulateCache() - Exception Occurred :" + e2.getMessage());
                }
            } else {
                int val = (int)((double)connectionsToLoadBalance * 0.25);
                for (int i2 = 0; i2 < 4; ++i2) {
                    try {
                        this.defaultUserPrePopulateCache(val);
                        continue;
                    }
                    catch (Exception e3) {
                        if (!bl2) continue;
                        OracleLog.debug($$$loggerRef$$$37, Level.INFO, this.getClass(), $$$methodRef$$$37, "OracleImplicitConnectionCache:loadBalanceConnections():defaultUserPrePopulateCache() - Exception Occurred :" + e3.getMessage());
                    }
                }
            }
        }
    }

    private int getNumberOfDefaultUserConnections() {
        OracleConnectionCacheEntry occe;
        int defaultUserConnections = 0;
        if (this.userMap != null && !this.userMap.isEmpty() && (occe = (OracleConnectionCacheEntry)this.userMap.get(OraclePooledConnection.generateKey(this.defaultUser, this.defaultPassword.get()))) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
            defaultUserConnections = occe.userConnList.size();
        }
        return defaultUserConnections;
    }

    synchronized void markDownLostConnections(boolean serviceDownEvent, boolean hostDownEvent, String instNameKey, String dbUniqNameKey, String hostNameKey, String status) {
        if (!this.isEntireServiceDownProcessed) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator i2 = this.userMap.entrySet().iterator();
                while (i2.hasNext()) {
                    OracleConnectionCacheEntry occe;
                    boolean isDefaultUser = false;
                    Map.Entry e2 = i2.next();
                    Object defaultKey = null;
                    if (this.defaultUser != null && this.defaultPassword != null && !this.defaultPassword.isNull()) {
                        defaultKey = this.defaultUser + this.defaultPassword.get();
                    }
                    if (defaultKey != null && ((String)defaultKey).equalsIgnoreCase((String)e2.getKey())) {
                        isDefaultUser = true;
                    }
                    if ((occe = (OracleConnectionCacheEntry)e2.getValue()) != null && occe.userConnList != null && !occe.userConnList.isEmpty()) {
                        boolean markedDown = false;
                        for (OraclePooledConnection pc : occe.userConnList) {
                            if (serviceDownEvent) {
                                markedDown = this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                            } else if (hostDownEvent) {
                                markedDown = this.markDownConnectionsForHostEvent(hostNameKey, pc);
                            }
                            if (!markedDown || !isDefaultUser) continue;
                            ++this.defaultUserPreFailureSize;
                        }
                    }
                    if (occe == null || occe.attrConnMap == null || occe.attrConnMap.isEmpty()) continue;
                    for (Map.Entry me : occe.attrConnMap.entrySet()) {
                        for (OraclePooledConnection pc : (Vector)me.getValue()) {
                            if (serviceDownEvent) {
                                this.markDownConnectionsForServiceEvent(instNameKey, dbUniqNameKey, pc);
                                continue;
                            }
                            if (!hostDownEvent) continue;
                            this.markDownConnectionsForHostEvent(hostNameKey, pc);
                        }
                    }
                }
            }
            if (instNameKey == null) {
                this.isEntireServiceDownProcessed = true;
            }
        }
    }

    private boolean markDownConnectionsForServiceEvent(String instanceNameKey, String dbUniqNameKey, OraclePooledConnection pc) {
        boolean markedDown = false;
        if (instanceNameKey == null || dbUniqNameKey == pc.dataSourceDbUniqNameKey && instanceNameKey == pc.dataSourceInstanceNameKey) {
            pc.connectionMarkedDown = true;
            markedDown = true;
        }
        return markedDown;
    }

    private boolean markDownConnectionsForHostEvent(String hostNameKey, OraclePooledConnection pc) {
        boolean markedDown = false;
        if (hostNameKey == pc.dataSourceHostNameKey) {
            pc.connectionMarkedDown = true;
            pc.needToAbort = true;
            markedDown = true;
        }
        return markedDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    synchronized void cleanupFailoverConnections(boolean bl, boolean bl2, String string, String string2, String string3, String string4) {
        void dbUniqNameKey;
        void instNameKey;
        int sz;
        Object[] objArr;
        block16: {
            int k2;
            boolean bl3 = (0L & TraceControllerImpl.feature) != 0L;
            OraclePooledConnection pc = null;
            objArr = this.checkedOutConnectionList.toArray();
            sz = this.checkedOutConnectionList.size();
            OraclePooledConnection[] abortedConnections = new OraclePooledConnection[sz];
            int abortedConnectionsCount = 0;
            for (k2 = 0; k2 < sz; ++k2) {
                try {
                    void hostNameKey;
                    void hostDownEvent;
                    void serviceDownEvent;
                    pc = (OraclePooledConnection)objArr[k2];
                    if ((serviceDownEvent == false || instNameKey != null && instNameKey != pc.dataSourceInstanceNameKey || dbUniqNameKey != pc.dataSourceDbUniqNameKey) && (hostDownEvent == false || hostNameKey != pc.dataSourceHostNameKey)) continue;
                    if (pc.isSameUser(this.defaultUser, this.defaultPassword.get()) && pc.cachedConnectionAttributes != null && pc.cachedConnectionAttributes.isEmpty()) {
                        ++this.defaultUserPreFailureSize;
                    }
                    this.checkedOutConnectionList.removeElement(pc);
                    this.abortConnection(pc);
                    pc.needToAbort = true;
                    abortedConnections[abortedConnectionsCount++] = pc;
                    continue;
                }
                catch (Exception e2) {
                    if (!bl3) continue;
                    this.debug($$$loggerRef$$$42, Level.FINEST, $$$methodRef$$$42, "OracleImplicitConnectionCache:cleanupFailoverConnections()- Exception Occurred :" + e2.getMessage());
                }
            }
            for (k2 = 0; k2 < abortedConnectionsCount; ++k2) {
                try {
                    this.closeCheckedOutConnection(abortedConnections[k2], false);
                    continue;
                }
                catch (SQLException e3) {
                    if (!bl3) continue;
                    this.debug($$$loggerRef$$$42, Level.FINEST, $$$methodRef$$$42, "OracleImplicitConnectionCache:cleanupFailoverConnections():closeCheckedOutConnection() - Exception Occurred :" + e3.getMessage());
                }
            }
            if (this.checkedOutConnectionList.size() < sz && this.cacheConnectionWaitTimeout > 0) {
                this.notifyAll();
            }
            try {
                this.doForEveryCachedConnection(2);
            }
            catch (SQLException e4) {
                if (!bl3) break block16;
                this.debug($$$loggerRef$$$42, Level.FINEST, $$$methodRef$$$42, "OracleImplicitConnectionCache:cleanupFailoverConnections():doForEveryCachedConnection() - Exception Occurred :" + e4.getMessage());
            }
        }
        if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance dbInstance = null;
                objArr = this.databaseInstancesList.toArray();
                for (int k3 = 0; k3 < sz; ++k3) {
                    dbInstance = (OracleDatabaseInstance)objArr[k3];
                    if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                    if (dbInstance.flag <= 3) {
                        this.dbInstancePercentTotal -= dbInstance.percent;
                    }
                    this.databaseInstancesList.remove(dbInstance);
                }
            }
        }
    }

    void zapRLBInfo() {
        this.databaseInstancesList.clear();
    }

    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection pc) throws SQLException {
        if (pc != null) {
            if (pc.needToAbort) {
                this.abortConnection(pc);
            }
            this.actualPooledConnectionClose(pc);
            this.removeCacheConnection(pc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void abortConnection(OraclePooledConnection oraclePooledConnection) {
        block2: {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try {
                void pc;
                ((OracleConnection)pc.getPhysicalHandle()).abort();
            }
            catch (Exception ex) {
                if (!bl) break block2;
                OracleLog.debug($$$loggerRef$$$45, Level.INFO, this.getClass(), $$$methodRef$$$45, "OracleImplicitConnectionCache:abortConnection() - Exception Occurred :" + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void actualPooledConnectionClose(OraclePooledConnection oraclePooledConnection) throws SQLException {
        block7: {
            void pc;
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            int sz = 0;
            if (this.databaseInstancesList != null && (sz = this.databaseInstancesList.size()) > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    OracleDatabaseInstance dbInstance = null;
                    for (int i2 = 0; i2 < sz; ++i2) {
                        dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                        if (dbInstance.databaseUniqName != pc.dataSourceDbUniqNameKey || dbInstance.instanceName != pc.dataSourceInstanceNameKey) continue;
                        if (dbInstance.numberOfConnectionsCount <= 0) break;
                        --dbInstance.numberOfConnectionsCount;
                        break;
                    }
                }
            }
            try {
                ++this.connectionClosedCount;
                pc.close();
            }
            catch (SQLException e2) {
                if (!bl) break block7;
                this.debug($$$loggerRef$$$46, Level.FINEST, $$$methodRef$$$46, "OracleImplicitConnectionCache:actualPooledConnectionClose() - Exception Occurred :" + e2.getMessage());
            }
        }
    }

    protected int getCacheTimeToLiveTimeout() {
        return this.cacheTimeToLiveTimeout;
    }

    protected int getCacheInactivityTimeout() {
        return this.cacheInactivityTimeout;
    }

    protected int getCachePropertyCheckInterval() {
        return this.cachePropertyCheckInterval;
    }

    protected int getCacheAbandonedTimeout() {
        return this.cacheAbandonedConnectionTimeout;
    }

    private synchronized void processConnectionCacheCallback() throws SQLException {
        float cachePct = (float)this.cacheMaxLimit / 100.0f;
        int expectedCacheSize = (int)((float)this.cacheLowerThresholdLimit * cachePct);
        this.releaseBasedOnPriority(1024, expectedCacheSize);
        if (this.cacheSize < expectedCacheSize) {
            this.releaseBasedOnPriority(512, expectedCacheSize);
        }
    }

    private void releaseBasedOnPriority(int priority, int expCacheSz) throws SQLException {
        Object[] objArr = this.checkedOutConnectionList.toArray();
        for (int i2 = 0; i2 < objArr.length && this.cacheSize < expCacheSz; ++i2) {
            OracleConnectionCacheCallback occc;
            OraclePooledConnection pc = (OraclePooledConnection)objArr[i2];
            OracleConnection conn = null;
            if (pc != null) {
                conn = (OracleConnection)pc.getLogicalHandle();
            }
            if (conn == null || (occc = conn.getConnectionCacheCallbackObj()) == null || conn.getConnectionCacheCallbackFlag() != 2 && conn.getConnectionCacheCallbackFlag() != 4 || priority != conn.getConnectionReleasePriority()) continue;
            Object userObj = conn.getConnectionCacheCallbackPrivObj();
            occc.releaseConnection(conn, userObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void processConnectionWaitTimeout(long l2) throws SQLException {
        block2: {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try {
                void waitTimeout;
                this.wait((long)waitTimeout);
            }
            catch (InterruptedException ea) {
                if (!bl) break block2;
                this.debug($$$loggerRef$$$53, Level.FINEST, $$$methodRef$$$53, "OracleImplicitConnectionCache:processConnectionWaitTimeout() -Got an InterruptedException:" + ea.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processInactivityTimeout(OraclePooledConnection oraclePooledConnection) throws SQLException {
        void pc;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        long lastAccessedTime = pc.getLastAccessedTime();
        long currentTime = System.currentTimeMillis();
        if (this.getTotalCachedConnections() > this.cacheMinLimit && currentTime - lastAccessedTime > (long)(this.cacheInactivityTimeout * 1000)) {
            if (bl) {
                this.debug($$$loggerRef$$$54, Level.FINEST, $$$methodRef$$$54, "OracleImplicitConnectionCache.processInactivityTimeout():PooledConnection in cache closed:" + (OraclePooledConnection)pc);
            }
            this.closeAndRemovePooledConnection((OraclePooledConnection)pc);
        }
    }

    private void cleanupTimeoutThread() throws SQLException {
        if (this.timeoutThread != null) {
            this.timeoutThread.timeToLive = false;
            if (this.timeoutThread.isSleeping) {
                this.timeoutThread.interrupt();
            }
            this.timeoutThread = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void purgeCacheConnections(boolean bl, int n2) {
        block3: {
            boolean bl2 = (0L & TraceControllerImpl.feature) != 0L;
            try {
                void mode;
                void cleanupCheckedOutConnections;
                if (cleanupCheckedOutConnections != false) {
                    this.doForEveryCheckedOutConnection((int)mode);
                }
                this.doForEveryCachedConnection((int)mode);
            }
            catch (SQLException e2) {
                if (!bl2) break block3;
                this.debug($$$loggerRef$$$56, Level.FINEST, $$$methodRef$$$56, "OracleImplicitConnectionCache:purgeCacheConnections() - Got an Exception:" + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDatabaseInstance(String dbUniqNameKey, String instNameKey, int percent, int flag) {
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            int numInstances = this.databaseInstancesList.size();
            boolean updated = false;
            for (int i2 = 0; i2 < numInstances; ++i2) {
                OracleDatabaseInstance dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                if (dbInstance.databaseUniqName != dbUniqNameKey || dbInstance.instanceName != instNameKey) continue;
                dbInstance.percent = percent;
                dbInstance.flag = flag;
                updated = true;
                break;
            }
            if (!updated) {
                OracleDatabaseInstance tmpInstance = new OracleDatabaseInstance(dbUniqNameKey, instNameKey);
                tmpInstance.percent = percent;
                tmpInstance.flag = flag;
                this.databaseInstancesList.add(tmpInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() throws SQLException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        OracleDatabaseInstance dbInstance = null;
        if (this.databaseInstancesList != null) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                int i2;
                int goodGroupSum = 0;
                boolean resetDBInstanceValues = false;
                this.useGoodGroup = false;
                int numInstances = this.databaseInstancesList.size();
                for (i2 = 0; i2 < numInstances; ++i2) {
                    dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                    if (dbInstance.flag <= 3) {
                        goodGroupSum += dbInstance.percent;
                    }
                    if (!bl) continue;
                    this.debug($$$loggerRef$$$58, Level.FINEST, $$$methodRef$$$58, "(RLB) OracleImplicitConnectionCache.processDatabaseInstances: <<< ServiceName=" + this.dataSourceServiceName + ", Connections to " + dbInstance.instanceName + " = " + dbInstance.numberOfConnectionsCount + ", Attempted Connection Requests to this instance=" + dbInstance.attemptedConnRequestCount + ", Total Connections=" + this.getTotalCachedConnections() + " >>>");
                }
                if (goodGroupSum > 0) {
                    this.dbInstancePercentTotal = goodGroupSum;
                    this.useGoodGroup = true;
                }
                if (numInstances > 1) {
                    for (i2 = 0; i2 < numInstances; ++i2) {
                        dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                        this.countTotal += dbInstance.attemptedConnRequestCount;
                    }
                    if (this.countTotal > numInstances * 1000) {
                        for (i2 = 0; i2 < numInstances; ++i2) {
                            dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                            float ACRRatio = (float)dbInstance.attemptedConnRequestCount / (float)this.countTotal;
                            float connRatio = (float)dbInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                            if (bl) {
                                this.debug($$$loggerRef$$$58, Level.FINEST, $$$methodRef$$$58, "(RLB)OracleImplicitConnectionCache.processDatabaseInstances() \n Total ACR count since last gravitation=" + this.countTotal + "\nNumberofInstances=" + numInstances + "\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                            }
                            if (!(connRatio > ACRRatio * 2.0f)) continue;
                            if (bl) {
                                this.debug($$$loggerRef$$$58, Level.FINEST, $$$methodRef$$$58, "(RLB)OracleImplicitConnectionCache.processDatabaseInstances: For Instance being retired::\nInstanceName=" + dbInstance.instanceName + "\nAttemptedConnectionRequestRatio=" + ACRRatio + "\nConnectionRequestRatio=" + connRatio);
                            }
                            if ((int)((double)dbInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                this.instancesToRetireQueue.addElement(dbInstance);
                            }
                            resetDBInstanceValues = true;
                        }
                        if (resetDBInstanceValues) {
                            for (i2 = 0; i2 < numInstances; ++i2) {
                                dbInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(i2);
                                dbInstance.attemptedConnRequestCount = 0;
                            }
                            resetDBInstanceValues = false;
                        }
                    }
                }
            }
            if (this.instancesToRetireQueue.size() > 0) {
                if (this.gravitateCacheThread != null) {
                    block20: {
                        try {
                            this.gravitateCacheThread.interrupt();
                            this.gravitateCacheThread.join();
                        }
                        catch (InterruptedException ie) {
                            if (!bl) break block20;
                            this.debug($$$loggerRef$$$58, Level.FINEST, $$$methodRef$$$58, "OracleImplicitConnectionCache:processDatabaseInstances() - Got an InterruptedException:" + ie.getMessage());
                        }
                    }
                    this.gravitateCacheThread = null;
                }
                this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
            }
        }
    }

    protected void gravitateCache() {
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        while (this.instancesToRetireQueue.size() > 0) {
            block7: {
                this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireQueue.remove(0);
                this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
                if (bl) {
                    this.debug($$$loggerRef$$$59, Level.FINEST, $$$methodRef$$$59, "(RLB)OracleImplicitConnectionCache.gravitateCache() : Available conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
                }
                try {
                    this.doForEveryCachedConnection(24);
                }
                catch (SQLException e2) {
                    if (!bl) break block7;
                    this.debug($$$loggerRef$$$59, Level.FINEST, $$$methodRef$$$59, "(RLB)OracleImplicitConnectionCache.gravitateCache():doForEveryCachedConnection() - Got a SQLException:" + e2.getMessage());
                }
            }
            if (this.retireConnectionsCount <= 0) continue;
            if (bl) {
                this.debug($$$loggerRef$$$59, Level.FINEST, $$$methodRef$$$59, "(RLB)OracleImplicitConnectionCache.gravitateCache(): checkedout conns to retire from: " + this.instanceToRetire.instanceName + " = " + this.retireConnectionsCount);
            }
            try {
                this.doForEveryCheckedOutConnection(24);
            }
            catch (SQLException e3) {
                if (!bl) continue;
                this.debug($$$loggerRef$$$59, Level.FINEST, $$$methodRef$$$59, "(RLB)OracleImplicitConnectionCache.gravitateCache():doForEveryCheckedOutConnection() - Got an SQLException:" + e3.getMessage());
            }
        }
        this.retireConnectionsCount = 0;
        this.instanceToRetire = null;
        this.countTotal = 0;
    }

    protected void cleanupRLBThreads() {
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (this.gravitateCacheThread != null) {
            block6: {
                try {
                    this.gravitateCacheThread.interrupt();
                    this.gravitateCacheThread.join();
                }
                catch (InterruptedException ie) {
                    if (!bl) break block6;
                    this.debug($$$loggerRef$$$60, Level.FINEST, $$$methodRef$$$60, "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads() - Got an InterruptedException:" + ie.getMessage());
                }
            }
            this.gravitateCacheThread = null;
        }
        if (this.runtimeLoadBalancingThread != null) {
            block7: {
                try {
                    this.runtimeLoadBalancingThread.interrupt();
                }
                catch (Exception e2) {
                    if (!bl) break block7;
                    this.debug($$$loggerRef$$$60, Level.FINEST, $$$methodRef$$$60, "(RLB)OracleImplicitConnectionCache.cleanupRLBThreads() - Got an Exception:" + e2.getMessage());
                }
            }
            this.runtimeLoadBalancingThread = null;
        }
    }

    Map getStatistics() throws SQLException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("PhysicalConnectionClosedCount", new Integer(this.connectionClosedCount));
        map.put("PhysicalConnectionCreatedCount", new Integer(this.connectionCreatedCount));
        return map;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$64 = OracleImplicitConnectionCache.class.getDeclaredConstructor(OracleDataSource.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleImplicitConnectionCache.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleImplicitConnectionCache.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleImplicitConnectionCache.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleImplicitConnectionCache.class.getDeclaredMethod("cleanupRLBThreads", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleImplicitConnectionCache.class.getDeclaredMethod("gravitateCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleImplicitConnectionCache.class.getDeclaredMethod("processDatabaseInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleImplicitConnectionCache.class.getDeclaredMethod("updateDatabaseInstance", String.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleImplicitConnectionCache.class.getDeclaredMethod("purgeCacheConnections", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleImplicitConnectionCache.class.getDeclaredMethod("cleanupTimeoutThread", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleImplicitConnectionCache.class.getDeclaredMethod("processInactivityTimeout", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleImplicitConnectionCache.class.getDeclaredMethod("processConnectionWaitTimeout", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleImplicitConnectionCache.class.getDeclaredMethod("releaseBasedOnPriority", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleImplicitConnectionCache.class.getDeclaredMethod("processConnectionCacheCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleImplicitConnectionCache.class.getDeclaredMethod("getCacheAbandonedTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleImplicitConnectionCache.class.getDeclaredMethod("getCachePropertyCheckInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleImplicitConnectionCache.class.getDeclaredMethod("getCacheInactivityTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleImplicitConnectionCache.class.getDeclaredMethod("getCacheTimeToLiveTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleImplicitConnectionCache.class.getDeclaredMethod("actualPooledConnectionClose", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleImplicitConnectionCache.class.getDeclaredMethod("abortConnection", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleImplicitConnectionCache.class.getDeclaredMethod("closeAndRemovePooledConnection", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleImplicitConnectionCache.class.getDeclaredMethod("zapRLBInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleImplicitConnectionCache.class.getDeclaredMethod("cleanupFailoverConnections", Boolean.TYPE, Boolean.TYPE, String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleImplicitConnectionCache.class.getDeclaredMethod("markDownConnectionsForHostEvent", String.class, OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleImplicitConnectionCache.class.getDeclaredMethod("markDownConnectionsForServiceEvent", String.class, String.class, OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleImplicitConnectionCache.class.getDeclaredMethod("markDownLostConnections", Boolean.TYPE, Boolean.TYPE, String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleImplicitConnectionCache.class.getDeclaredMethod("getNumberOfDefaultUserConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleImplicitConnectionCache.class.getDeclaredMethod("loadBalanceConnections", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleImplicitConnectionCache.class.getDeclaredMethod("processUpEvent", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleImplicitConnectionCache.class.getDeclaredMethod("processFailoverEvent", Integer.TYPE, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleImplicitConnectionCache.class.getDeclaredMethod("initFailoverParameters", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleImplicitConnectionCache.class.getDeclaredMethod("enableConnectionCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleImplicitConnectionCache.class.getDeclaredMethod("disableConnectionCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleImplicitConnectionCache.class.getDeclaredMethod("closeConnectionCache", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleImplicitConnectionCache.class.getDeclaredMethod("testDatabaseConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleImplicitConnectionCache.class.getDeclaredMethod("getConnectionCacheProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleImplicitConnectionCache.class.getDeclaredMethod("setConnectionCacheProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleImplicitConnectionCache.class.getDeclaredMethod("reinitializeCacheConnections", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleImplicitConnectionCache.class.getDeclaredMethod("refreshCacheConnections", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleImplicitConnectionCache.class.getDeclaredMethod("closePooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleImplicitConnectionCache.class.getDeclaredMethod("reusePooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleImplicitConnectionCache.class.getDeclaredMethod("setStatementCaching", OraclePooledConnection.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleImplicitConnectionCache.class.getDeclaredMethod("makeCacheConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleImplicitConnectionCache.class.getDeclaredMethod("buildAttrKey", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleImplicitConnectionCache.class.getDeclaredMethod("storeCacheConnection", Properties.class, OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleImplicitConnectionCache.class.getDeclaredMethod("closeCheckedOutConnection", OraclePooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleImplicitConnectionCache.class.getDeclaredMethod("doForEveryCheckedOutConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleImplicitConnectionCache.class.getDeclaredMethod("performPooledConnectionTask", OraclePooledConnection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleImplicitConnectionCache.class.getDeclaredMethod("doForEveryCachedConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleImplicitConnectionCache.class.getDeclaredMethod("removeCacheConnection", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleImplicitConnectionCache.class.getDeclaredMethod("selectConnectionFromList", Vector.class, OracleDatabaseInstance.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleImplicitConnectionCache.class.getDeclaredMethod("retrieveFromConnectionList", Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleImplicitConnectionCache.class.getDeclaredMethod("setUnMatchedAttributes", Properties.class, OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleImplicitConnectionCache.class.getDeclaredMethod("getAttributesWeightCount", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleImplicitConnectionCache.class.getDeclaredMethod("getAttributesMatchCount", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleImplicitConnectionCache.class.getDeclaredMethod("retrieveClosestConnectionMatch", HashMap.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleImplicitConnectionCache.class.getDeclaredMethod("retrieveCacheConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleImplicitConnectionCache.class.getDeclaredMethod("getNumberOfCheckedOutConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleImplicitConnectionCache.class.getDeclaredMethod("getTotalCachedConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleImplicitConnectionCache.class.getDeclaredMethod("makeOneConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleImplicitConnectionCache.class.getDeclaredMethod("getCacheConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleImplicitConnectionCache.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleImplicitConnectionCache.class.getDeclaredMethod("validateUser", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleImplicitConnectionCache.class.getDeclaredMethod("initializeConnectionCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleImplicitConnectionCache.class.getDeclaredMethod("defaultUserPrePopulateCache", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

