/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY, Feature.CONN_POOL})
public class OracleDataSource
implements oracle.jdbc.datasource.OracleDataSource,
Serializable,
Referenceable {
    static final long serialVersionUID = 3349652938965166731L;
    protected static final String DEFAULT_SERVICE_NAME = "SYS$USERS";
    protected PrintWriter logWriter;
    protected int loginTimeout;
    protected String databaseName;
    protected String serviceName;
    protected String dataSourceName;
    protected String description;
    protected String networkProtocol;
    protected int portNumber;
    protected String user;
    protected OpaqueString password;
    protected String serverName;
    protected String url;
    protected String driverType;
    protected String tnsEntry;
    protected int maxStatements;
    protected boolean implicitCachingEnabled;
    protected boolean explicitCachingEnabled;
    protected boolean maxStatementsSet;
    protected boolean implicitCachingEnabledSet;
    protected boolean explicitCachingEnabledSet;
    protected transient OracleImplicitConnectionCache odsCache;
    protected transient OracleConnectionCacheManager cacheManager;
    protected String connCacheName;
    protected Properties connCacheProperties;
    protected Properties connectionProperties;
    protected boolean connCachingEnabled;
    protected boolean fastConnFailover;
    protected String onsConfigStr;
    public boolean isOracleDataSource;
    private String roleName;
    private static final boolean fastConnectionFailoverSysProperty;
    private boolean urlExplicit;
    private boolean useDefaultConnection;
    protected transient OracleDriver driver;
    private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_21:00:56_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;

    public OracleDataSource() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, null, new Object[0]);
            }
            this.logWriter = null;
            this.loginTimeout = 0;
            this.databaseName = null;
            this.serviceName = null;
            this.dataSourceName = "OracleDataSource";
            this.description = null;
            this.networkProtocol = "tcp";
            this.portNumber = 0;
            this.user = null;
            this.password = null;
            this.serverName = null;
            this.url = null;
            this.driverType = null;
            this.tnsEntry = null;
            this.maxStatements = 0;
            this.implicitCachingEnabled = false;
            this.explicitCachingEnabled = false;
            this.maxStatementsSet = false;
            this.implicitCachingEnabledSet = false;
            this.explicitCachingEnabledSet = false;
            this.odsCache = null;
            this.cacheManager = null;
            this.connCacheName = null;
            this.connCacheProperties = null;
            this.connectionProperties = null;
            this.connCachingEnabled = false;
            this.fastConnFailover = false;
            this.onsConfigStr = null;
            this.isOracleDataSource = true;
            this.roleName = null;
            this.urlExplicit = false;
            this.useDefaultConnection = false;
            this.driver = new OracleDriver();
            this.processFastConnectionFailoverSysProperty();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, null);
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, null, throwable2);
            }
            throw throwable;
        }
    }

    void processFastConnectionFailoverSysProperty() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
                block9: {
                    this.connCachingEnabled = true;
                    if (this.cacheManager == null) {
                        try {
                            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                        }
                        catch (SQLException e2) {
                            if (!bl) break block9;
                            this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleDataSource.processFastConnectionFailoverSysProperty()- SQL Exception Occurred:" + e2.getMessage());
                        }
                    }
                }
                this.fastConnFailover = true;
                this.setSpawnNewThreadToCancel(true);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, new Object[0]);
            }
            String localUser = null;
            OpaqueString localPassword = null;
            OracleDataSource oracleDataSource = this;
            synchronized (oracleDataSource) {
                try {
                    localUser = this.user;
                    localPassword = this.password;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_4
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            String str = null;
            if (localPassword != null) {
                str = localPassword.get();
            }
            Connection connection = this.getConnection(localUser, str);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, connection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _passwd;
            void _user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, string, "*****");
            }
            Connection conn = null;
            if (this.connCachingEnabled) {
                conn = this.getConnection((String)_user, (String)_passwd, null);
            } else {
                if (bl) {
                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleDataSource.getConnection(user, passwd): URL is" + this.url);
                }
                conn = this.getConnection(this.createConnectionBuilder().user((String)_user).password((String)_passwd));
            }
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, connection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, oracleConnectionBuilderImpl);
            }
            Connection conn = null;
            Properties prop = null;
            OracleDataSource oracleDataSource = this;
            synchronized (oracleDataSource) {
                try {
                    if (builder.getGSSCredential() != null && (builder.getUser() != null || builder.getPassword() != null)) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, "GSSCredential and user/password cannot both be set in a connection builder.").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.makeURL();
                    Properties properties = prop = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
                    if (this.url != null) {
                        prop.setProperty("connection_url", this.url);
                    }
                    if (builder.getUser() != null && builder.getPassword() != null) {
                        prop.setProperty("user", builder.getUser());
                        prop.setProperty("password", builder.getPassword());
                    }
                    if (this.loginTimeout != 0) {
                        prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    if (this.maxStatementsSet) {
                        prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                    }
                    if (builder.getInstanceName() != null) {
                        prop.setProperty("oracle.jdbc.targetInstanceName", builder.getInstanceName());
                    }
                    if (builder.getServiceName() != null && !builder.getServiceName().equalsIgnoreCase(DEFAULT_SERVICE_NAME)) {
                        prop.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
                    }
                    if (builder.getShardingKey() != null) {
                        String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
                        prop.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
                    }
                    if (builder.getSuperShardingKey() != null) {
                        String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
                        prop.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl48 : MonitorExitStatement: MONITOREXIT : var4_5
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            conn = this.getPhysicalConnection(prop, builder.getGSSCredential());
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, connection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected Connection getPhysicalConnection(Properties properties, GSSCredential gSSCredential) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void gssCredential;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, properties, gSSCredential);
            }
            Connection conn = null;
            Properties localProps = prop;
            String localUrl = prop.getProperty("connection_url");
            String localUser = prop.getProperty("user");
            String localPassword = localProps.getProperty("password");
            String localInstanceName = localProps.getProperty("oracle.jdbc.targetInstanceName");
            String localServiceName = localProps.getProperty("oracle.jdbc.targetServiceName");
            String shardingKeyStr = localProps.getProperty("oracle.jdbc.targetShardingKey");
            String superShardingKeyStr = localProps.getProperty("oracle.jdbc.targetSuperShardingKey");
            String temp = null;
            boolean localUseDefaultConnection = false;
            if (bl) {
                this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleDataSource.getPhysicalConnection(prop): URL is" + localUrl + ", user: " + localUser + ", password: " + (localPassword == null ? "null" : "*****"));
            }
            OracleDataSource oracleDataSource = this;
            synchronized (oracleDataSource) {
                try {
                    String localLoginTimeout;
                    if (this.connectionProperties != null) {
                        localProps = (Properties)this.connectionProperties.clone();
                        if (localUser != null) {
                            localProps.put("user", localUser);
                        }
                        if (localPassword != null) {
                            localProps.put("password", localPassword);
                        }
                        if (localInstanceName != null) {
                            localProps.put("oracle.jdbc.targetInstanceName", localInstanceName);
                        }
                        if (localServiceName != null) {
                            localProps.put("oracle.jdbc.targetServiceName", localServiceName);
                        }
                        if (shardingKeyStr != null) {
                            localProps.put("oracle.jdbc.targetShardingKey", shardingKeyStr);
                        }
                        if (superShardingKeyStr != null) {
                            localProps.put("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                        }
                    }
                    if (gssCredential == null) {
                        if (localUser == null && this.user != null) {
                            localProps.put("user", this.user);
                        }
                        if (localPassword == null && this.password != null && this.password.get() != null) {
                            localProps.put("password", this.password.get());
                        }
                    }
                    if (localUrl == null) {
                        localUrl = this.url;
                    }
                    if ((localLoginTimeout = prop.getProperty("LoginTimeout")) != null) {
                        localProps.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(localLoginTimeout) * 1000);
                    }
                    localUseDefaultConnection = this.useDefaultConnection;
                    if (this.driver == null) {
                        this.driver = new OracleDriver();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl59 : MonitorExitStatement: MONITOREXIT : var14_15
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            conn = localUseDefaultConnection ? this.driver.defaultConnection() : this.driver.connect(localUrl, localProps, (GSSCredential)gssCredential);
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            temp = prop.getProperty("stmt_cache_size");
            int statementCacheSize = 0;
            if (temp != null) {
                statementCacheSize = Integer.parseInt(temp);
                ((OracleConnection)conn).setStatementCacheSize(statementCacheSize);
            }
            boolean explicitStatementCachingEnabled = false;
            temp = prop.getProperty("ExplicitStatementCachingEnabled");
            if (temp != null) {
                explicitStatementCachingEnabled = temp.equals("true");
                ((OracleConnection)conn).setExplicitCachingEnabled(explicitStatementCachingEnabled);
            } else if (this.explicitCachingEnabled) {
                ((OracleConnection)conn).setExplicitCachingEnabled(true);
            }
            boolean implicitStatementCachingEnabled = false;
            temp = prop.getProperty("ImplicitStatementCachingEnabled");
            if (temp != null) {
                implicitStatementCachingEnabled = temp.equals("true");
                ((OracleConnection)conn).setImplicitCachingEnabled(implicitStatementCachingEnabled);
            } else if (this.implicitCachingEnabled) {
                ((OracleConnection)conn).setImplicitCachingEnabled(true);
            }
            if (statementCacheSize > 0 && !explicitStatementCachingEnabled && !implicitStatementCachingEnabled) {
                ((OracleConnection)conn).setImplicitCachingEnabled(true);
                ((OracleConnection)conn).setExplicitCachingEnabled(true);
            }
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, connection);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Connection getConnection(Properties properties) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cachedConnectionAttributes;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, properties);
            }
            String localUser = null;
            OpaqueString localPassword = null;
            OracleDataSource oracleDataSource = this;
            synchronized (oracleDataSource) {
                try {
                    if (!this.connCachingEnabled) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, sQLException);
                        }
                        throw sQLException;
                    }
                    localUser = this.user;
                    localPassword = this.password;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var4_5
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            String str = null;
            if (localPassword != null) {
                str = localPassword.get();
            }
            Connection connection = conn = this.getConnection(localUser, str, (Properties)cachedConnectionAttributes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, connection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Connection getConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cachedConnectionAttributes;
            void _passwd;
            void _user;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, string, "*****", properties);
            }
            if (!this.connCachingEnabled) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            if (this.odsCache == null) {
                this.cacheInitialize();
            }
            Connection connection = conn = this.odsCache.getConnection((String)_user, (String)_passwd, (Properties)cachedConnectionAttributes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, connection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private synchronized void cacheInitialize() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (this.odsCache == null) {
                if (this.connCacheName != null) {
                    this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
                } else {
                    this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized void close() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
                this.odsCache = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, bl);
            }
            if (this.isOracleDataSource) {
                void flag;
                if (flag != false) {
                    this.connCachingEnabled = true;
                    if (this.cacheManager == null) {
                        this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                    }
                } else if (this.odsCache == null) {
                    this.connCachingEnabled = false;
                    this.fastConnFailover = false;
                    this.setSpawnNewThreadToCancel(false);
                    this.connCacheName = null;
                    this.connCacheProperties = null;
                } else if (bl2) {
                    OracleLog.debug($$$loggerRef$$$9, Level.INFO, this.getClass(), $$$methodRef$$$9, "OracleDataSource.setConnectionCachingEnabled() Can't disable connection caching without calling close()");
                }
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getConnectionCachingEnabled() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl2 = this.connCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionCacheName(String string) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cacheName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, string);
            }
            if (cacheName == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(138).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, sQLException);
                }
                throw sQLException;
            }
            this.connCacheName = cacheName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getConnectionCacheName() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                String string = this.odsCache.cacheName;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, string);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, null);
                }
                return string;
            }
            String string = this.connCacheName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cp;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, properties);
            }
            this.connCacheProperties = cp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                Properties properties = this.odsCache.getConnectionCacheProperties();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, properties);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, null);
                }
                return properties;
            }
            Properties properties = this.connCacheProperties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, properties);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, bl);
            }
            if (!this.fastConnFailover) {
                this.fastConnFailover = flag;
                this.setSpawnNewThreadToCancel((boolean)flag);
            } else if (flag == false) {
                if (bl2) {
                    this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "OracleDataSource.setFastConnectionFailoverEnabled(): setting flag to false is not allowed when the Fast Connection fail over is already set to true");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(255).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, sQLException);
                }
                throw sQLException;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, new Object[0]);
            }
            boolean bl2 = this.fastConnFailover;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getONSConfiguration() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, new Object[0]);
            }
            String string = this.onsConfigStr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, string);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setONSConfiguration(String string) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void onsConfigStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, string);
            }
            this.onsConfigStr = onsConfigStr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getLoginTimeout() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, new Object[0]);
            }
            int n2 = this.loginTimeout;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, n2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setLoginTimeout(int n2) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, n2);
            }
            this.loginTimeout = timeout;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pw;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, printWriter);
            }
            this.logWriter = pw;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, new Object[0]);
            }
            PrintWriter printWriter = this.logWriter;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, printWriter);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, null);
            }
            return printWriter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setTNSEntryName(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dbname;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, string);
            }
            this.tnsEntry = dbname;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized String getTNSEntryName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, new Object[0]);
            }
            String string = this.tnsEntry;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, string);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setDataSourceName(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dsname;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, string);
            }
            this.dataSourceName = dsname;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getDataSourceName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, new Object[0]);
            }
            String string = this.dataSourceName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, string);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getDatabaseName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, new Object[0]);
            }
            String string = this.databaseName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, string);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setDatabaseName(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dbname;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, string);
            }
            this.databaseName = dbname;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setServiceName(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void svcname;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, string);
            }
            this.serviceName = svcname;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized String getServiceName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, new Object[0]);
            }
            String string = this.serviceName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, string);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setServerName(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, string);
            }
            this.serverName = sn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getServerName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, new Object[0]);
            }
            String string = this.serverName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, string);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setURL(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, string);
            }
            this.url = url;
            if (this.url != null) {
                this.urlExplicit = true;
            }
            if (this.connCachingEnabled && this.odsCache != null && this.odsCache.connectionPoolDS != null) {
                this.odsCache.connectionPoolDS.url = url;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getURL() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, new Object[0]);
            }
            if (!this.urlExplicit) {
                this.makeURL();
            }
            String string = this.url;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, string);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setUser(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, string);
            }
            this.user = userName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getUser() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, new Object[0]);
            }
            String string = this.user;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, string);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setPassword(OpaqueString opaqueString) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void os;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, opaqueString);
            }
            this.password = os;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setPassword(@Blind String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pd;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, "*****");
            }
            this.setPassword(OpaqueString.newOpaqueString((String)pd));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    @Blind
    protected String getPassword() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, new Object[0]);
            }
            String string2 = string = this.password != null ? this.password.get() : null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, "******");
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getDescription() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, new Object[0]);
            }
            String string = this.description;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, string);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setDescription(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void des;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, string);
            }
            this.description = des;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized String getDriverType() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, new Object[0]);
            }
            String string = this.driverType;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, string);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setDriverType(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, string);
            }
            this.driverType = dt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized String getNetworkProtocol() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, new Object[0]);
            }
            String string = this.networkProtocol;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, string);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setNetworkProtocol(String string) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void np;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, string);
            }
            this.networkProtocol = np;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setPortNumber(int n2) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, n2);
            }
            this.portNumber = pn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int getPortNumber() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, new Object[0]);
            }
            int n2 = this.portNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, n2);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, new Object[0]);
            }
            Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
            this.addRefProperties(ref);
            Reference reference = ref;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, reference);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, null);
            }
            return reference;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addRefProperties(Reference reference) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ref;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, reference);
            }
            if (this.url != null) {
                ref.add(new StringRefAddr("url", this.url));
            }
            if (this.user != null) {
                ref.add(new StringRefAddr("userName", this.user));
            }
            if (this.password != null && !this.password.isNull()) {
                ref.add(new StringRefAddr("passWord", this.password.get()));
            }
            if (this.description != null) {
                ref.add(new StringRefAddr("description", this.description));
            }
            if (this.driverType != null) {
                ref.add(new StringRefAddr("driverType", this.driverType));
            }
            if (this.serverName != null) {
                ref.add(new StringRefAddr("serverName", this.serverName));
            }
            if (this.databaseName != null) {
                ref.add(new StringRefAddr("databaseName", this.databaseName));
            }
            if (this.serviceName != null) {
                ref.add(new StringRefAddr("serviceName", this.serviceName));
            }
            if (this.networkProtocol != null) {
                ref.add(new StringRefAddr("networkProtocol", this.networkProtocol));
            }
            if (this.portNumber != 0) {
                ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
            }
            if (this.tnsEntry != null) {
                ref.add(new StringRefAddr("tnsentryname", this.tnsEntry));
            }
            if (this.maxStatementsSet) {
                ref.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
            }
            if (this.implicitCachingEnabledSet) {
                ref.add(new StringRefAddr("implicitCachingEnabled", this.implicitCachingEnabled ? "true" : "false"));
            }
            if (this.explicitCachingEnabledSet) {
                ref.add(new StringRefAddr("explicitCachingEnabled", this.explicitCachingEnabled ? "true" : "false"));
            }
            if (this.connCachingEnabled) {
                ref.add(new StringRefAddr("connectionCachingEnabled", "true"));
            }
            if (this.connCacheName != null) {
                ref.add(new StringRefAddr("connectionCacheName", this.connCacheName));
            }
            if (this.connCacheProperties != null) {
                ref.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
            }
            if (this.fastConnFailover) {
                ref.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
            }
            if (this.onsConfigStr != null) {
                ref.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    void makeURL() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, new Object[0]);
            }
            if (this.urlExplicit) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                    ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
                }
                return;
            }
            if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, sQLException);
                }
                throw sQLException;
            }
            if (this.driverType.equals("kprb")) {
                this.useDefaultConnection = true;
                this.url = "jdbc:oracle:kprb:@";
                if (bl) {
                    this.debug($$$loggerRef$$$50, Level.FINEST, $$$methodRef$$$50, "OracleDataSource.makeURL(): useDefaultConnection=" + this.useDefaultConnection + ", url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                    ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
                }
                return;
            }
            if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
                this.url = "jdbc:oracle:oci:@";
                if (bl) {
                    this.debug($$$loggerRef$$$50, Level.FINEST, $$$methodRef$$$50, "OracleDataSource.makeURL(): url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                    ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
                }
                return;
            }
            if (this.tnsEntry != null) {
                this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
                if (bl) {
                    this.debug($$$loggerRef$$$50, Level.FINEST, $$$methodRef$$$50, "OracleDataSource.makeURL(): url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                    ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
                }
                return;
            }
            if (this.serviceName != null) {
                this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
            } else {
                this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
                DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
                if (this.fastConnFailover) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                this.debug($$$loggerRef$$$50, Level.FINEST, $$$methodRef$$$50, "OracleDataSource.makeURL(): url=" + this.url);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void trace(String string) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, string);
            }
            if (bl) {
                void s2;
                this.debug($$$loggerRef$$$51, Level.FINEST, $$$methodRef$$$51, "OracleDataSource.trace(" + (String)s2 + "): logWriter=" + this.logWriter);
            }
            if (this.logWriter != null && bl) {
                this.debug($$$loggerRef$$$51, Level.FINEST, $$$methodRef$$$51, "OracleDataSource.trace(s): logWriter is not null");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ds;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, oracleDataSource);
            }
            ds.setUser(this.user);
            super.setPassword(this.password);
            ds.setTNSEntryName(this.tnsEntry);
            this.makeURL();
            ds.setURL(this.url);
            if (this.loginTimeout > 0) {
                ds.setLoginTimeout(this.loginTimeout);
            }
            ds.connectionProperties = this.connectionProperties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxStatements(int n2) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void max;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, n2);
            }
            if (max < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, sQLException);
                }
                throw sQLException;
            }
            this.maxStatementsSet = true;
            this.maxStatements = max;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, new Object[0]);
            }
            int n2 = this.maxStatements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, n2);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, bl);
            }
            this.implicitCachingEnabledSet = true;
            this.implicitCachingEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, new Object[0]);
            }
            boolean bl2 = this.implicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, bl);
            }
            this.explicitCachingEnabledSet = true;
            this.explicitCachingEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, new Object[0]);
            }
            boolean bl2 = this.explicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, properties);
            }
            this.connectionProperties = value == null ? value : (Properties)value.clone();
            this.setSpawnNewThreadToCancel(this.fastConnFailover);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRoleName(String string) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void roleName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, this, string);
            }
            this.roleName = roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, this);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getRoleName() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, this, new Object[0]);
            }
            String string = this.roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, this, string);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Properties getConnectionProperties() throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, new Object[0]);
            }
            Properties properties = OracleDataSource.filterConnectionProperties(this.connectionProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, properties);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    public static final Properties filterConnectionProperties(Properties properties) {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, null, properties);
            }
            Properties result = null;
            if (prop != null) {
                result = (Properties)prop.clone();
                Enumeration<?> enu = result.propertyNames();
                Object c2 = null;
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    if (key == null || !key.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")) continue;
                    result.remove(key);
                }
                prop.remove(spawnNewThreadToCancelProperty);
            }
            Properties properties2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, null, properties2);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, null, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSpawnNewThreadToCancel(boolean bl) {
        boolean bl2 = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void enable;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, bl);
            }
            if (enable != false) {
                if (this.connectionProperties == null) {
                    this.connectionProperties = new Properties();
                }
                this.connectionProperties.setProperty(spawnNewThreadToCancelProperty, "true");
            } else if (this.connectionProperties != null) {
                this.connectionProperties.remove(spawnNewThreadToCancelProperty);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, objectOutputStream);
            }
            out.defaultWriteObject();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, objectInputStream);
            }
            in.defaultReadObject();
            if (this.connCachingEnabled) {
                this.setConnectionCachingEnabled(this.connCachingEnabled);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this);
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, clazz);
            }
            if (iface.isInterface()) {
                boolean bl2 = iface.isInstance(this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, null);
                }
                return bl2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleDataSource oracleDataSource = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, oracleDataSource);
                    ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, null);
                }
                return (T)oracleDataSource;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, new Object[0]);
            }
            Logger logger = Logger.getLogger("oracle");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, logger);
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, new Object[0]);
            }
            OracleConnectionBuilderImpl oracleConnectionBuilderImpl = new OracleConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;

                @Override
                public OracleConnection build() throws SQLException {
                    boolean bl;
                    boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                    if (bl) {
                        OracleDataSource.this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleDataSource.OracleConnectionBuilder.build(): URL is" + OracleDataSource.this.url);
                    }
                    if (this.gssCredential != null && (this.user != null || this.password != null)) {
                        throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                    }
                    return (OracleConnection)OracleDataSource.this.getConnection(this);
                }

                static {
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredConstructor(OracleDataSource.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, oracleConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, null);
            }
            return oracleConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        boolean bl = (0x40000004000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.pool");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, null, logger);
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$75 = OracleDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = OracleDataSource.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = OracleDataSource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = OracleDataSource.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OracleDataSource.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OracleDataSource.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OracleDataSource.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OracleDataSource.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OracleDataSource.class.getDeclaredMethod("setSpawnNewThreadToCancel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleDataSource.class.getDeclaredMethod("filterConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleDataSource.class.getDeclaredMethod("getConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleDataSource.class.getDeclaredMethod("getRoleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleDataSource.class.getDeclaredMethod("setRoleName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleDataSource.class.getDeclaredMethod("setConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleDataSource.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleDataSource.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleDataSource.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleDataSource.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleDataSource.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleDataSource.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleDataSource.class.getDeclaredMethod("copy", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleDataSource.class.getDeclaredMethod("trace", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleDataSource.class.getDeclaredMethod("makeURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleDataSource.class.getDeclaredMethod("addRefProperties", Reference.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleDataSource.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleDataSource.class.getDeclaredMethod("getPortNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleDataSource.class.getDeclaredMethod("setPortNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleDataSource.class.getDeclaredMethod("setNetworkProtocol", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleDataSource.class.getDeclaredMethod("getNetworkProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleDataSource.class.getDeclaredMethod("setDriverType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleDataSource.class.getDeclaredMethod("getDriverType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleDataSource.class.getDeclaredMethod("setDescription", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleDataSource.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleDataSource.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleDataSource.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleDataSource.class.getDeclaredMethod("setPassword", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleDataSource.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleDataSource.class.getDeclaredMethod("setUser", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleDataSource.class.getDeclaredMethod("getURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleDataSource.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleDataSource.class.getDeclaredMethod("getServerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleDataSource.class.getDeclaredMethod("setServerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleDataSource.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleDataSource.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleDataSource.class.getDeclaredMethod("setDatabaseName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleDataSource.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleDataSource.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleDataSource.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleDataSource.class.getDeclaredMethod("getTNSEntryName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleDataSource.class.getDeclaredMethod("setTNSEntryName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleDataSource.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleDataSource.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleDataSource.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleDataSource.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleDataSource.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleDataSource.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleDataSource.class.getDeclaredMethod("getFastConnectionFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleDataSource.class.getDeclaredMethod("setFastConnectionFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleDataSource.class.getDeclaredMethod("getConnectionCacheProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleDataSource.class.getDeclaredMethod("setConnectionCacheProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleDataSource.class.getDeclaredMethod("getConnectionCacheName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleDataSource.class.getDeclaredMethod("setConnectionCacheName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleDataSource.class.getDeclaredMethod("getConnectionCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleDataSource.class.getDeclaredMethod("setConnectionCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleDataSource.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDataSource.class.getDeclaredMethod("cacheInitialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDataSource.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDataSource.class.getDeclaredMethod("getPhysicalConnection", Properties.class, GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDataSource.class.getDeclaredMethod("getConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDataSource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDataSource.class.getDeclaredMethod("processFastConnectionFailoverSysProperty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

