/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
class ServiceMember {
    private String name;
    private String svc;
    private String db;
    private String hst;
    private boolean restarted;
    int connCount;
    private MemberStatus status;
    private ConcurrentHashMap<OracleConnection, OracleConnection> connections;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_21:00:56_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    ServiceMember(String svcname, String iname, String dbuniq, String hstname) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ServiceMember.class, $$$methodRef$$$10, null, svcname, iname, dbuniq, hstname);
            }
            this.name = iname;
            this.svc = svcname;
            this.db = dbuniq;
            this.hst = hstname;
            this.restarted = false;
            this.connCount = 0;
            this.status = MemberStatus.UNKNOWN;
            this.connections = new ConcurrentHashMap();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ServiceMember.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ServiceMember.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ServiceMember.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    void up() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ServiceMember.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "Marked service member UP: " + this.name);
            }
            this.status = MemberStatus.UP;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ServiceMember.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ServiceMember.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ServiceMember.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void down() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ServiceMember.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "Marked service member DOWN: " + this.name);
            }
            this.status = MemberStatus.DOWN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ServiceMember.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ServiceMember.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ServiceMember.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isDown() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ServiceMember.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.status == MemberStatus.DOWN;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ServiceMember.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ServiceMember.class, $$$methodRef$$$2, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ServiceMember.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isUp() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ServiceMember.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.status == MemberStatus.UP;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ServiceMember.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ServiceMember.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ServiceMember.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addConnection(OracleConnection oracleConnection) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ServiceMember.class, $$$methodRef$$$4, this, oracleConnection);
            }
            this.connections.put((OracleConnection)oconn, (OracleConnection)oconn);
            ++this.connCount;
            if (bl) {
                OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "Added connection to service member: " + (OracleConnection)oconn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ServiceMember.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ServiceMember.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ServiceMember.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void dropConnection(OracleConnection oracleConnection) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ServiceMember.class, $$$methodRef$$$5, this, oracleConnection);
            }
            this.connections.remove(oconn);
            if (this.connCount > 0) {
                --this.connCount;
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "Removed connection to service member: " + (OracleConnection)oconn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ServiceMember.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ServiceMember.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ServiceMember.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanupConnections() throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ServiceMember.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "Cleaning up connections to service member: " + this.name);
            }
            ConcurrentHashMap<OracleConnection, OracleConnection> _conns = this.connections;
            this.connections = new ConcurrentHashMap();
            for (OracleConnection oconn : _conns.keySet()) {
                oconn.abort();
                oconn.close();
                if (!bl) continue;
                OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "Cleaned up connection to service member: " + oconn);
            }
            this.connCount = 0;
            _conns.clear();
            if (bl) {
                OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "Cleaned up all connections to service member: " + this.name);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ServiceMember.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ServiceMember.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ServiceMember.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getName() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ServiceMember.class, $$$methodRef$$$7, this, new Object[0]);
            }
            String string = this.name;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ServiceMember.class, $$$methodRef$$$7, this, string);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ServiceMember.class, $$$methodRef$$$7, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ServiceMember.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    String getDatabase() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ServiceMember.class, $$$methodRef$$$8, this, new Object[0]);
            }
            String string = this.db;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ServiceMember.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ServiceMember.class, $$$methodRef$$$8, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ServiceMember.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return "Service name: " + this.svc + ", Instance name: " + this.name + ", Database name: " + this.db + ", Host name: " + this.hst;
    }

    private static Logger logger() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ServiceMember.class, $$$methodRef$$$9, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.driver");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ServiceMember.class, $$$methodRef$$$9, null, logger);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ServiceMember.class, $$$methodRef$$$9, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ServiceMember.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$10 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ServiceMember.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ServiceMember.class.getDeclaredMethod("getDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ServiceMember.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ServiceMember.class.getDeclaredMethod("cleanupConnections", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ServiceMember.class.getDeclaredMethod("dropConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ServiceMember.class.getDeclaredMethod("addConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ServiceMember.class.getDeclaredMethod("isUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ServiceMember.class.getDeclaredMethod("isDown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ServiceMember.class.getDeclaredMethod("down", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ServiceMember.class.getDeclaredMethod("up", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ServiceMember"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class MemberStatus
    extends Enum<MemberStatus> {
        public static final /* enum */ MemberStatus UNKNOWN;
        public static final /* enum */ MemberStatus UP;
        public static final /* enum */ MemberStatus DOWN;
        private static final /* synthetic */ MemberStatus[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static MemberStatus[] values() {
            return (MemberStatus[])$VALUES.clone();
        }

        public static MemberStatus valueOf(String name) {
            return Enum.valueOf(MemberStatus.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = MemberStatus.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = MemberStatus.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = MemberStatus.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            UNKNOWN = new MemberStatus();
            UP = new MemberStatus();
            DOWN = new MemberStatus();
            $VALUES = new MemberStatus[]{UNKNOWN, UP, DOWN};
        }
    }
}

