/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.http.ClientConfigurator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import lombok.NonNull;

public class DelegationTokenConfigurator
implements ClientConfigurator {
    private final String delegationToken;

    @Override
    public void customizeBuilder(ClientBuilder builder) {
    }

    @Override
    public void customizeClient(Client client) {
        client.register((Object)new DelegationTokenClientFilter(this.delegationToken));
    }

    @ConstructorProperties(value={"delegationToken"})
    public DelegationTokenConfigurator(String delegationToken) {
        this.delegationToken = delegationToken;
    }

    @Priority(value=998)
    public static class DelegationTokenClientFilter
    implements ClientRequestFilter {
        public static final int PRIORITY = 998;
        private final String delegationToken;

        public DelegationTokenClientFilter(@NonNull String delegationToken) {
            if (delegationToken == null) {
                throw new NullPointerException("delegationToken is marked @NonNull but is null");
            }
            this.delegationToken = delegationToken;
        }

        public void filter(@NonNull ClientRequestContext clientRequestContext) throws IOException {
            if (clientRequestContext == null) {
                throw new NullPointerException("clientRequestContext is marked @NonNull but is null");
            }
            clientRequestContext.getHeaders().putSingle((Object)"opc-obo-token", (Object)this.delegationToken);
        }
    }
}

