/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.http.ClientConfigurator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

@InternalSdk
public class AbstractRequestingAuthenticationDetailsProvider
implements BasicAuthenticationDetailsProvider {
    protected final FederationClient federationClient;
    protected final CachingSessionKeySupplier sessionKeySupplier;

    public AbstractRequestingAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier) {
        this.federationClient = federationClient;
        this.sessionKeySupplier = new CachingSessionKeySupplier(sessionKeySupplier);
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.federationClient.getSecurityToken();
    }

    @Override
    public InputStream getPrivateKey() {
        return new ByteArrayInputStream(this.sessionKeySupplier.getPrivateKeyBytes());
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return null;
    }

    @Override
    public char[] getPassphraseCharacters() {
        return null;
    }

    protected static class CachingSessionKeySupplier
    implements SessionKeySupplier {
        private final SessionKeySupplier delegate;
        private RSAPrivateKey lastPrivateKey = null;
        private byte[] privateKeyBytes = null;

        protected CachingSessionKeySupplier(SessionKeySupplier delegate) {
            this.delegate = delegate;
            this.setPrivateKeyBytes((RSAPrivateKey)delegate.getKeyPair().getPrivate());
        }

        @Override
        public KeyPair getKeyPair() {
            return this.delegate.getKeyPair();
        }

        @Override
        @Deprecated
        public synchronized RSAPublicKey getPublicKey() {
            return this.delegate.getPublicKey();
        }

        @Override
        @Deprecated
        public synchronized RSAPrivateKey getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public synchronized void refreshKeys() {
            this.delegate.refreshKeys();
        }

        protected synchronized byte[] getPrivateKeyBytes() {
            this.setPrivateKeyBytes((RSAPrivateKey)this.getKeyPair().getPrivate());
            return this.privateKeyBytes;
        }

        private void setPrivateKeyBytes(RSAPrivateKey privateKey) {
            if (privateKey != null && privateKey != this.lastPrivateKey) {
                this.lastPrivateKey = privateKey;
                this.privateKeyBytes = AuthUtils.toByteArrayFromRSAPrivateKey(privateKey);
            }
        }
    }

    protected static abstract class Builder<B extends Builder<B>> {
        protected Set<X509CertificateSupplier> intermediateCertificateSuppliers;
        protected SessionKeySupplier sessionKeySupplier;
        protected ClientConfigurator federationClientConfigurator;
        protected FederationClient federationClient;
        protected List<ClientConfigurator> additionalFederationClientConfigurators = new ArrayList<ClientConfigurator>();

        protected Builder() {
        }

        public B sessionKeySupplier(SessionKeySupplier sessionKeySupplier) {
            this.sessionKeySupplier = sessionKeySupplier;
            return (B)this;
        }

        public B intermediateCertificateSuppliers(Set<X509CertificateSupplier> intermediateCertificateSuppliers) {
            this.intermediateCertificateSuppliers = intermediateCertificateSuppliers;
            return (B)this;
        }

        public B federationClientConfigurator(ClientConfigurator clientConfigurator) {
            this.federationClientConfigurator = clientConfigurator;
            return (B)this;
        }

        public B additionalFederationClientConfigurator(@NonNull ClientConfigurator additionalClientConfigurator) {
            if (additionalClientConfigurator == null) {
                throw new NullPointerException("additionalClientConfigurator is marked @NonNull but is null");
            }
            this.additionalFederationClientConfigurators.add(additionalClientConfigurator);
            return (B)this;
        }
    }
}

