/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLByteReader;

class XMLUCS2Reader
extends XMLByteReader {
    boolean utf16Mode = false;
    boolean surrogate = false;

    XMLUCS2Reader(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    void reset() {
        this.utf16Mode = false;
        this.surrogate = false;
        super.reset();
    }

    void fillBuffer() throws IOException {
        boolean bl = false;
        while (true) {
            try {
                while (true) {
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    int n = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n);
                    if (bl || n == 65535 || n == 65534) {
                        String string = this.err.getMessage1(171, Integer.toHexString(n));
                        throw new IOException(string);
                    }
                    this.charBuffer[this.endPos] = (char)n;
                    this.byteIndex += 2;
                    ++this.endPos;
                    if (this.charBuffer[this.endPos - 1] != '\r' && this.charBuffer[this.endPos - 1] != '\n') continue;
                    char c = this.charBuffer[this.endPos - 1];
                    this.setLineNumber(this.endPos - 1);
                    this.charBuffer[this.endPos - 1] = 10;
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    n = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n);
                    if (bl || n == 65535 || n == 65534) {
                        String string = this.err.getMessage1(171, Integer.toHexString(n));
                        throw new IOException(string);
                    }
                    if (c != '\r' || this.charBuffer[this.endPos] == '\n') continue;
                    this.charBuffer[this.endPos] = (char)n;
                    this.byteIndex += 2;
                    ++this.endPos;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkSurrogate(int n) {
        if (n >= 55296 && n < 57344) {
            if (!this.utf16Mode) return true;
            if (n < 56320) {
                if (this.surrogate) {
                    return true;
                }
                this.surrogate = true;
                return false;
            } else {
                if (!this.surrogate) {
                    return true;
                }
                this.surrogate = false;
            }
            return false;
        } else {
            if (!this.surrogate) return false;
            return true;
        }
    }

    void setUTF16Mode(boolean bl) {
        this.utf16Mode = bl;
    }

    void setByteOrder(int n) {
        this.byteOrder = n;
        if (n == 1) {
            this.first = 1;
            this.second = 0;
        }
    }
}

