/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLToken;
import oracle.xml.binxml.BinXMLTokenList;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.util.XMLError;

class BinXMLTokenManager
implements BinXMLConstants {
    boolean q4level = false;
    boolean q8level = false;
    HashMap elementIdTokens;
    HashMap attrIdTokens;
    Hashtable namespaceIdTokens;
    HashMap elementNameTokens;
    HashMap elementNSTokens;
    HashMap attrNameTokens;
    HashMap attrNSTokens;
    HashMap namespaceURITokens;
    BinXMLProcessor binXMLProc;
    BinXMLMetadataProvider metaProvider;
    XMLError err;
    static BinXMLNamespaceToken nstoken1 = BinXMLToken.createNamespaceToken(1L, "http://www.w3.org/XML/1998/namespace");
    static BinXMLNamespaceToken nstoken2 = BinXMLToken.createNamespaceToken(2L, "http://www.w3.org/XML/2000/xmlns/");
    static BinXMLNamespaceToken nstoken3 = BinXMLToken.createNamespaceToken(3L, "http://www.w3.org/2001/XMLSchema-instance");
    static BinXMLNamespaceToken nstoken4 = BinXMLToken.createNamespaceToken(4L, "http://www.w3.org/2001/XMLSchema");
    static BinXMLNamespaceToken nstoken5 = BinXMLToken.createNamespaceToken(5L, "http://xmlns.oracle.com/2004/csx");
    static BinXMLNamespaceToken nstoken6 = BinXMLToken.createNamespaceToken(6L, "http://xmlns.oracle.com/xdb");
    static BinXMLNamespaceToken nstoken7 = BinXMLToken.createNamespaceToken(7L, "");
    static BinXMLNamespaceToken nstoken8 = BinXMLToken.createNamespaceToken(8L, "http://www.w3.org/2001/XInclude");
    static BinXMLQNameToken attrtoken0 = BinXMLToken.createQNameToken(16L, 1L, "space", true);
    static BinXMLQNameToken attrtoken1 = BinXMLToken.createQNameToken(17L, 1L, "lang", true);
    static BinXMLQNameToken attrtoken2 = BinXMLToken.createQNameToken(18L, 3L, "type", true);
    static BinXMLQNameToken attrtoken3 = BinXMLToken.createQNameToken(19L, 3L, "nil", true);
    static BinXMLQNameToken attrtoken4 = BinXMLToken.createQNameToken(20L, 3L, "schemaLocation", true);
    static BinXMLQNameToken attrtoken5 = BinXMLToken.createQNameToken(21L, 3L, "noNamespaceSchemaLocation", true);
    static BinXMLQNameToken attrtoken6 = BinXMLToken.createQNameToken(22L, 2L, "xmlns", true);

    BinXMLTokenManager(BinXMLProcessor binXMLProcessor) {
        this.binXMLProc = binXMLProcessor;
        this.initTables();
    }

    private void initTables() {
        this.elementIdTokens = new HashMap(100);
        this.attrIdTokens = new HashMap(100);
        this.namespaceIdTokens = new Hashtable(100);
        this.elementNameTokens = new HashMap(100);
        this.elementNSTokens = new HashMap(100);
        this.attrNameTokens = new HashMap(100);
        this.attrNSTokens = new HashMap(100);
        this.namespaceURITokens = new HashMap(100);
        this.attrIdTokens.put(new Long(16L), attrtoken0);
        this.attrIdTokens.put(new Long(17L), attrtoken1);
        this.attrIdTokens.put(new Long(18L), attrtoken2);
        this.attrIdTokens.put(new Long(19L), attrtoken3);
        this.attrIdTokens.put(new Long(20L), attrtoken4);
        this.attrIdTokens.put(new Long(21L), attrtoken5);
        this.attrIdTokens.put(new Long(22L), attrtoken6);
        this.namespaceIdTokens.put(new Long(1L), nstoken1);
        this.namespaceIdTokens.put(new Long(2L), nstoken2);
        this.namespaceIdTokens.put(new Long(3L), nstoken3);
        this.namespaceIdTokens.put(new Long(4L), nstoken4);
        this.namespaceIdTokens.put(new Long(5L), nstoken5);
        this.namespaceIdTokens.put(new Long(6L), nstoken6);
        this.namespaceIdTokens.put(new Long(7L), nstoken7);
        this.namespaceIdTokens.put(new Long(8L), nstoken8);
        this.attrNameTokens.put(attrtoken0.getLocalName(), new BinXMLTokenList(attrtoken0));
        this.attrNameTokens.put(attrtoken1.getLocalName(), new BinXMLTokenList(attrtoken1));
        this.attrNameTokens.put(attrtoken2.getLocalName(), new BinXMLTokenList(attrtoken2));
        this.attrNameTokens.put(attrtoken3.getLocalName(), new BinXMLTokenList(attrtoken3));
        this.attrNameTokens.put(attrtoken4.getLocalName(), new BinXMLTokenList(attrtoken4));
        this.attrNameTokens.put(attrtoken5.getLocalName(), new BinXMLTokenList(attrtoken5));
        this.attrNameTokens.put(attrtoken6.getLocalName(), new BinXMLTokenList(attrtoken6));
        BinXMLTokenList binXMLTokenList = new BinXMLTokenList();
        binXMLTokenList.add(attrtoken0);
        binXMLTokenList.add(attrtoken1);
        this.attrNSTokens.put(new Long(1L), binXMLTokenList);
        binXMLTokenList = new BinXMLTokenList();
        binXMLTokenList.add(attrtoken2);
        binXMLTokenList.add(attrtoken3);
        binXMLTokenList.add(attrtoken4);
        binXMLTokenList.add(attrtoken5);
        this.attrNSTokens.put(new Long(3L), binXMLTokenList);
        this.attrNSTokens.put(new Long(2L), new BinXMLTokenList(attrtoken6));
        this.namespaceURITokens.put(nstoken1.getLocalName(), nstoken1);
        this.namespaceURITokens.put(nstoken2.getLocalName(), nstoken2);
        this.namespaceURITokens.put(nstoken3.getLocalName(), nstoken3);
        this.namespaceURITokens.put(nstoken4.getLocalName(), nstoken4);
        this.namespaceURITokens.put(nstoken5.getLocalName(), nstoken5);
        this.namespaceURITokens.put(nstoken6.getLocalName(), nstoken6);
        this.namespaceURITokens.put(nstoken7.getLocalName(), nstoken7);
        this.namespaceURITokens.put(nstoken8.getLocalName(), nstoken8);
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
    }

    BinXMLQNameToken putElement(String string, long l) throws BinXMLException {
        return this.putQName(string, l, false);
    }

    BinXMLQNameToken putAttr(String string, long l) throws BinXMLException {
        return this.putQName(string, l, true);
    }

    private BinXMLQNameToken putQName(String string, long l, boolean bl) throws BinXMLException {
        Object object;
        long l2 = -1L;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.metaProvider == null || !(this.metaProvider instanceof DBBinXMLMetadataProviderImpl)) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byArray2 = new byte[9 + byArray.length];
            BinXMLStreamImpl.writeNum8(l, byArray2, 0);
            byArray2[8] = bl ? (byte)1 : 0;
            BinXMLStreamImpl.copyByteArray(byArray, 0, byArray.length, byArray2, 9);
            l2 = this.generateTokenId(byArray2);
        } else {
            BinXMLNamespaceToken binXMLNamespaceToken = this.getNamespaceToken(l);
            object = binXMLNamespaceToken.getLocalName();
            if (object == null) {
                object = "";
            }
            l2 = this.getTokenId((String)object, string, bl);
        }
        int n = 0;
        while (true) {
            if ((object = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l2))) == null) {
                object = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l2));
            }
            if (object == null) break;
            if (((BinXMLQNameToken)object).isAttr() == bl && ((BinXMLToken)object).getLocalName().equals(string) && ((BinXMLQNameToken)object).getNamespaceId() == l) {
                return object;
            }
            if (n++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l2 = this.regenerateTokenId(l2, byArray2);
                n = 0;
                continue;
            }
            l2 = this.regenerateTokenId(l2, null);
        }
        object = this.registerTokenId(l2, string, l, bl);
        return object;
    }

    private void setQ2Q4Q8Level() {
        if (!this.q4level && !this.q8level) {
            this.q4level = true;
        } else if (this.q4level && !this.q8level) {
            this.q4level = false;
            this.q8level = true;
        }
    }

    private String getNamespaceIDfromXDB(String string) throws BinXMLException {
        BinXMLStream binXMLStream = ((DBBinXMLMetadataProviderImpl)this.metaProvider).getNamespaceIDfromXDBByPLSQL(string);
        if (binXMLStream != null) {
            BinXMLDecoder binXMLDecoder = binXMLStream.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
            if (binXMLNamespaceToken == null) {
                return null;
            }
            long l = binXMLNamespaceToken.getTokenId();
            String string2 = Long.toHexString(l);
            return string2;
        }
        return null;
    }

    BinXMLNamespaceToken putNamespace(String string) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken;
        byte[] byArray = null;
        long l = 0L;
        boolean bl = false;
        if (string == null) {
            return nstoken7;
        }
        if (this.metaProvider == null || !(this.metaProvider instanceof DBBinXMLMetadataProviderImpl)) {
            byArray = string.getBytes();
            l = this.generateTokenId(byArray);
        } else {
            String string2 = this.getNamespaceIDfromXDB(string);
            if (string2 == null) {
                throw new BinXMLException(this.err.getMessage1(35012, string));
            }
            l = BinXMLUtil.hex2dec(string2);
            bl = true;
        }
        int n = 0;
        while ((binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l))) != null) {
            if (binXMLNamespaceToken.getNamespaceURI().equals(string)) {
                return binXMLNamespaceToken;
            }
            if (n++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l = this.regenerateTokenId(l, byArray);
                n = 0;
            } else {
                l = this.regenerateTokenId(l, null);
            }
            bl = false;
        }
        binXMLNamespaceToken = null;
        binXMLNamespaceToken = !bl ? this.registerNamespace(l, string) : (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
        return binXMLNamespaceToken;
    }

    long getTokenId(String string, String string2, boolean bl) throws BinXMLException {
        long l;
        if (string == null) {
            string = "";
        }
        if ((l = this.getTokenFromLocalCache(string, string2, bl)) == 0L) {
            boolean bl2 = this.registerTokenSetFromMetadataRepos(string, bl);
            if (!bl2) {
                throw new BinXMLException(this.err.getMessage0(35013));
            }
            l = this.getTokenFromLocalCache(string, string2, bl);
            if (l == 0L) {
                l = this.generateTokenId(string, string2, bl);
            }
        }
        return l;
    }

    long generateTokenId(String string, String string2, boolean bl) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken;
        long l = this.getNamespaceTokenId(string);
        byte[] byArray = string2.getBytes();
        long l2 = this.generateTokenId(byArray);
        int n = 0;
        while (true) {
            if ((binXMLQNameToken = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l2))) == null) {
                binXMLQNameToken = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l2));
            }
            if (binXMLQNameToken == null) break;
            if (binXMLQNameToken.isAttr() == bl && binXMLQNameToken.getLocalName().equals(string2) && binXMLQNameToken.getNamespaceId() == l) {
                return l2;
            }
            if (n++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l2 = this.regenerateTokenId(l2, byArray);
                n = 0;
                continue;
            }
            l2 = this.regenerateTokenId(l2, null);
        }
        binXMLQNameToken = this.registerTokenId(l2, string2, l, bl);
        return binXMLQNameToken.getTokenId();
    }

    private long getTokenFromLocalCache(String string, String string2, boolean bl) {
        long l = 0L;
        BinXMLTokenList binXMLTokenList = null;
        binXMLTokenList = !bl ? (BinXMLTokenList)this.elementNameTokens.get(string2) : (BinXMLTokenList)this.attrNameTokens.get(string2);
        if (binXMLTokenList != null) {
            BinXMLQNameToken binXMLQNameToken;
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
            long l2 = 0L;
            if (binXMLNamespaceToken != null) {
                l2 = binXMLNamespaceToken.getTokenId();
            }
            if ((binXMLQNameToken = binXMLTokenList.getQNameToken(l2)) != null) {
                l = binXMLQNameToken.getTokenId();
            }
        }
        return l;
    }

    private boolean registerTokenSetFromMetadataRepos(String string, boolean bl) throws BinXMLException {
        if (this.metaProvider == null) {
            return false;
        }
        BinXMLStreamImpl binXMLStreamImpl = null;
        binXMLStreamImpl = (BinXMLStreamImpl)this.metaProvider.getTokenSet(string, bl);
        if (binXMLStreamImpl != null) {
            BinXMLDecoder binXMLDecoder = binXMLStreamImpl.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            return true;
        }
        return false;
    }

    QName getTokenName(long l) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken = this.getToken(l);
        return this.getTokenName(binXMLQNameToken);
    }

    QName getTokenName(BinXMLQNameToken binXMLQNameToken) throws BinXMLException {
        QName qName = null;
        if (binXMLQNameToken != null) {
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(binXMLQNameToken.getNamespaceId()));
            qName = new QName(binXMLNamespaceToken.getLocalName(), binXMLQNameToken.getLocalName());
        }
        return qName;
    }

    BinXMLQNameToken getToken(long l) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken = this.getTokenFromLocalCache(l);
        if (binXMLQNameToken == null) {
            boolean bl = this.registerTokenSetFromMetadataRepos(l, false);
            if (!bl) {
                throw new BinXMLException(this.err.getMessage0(35013));
            }
            binXMLQNameToken = this.getTokenFromLocalCache(l);
            if (binXMLQNameToken == null) {
                throw new BinXMLException(this.err.getMessage0(35013));
            }
        }
        return binXMLQNameToken;
    }

    private BinXMLQNameToken getTokenFromLocalCache(long l) {
        BinXMLQNameToken binXMLQNameToken = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l));
        if (binXMLQNameToken == null) {
            binXMLQNameToken = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l));
        }
        return binXMLQNameToken;
    }

    private boolean registerTokenSetFromMetadataRepos(long l, boolean bl) throws BinXMLException {
        if (this.metaProvider == null) {
            return false;
        }
        try {
            BinXMLStreamImpl binXMLStreamImpl = (BinXMLStreamImpl)this.metaProvider.getTokenSet(l, bl);
            BinXMLDecoder binXMLDecoder = binXMLStreamImpl.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            return true;
        }
        catch (Exception exception) {
            throw new BinXMLException(exception.getMessage());
        }
    }

    BinXMLNamespaceToken registerNamespace(long l, String string) {
        BinXMLNamespaceToken binXMLNamespaceToken = BinXMLNamespaceToken.createNamespaceToken(l, string);
        this.namespaceIdTokens.put(new Long(l), binXMLNamespaceToken);
        this.namespaceURITokens.put(string, binXMLNamespaceToken);
        return binXMLNamespaceToken;
    }

    BinXMLQNameToken registerTokenId(long l, String string, long l2, boolean bl) {
        BinXMLQNameToken binXMLQNameToken = BinXMLQNameToken.createQNameToken(l, l2, string, bl);
        if (bl) {
            this.attrIdTokens.put(new Long(l), binXMLQNameToken);
            BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
            if (binXMLTokenList == null) {
                this.attrNameTokens.put(string, new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
            binXMLTokenList = (BinXMLTokenList)this.attrNSTokens.get(new Long(l2));
            if (binXMLTokenList == null) {
                this.attrNSTokens.put(new Long(l2), new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
        } else {
            this.elementIdTokens.put(new Long(l), binXMLQNameToken);
            BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
            if (binXMLTokenList == null) {
                this.elementNameTokens.put(string, new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
            binXMLTokenList = (BinXMLTokenList)this.elementNSTokens.get(new Long(l2));
            if (binXMLTokenList == null) {
                this.elementNSTokens.put(new Long(l2), new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
        }
        return binXMLQNameToken;
    }

    BinXMLNamespaceToken getNamespaceToken(long l) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l));
        if (binXMLNamespaceToken != null) {
            return binXMLNamespaceToken;
        }
        boolean bl = this.registerTokenSetFromMetadataRepos(l, true);
        if (!bl) {
            return null;
        }
        binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l));
        return binXMLNamespaceToken;
    }

    BinXMLQNameToken getElementToken(String string, long l, String string2) throws BinXMLException {
        BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
        if (binXMLTokenList == null) {
            return null;
        }
        BinXMLQNameToken binXMLQNameToken = binXMLTokenList.getQNameToken(l);
        if (binXMLQNameToken == null) {
            boolean bl = this.registerTokenSetFromMetadataRepos(string2, false);
            if (!bl) {
                return null;
            }
            binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
            if (binXMLTokenList == null) {
                return null;
            }
            binXMLQNameToken = binXMLTokenList.getQNameToken(l);
            if (binXMLQNameToken == null) {
                return null;
            }
        }
        return binXMLQNameToken;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    BinXMLQNameToken getAttrToken(String string, long l, String string2) throws BinXMLException {
        BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
        if (binXMLTokenList == null) {
            return null;
        }
        BinXMLQNameToken binXMLQNameToken = binXMLTokenList.getQNameToken(l);
        if (binXMLQNameToken == null) {
            boolean bl = this.registerTokenSetFromMetadataRepos(string2, true);
            if (!bl) {
                return null;
            }
            binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
            if (binXMLTokenList == null) {
                return null;
            }
            binXMLQNameToken = binXMLTokenList.getQNameToken(l);
            if (binXMLQNameToken == null) {
                return null;
            }
        }
        return binXMLQNameToken;
    }

    long getNamespaceTokenId(String string) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
        if (binXMLNamespaceToken == null) {
            binXMLNamespaceToken = this.metaProvider == null || !(this.metaProvider instanceof DBBinXMLMetadataProviderImpl) ? this.putNamespace(string) : this.putNamespace(string);
        }
        return binXMLNamespaceToken.getTokenId();
    }

    private long generateTokenId(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        long l = 0L;
        int n3 = 0;
        long l2 = 2654435769L;
        long l3 = 2654435769L;
        long l4 = 2654435769L;
        long l5 = l;
        for (n = n2; n >= 16; n -= 16) {
            l4 += (long)(byArray[n3 + 0] + (byArray[n3 + 1] << 8) + (byArray[n3 + 2] << 16) + (byArray[n3 + 3] << 24));
            l3 += (long)(byArray[n3 + 4] + (byArray[n3 + 5] << 8) + (byArray[n3 + 6] << 16) + (byArray[n3 + 7] << 24));
            l2 += (long)(byArray[n3 + 8] + (byArray[n3 + 9] << 8) + (byArray[n3 + 10] << 16) + (byArray[n3 + 11] << 24));
            l4 += (l5 += (long)(byArray[n3 + 12] + (byArray[n3 + 13] << 8) + (byArray[n3 + 14] << 16) + (byArray[n3 + 15] << 24)));
            l5 += l4;
            l4 ^= l4 >> 7;
            l3 += l4;
            l4 += l3;
            l3 ^= l3 << 13;
            l2 += l3;
            l3 += l2;
            l2 ^= l2 >> 17;
            l5 += l2;
            l2 += l5;
            l5 ^= l5 << 9;
            l4 += l5;
            l5 += l4;
            l4 ^= l4 >> 3;
            l3 += l4;
            l4 += l3;
            l3 ^= l3 << 7;
            l2 += l3;
            l3 += l2;
            l2 ^= l2 >> 15;
            l5 += l2;
            l2 += l5;
            l5 ^= l5 << 11;
            n3 += 16;
        }
        l5 += (long)n2;
        switch (n) {
            case 15: {
                l5 += (long)(byArray[n3 + 14] << 24);
            }
            case 14: {
                l5 += (long)(byArray[n3 + 13] << 16);
            }
            case 13: {
                l5 += (long)(byArray[n3 + 12] << 8);
            }
            case 12: {
                l2 += (long)(byArray[n3 + 11] << 24);
            }
            case 11: {
                l2 += (long)(byArray[n3 + 10] << 16);
            }
            case 10: {
                l2 += (long)(byArray[n3 + 9] << 8);
            }
            case 9: {
                l2 += (long)byArray[n3 + 8];
            }
            case 8: {
                l3 += (long)(byArray[n3 + 7] << 24);
            }
            case 7: {
                l3 += (long)(byArray[n3 + 6] << 16);
            }
            case 6: {
                l3 += (long)(byArray[n3 + 5] << 8);
            }
            case 5: {
                l3 += (long)byArray[n3 + 4];
            }
            case 4: {
                l4 += (long)(byArray[n3 + 3] << 24);
            }
            case 3: {
                l4 += (long)(byArray[n3 + 2] << 16);
            }
            case 2: {
                l4 += (long)(byArray[n3 + 1] << 8);
            }
            case 1: {
                l4 += (long)byArray[n3 + 0];
            }
        }
        l4 += l5;
        l5 += l4;
        l4 ^= l4 >> 7;
        l3 += l4;
        l4 += l3;
        l3 ^= l3 << 13;
        l2 += l3;
        l3 += l2;
        l2 ^= l2 >> 17;
        l5 += l2;
        l2 += l5;
        l5 ^= l5 << 9;
        l4 += l5;
        l5 += l4;
        l4 ^= l4 >> 3;
        l3 += l4;
        l4 += l3;
        l3 ^= l3 << 7;
        l2 += l3;
        l3 += l2;
        l2 ^= l2 >> 15;
        l5 += l2;
        l2 += l5;
        l5 ^= l5 << 11;
        long l6 = this.getTokenMask();
        if ((l5 &= l6) >= 0L && l5 <= 22L) {
            return this.regenerateTokenId(l5, null);
        }
        return l5;
    }

    private long getTokenMask() {
        if (!this.q4level && !this.q8level) {
            return 32767L;
        }
        if (this.q4level) {
            return 0x7FFF7FFFL;
        }
        return -2147516417L;
    }

    private long regenerateTokenId(long l, byte[] byArray) {
        long l2;
        if (byArray != null) {
            l = this.generateTokenId(byArray);
        }
        if ((l = l + 13L & (l2 = this.getTokenMask())) >= 0L && l <= 22L) {
            return this.regenerateTokenId(l, byArray);
        }
        return l;
    }
}

