/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.OutputStream;

public class XDBOutputStream
extends OutputStream {
    private long c_state_;
    private long c_errhp_;
    private long m_gp_;
    private int m_type_;
    private int m_stream_offset = 0;

    private native void closeNative(long var1, long var3);

    private native void writeNative(long var1, long var3, byte[] var5, int var6, int var7, int var8);

    public XDBOutputStream(long c_gp, long c_state, int offset) {
        System.out.println("in XDBOutputStream constructor " + c_state);
        this.c_state_ = c_state;
        this.m_gp_ = c_gp;
        this.m_stream_offset = offset;
    }

    @Override
    public void write(byte[] b) {
        System.out.println("in XDBOutputStream.write byte array");
        if (b == null) {
            throw new NullPointerException();
        }
        System.out.println("in XDBOutputStream.write len = " + b.length);
        this.writeNative(this.m_gp_, this.c_state_, b, 0, b.length, this.m_stream_offset);
        this.m_stream_offset += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        System.out.println("in XDBOutputStream.write byte array w/ offset");
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        System.out.println("in XDBOutputStream.write len = " + len + " off = " + off);
        this.writeNative(this.m_gp_, this.c_state_, b, off, len, this.m_stream_offset);
        this.m_stream_offset += len;
    }

    @Override
    public void write(int b) {
        System.out.println("in XDBOutputStream.write 1 byte ");
        byte[] buf = new byte[]{new Integer(b).byteValue()};
        this.writeNative(this.m_gp_, this.c_state_, buf, 0, 1, this.m_stream_offset);
        ++this.m_stream_offset;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

